﻿module("VOICE")

transform = {}

transform.roadname_abbrev_table = TRANSFORM.new({	
	{2,L"(?i)([0-9])[ -]BL\\b", L"\\1 Business Loop"},
	{2,L"(?i)([0-9])[ -]BR\\b", L"\\1 Business Road"},
	{2,L"(?i)([0-9])[ -]BS\\b", L"\\1 Business Spur"},
	{2,L"(?i)^S\\.?T\\.? ",L"Saint "},
	{2,L"(?i)\\sST\\.?\\b",L" Strit"},
	
	
	{2,L"(?i)^DR\\.?\\b", L"Doctor"},
	
	{1, L"A F N", L"AFRIQUE FRANÇAISE DU NORD"},
	{1, L"ABEY", L"ABBEY"},
	{1, L"ACC", L"ACCESS"},
	{1, L"ACRS", L"ACRES"},
	{1, L"ACCS", L"ACCESS"},
	{1, L"ADJ /C", L"ADJUDANT-CHEF"},
	{1, L"ADJ", L"ADJUDANT"},
	{1, L"AÉRODR", L"AÉRODROME"},
	{1, L"AÉROP", L"AÉROPORT"},
	{1, L"AFB", L"AIR FORCE BASE"},
	{1, L"AL", L"ALLÉE"},
	{1, L"ALLEE", L"ALLI"},
	{1, L"ALLEY", L"ALLI"},
	{1, L"ALS", L"ALLÉES"},
	{1, L"ALY", L"ALLI"},
	{1, L"ALLY", L"ALLI"},
	{1, L"AM", L"AMIRAL"},
	{1, L"AMBL", L"AMBLE"},
	{1, L"ANC CHEM D'", L"ANCIEN CHEMIN D'"},
	{1, L"ANC CHEM DE L'", L"ANCIEN CHEMIN DE L'"},
	{1, L"ANC CHEM DE LA", L"ANCIEN CHEMIN DE LA"},
	{1, L"ANC CHEM DE", L"ANCIEN CHEMIN DE"},
	{1, L"ANC CHEM DES", L"ANCIEN CHEMIN DES"},
	{1, L"ANC CHEM DU", L"ANCIEN CHEMIN DU"},
	{1, L"ANC CHEM", L"ANCIEN CHEMIN"},
	{1, L"ANC ROUTE DE LA", L"ANCIENNE ROUTE DE LA"},
	{1, L"ANC ROUTE DE", L"ANCIENNE ROUTE DE"},
	{1, L"ANC ROUTE DES", L"ANCIENNE ROUTE DES"},
	{1, L"ANC ROUTE DU", L"ANCIENNE ROUTE DU"},
	{1, L"ANC ROUTE", L"ANCIENNE ROUTE"},
	{1, L"ANC RUE AUX", L"ANCIENNE RUE AUX"},
	{1, L"ANC", L"ANCIEN"},
	{1, L"ANCIENS COMBATTANTS D’AFR DU N", L"ANCIENS COMBATTANTS D'AFRIQUE DU NORD"},
	{1, L"ANEX", L"ANNEX"},
	{1, L"ANNEX", L"ANNEX"},
	{1, L"ANNX", L"ANNEX"},
	{1, L"ANX", L"ANNEX"},
	{1, L"APP", L"APPROACH"},
	{1, L"AR DES", L"ARCADE DES"},
	{1, L"ARC", L"ARCADE"},
	{1, L"ARCADE", L"ARCADE"},
	{1, L"AUTOR DE L'", L"AUTOROUTE DE L'"},
	{1, L"AUTOR DE LA", L"AUTOROUTE DE LA"},
	{1, L"AUTOR DE", L"AUTOROUTE DE"},
	{1, L"AUTOR DES", L"AUTOROUTE DES"},
	{1, L"AUTOR DU", L"AUTOROUTE DU"},
	{1, L"AUTORTE", L"AUTOROUTE"},
	{1, L"AV AU", L"AVENUE AU"},
	{1, L"AV D'", L"AVENUE D'"},
	{1, L"AV DE L'", L"AVENUE DE L'"},
	{1, L"AV DE LA", L"AVENUE DE LA"},
	{1, L"AV DE", L"AVENUE DE"},
	{1, L"AV DES", L"AVENUE DES"},
	{1, L"AV DU", L"AVENUE DU"},
	{1, L"AV LA", L"AVENUE LA"},
	{1, L"AV", L"AVENUE"},
	{1, L"AVE", L"AVENUE"},
	{1, L"AVEN", L"AVENUE"},
	{1, L"AVENU", L"AVENUE"},
	{1, L"AVENUE", L"AVENUE"},
	{1, L"AVN", L"AVENUE"},
	{1, L"AVNUE", L"AVENUE"},
	{1, L"AVS", L"AVENUES"},
	{1, L"BAIE", L"BAIE"},
	{1, L"BANGERTER", L"BANGHETTER"},
	{1, L"BARRI D'", L"BARRI?RE D'"},
	{1, L"BAS ?", L"BASSIN ?"},
	{1, L"BAS D'", L"BASSIN D'"},
	{1, L"BAS DE LA", L"BASSIN DE LA"},
	{1, L"BAS DU", L"BASSIN DU"},
	{1, L"BAS", L"BASSIN"},
	{1, L"BÂT DE LA", L"BÂTIMENT DE LA"},
	{1, L"BÂT DES", L"BÂTIMENT DES"},
	{1, L"BÂT", L"BÂTIMENT"},
	{1, L"BAYOU", L"BAYOO"},
	{1, L"BCH", L"BEACH"},
	{1, L"BDN", L"BČND"},
	{1, L"BDN", L"BEND"},
	{1, L"BDS", L"BOULEVARDS"},
	{1, L"BDWY", L"BROADWAY"},
	{1, L"BEACH", L"BEACH"},
	{1, L"BELT", L"BELTWAY"},
	{1, L"BEND", L"BEND"},
	{1, L"BG", L"BURG"},
	{1, L"BGS", L"BURGS"},
	{1, L"BIBL", L"BIBLIOTH?QUE"},
	{1, L"BL", L"BOULEVARD"},
	{1, L"BLF", L"BLUFF"},
	{1, L"BLFS", L"BLUFFS"},
	{1, L"BLUF", L"BLUFF"},
	{1, L"BLUFF", L"BLUFF"},
	{1, L"BLUFFS", L"BLUFFS"},
	{1, L"BLVB", L"BOULEVARDE"},
	{1, L"BLVD", L"BOULEVARD"},
	{1, L"BND", L"BEND"},
	{1, L"BOT", L"BOTTOM"},
	{1, L"BOTTM", L"BOTTOM"},
	{1, L"BOTTOM", L"BOTTOM"},
	{1, L"BOUL D'", L"BOULEVARD D'"},
	{1, L"BOUL DE L'", L"BOULEVARD DE L'"},
	{1, L"BOUL DE LA", L"BOULEVARD DE LA"},
	{1, L"BOUL DE", L"BOULEVARD DE"},
	{1, L"BOUL DES", L"BOULEVARD DES"},
	{1, L"BOUL DU", L"BOULEVARD DU"},
	{1, L"BOUL LE", L"BOULEVARD LE"},
	{1, L"BOUL LES", L"BOULEVARD LES"},
	{1, L"BOUL", L"BOULEVARD"},
	{1, L"BOULEVARD", L"BOULEVARD"},
	{1, L"BOULV", L"BOULEVARD"},
	{1, L"BR", L"BRANCH"},
	{1, L"BRANCH", L"BRANCH"},
	{1, L"BRCE", L"BRACE"},
	{1, L"BRDGE", L"BRIDGE"},
	{1, L"BRG", L"BRIDGE"},
	{1, L"BRIDGE", L"BRIDGE"},
	{1, L"BRK", L"BROOK"},
	{1, L"BRKS", L"BROOKS"},
	{1, L"BRNCH", L"BRANCH"},
	{1, L"BROOK", L"BROOK"},
	{1, L"BROOKS", L"BROOKS"},
	{1, L"BROS", L"BROTHERS"},
	{1, L"BTM", L"BOTTOM"},
	{1, L"BURG", L"BURG"},
	{1, L"BURGS", L"BURGS"},
	{1, L"BYOU", L"BAYOU"},
	{1, L"BYP", L"BYPASS"},
	{1, L"BYPA", L"BYPASS"},
	{1, L"BYPAS", L"BYPASS"},
	{1, L"BYPASS", L"BYPASS"},
	{1, L"BYPS", L"BYPASS"},
	{1, L"BYU", L"BAYOO"},
	{1, L"BYWY", L"BYWAY"},
	{1, L"C C", L"COMMUNAUTÉ DE COMMUNE"},
	{1, L"C F", L"CORPS FRANÇAIS"},
	{1, L"C I R", L"CENTRE INTERNATIONAL ROUTIER"},
	{1, L"C R T", L"CENTRE RÉGIONAL DE TRANSPORT"},
	{1, L"C", L"CITE"},
	{1, L"CAMP", L"CAMP"},
	{1, L"CANT D'", L"CANTON D'"},
	{1, L"CANT DE L'", L"CANTON DE L'"},
	{1, L"CANT DE LA", L"CANTON DE LA"},
	{1, L"CANT DE", L"CANTON DE"},
	{1, L"CANT DES", L"CANTON DES"},
	{1, L"CANT DU", L"CANTON DU"},
	{1, L"CANT", L"CANTON"},
	{1, L"CANYN", L"CANYON"},
	{1, L"CANYON", L"CANYON"},
	{1, L"CAP", L"CAPITAINE"},
	{1, L"CAPE", L"CAPE"},
	{1, L"CARD", L"CARDINAL"},
	{1, L"CARR D'", L"CARRI?RE D'"},
	{1, L"CARR DE L'", L"CARRI?RE DE L'"},
	{1, L"CARR DE LA", L"CARRI?RE DE LA"},
	{1, L"CARR DE", L"CARRI?RE DE"},
	{1, L"CARR DES", L"CARRI?RE DES"},
	{1, L"CARR DU", L"CARRI?RE DU"},
	{1, L"CARR", L"CARRI?RE"},
	{1, L"CARREF AU", L"CARREFOUR AU"},
	{1, L"CARREF AUX", L"CARREFOUR AUX"},
	{1, L"CARREF D'", L"CARREFOUR D'"},
	{1, L"CARREF DE L'", L"CARREFOUR DE L'"},
	{1, L"CARREF DE LA", L"CARREFOUR DE LA"},
	{1, L"CARREF DE", L"CARREFOUR DE"},
	{1, L"CARREF DES", L"CARREFOUR DES"},
	{1, L"CARREF DU", L"CARREFOUR DU"},
	{1, L"CAUSEWAY", L"CAUSEWAY"},
	{1, L"CAUSWAY", L"CAUSEWAY"},
	{1, L"CCT", L"CIRCUIT"},
	{1, L"CD", L"SIOUDAD"},
	{1, L"CDT", L"COMMANDANT"},
	{1, L"CEM", L"CEMETERY"},
	{1, L"CEN", L"CENTER"},
	{1, L"CENT THERM", L"CENTRALE THERMIQUE"},
	{1, L"CENT", L"CENTER"},
	{1, L"CENTER", L"CENTER"},
	{1, L"CENTERS", L"CENTERS"},
	{1, L"CENTR", L"CENTER"},
	{1, L"CENTRE", L"CENTER"},
	{1, L"CER DE LA", L"CERCLE DE LA"},
	{1, L"CER DES", L"CERCLE DES"},
	{1, L"CER", L"CERCLE"},
	{1, L"CH", L"CHASE"},
	{1, L"CHAN", L"CHANOINE"},
	{1, L"CHAP", L"CHAPELLE"},
	{1, L"CHAS", L"CHASE"},
	{1, L"CHÂT", L"CHÂTEAU"},
	{1, L"CHE", L"CHEMIN"},
	{1, L"CHEM ? L'", L"CHEMIN ? L'"},
	{1, L"CHEM ?", L"CHEMIN ?"},
	{1, L"CHEM AU", L"CHEMIN AU"},
	{1, L"CHEM AUX", L"CHEMIN AUX"},
	{1, L"CHEM CHEZ", L"CHEMIN CHEZ"},
	{1, L"CHEM COMM DE", L"CHEMIN COMMUNAL DE"},
	{1, L"CHEM COMM DU", L"CHEMIN COMMUNAL DU"},
	{1, L"CHEM D'", L"CHEMIN D'"},
	{1, L"CHEM DE CEINTURE DU", L"CHEMIN DE CEINTURE DU"},
	{1, L"CHEM DE FRONT DU", L"CHEMIN DE FRONT DU"},
	{1, L"CHEM DE L'", L"CHEMIN DE L'"},
	{1, L"CHEM DE LA", L"CHEMIN DE LA"},
	{1, L"CHEM DE LIGNE DE LA", L"CHEMIN DE LIGNE DE LA"},
	{1, L"CHEM DE", L"CHEMIN DE"},
	{1, L"CHEM D'EN", L"CHEMIN D'EN"},
	{1, L"CHEM DES", L"CHEMIN DES"},
	{1, L"CHEM DU", L"CHEMIN DU"},
	{1, L"CHEM LES", L"CHEMIN LES"},
	{1, L"CHEM RUR DE L'", L"CHEMIN RURAL DE L'"},
	{1, L"CHEM RUR DE LA", L"CHEMIN RURAL DE LA"},
	{1, L"CHEM RUR DE", L"CHEMIN RURAL DE"},
	{1, L"CHEM RUR DES", L"CHEMIN RURAL DES"},
	{1, L"CHEM RUR DU", L"CHEMIN RURAL DU"},
	{1, L"CHEV", L"CHEVALIER"},
	{1, L"CIAL", L"COMMERCIAL"},
	{1, L"CIALE", L"COMMERCIALE"},
	{1, L"CIE", L"COMPAGNIE"},
	{1, L"CIM", L"CIMETI?RE"},
	{1, L"CIR", L"CIRCLE"},
	{1, L"CIRC", L"CIRCLE"},
	{1, L"CIRCL", L"CIRCLE"},
	{1, L"CIRCLE", L"CIRCLE"},
	{1, L"CIRCLES", L"CIRCLES"},
	{1, L"CIRS", L"CIRCLES"},
	{1, L"CIRT", L"CIRCUIT"},
	{1, L"CK", L"CREEK"},
	{1, L"CL", L"CLOSE"},
	{1, L"CLB", L"CLUB"},
	{1, L"CLDE", L"COLONNADE"},
	{1, L"CLF", L"CLIFF"},
	{1, L"CLFS", L"CLIFFS"},
	{1, L"CLIFF", L"CLIFF"},
	{1, L"CLIFFS", L"CLIFFS"},
	{1, L"CLOS", L"CLOSE"},
	{1, L"CLT", L"CIRCLET"},
	{1, L"CLUB", L"CLUB"},
	{1, L"CMN", L"COMMON"},
	{1, L"CMP", L"CAMP"},
	{1, L"CNL", L"CANAL"},
	{1, L"CNRS", L"CORNERS"},
	{1, L"CNTER", L"CENTER"},
	{1, L"CNTR", L"CENTER"},
	{1, L"CNYN", L"CANYON"},
	{1, L"CO", L"COUNTY"},
	{1, L"COL", L"COLONEL"},
	{1, L"COM", L"COMMON"},
	{1, L"COMM", L"COMMUNAL"},
	{1, L"COMMON", L"COMMON"},
	{1, L"CON", L"CONCOURSE"},
	{1, L"CONN", L"CONNECTOR"},
	{1, L"COR", L"CORNER"},
	{1, L"CORN D'", L"CORNICHE D'"},
	{1, L"CORN DE L'", L"CORNICHE DE L'"},
	{1, L"CORN DE LA", L"CORNICHE DE LA"},
	{1, L"CORN DE", L"CORNICHE DE"},
	{1, L"CORN DES", L"CORNICHE DES"},
	{1, L"CORN DU", L"CORNICHE DU"},
	{1, L"CORN", L"CORNICHE"},
	{1, L"CORNER", L"CORNER"},
	{1, L"CORNERS", L"CORNERS"},
	{1, L"CORS", L"CORNERS"},
	{1, L"COURSE", L"COURSE"},
	{1, L"COURT", L"COURT"},
	{1, L"COURTS", L"COURTS"},
	{1, L"COVE", L"COVE"},
	{1, L"COVES", L"COVES"},
	{1, L"CP", L"CAMP"},
	{1, L"CPE", L"CAPE"},
	{1, L"CPL", L"CAPORAL"},
	{1, L"CPS", L"COPSE"},
	{1, L"CR", L"CREEK"},
	{1, L"CRC", L"CIRCLE"},
	{1, L"CRCL", L"CIRCLE"},
	{1, L"CRCLE", L"CIRCLE"},
	{1, L"CRCS", L"CIRCUS"},
	{1, L"CRECENT", L"CRESCENT"},
	{1, L"CREEK", L"CREEK"},
	{1, L"CRES", L"CRESCENT"},
	{1, L"CRESCENT", L"CRESCENT"},
	{1, L"CRESENT", L"CRESCENT"},
	{1, L"CREST", L"CREST"},
	{1, L"CRK", L"CREEK"},
	{1, L"CROISS D'", L"CROISSANT D'"},
	{1, L"CROISS DE L'", L"CROISSANT DE L'"},
	{1, L"CROISS DE LA", L"CROISSANT DE LA"},
	{1, L"CROISS DE", L"CROISSANT DE"},
	{1, L"CROISS DES", L"CROISSANT DES"},
	{1, L"CROISS DU", L"CROISSANT DU"},
	{1, L"CROISS", L"CROISSANT"},
	{1, L"CROIX D'", L"CROIX D'"},
	{1, L"CROIX DE L'", L"CROIX DE L'"},
	{1, L"CROIX DE LA", L"CROIX DE LA"},
	{1, L"CROIX DE", L"CROIX DE"},
	{1, L"CROIX DES", L"CROIX DES"},
	{1, L"CROIX DU", L"CROIX DU"},
	{1, L"CROSSING", L"CROSSING"},
	{1, L"CROSSROAD", L"CROSSROAD"},
	{1, L"CRS", L"COURS"},
	{1, L"CRSCNT", L"CRESCENT"},
	{1, L"CRSE", L"COURSE"},
	{1, L"CRSENT", L"CRESCENT"},
	{1, L"CRSNT", L"CRESCENT"},
	{1, L"CRSS", L"CROSS"},
	{1, L"CRSSING", L"CROSSING"},
	{1, L"CRSSNG", L"CROSSING"},
	{1, L"CRST", L"CREST"},
	{1, L"CRT", L"COURT"},
	{1, L"CRVE", L"CURVE"},
	{1, L"CT", L"COURT"},
	{1, L"CTE", L"COMTE"},
	{1, L"CTR", L"CENTER"},
	{1, L"CTRE CCIAL", L"CENTRE COMMERCIAL"},
	{1, L"CTRE HORT", L"CENTRE HORTICOLE"},
	{1, L"CTRE", L"CENTRE"},
	{1, L"CTRS", L"CENTERS"},
	{1, L"CTS", L"COURTS"},
	{1, L"CTY", L"CITY"},
	{1, L"CTYD", L"COURTYARD"},
	{1, L"CURV", L"CURVE"},
	{1, L"CURVE", L"CURVE"},
	{1, L"CV", L"COVE"},
	{1, L"CVS", L"COVES"},
	{1, L"CYN", L"CANYON"},
	{1, L"CSO", L"CORSO"},
	{1, L"CSWY", L"CAUSEWAY"},
	{1, L"D B", L"DIVISION BLINDÉE"},
	{1, L"D F L", L"DIVISION FRANÇAISE LIBRE"},
	{1, L"D'", L"VILLA D'"},
	{1, L"DALE", L"DALE"},
	{1, L"DAM", L"DAM"},
	{1, L"DE L'", L"VILLA DE L'"},
	{1, L"DE LA", L"VILLA DE LA"},
	{1, L"DE", L"VILLA DE"},
	{1, L"DEMI-ÉCH D'", L"DEMI-ÉCHANGEUR D'"},
	{1, L"DEMI-ÉCH DE", L"DEMI-ÉCHANGEUR DE"},
	{1, L"DEMI-ÉCH DES", L"DEMI-ÉCHANGEUR DES"},
	{1, L"DEMI-ÉCH DU", L"DEMI-ÉCHANGEUR DU"},
	{1, L"DEMI-ÉCH", L"DEMI-ÉCHANGEUR"},
	{1, L"DÉP", L"DÉPARTEMENTAL"},
	{1, L"DÉPART", L"DÉPARTEMENTAL(E)"},
	{1, L"DES", L"VILLA DES"},
	{1, L"DESC DE L'", L"DESCENTE DE L'"},
	{1, L"DESC DE LA", L"DESCENTE DE LA"},
	{1, L"DESC DE", L"DESCENTE DE"},
	{1, L"DESC DES", L"DESCENTE DES"},
	{1, L"DESC DU", L"DESCENTE DU"},
	{1, L"DEVN", L"DEVIATION"},
	{1, L"DIV", L"DIVIDE"},
	{1, L"DIVIDE", L"DIVIDE"},
	{1, L"DL", L"DALE"},
	{1, L"DM", L"DAM"},
	{1, L"DOM D'", L"DOMAINE D'"},
	{1, L"DOM DE L'", L"DOMAINE DE L'"},
	{1, L"DOM DE LA", L"DOMAINE DE LA"},
	{1, L"DOM DE", L"DOMAINE DE"},
	{1, L"DOM DES", L"DOMAINE DES"},
	{1, L"DOM DU", L"DOMAINE DU"},
	{1, L"DOM", L"DOMAINE"},
	{1, L"DR", L"DRIVE"},
	{1, L"DRIV", L"DRIVE"},
	{1, L"DRS", L"DRIVES"},
	{1, L"DRV", L"DRIVE"},
	{1, L"DRWY", L"DRIVEWAY"},
	{1, L"DU", L"VILLA DU"},
	{1, L"DV", L"DIVIDE"},
	{1, L"DVD", L"DIVIDE"},
	{1, L"DWNS", L"DOWNS"},
	{1, L"EB", L"EAST BOUND"},
	{1, L"ÉCH ?", L"ÉCHANGEUR ?"},
	{1, L"ÉCH D'", L"ÉCHANGEUR D'"},
	{1, L"ÉCH DE L'", L"ÉCHANGEUR DE L'"},
	{1, L"ÉCH DE LA", L"ÉCHANGEUR DE LA"},
	{1, L"ÉCH DES", L"ÉCHANGEUR DES"},
	{1, L"ÉCH DU", L"ÉCHANGEUR DU"},
	{1, L"ÉCH", L"ÉCHANGEUR"},
	{1, L"ELB", L"ELBOW"},
	{1, L"ÉLÉM", L"ÉLÉMENTAIRE"},
	{1, L"ENCL AUX", L"ENCLOS AUX"},
	{1, L"ENCL DE L'", L"ENCLOS DE L'"},
	{1, L"ENCL DE LA", L"ENCLOS DE LA"},
	{1, L"ENCL DE", L"ENCLOS DE"},
	{1, L"ENCL DES", L"ENCLOS DES"},
	{1, L"ENCL DU", L"ENCLOS DU"},
	{1, L"ENCL", L"ENCLOS"},
	
	{1, L"ENT", L"ENTRANCE"},
	{1, L"ESC DE L'", L"ESCALIER DE L'"},
	{1, L"ESC DE LA", L"ESCALIER DE LA"},
	{1, L"ESC DE", L"ESCALIER DE"},
	{1, L"ESC DES", L"ESCALIER DES"},
	{1, L"ESC DU", L"ESCALIER DU"},
	{1, L"ESC", L"ESCALIER"},
	{1, L"ESP TECH IND", L"ESPACE TECHNOLOGIQUE INDUSTRIEL"},
	{1, L"ESP", L"ESPLANADE"},
	{1, L"ESQ", L"ESQUIRE"},
	{1, L"EST", L"ESTATE"},
	{1, L"ESTATE", L"ESTATE"},
	{1, L"ESTATES", L"ESTATES"},
	{1, L"ESTE", L"ESTATE"},
	{1, L"ESTS", L"ESTATES"},
	{1, L"EXP", L"EXPRESSWAY"},
	{1, L"EXPR", L"EXPRESSWAY"},
	{1, L"EXPRESS", L"EXPRESSWAY"},
	{1, L"EXPRESSWAY", L"EXPRESSWAY"},
	{1, L"EXPW", L"EXPRESSWAY"},
	{1, L"EXPY", L"EXPRESSWAY"},
	{1, L"EXT", L"EXTENSION"},
	{1, L"EXTENSION", L"EXTENSION"},
	{1, L"EXTENSIONS", L"EXTENSIONS"},
	{1, L"EXTN", L"EXTENSION"},
	{1, L"EXTNSN", L"EXTENSION"},
	{1, L"EXTS", L"EXTENSIONS"},
	{1, L"FALL", L"FALL"},
	{1, L"FALLS", L"FALLS"},
	{1, L"FAUB D'", L"FAUBOURG D'"},
	{1, L"FAUB DE L'", L"FAUBOURG DE L'"},
	{1, L"FAUB DE LA", L"FAUBOURG DE LA"},
	{1, L"FAUB DE", L"FAUBOURG DE"},
	{1, L"FAUB DES", L"FAUBOURG DES"},
	{1, L"FAUB DU", L"FAUBOURG DU"},
	{1, L"FAWY", L"FAIRWAY"},
	{1, L"FDLS", L"FIELDS"},
	{1, L"FDLS", L"FILDSE"},
	{1, L"FERRY", L"FERRY"},
	{1, L"FG", L"FAUBOURG"},
	{1, L"FIELD", L"FIELD"},
	{1, L"FIELDS", L"FIELDS"},
	{1, L"FL", L"FALL"},
	{1, L"FLAT", L"FLAT"},
	{1, L"FLATS", L"FLATS"},
	{1, L"FLD", L"FIELD"},
	{1, L"FLDS", L"FIELDS"},
	{1, L"FLS", L"FALLS"},
	{1, L"FLT", L"FLAT"},
	{1, L"FLTS", L"FLATS"},
	{1, L"FOLW", L"FOLLOW"},
	{1, L"FORD", L"FORD"},
	{1, L"FORDS", L"FORDS"},
	{1, L"FOREST", L"FOREST"},
	{1, L"FORESTS", L"FOREST"},
	{1, L"FORG", L"FORGE"},
	{1, L"FORGE", L"FORGE"},
	{1, L"FORGES", L"FORGES"},
	{1, L"FORK", L"FORK"},
	{1, L"FORKS", L"FORKS"},
	{1, L"FORT", L"FORT"},
	{1, L"FR", L"FATHER"},
	
	{1, L"FRD", L"FORD"},
	{1, L"FRDS", L"FORDS"},
	{1, L"FREEWAY", L"FREEWAY"},
	{1, L"FREEWY", L"FREEWAY"},
	{1, L"FRG", L"FORGE"},
	{1, L"FRGS", L"FORGES"},
	{1, L"FRK", L"FORK"},
	{1, L"FRKS", L"FORKS"},
	{1, L"FRNT", L"FRONT"},
	{1, L"FRRY", L"FERRY"},
	{1, L"FRST", L"FOREST"},
	{1, L"FRSTS", L"FORESTS"},
	{1, L"FRT", L"FORT"},
	{1, L"FRTG", L"FRONTAGE"},
	{1, L"FRWAY", L"FREEWAY"},
	{1, L"FRWY", L"FREEWAY"},
	{1, L"FRY", L"FERRY"},
	{1, L"FSHR", L"FORESHORE"},
	{1, L"FT", L"FORT"},
	{1, L"FWY", L"FREEWAY"},
	{1, L"GAL D'", L"GALERIE D'"},
	{1, L"GAL DE L'", L"GALERIE DE L'"},
	{1, L"GAL DE LA", L"GALERIE DE LA"},
	{1, L"GAL DE", L"GALERIE DE"},
	{1, L"GAL DES", L"GALERIE DES"},
	{1, L"GAL DU", L"GALERIE DU"},
	{1, L"GAL", L"GALERIE"},
	{1, L"GARDEN", L"GARDEN"},
	{1, L"GARDENS", L"GARDENS"},
	{1, L"GARDN", L"GARDEN"},
	{1, L"GATEWAY", L"GATEWAY"},
	{1, L"GATEWY", L"GATEWAY"},
	{1, L"GATWAY", L"GATEWAY"},
	{1, L"GD SENTIER DES", L"GRAND SENTIER DES"},
	{1, L"GD SENTIER", L"GRAND SENTIER"},
	{1, L"GD", L"GRAND "},
	{1, L"GDE ALLÉE DE LA", L"GRANDE ALLÉE DE LA"},
	{1, L"GDE ALLÉE DE", L"GRANDE ALLÉE DE"},
	{1, L"GDE ALLÉE DES", L"GRANDE ALLÉE DES"},
	{1, L"GDE ALLÉE DU", L"GRANDE ALLÉE DU"},
	{1, L"GDE ALLÉE", L"GRANDE ALLÉE"},
	{1, L"GDE IMPASSE DES", L"GRANDE IMPASSE DES"},
	{1, L"GDE RUE D'", L"GRANDE RUE D'"},
	{1, L"GDE RUE DE LA", L"GRANDE RUE DE LA"},
	{1, L"GDE RUE DE", L"GRANDE RUE DE"},
	{1, L"GDE RUE DES", L"GRANDE RUE DES"},
	{1, L"GDE RUE DU", L"GRANDE RUE DU"},
	{1, L"GDE RUE", L"GRANDE RUE"},
	{1, L"GDE RUELLE DE LA", L"GRANDE RUELLE DE LA"},
	{1, L"GDE RUELLE DU", L"GRANDE RUELLE DU"},
	{1, L"GDE SENTE DES", L"GRANDE SENTE DES"},
	{1, L"GDE SENTE DU", L"GRANDE SENTE DU"},
	{1, L"GDE VOIE DES", L"GRANDE VOIE DES"},
	{1, L"GDN", L"GARDEN"},
	{1, L"GDNS", L"GARDENS"},
	{1, L"GEN", L"GENERAL"},
	{1, L"GÉN", L"GÉNÉRAL"},
	{1, L"GLAD", L"GLADE"},
	{1, L"GLD", L"GLADE"},
	{1, L"GLEN", L"GLEN"},
	{1, L"GLENS", L"GLENS"},
	{1, L"GLN", L"GLEN"},
	{1, L"GLNS", L"GLENS"},
	{1, L"GLY", L"GULLY"},
	{1, L"GR SCOL", L"GROUPE SCOLAIRE"},
	{1, L"GRA", L"GRANGE"},
	{1, L"GRDEN", L"GARDEN"},
	{1, L"GRDN", L"GARDEN"},
	{1, L"GRDNS", L"GARDENS"},
	{1, L"GREEN", L"GREEN"},
	{1, L"GREENS", L"GREENS"},
	{1, L"GRN", L"GREEN"},
	{1, L"GRNS", L"GREENS"},
	{1, L"GROV", L"GROVE"},
	{1, L"GROVE", L"GROVE"},
	{1, L"GROVES", L"GROVES"},
	{1, L"GRV", L"GROVE"},
	{1, L"GRVS", L"GROVES"},
	{1, L"GTE", L"GATE"},
	{1, L"GTWAY", L"GATEWAY"},
	{1, L"GTWY", L"GATEWAY"},
	{1, L"H L M", L"HABITATION ? LOYER MODÉRÉ"},
	{1, L"HAM AU", L"HAMEAU AU"},
	{1, L"HAM AUX", L"HAMEAU AUX"},
	{1, L"HAM D'", L"HAMEAU D'"},
	{1, L"HAM DE L'", L"HAMEAU DE L'"},
	{1, L"HAM DE LA", L"HAMEAU DE LA"},
	{1, L"HAM DE", L"HAMEAU DE"},
	{1, L"HAM DES", L"HAMEAU DES"},
	{1, L"HAM DU", L"HAMEAU DU"},
	{1, L"HAM", L"HAMEAU"},
	{1, L"HARB", L"HARBOR"},
	{1, L"HARBOR", L"HARBOR"},
	{1, L"HARBORS", L"HARBORS"},
	{1, L"HARBR", L"HARBOR"},
	{1, L"HAVEN", L"HAVEN"},
	{1, L"HAVN", L"HAVEN"},
	{1, L"HBR", L"HARBOR"},
	{1, L"HBRS", L"HARBORS"},
	{1, L"HD", L"HEAD"},
	{1, L"HEIGHT", L"HEIGHT"},
	{1, L"HEIGHTS", L"HEIGHTS"},
	{1, L"HENT", L"HENT"},
	{1, L"HGTS", L"HEIGHTS"},
	{1, L"HIGHWAY", L"HIGHWAY"},
	{1, L"HIGHWY", L"HIGHWAY"},
	{1, L"HILL", L"HILL"},
	{1, L"HILLS", L"HILLS"},
	{1, L"HILN", L"HIGHLANDS"},
	{1, L"HIWAY", L"HIGHWAY"},
	{1, L"HIWY", L"HIGHWAY"},
	{1, L"HL", L"HILL"},
	{1, L"HLLW", L"HOLLOW"},
	{1, L"HLS", L"HILLS"},
	{1, L"HOLLOW", L"HOLLOW"},
	{1, L"HOLLOWS", L"HOLLOWS"},
	{1, L"HOLW", L"HOLLOW"},
	{1, L"HOLWS", L"HOLLOWS"},
	{1, L"HOSP", L"HOSPITAL"},
	{1, L"HRBOR", L"HARBOR"},
	{1, L"HRBR", L"HARBOUR"},
	{1, L"HSE", L"HOUSE"},
	{1, L"HT", L"HEIGHT"},
	{1, L"HTH", L"HEATH"},
	{1, L"HTS", L"HEIGHTS"},
	{1, L"HVN", L"HAVEN"},
	{1, L"HVY", L"HAĎHWWAI"},
	{1, L"HVY", L"HIGHWAY"},
	{1, L"HWAY ", L"HIGHWAY"},
	{1, L"HWY ", L"HIGHWAY"},
	{1, L"HWY", L"HIGHWAY"},
	{1, L"I U T", L"INSTITUT UNIVERSITAIRE DE TECHNOLOGIES"},
	{1, L"IMM", L"IMMEUBLE"},
	{1, L"IMP ? L'", L"IMPASSE ? L'"},
	{1, L"IMP ?", L"IMPASSE ?"},
	{1, L"IMP AU", L"IMPASSE AU"},
	{1, L"IMP AUX", L"IMPASSE AUX"},
	{1, L"IMP D'", L"IMPASSE D'"},
	{1, L"IMP DE L'", L"IMPASSE DE L'"},
	{1, L"IMP DE LA", L"IMPASSE DE LA"},
	{1, L"IMP DE", L"IMPASSE DE"},
	{1, L"IMP DES", L"IMPASSE DES"},
	{1, L"IMP DU", L"IMPASSE DU"},
	{1, L"IMP", L"IMPASSE"},
	{1, L"ING", L"INGÉNIEUR"},
	{1, L"INLET", L"INLET"},
	{1, L"INLT", L"INLET"},
	{1, L"INST", L"INSTITUT"},
	{1, L"IS", L"ISLAND"},
	{1, L"ISLE", L"ISLE"},
	{1, L"ISLES", L"ISLES"},
	{1, L"ISLND", L"ISLAND"},
	{1, L"ISLNDS", L"ISLANDS"},
	{1, L"ISS", L"ISLANDS"},
	{1, L"JARD D'", L"JARDIN D'"},
	{1, L"JARD DE L'", L"JARDIN DE L'"},
	{1, L"JARD DE LA", L"JARDIN DE LA"},
	{1, L"JARD DE", L"JARDIN DE"},
	{1, L"JARD DES", L"JARDIN DES"},
	{1, L"JARD DU", L"JARDIN DU"},
	{1, L"JARD", L"JARDIN"},
	{1, L"JCT", L"JUNCTION"},
	{1, L"JCTION", L"JUNCTION"},
	{1, L"JCTN", L"JUNCTION"},
	{1, L"JCTNS", L"JUNCTIONS"},
	{1, L"JCTS", L"JUNCTIONS"},
	{1, L"JOHN F KENNEDY", L"JOHN FITZGERALD KENNEDY"},
	{1, L"JUNCTN", L"JUNCTION"},
	{1, L"JUNCTON", L"JUNCTION"},
	{1, L"KNL", L"KNOLL"},
	{1, L"KNLS", L"KNOLLS"},
	{1, L"KNOL", L"KNOLL"},
	{1, L"KNOLL", L"KNOLL"},
	{1, L"KNOLLS", L"KNOLLS"},
	{1, L"KY", L"KEY"},
	{1, L"KYS", L"KEYS"},
	{1, L"LA CLOSERIE DE LA", L"LA CLOSERIE DE LA"},
	{1, L"LA CLOSERIE DE", L"LA CLOSERIE DE"},
	{1, L"LA CLOSERIE DES", L"LA CLOSERIE DES"},
	{1, L"LA CLOSERIE DU", L"LA CLOSERIE DU"},
	{1, L"LA CLOSERIE", L"LA CLOSERIE"},
	{1, L"LA RÉSIDENCE DE", L"LA RÉSIDENCE DE"},
	{1, L"LA RÉSIDENCE DES", L"LA RÉSIDENCE DES"},
	{1, L"LA RÉSIDENCE DU", L"LA RÉSIDENCE DU"},
	{1, L"LA RÉSIDENCE", L"LA RÉSIDENCE"},
	{1, L"LA TERRASSE DE L'", L"LA TERRASSE DE L'"},
	{1, L"LA TERRASSE DE", L"LA TERRASSE DE"},
	{1, L"LA", L"A"},
	{1, L"LAKE", L"LAKE"},
	{1, L"LAKES", L"LAKES"},
	{1, L"LAND", L"LAND"},
	{1, L"LANDING", L"LANDING"},
	{1, L"LCK", L"LOCK"},
	{1, L"LCKS", L"LOCKS"},
	{1, L"LDG", L"LODGE"},
	{1, L"LDGE", L"LODGE"},
	{1, L"LE BOIS DE LA", L"LE BOIS DE LA"},
	{1, L"LE CLOS D'", L"LE CLOS D'"},
	{1, L"LE CLOS DE L'", L"LE CLOS DE L'"},
	{1, L"LE CLOS DE LA", L"LE CLOS DE LA"},
	{1, L"LE CLOS DE", L"LE CLOS DE"},
	{1, L"LE CLOS DES", L"LE CLOS DES"},
	{1, L"LE CLOS DU", L"LE CLOS DU"},
	{1, L"LE DOM D'", L"LE DOMAINE D'"},
	{1, L"LE DOM DE L'", L"LE DOMAINE DE L'"},
	{1, L"LE DOM DE LA", L"LE DOMAINE DE LA"},
	{1, L"LE DOM DE", L"LE DOMAINE DE"},
	{1, L"LE DOM DES", L"LE DOMAINE DES"},
	{1, L"LE DOM DU", L"LE DOMAINE DU"},
	{1, L"LE DOM", L"LE DOMAINE"},
	{1, L"L'ENCL DE LA", L"L'ENCLOS DE LA"},
	{1, L"L'ENCL DE", L"L'ENCLOS DE"},
	{1, L"L'ENCL DES", L"L'ENCLOS DES"},
	{1, L"L'ENCL DU", L"L'ENCLOS DU"},
	{1, L"LES JARD D'", L"LES JARDINS D'"},
	{1, L"LES JARD DE L'", L"LES JARDINS DE L'"},
	{1, L"LES JARD DE LA", L"LES JARDINS DE LA"},
	{1, L"LES JARD DE", L"LES JARDINS DE"},
	{1, L"LES JARD DES", L"LES JARDINS DES"},
	{1, L"LES JARD DU", L"LES JARDINS DU"},
	{1, L"LES JARD", L"LES JARDINS"},
	{1, L"LF", L"LOAF"},
	{1, L"LFS", L"BLUFFS"},
	{1, L"LGT", L"LIGHT"},
	{1, L"LGTS", L"LIGHTS"},
	{1, L"LIEU-DIT", L"LIEU-DIT"},
	{1, L"LIGHT", L"LIGHT"},
	{1, L"LIGHTS", L"LIGHTS"},
	{1, L"LIGNE DES", L"LIGNE DES"},
	{1, L"LITTÉR", L"LITTÉRATURE"},
	{1, L"LK", L"LAKE"},
	{1, L"LKOT", L"LOOKOUT"},
	{1, L"LKS", L"LAKES"},
	{1, L"LKT", L"LOOKOUT"},
	{1, L"LN", L"LANE"},
	{1, L"LNDG", L"LANDING"},
	{1, L"LNDNG", L"LANDING"},
	{1, L"LNWY", L"LANEWAY"},
	{1, L"LOAF", L"LOAF"},
	{1, L"LOCK", L"LOCK"},
	{1, L"LOCKS", L"LOCKS"},
	{1, L"LODG", L"LODGE"},
	{1, L"LODGE", L"LODGE"},
	{1, L"LOOP", L"LOOP"},
	{1, L"LOOPS", L"LOOPS"},
	{1, L"L'ORÉE D'", L"L'ORÉE D'"},
	{1, L"L'ORÉE DE LA", L"L'ORÉE DE LA"},
	{1, L"L'ORÉE DE", L"L'ORÉE DE"},
	{1, L"L'ORÉE DES", L"L'ORÉE DES"},
	{1, L"L'ORÉE DU", L"L'ORÉE DU"},
	{1, L"LOT A", L"LOTISSEMENT D'ACTIVITÉS"},
	{1, L"LOT I", L"LOTISSEMENT INDUSTRIEL"},
	{1, L"LOTISS ? L'", L"LOTISSEMENT ? L'"},
	{1, L"LOTISS ? LA", L"LOTISSEMENT ? LA"},
	{1, L"LOTISS ?", L"LOTISSEMENT ?"},
	{1, L"LOTISS AU", L"LOTISSEMENT AU"},
	{1, L"LOTISS AUX", L"LOTISSEMENT AUX"},
	{1, L"LOTISS D'", L"LOTISSEMENT D'"},
	{1, L"LOTISS DE L'", L"LOTISSEMENT DE L'"},
	{1, L"LOTISS DE LA", L"LOTISSEMENT DE LA"},
	{1, L"LOTISS DE", L"LOTISSEMENT DE"},
	{1, L"LOTISS DES", L"LOTISSEMENT DES"},
	{1, L"LOTISS DU", L"LOTISSEMENT DU"},
	{1, L"LOTISS", L"LOTISSEMENT"},
	{1, L"LOTS", L"LOTISSEMENTS"},
	{1, L"LT", L"LIEUTENANT"},
	{1, L"M I N", L"MARCHÉ D'INTÉR?T NATIONAL"},
	{1, L"M", L"MONSIEUR"},
	{1, L"MAJ", L"MAJOR"},
	{1, L"MAL", L"MARÉCHAL"},
	{1, L"MALL", L"MALL"},
	{1, L"MANOR", L"MANOR"},
	{1, L"MANORS", L"MANORS"},
	{1, L"MCKEE", L"MC KEE"},
	{1, L"MDOW", L"MEADOW"},
	{1, L"MDW", L"MEADOW"},
	{1, L"MDWS", L"MEADOWS"},
	{1, L"MEADOW", L"MEADOW"},
	{1, L"MEADOWS", L"MEADOWS"},
	{1, L"MEDOWS", L"MEADOWS"},
	{1, L"MEWS", L"MEWS"},
	{1, L"MIDDLEFIELD", L"MIDDLE-FIELD"},
	{1, L"MILL", L"MILL"},
	{1, L"MILLS", L"MILLS"},
	{1, L"MIS", L"MARQUIS"},
	{1, L"MISE", L"MARQUISE"},
	{1, L"MISSION", L"MISSION"},
	{1, L"MISSN", L"MISSION"},
	{1, L"MITAC", L"MY TACK"},
	{1, L"ML", L"MILL"},
	{1, L"MLLE", L"MADEMOISELLE"},
	{1, L"MLLES", L"MESDEMOISELLES"},
	{1, L"MLS", L"MILLS"},
	{1, L"MM", L"MESSIEURS"},
	{1, L"MME", L"MADAME"},
	{1, L"MMES", L"MESDAMES"},
	{1, L"MNDR", L"MEANDER"},
	{1, L"MNR", L"MANOR"},
	{1, L"MNRS", L"MANORS"},
	{1, L"MNT", L"MOUNT"},
	{1, L"MNTAIN", L"MOUNTAIN"},
	{1, L"MNTN", L"MOUNTAIN"},
	{1, L"MNTNS", L"MOUNTAINS"},
	{1, L"MONTAGUE", L"MONTIG-YOU"},
	{1, L"MOTORWAY", L"MOTORWAY"},
	{1, L"MOUNT", L"MOUNT"},
	{1, L"MOUNTAIN", L"MOUNTAIN"},
	{1, L"MOUNTAINS", L"MOUNTAINS"},
	{1, L"MOUNTIN", L"MOUNTAIN"},
	{1, L"MSGR", L"MONSEIGNEUR"},
	{1, L"MSN", L"MISSION"},
	{1, L"MSSN", L"MISSION"},
	{1, L"MT", L"MOUNT"},
	{1, L"MTIN", L"MOUNTAIN"},
	{1, L"MTN", L"MOUNTAIN"},
	{1, L"MTNS", L"MOUNTAINS"},
	{1, L"MTWY", L"MOTORWAY"},
	{1, L"N-D", L"NOTRE-DAME"},
	{1, L"NAT", L"NATIONAL"},
	{1, L"NB", L"NORTH BOUND"},
	{1, L"NCK", L"NECK"},
	{1, L"NE", L"NORD-EST"},
	{1, L"NE", L"NORTHEAST"},
	{1, L"NECK", L"NECK"},
	{1, L"NO", L"NORD-OUEST"},
	{1, L"NO", L"NORTH"},
	{1, L"NO1", L"NUMÉRO 1"},
	{1, L"NOUV CHEM DES", L"NOUVEAU CHEMIN DES"},
	{1, L"NOUV CHEM", L"NOUVEAU CHEMIN"},
	{1, L"NOUV CITÉ DE", L"NOUVELLE CITÉ DE"},
	{1, L"NOUV CITÉ DES", L"NOUVELLE CITÉ DES"},
	{1, L"NOUV CITÉ", L"NOUVELLE CITÉ"},
	{1, L"NOUV ROUTE DE L'", L"NOUVELLE ROUTE DE L'"},
	{1, L"NOUV ROUTE DE LA", L"NOUVELLE ROUTE DE LA"},
	{1, L"NOUV ROUTE DE", L"NOUVELLE ROUTE DE"},
	{1, L"NOUV ROUTE DES", L"NOUVELLE ROUTE DES"},
	{1, L"NOUV ROUTE DU", L"NOUVELLE ROUTE DU"},
	{1, L"NW", L"NORTHWEST"},
	{1, L"O N U", L"ORGANISATION DES NATIONS-UNIES"},
	{1, L"OPAS", L"OVERPASS"},
	{1, L"ORCH", L"ORCHARD"},
	{1, L"ORCHARD", L"ORCHARD"},
	{1, L"ORCHRD", L"ORCHARD"},
	{1, L"ORD", L"ORDINAIRE"},
	{1, L"OTE", L"ORIENTÉ"},
	{1, L"OTLK", L"OUTLOOK"},
	{1, L"OVAL", L"OVAL"},
	{1, L"OVERPASS", L"OVERPASS"},
	{1, L"OVL", L"OVAL"},
	{1, L"OVPS", L"OVERPASS"},
	{1, L"P A ART", L"PARC D'ACTIVITÉS ARTISANALES"},
	{1, L"P A E", L"PARC D'ACTVITÉS ECONOMIQUE"},
	{1, L"P A PECH", L"PARC D'ACTIVITÉS TECHNOLOGIQUES"},
	{1, L"P E", L"PARC D'ENTREPRISES"},
	{1, L"P H TECH", L"PARC DE HAUTO TECHNOLOGIE"},
	{1, L"P INT E", L"PARC INTERCOMMUNAL D'ENTREPRISES"},
	{1, L"P INTER A", L"PARC INTERNATIONAL D'ACTIVITÉS"},
	{1, L"P LOG", L"PARC LOGISTIQUE"},
	{1, L"P PAY & ART", L"PARC PAYSAGER ET ARTISANAL"},
	{1, L"P TECH", L"PARC TECHNOLOGIQUE"},
	{1, L"PARC ?", L"PARC ?"},
	{1, L"PARC AU", L"PARC AU"},
	{1, L"PARC AUX", L"PARC AUX"},
	{1, L"PARC D'", L"PARC D'"},
	{1, L"PARC DE L'", L"PARC DE L'"},
	{1, L"PARC DE LA", L"PARC DE LA"},
	{1, L"PARC DE", L"PARC DE"},
	{1, L"PARC DES", L"PARC DES"},
	{1, L"PARC DU", L"PARC DU"},
	{1, L"PARC LA", L"PARC LA"},
	{1, L"PARC LES", L"PARC LES"},
	{1, L"PARC", L"PARC"},
	{1, L"PARD", L"PARADE"},
	{1, L"PARK", L"PARK"},
	{1, L"PARKS", L"PARKS"},
	{1, L"PARKWAY", L"PARKWAY"},
	{1, L"PARKWAYS", L"PARKWAYS"},
	{1, L"PARKWY", L"PARKWAY"},
	{1, L"PARV DE L'", L"PARVIS DE L'"},
	{1, L"PARV DE LA", L"PARVIS DE LA"},
	{1, L"PARV DE", L"PARVIS DE"},
	{1, L"PARV DES", L"PARVIS DES"},
	{1, L"PARV DU", L"PARVIS DU"},
	{1, L"PARV", L"PARVIS"},
	{1, L"PASS ?", L"PASSAGE ?"},
	{1, L"PASS AU", L"PASSAGE AU"},
	{1, L"PASS AUX", L"PASSAGE AUX"},
	{1, L"PASS D'", L"PASSAGE D'"},
	{1, L"PASS DE L'", L"PASSAGE DE L'"},
	{1, L"PASS DE LA", L"PASSAGE DE LA"},
	{1, L"PASS DE", L"PASSAGE DE"},
	{1, L"PASS DES", L"PASSAGE DES"},
	{1, L"PASS DU", L"PASSAGE DU"},
	{1, L"PASS", L"PASS"},
	{1, L"PASSAGE", L"PASSAGE"},
	{1, L"PASSER D'", L"PASSERELLE D'"},
	{1, L"PASSER DE L'", L"PASSERELLE DE L'"},
	{1, L"PASSER DE LA", L"PASSERELLE DE LA"},
	{1, L"PASSER DE", L"PASSERELLE DE"},
	{1, L"PASSER DES", L"PASSERELLE DES"},
	{1, L"PASSER DU", L"PASSERELLE DU"},
	{1, L"PASSER", L"PASSERELLE"},
	{1, L"PATH", L"PATH"},
	{1, L"PATHS", L"PATHS"},
	{1, L"PCE", L"PRINCE"},
	{1, L"PCESSE", L"PRINCESSE"},
	{1, L"PD", L"POND"},
	{1, L"PDE", L"PARADE"},
	{1, L"PET CHEM DE L'", L"PETIT CHEMIN DE L'"},
	{1, L"PET CHEM DE LA", L"PETIT CHEMIN DE LA"},
	{1, L"PET CHEM DE", L"PETIT CHEMIN DE"},
	{1, L"PET CHEM DU", L"PETIT CHEMIN DU"},
	{1, L"PET CHEM", L"PETIT CHEMIN"},
	{1, L"PET CÔTE DES", L"PETITE CÔTE DES"},
	{1, L"PET IMP DES", L"PETITE IMPASSE DES"},
	{1, L"PET R ? LA", L"PETITE RUE ? LA"},
	{1, L"PET R AU", L"PETITE RUE AU"},
	{1, L"PET R AUX", L"PETITE RUE AUX"},
	{1, L"PET R D'", L"PETITE RUE D'"},
	{1, L"PET R DE L'", L"PETITE RUE DE L'"},
	{1, L"PET R DE LA", L"PETITE RUE DE LA"},
	{1, L"PET R DE", L"PETITE RUE DE"},
	{1, L"PET R DES", L"PETITE RUE DES"},
	{1, L"PET R DU", L"PETITE RUE DU"},
	{1, L"PET R L'", L"PETITE RUE L'"},
	{1, L"PET R", L"PETITE RUE"},
	{1, L"PET RANG", L"PETIT RANG"},
	{1, L"PET ROUTE DE L'", L"PETITE ROUTE DE L'"},
	{1, L"PET RUELLE", L"PETITE RUELLE"},
	{1, L"PET SENTE DES", L"PETITE SENTE DES"},
	{1, L"PET SENTIER DE", L"PETIT SENTIER DE"},
	{1, L"PET SENTIER DES", L"PETIT SENTIER DES"},
	{1, L"PET SENTIER DU", L"PETIT SENTIER DU"},
	{1, L"PET VOIE DE", L"PETITE VOIE DE"},
	{1, L"PET VOIE DES", L"PETITE VOIE DES"},
	{1, L"PHWY", L"PATHWAY"},
	{1, L"PIKE", L"PIKE"},
	{1, L"PIKES", L"PIKES"},
	{1, L"PINE", L"PINE"},
	{1, L"PINES", L"PINES"},
	{1, L"PK", L"PARK"},
	{1, L"PKT", L"POCKET"},
	{1, L"PKWAY", L"PARKWAY"},
	{1, L"PKWY", L"PARKWAY"},
	{1, L"PKWYS", L"PARKWAYS"},
	{1, L"PKY", L"PARKWAY"},
	{1, L"PL ? L'", L"PLACE ? L'"},
	{1, L"PL ?", L"PLACE ?"},
	{1, L"PL AU", L"PLACE AU"},
	{1, L"PL AUX", L"PLACE AUX"},
	{1, L"PL D'", L"PLACE D'"},
	{1, L"PL DE L'", L"PLACE DE L'"},
	{1, L"PL DE LA", L"PLACE DE LA"},
	{1, L"PL DES", L"PLACE DES"},
	{1, L"PL DU", L"PLACE DU"},
	{1, L"PL F LOG", L"PLATE-FORME LOGISTIQUE"},
	{1, L"PL L'", L"PLACE L'"},
	{1, L"PL", L"PLACE"},
	{1, L"PLACE", L"PLACE"},
	{1, L"PLAIN", L"PLAIN"},
	{1, L"PLAINES", L"PLAINES"},
	{1, L"PLAINS", L"PLAINES"},
	{1, L"PLAN D'", L"PLAN D'"},
	{1, L"PLAN DE L'", L"PLAN DE L'"},
	{1, L"PLAN DE LA", L"PLAN DE LA"},
	{1, L"PLAN DE", L"PLAN DE"},
	{1, L"PLAN DES", L"PLAN DES"},
	{1, L"PLAN DU", L"PLAN DU"},
	{1, L"PLAN", L"PLAN"},
	{1, L"PLAT DE L'", L"PLATEAU DE L'"},
	{1, L"PLAT DE LA", L"PLATEAU DE LA"},
	{1, L"PLAT DE", L"PLATEAU DE"},
	{1, L"PLAT DES", L"PLATEAU DES"},
	{1, L"PLAT DU", L"PLATEAU DU"},
	{1, L"PLAT", L"PLATEAU"},
	{1, L"PLAZA", L"PLAZA"},
	{1, L"PLN", L"PLAIN"},
	{1, L"PLNS", L"PLAINES"},
	{1, L"PLZ", L"PLAZA"},
	{1, L"PLZA", L"PLAZA"},
	{1, L"PNE", L"PINE"},
	{1, L"PNES", L"PINES"},
	{1, L"POINT", L"POINT"},
	{1, L"POINTS", L"POINTS"},
	{1, L"PÔLE ACT ET AFF", L"PÔLE D'ACTIVITÉ (S) ET D'AFFAIRES"},
	{1, L"PORT", L"PORT"},
	{1, L"PORTS", L"PORTS"},
	{1, L"PR", L"PRAIRIE"},
	{1, L"PRAIRIE", L"PRAIRIE"},
	{1, L"PRARIE", L"PRAIRIE"},
	{1, L"PRÉS", L"PRÉSIDENT"},
	{1, L"PRK", L"PARK"},
	{1, L"PROF", L"PROFESSEUR"},
	{1, L"PROM", L"PROMENADE"},
	{1, L"PROMENADE ?", L"PROMENADE ?"},
	{1, L"PROMENADE D'", L"PROMENADE D'"},
	{1, L"PROMENADE DE L'", L"PROMENADE DE L'"},
	{1, L"PROMENADE DE LA", L"PROMENADE DE LA"},
	{1, L"PROMENADE DE", L"PROMENADE DE"},
	{1, L"PROMENADE DES", L"PROMENADE DES"},
	{1, L"PROMENADE DU", L"PROMENADE DU"},
	{1, L"PRR", L"PRAIRIE"},
	{1, L"PRT", L"PORT"},
	{1, L"PRTS", L"PORTS"},
	{1, L"PS", L"PASS"},
	{1, L"PSGE", L"PASSAGE"},
	{1, L"PT ?", L"PONT ?"},
	{1, L"PT AU", L"PONT AU"},
	{1, L"PT AUX", L"PONT AUX"},
	{1, L"PT D'", L"PONT D'"},
	{1, L"PT DE L'", L"PONT DE L'"},
	{1, L"PT DE LA", L"PONT DE LA"},
	{1, L"PT DE", L"PONT DE"},
	{1, L"PT DES", L"PONT DES"},
	{1, L"PT DU", L"PONT DU"},
	{1, L"PT", L"POINT"},
	{1, L"PTE ?", L"PORTE ?"},
	{1, L"PTE AUX", L"PORTE AUX"},
	{1, L"PTE D'", L"PORTE D'"},
	{1, L"PTE DE L'", L"PORTE DE L'"},
	{1, L"PTE DE LA", L"PORTE DE LA"},
	{1, L"PTE DE", L"PORTE DE"},
	{1, L"PTE DES", L"PORTE DES"},
	{1, L"PTE DU", L"PORTE DU"},
	{1, L"PTE", L"PORTE"},
	{1, L"PTS", L"POINTS"},
	{1, L"PTWY", L"PATHWAY"},
	{1, L"PVT", L"PRIVATE"},
	{1, L"QDRT", L"QUADRANT"},
	{1, L"QU ? LA", L"QUAI ? LA"},
	{1, L"QU ?", L"QUAI ?"},
	{1, L"QU AU", L"QUAI AU"},
	{1, L"QU AUX", L"QUAI AUX"},
	{1, L"QU D'", L"QUAI D'"},
	{1, L"QU DE L'", L"QUAI DE L'"},
	{1, L"QU DE LA", L"QUAI DE LA"},
	{1, L"QU DE", L"QUAI DE"},
	{1, L"QU DES", L"QUAI DES"},
	{1, L"QU DU", L"QUAI DU"},
	{1, L"QU", L"QUAI"},
	{1, L"QUART AU", L"QUARTIER AU"},
	{1, L"QUART D'", L"QUARTIER D'"},
	{1, L"QUART DE L'", L"QUARTIER DE L'"},
	{1, L"QUART DE LA", L"QUARTIER DE LA"},
	{1, L"QUART DE", L"QUARTIER DE"},
	{1, L"QUART DES", L"QUARTIER DES"},
	{1, L"QUART DU", L"QUARTIER DU"},
	{1, L"QUART", L"QUARTIER"},
	{1, L"QY", L"QUAY"},
	{1, L"QYS", L"QUAYS"},
	{1, L"R ? L'", L"RUE ? L'"},
	{1, L"R ? LA", L"RUE ? LA"},
	{1, L"R ?", L"RUE ?"},
	{1, L"R A", L"RÉGIMENT D'ARTILLERIE"},
	{1, L"R AU", L"RUE AU"},
	{1, L"R AUX", L"RUE AUX"},
	{1, L"R CHEZ", L"RUE CHEZ"},
	{1, L"R D'", L"RUE D'"},
	{1, L"R DE L'", L"RUE DE L'"},
	{1, L"R DE LA", L"RUE DE LA"},
	{1, L"R DES", L"RUE DES"},
	{1, L"R DU", L"RUE DU"},
	{1, L"R I", L"RÉGIMENT D'INFANTERIE"},
	{1, L"R L'", L"RUE L'"},
	{1, L"R LA", L"RUE LA"},
	{1, L"R LE", L"RUE LE"},
	{1, L"R LES", L"RUE LES"},
	{1, L"R SUR LA", L"RUE SUR LA"},
	{1, L"R T M", L"RÉGIMENT DES TIRAILLEURS MAROCAINS"},
	{1, L"R", L"BRANCH"},
	{1, L"RAD", L"RADIAL"},
	{1, L"RADIAL", L"RADIAL"},
	{1, L"RADIEL", L"RADIAL"},
	{1, L"RADL", L"RADIAL"},
	{1, L"RAMP", L"RAMP"},
	{1, L"RANCH", L"RANCH"},
	{1, L"RANCHES", L"RANCHES"},
	{1, L"RAPID", L"RAPID"},
	{1, L"RAPIDS", L"RAPIDS"},
	{1, L"RCH", L"REACH"},
	{1, L"RD", L"ROAD"},
	{1, L"RDG", L"RIDGE"},
	{1, L"RDGE", L"RIDGE"},
	{1, L"RDGS", L"RIDGES"},
	{1, L"RDS", L"ROADS"},
	{1, L"RDWY", L"ROADWAY"},
	{1, L"RÉGION", L"RÉGIONAL(E)"},
	{1, L"REMP D'", L"REMPART D'"},
	{1, L"REMP DE L'", L"REMPART DE L'"},
	{1, L"REMP DE LA", L"REMPART DE LA"},
	{1, L"REMP DE", L"REMPART DE"},
	{1, L"REMP DES", L"REMPART DES"},
	{1, L"REMP DU", L"REMPART DU"},
	{1, L"REMP", L"REMPART"},
	{1, L"RES", L"RESERVE"},
	{1, L"RÉS", L"RÉSIDENCE"},
	{1, L"RÉSIDENCE ? L'", L"RÉSIDENCE ? L'"},
	{1, L"RÉSIDENCE ?", L"RÉSIDENCE ?"},
	{1, L"RÉSIDENCE AU", L"RÉSIDENCE AU"},
	{1, L"RÉSIDENCE D'", L"RÉSIDENCE D'"},
	{1, L"RÉSIDENCE DE L'", L"RÉSIDENCE DE L'"},
	{1, L"RÉSIDENCE DE LA", L"RÉSIDENCE DE LA"},
	{1, L"RÉSIDENCE DE", L"RÉSIDENCE DE"},
	{1, L"RÉSIDENCE DES", L"RÉSIDENCE DES"},
	{1, L"RÉSIDENCE DU", L"RÉSIDENCE DU"},
	{1, L"REST", L"REST"},
	{1, L"RF", L"REEF"},
	{1, L"RGT", L"RÉGIMENT"},
	{1, L"RICCI", L"RITCHI"},
	{1, L"RIDGE", L"RIDGE"},
	{1, L"RIDGES", L"RIDGES"},
	{1, L"RIV", L"RIVER"},
	{1, L"RIV", L"RIVI?RE"},
	{1, L"RIVER", L"RIVER"},
	{1, L"RIVR", L"RIVER"},
	{1, L"RK", L"ROCK"},
	{1, L"RMBL", L"RAMBLE"},
	{1, L"RN", L"ROUTE NATIONALE"},
	{1, L"RNCH", L"RANCH"},
	{1, L"RNCHS", L"RANCHES"},
	{1, L"RND", L"ROUND"},
	{1, L"RNGE", L"RANGE"},
	{1, L"ROAD", L"ROAD"},
	{1, L"ROADS", L"ROADS"},
	{1, L"ROC D'", L"ROCADE D'"},
	{1, L"ROC DE L'", L"ROCADE DE L'"},
	{1, L"ROC DE LA", L"ROCADE DE LA"},
	{1, L"ROC DE", L"ROCADE DE"},
	{1, L"ROC DES", L"ROCADE DES"},
	{1, L"ROC DU", L"ROCADE DU"},
	{1, L"ROC", L"ROCADE"},
	{1, L"ROND-POINT ?", L"ROND-POINT ?"},
	{1, L"ROND-POINT D'", L"ROND-POINT D'"},
	{1, L"ROND-POINT DE L'", L"ROND-POINT DE L'"},
	{1, L"ROND-POINT DE LA", L"ROND-POINT DE LA"},
	{1, L"ROND-POINT DE", L"ROND-POINT DE"},
	{1, L"ROND-POINT DES", L"ROND-POINT DES"},
	{1, L"ROND-POINT DU", L"ROND-POINT DU"},
	{1, L"ROUTE AU", L"ROUTE AU"},
	{1, L"ROUTE AUX", L"ROUTE AUX"},
	{1, L"ROUTE FOREST AU", L"ROUTE FORESTI?RE AU"},
	{1, L"ROUTE FOREST AUX", L"ROUTE FORESTI?RE AUX"},
	{1, L"ROUTE FOREST D'", L"ROUTE FORESTI?RE D'"},
	{1, L"ROUTE FOREST DE L'", L"ROUTE FORESTI?RE DE L'"},
	{1, L"ROUTE FOREST DES", L"ROUTE FORESTI?RE DES"},
	{1, L"ROUTE FOREST", L"ROUTE FORESTI?RE"},
	{1, L"ROUTE", L"ROUTE"},
	{1, L"ROW", L"ROW"},
	{1, L"RPD", L"RAPID"},
	{1, L"RPDS", L"RAPIDS"},
	{1, L"RST", L"REST"},
	{1, L"RTE", L"ROUTE"},
	{1, L"RTES", L"ROUTES"},
	{1, L"RTT", L"RETREAT"},
	{1, L"RUE", L"RUE"},
	{1, L"RUELLE", L"RUELLE"},
	{1, L"RUN", L"RUN"},
	{1, L"RV", L"RIVER"},
	{1, L"RVR", L"RIVER"},
	{1, L"S I", L"SECTEUR INDUSTRIEL"},
	{1, L"S/LTN", L"SOUS-LIEUTENANT"},
	{1, L"SB", L"SOUTH BOUND"},
	{1, L"SBWY", L"SUBWAY"},
	{1, L"SC", L"SCIENCE(S)"},
	{1, L"SCH", L"SCHOOL"},
	{1, L"SE", L"SOUTHEAST"},
	{1, L"SE", L"SUD-EST"},
	{1, L"SENT", L"SENTIER"},
	{1, L"SGT", L"SARGEANT"},
	{1, L"SGT", L"SERGENT"},
	{1, L"SHL", L"SHOAL"},
	{1, L"SHLS", L"SHOALS"},
	{1, L"SHOAL", L"SHOAL"},
	{1, L"SHOALS", L"SHOALS"},
	{1, L"SHOAR", L"SHORE"},
	{1, L"SHOARS", L"SHORES"},
	{1, L"SHORE", L"SHORE"},
	{1, L"SHORES", L"SHORES"},
	{1, L"SHR", L"SHORE"},
	{1, L"SHRS", L"SHORES"},
	{1, L"SKWY", L"SKYWAY"},
	{1, L"SKYWAY", L"SKYWAY"},
	{1, L"SLPE", L"SLOPE"},
	{1, L"SMT", L"SUMMIT"},
	{1, L"SND", L"SOUND"},
	{1, L"SO", L"SOUTH"},
	{1, L"SO", L"SUD-OUEST"},
	{1, L"SPG", L"SPRING"},
	{1, L"SPGS", L"SPRINGS"},
	{1, L"SPNG", L"SPRING"},
	{1, L"SPNGS", L"SPRINGS"},
	{1, L"SPRING", L"SPRING"},
	{1, L"SPRINGS", L"SPRINGS"},
	{1, L"SPRNG", L"SPRING"},
	{1, L"SPRNGS", L"SPRINGS"},
	{1, L"SPUR", L"SPUR"},
	{1, L"SPURS", L"SPURS"},
	{1, L"SQ", L"SQUARE"},
	{1, L"SQR", L"SQUARE"},
	{1, L"SQRE", L"SQUARE"},
	{1, L"SQRS", L"SQUARES"},
	{1, L"SQS", L"SQUARES"},
	{1, L"SQU", L"SQUARE"},
	{1, L"SQUARE", L"SQUARE"},
	{1, L"SQUARES", L"SQUARES"},
	{1, L"STA", L"STATION"},
	{1, L"STATION", L"STATION"},
	{1, L"STATN", L"STATION"},
	{1, L"STE", L"SAINTE"},
	{1, L"STÉ", L"SOCIÉTÉ"},
	{1, L"STN", L"STATION"},
	{1, L"STPS", L"STEPS"},
	{1, L"STR", L"STREET"},
	{1, L"STRA", L"STRAVENUE"},
	{1, L"STRAV", L"STRAVENUE"},
	{1, L"STRAVE", L"STRAVENUE"},
	{1, L"STRAVEN", L"STRAVENUE"},
	{1, L"STRAVENUE", L"STRAVENUE"},
	{1, L"STRAVN", L"STRAVENUE"},
	{1, L"STREAM", L"STREAM"},
	{1, L"STREME", L"STREAM"},
	{1, L"STRM", L"STREAM"},
	{1, L"STRP", L"STRIP"},
	{1, L"STRT", L"STREET"},
	{1, L"STRVN", L"STRAVENUE"},
	{1, L"STRVNUE", L"STRAVENUE"},
	{1, L"STS", L"STREETS"},
	{1, L"SUMIT", L"SUMMIT"},
	{1, L"SUMITT", L"SUMMIT"},
	{1, L"SUMMIT", L"SUMMIT"},
	{1, L"SUP", L"SUPÉRIEUR(E)"},
	{1, L"SW", L"SOUTHWEST"},
	{1, L"TER", L"TERRACE"},
	{1, L"TERR", L"TERRACE"},
	{1, L"TERRACE", L"TERRACE"},
	{1, L"THROUGHWAY", L"THROUGHWAY"},
	{1, L"TLPK", L"TRAILER PARK"},
	{1, L"TPK", L"TURNPIKE"},
	{1, L"TPKE", L"TURNPIKE"},
	{1, L"TR", L"TRAIL"},
	{1, L"TRACE", L"TRACE"},
	{1, L"TRACES", L"TRACES"},
	{1, L"TRACK", L"TRACK"},
	{1, L"TRACKS", L"TRACKS"},
	{1, L"TRAFFICWAY", L"TRAFFICWAY"},
	{1, L"TRAIL", L"TRAIL"},
	{1, L"TRAILS", L"TRAILS"},
	{1, L"TRAK", L"TRACK"},
	{1, L"TRCE", L"TRACE"},
	{1, L"TRFY", L"TRAFFICWAY"},
	{1, L"TRK", L"TRACK"},
	{1, L"TRKS", L"TRACKS"},
	{1, L"TRL", L"TRAIL"},
	{1, L"TRLS", L"TRAILS"},
	{1, L"TRNPK", L"TURNPIKE"},
	{1, L"TRPK", L"TURNPIKE"},
	{1, L"TRWY", L"THROUGHWAY"},
	{1, L"TUN D'", L"TUNNEL D'"},
	{1, L"TUN DE L'", L"TUNNEL DE L'"},
	{1, L"TUN DE LA", L"TUNNEL DE LA"},
	{1, L"TUN DE", L"TUNNEL DE"},
	{1, L"TUN DES", L"TUNNEL DES"},
	{1, L"TUN DU", L"TUNNEL DU"},
	{1, L"TUNEL", L"TUNNEL"},
	{1, L"TUNL", L"TUNNEL"},
	{1, L"TUNLS", L"TUNNELS"},
	{1, L"TUNNEL", L"TUNNEL"},
	{1, L"TUNNELS", L"TUNNELS"},
	{1, L"TUNNL", L"TUNNEL"},
	{1, L"TURNPIKE", L"TURNPIKE"},
	{1, L"TURNPK", L"TURNPIKE"},
	{1, L"TWR", L"TOWER"},
	{1, L"TWRS", L"TOWERS"},
	{1, L"UN", L"UNION"},
	{1, L"UNDERPASS", L"UNDERPASS"},
	{1, L"UNION", L"UNION"},
	{1, L"UNIONS", L"UNIONS"},
	{1, L"UNIV", L"UNIVERSITÉ"},
	{1, L"UNNAMED", L"UNNNAMED"},
	{1, L"UNP", L"UNDERPASS"},
	{1, L"UNS", L"UNIONS"},
	{1, L"UPAS", L"UNDERPASS"},
	{1, L"V ART", L"VILLAGE ARTISANALE"},
	{1, L"V/AM", L"VICE-AMIRAL"},
	{1, L"V", L"VILLA"},
	{1, L"VALL ?", L"VALLÉE ?"},
	{1, L"VALL AUX", L"VALLÉE AUX"},
	{1, L"VALL D'", L"VALLÉE D'"},
	{1, L"VALL DE L'", L"VALLÉE DE L'"},
	{1, L"VALL DE LA", L"VALLÉE DE LA"},
	{1, L"VALL DE", L"VALLÉE DE"},
	{1, L"VALL DES", L"VALLÉE DES"},
	{1, L"VALL DU", L"VALLÉE DU"},
	{1, L"VALLEY", L"VALLEY"},
	{1, L"VALLEYS", L"VALLEYS"},
	{1, L"VALLY", L"VALLEY"},
	{1, L"VDCT", L"VIADUCT"},
	{1, L"VENELLE ?", L"VENELLE ?"},
	{1, L"VENELLE AU", L"VENELLE AU"},
	{1, L"VENELLE AUX", L"VENELLE AUX"},
	{1, L"VENELLE D'", L"VENELLE D'"},
	{1, L"VENELLE DE L'", L"VENELLE DE L'"},
	{1, L"VENELLE DE LA", L"VENELLE DE LA"},
	{1, L"VENELLE DE", L"VENELLE DE"},
	{1, L"VENELLE DES", L"VENELLE DES"},
	{1, L"VENELLE DU", L"VENELLE DU"},
	{1, L"VENELLE", L"VENELLE"},
	{1, L"VIA", L"VIADUCT"},
	{1, L"VIAD", L"VIADUCT"},
	{1, L"VIADCT", L"VIADUCT"},
	{1, L"VIADUCT", L"VIADUCT"},
	{1, L"VIC", L"VICINAL"},
	{1, L"VIEILLE ROUTE DE LA", L"VIEILLE ROUTE DE LA"},
	{1, L"VIEILLE RTE DE", L"VIEILLE ROUTE DE"},
	{1, L"VIEILLE RUE AUX", L"VIEILLE RUE AUX"},
	{1, L"VIEW", L"VIEW"},
	{1, L"VIEWS", L"VIEWS"},
	{1, L"VILL AU", L"VILLAGE AU"},
	{1, L"VILL D'", L"VILLAGE D'"},
	{1, L"VILL DE L'", L"VILLAGE DE L'"},
	{1, L"VILL DE LA", L"VILLAGE DE LA"},
	{1, L"VILL DE", L"VILLAGE DE"},
	{1, L"VILL DES", L"VILLAGE DES"},
	{1, L"VILL DU", L"VILLAGE DU"},
	{1, L"VILL", L"VILLAGE"},
	{1, L"VILL", L"VILLAS"},
	{1, L"VILLAG", L"VILLAGE"},
	{1, L"VILLAGE", L"VILLAGE"},
	{1, L"VILLAGES", L"VILLAGES"},
	{1, L"VILLE", L"VILLE"},
	{1, L"VILLG", L"VILLAGE"},
	{1, L"VILLIAGE", L"VILLAGE"},
	{1, L"VIS", L"VISTA"},
	{1, L"VIST", L"VISTA"},
	{1, L"VISTA", L"VISTA"},
	{1, L"VL", L"VILLE"},
	{1, L"VLG", L"VILLAGE"},
	{1, L"VLGS", L"VILLAGES"},
	{1, L"VLS", L"VILLAS"},
	{1, L"VLY", L"VALLEY"},
	{1, L"VLLY", L"VALLEY"},
	{1, L"VLYS", L"VALLEYS"},
	{1, L"VOIRIE COMM", L"VOIRIE COMMUNALE"},
	{1, L"VOIRIE COMMU DU", L"VOIRIE COMMUNALE DU"},
	{1, L"VST", L"VISTA"},
	{1, L"VSTA", L"VISTA"},
	{1, L"VW", L"VIEW"},
	{1, L"VWS", L"VIEWS"},
	{1, L"VX CHEM D'", L"VIEUX CHEMIN D'"},
	{1, L"VX CHEM DE L'", L"VIEUX CHEMIN DE L'"},
	{1, L"VX CHEM DE LA", L"VIEUX CHEMIN DE LA"},
	{1, L"VX CHEM DE", L"VIEUX CHEMIN DE"},
	{1, L"VX CHEM DES", L"VIEUX CHEMIN DES"},
	{1, L"VX CHEM DU", L"VIEUX CHEMIN DU"},
	{1, L"VX CHEM", L"VIEUX CHEMIN"},
	{1, L"VX PONT DE", L"VIEUX PONT DE"},
	{1, L"WALK", L"WALK"},
	{1, L"WALKS", L"WALKS"},
	{1, L"WALL", L"WALL"},
	{1, L"WAY", L"WAY"},
	{1, L"WAYS", L"WAYS"},
	{1, L"WB", L"WEST BOUND"},
	{1, L"WDS", L"WOODS"},
	{1, L"WELL", L"WELL"},
	{1, L"WELLS", L"WELLS"},
	{1, L"WHRF", L"WHARF"},
	{1, L"WK", L"WALK"},
	{1, L"WKWY", L"WALKWAY"},
	{1, L"WL", L"WELL"},
	{1, L"WLS", L"WELLS"},
	{1, L"WY", L"WAY"},
	{1, L"WYS", L"WAYS"},
	{1, L"XING", L"CROSSING"},
	{1, L"XRD", L"CROSSROAD"},
	{1, L"Z A C", L"ZONE D'AMÉNAGEMENT CONCERTÉ"},
	{1, L"Z A D", L"ZONE D'AMÉNAGEMENT DIFFÉRÉE"},
	{1, L"Z A E S", L"ZONE D'ACTIVITÉS ET DE SERVICES"},
	{1, L"Z A E T", L"ZONE D'ACTIVITÉ ECONOMIQUE ET TERTIAIRE"},
	{1, L"Z A E", L"ZONE D'ACTIVITÉ ECONOMIQUE"},
	{1, L"Z A I", L"ZONE D'ACTIVITÉ(S) INTERCOMMUNALE"},
	{1, L"Z A L", L"ZONE D'ACTIVITÉ(S) LÉG?RES"},
	{1, L"Z A", L"ZONE D'ACTIVITÉ(S)"},
	{1, L"Z CCIALE", L"ZONE COMMERCIALE"},
	{1, L"Z I & ART", L"ZONE INDUSTRIEL ET ARTISANALE"},
	{1, L"Z I A C", L"ZONE INDUSTRIELLE ARTISANALE ET COMMERCIALE"},
	{1, L"Z I L", L"ZONE INDUSTRIELLE LÉG?RE"},
	{1, L"Z I P", L"ZONE INDUSTRIALO PORTUAIRE"},
	{1, L"Z INT", L"ZONE INTERCOMMUNALE"},
	{1, L"Z R U", L"ZONE DE REDYNAMISATION URBAINE"},
	{1, L"Z U P", L"ZONE D'URBANISATION PRIORITAIRE"},
	{1, L"ZA", L"ZONE ARTISANALE"},
	{1, L"ZAC", L"ZONE D'ACTIVITÉS COMMERCIALES"},
	{1, L"ZAE", L"ZONE D'ACTIVITÉS ÉCONOMIQUES"},
	{1, L"ZI", L"ZONE INDUSTRIELLE"},
	}
)	

transform.direction_abbrev = TRANSFORM.new({
	{2,L"\\bS\\.?W\\.?\\b",L"South West"},
	{2,L"\\bS\\.?E\\.?\\b",L"South East"},
	{2,L"\\bN\\.?W\\.?\\b",L"North West"},
	{2,L"\\bN\\.?E\\.?\\b",L"North East"},

	{1,L"S",L"South"},
	{1,L"SO",L"South"},
	{1,L"SO.",L"South"},
	
	{1,L"N",L"North"},
	{1,L"NO",L"North"},
	{1,L"NO.",L"North"},
	
	{1,L"E",L"East"},
	{1,L"E.",L"East"},
	
	{1,L"W",L"West"},
	{1,L"W.",L"West"},
	
	{1,L"EB",L"East Bound"},
	{1,L"WB",L"West Bound"},
	{1,L"SB",L"South Bound"},
	{1,L"NB",L"North Bound"},
	}
)

transform.state_name_abbrev = TRANSFORM.new({
	{1,L"AL", L"Alabama"},
	{1,L"AK", L"Alaska"},
	{1,L"AZ", L"Arizona"},
	{1,L"AR", L"Arkansas"},
	{1,L"CA", L"California"},
	{1,L"CO", L"Colorado"},
	{1,L"CT", L"Connecticut"},
	{1,L"DE", L"Delaware"},
	{1,L"FL", L"Florida"},
	{1,L"GA", L"Georgia"},
	{1,L"HI", L"Hawaii"},
	{1,L"ID", L"Idaho"},
	{1,L"IL", L"Illinois"},
	{1,L"IN", L"Indiana"},
	{1,L"IA", L"Iowa"},
	{1,L"KS", L"Kansas"},
	{1,L"KY", L"Kentucky"},
	{1,L"LA", L"Louisiana"},
	{1,L"ME", L"Maine"},
	{1,L"MD", L"Maryland"},
	{1,L"MA", L"Massachusetts"},
	{1,L"MI", L"Michigan"},
	{1,L"MN", L"Minnesota"},
	{1,L"MS", L"Mississippi"},
	{1,L"MO", L"Missouri"},
	{1,L"MT", L"Montana"},
	{1,L"NE", L"Nebraska"},
	{1,L"NV", L"Nevada"},
	{1,L"NH", L"New Hampshire"},
	{1,L"NJ", L"New Jersey"},
	{1,L"NM", L"New Mexico"},
	{1,L"NY", L"New York"},
	{1,L"NC", L"North Carolina"},
	{1,L"ND", L"North Dakota"},
	{1,L"OH", L"Ohio"},
	{1,L"OK", L"Oklahoma"},
	{1,L"OR", L"Oregon"},
	{1,L"PA", L"Pennsylvania"},
	{1,L"RI", L"Rhode Island"},
	{1,L"SC", L"South Carolina"},
	{1,L"SD", L"South Dakota"},
	{1,L"TN", L"Tennessee"},
	{1,L"TX", L"Texas"},
	{1,L"UT", L"Utah"},
	{1,L"VT", L"Vermont"},
	{1,L"VA", L"Virginia"},
	{1,L"WA", L"Washington"},
	{1,L"WV", L"West Virginia"},
	{1,L"WI", L"Wisconsin"},
	{1,L"WY", L"Wyoming"},
	}
)

transform.fraction_road = TRANSFORM.new({
	{2,L" 1/2 ",L" and a half "},
	{2,L" 1/2$",L" and a half"},
	}
)

transform.road_number_head = TRANSFORM.new(transform.direction_abbrev, {
	{1, L"HWY", L"Highway"},
	{1, L"JCT", L"JUNCTION"},
	}
)

transform.road_number_tail = TRANSFORM.new(transform.direction_abbrev, {
	{1, L"BL", L"Business Loop"},
	{1, L"BR", L"Business Road"},
	{1, L"BS", L"Business Spur"},
	{1, L"BYP", L"Bypass"},
	{1, L"BYPA", L"Bypass"},
	{1, L"BYPAS", L"Bypass"},
	{1, L"BYPS", L"Bypass"},
	{1, L"HWY", L"Highway"},
	{1, L"JCT", L"JUNCTION"},
	{1, L"L", L"Loop"},
	{1, L"TPK",L"Turnpike"},
	{1, L"TPKE",L"Turnpike"},
	{1, L"TRNPK",L"Turnpike"},
	{1, L"TRPK",L"Turnpike"},
	{1, L"TURNPK",L"Turnpike"},
	}
)

transform.direction_roadname_abbrev = TRANSFORM.new(transform.direction_abbrev, transform.roadname_abbrev_table)

