-----------------------------------------------------------------------------------
-- Adio das facilidades Cone-30 na diMka WA_P.1.7.1_GpsForum_Cappuccino_BR_mod_AD
--
-- * Suporte estendido de 24 para 32 tipos de alerta;
-- * Adicionado alerta de "Zona Violenta" no type 30;
-- * Adicionado alerta de "Altura mxima permitida" no type 37, que corresponde ao
--   type 5 interno;
-- * Mini dicionario embutido para facilitar a introduo de novas frases sem
--   necessidade de alteraes na voz ou na lang, alm de facilidades extras como
--   as falas do nome da localidade no alerta de permetro ubano e da altura no
--   alerta de altura limitada.
-- * Adio do nome da localidade ao alerta de permetro urbano;
-- * Adio da previso de chegada ao resumo da rota;
-- * Tipos reordenados pelo type do txt na apresentao para configurao de frases
--   extras. Facilita a identificao do valor do type por contagem;
-- * Os tipos vagos so apresentados com cones transparentes na tela de configurao
--   para fcil identificao, mas bloqueados;
--
-- Fidelis Assis
-----------------------------------------------------------------------------------

MODEL.SETPERSISTENT.lua.camera_setting114_32 = BOOL_MODEL(false)
MODEL.SET.lua.last_low_bridge_height_text = CSTRING_MODEL('')

-- utils
function sd_undefined_type(n)
  return n > 24 and n < 30
end

local function get_low_bridge_height()
  if MODEL.navigation.curr_speedcam.category() == 5 then
    local coords = tostring(MODEL.navigation.curr_speedcam.position())
    if coords:match('= 250') then
      coords = tostring(MODEL.navigation.curr_speedcam.position())
    end
    if coords:match('= 250') then
      return nil
    end
    local m, d = coords:match('(%d),.+(%d)$')
    return m, d
  else
    return nil
  end
end

local last_low_bridge_height_speech = ''
function sd_get_low_bridge_height()
  local m, d = get_low_bridge_height()
  if type(m) == 'string' and type(d) == 'string' then 
    MODEL.lua.last_low_bridge_height_text = m .. ',' .. d .. 'm'
    local nm, nd = tonumber(m), tonumber(d)
    -- alterar depois para usar 0 e 1 representando 10 e 11m ou usar a velocidade?
    if nm >= 1 then -- s fala se for maior ou igual a 1m
      local int = m .. (nm > 1 and ' metros' or ' metro')
      local cents = nd > 0 and ' e ' .. d .. '0.' or '.'
      last_low_bridge_height_speech =  ' ' .. int .. cents
    else
      last_low_bridge_height_speech = ''
    end
  else
    MODEL.lua.last_low_bridge_height_text = ''
    last_low_bridge_height_speech = ''
  end
  return MODEL.lua.last_low_bridge_height_text()
end

-- Adicione novas frases aqui
local skin_dictionary = {
  ["Destination"]="Destination",
  ["Low bridge,"]="Low Bridge,",
  ["Road police station,"]="Road Police Station,",
  ["Violence zone,"]="Violence Zone,",
}

-- populate the local dictionaries
local lang_dictionary, voice_dictionary = {}, {}

for k, v in pairs(skin_dictionary) do
  lang_dictionary[m_i18n(k)] = v
  voice_dictionary[m_i18n_voice(k)] = towstring(v)
end
-- discard dictionary data to save memory
skin_dictionary = nil

-- menu item translation.
sd_translate_menu = function(s, onde)
  if type(s) ~= 'string' and type(s) ~= 'wstring' then
    return s
  end
  return lang_dictionary[m_i18n(s)] or s
end


-- Hooks for original functions

-- voice functions
local sd_is_it_voice_localizable_orig = MODEL.regional.is_it_voice_localizable
MODEL_regional_is_it_voice_localizable = function(s)
  return voice_dictionary[s] and true or sd_is_it_voice_localizable_orig(s)
end
  
local pu_i18n_voice = m_i18n_voice('Town entry point,')
local wcolon = towstring(': ')
local translate_voice_orig = translate_voice
translate_voice = function(s)
  if type(s) ~= 'string' and type(s) ~= 'wstring' then
    return s
  end
  local st = voice_dictionary[m_i18n_voice(s)] or voice_dictionary[s]
  if st and (s == pu_i18n_voice) then
    st =  st .. wcolon .. MODEL.navigation.car.address.city()
  elseif st and (s == "Low bridge,") then
    st =  st .. towstring(last_low_bridge_height_speech)
  end
  return st or translate_voice_orig(s)
end

local translated_voice_format_orig = translated_voice_format
translated_voice_format = function(s, ...)
  if type(s) ~= 'string' and type(s) ~= 'wstring' then
    return s
  end
  local st = voice_dictionary[m_i18n_voice(s)]
  return st and wstring.format(st, ...) or translated_voice_format_orig(s, ...)
end

-- lang functions
local translate_orig = translate
translate = function(s)
  if type(s) ~= 'string' and type(s) ~= 'wstring' then
    return s
  end
  local st = lang_dictionary[s] or lang_dictionary[m_i18n(s)]
  return st and towstring(st) or translate_orig(s)
end

local translated_format_orig = translated_format
translated_format = function(s, ...)
  if type(s) ~= 'string' and type(s) ~= 'wstring' then
    return s
  end
  local st = lang_dictionary[s] or lang_dictionary[m_i18n(s)]
  return st and wstring.format(towstring(st), ...) or translated_format_orig(s, ...)
end

-- add ETA to route summary
sc_ReadOutRouteSummary = function(summary)
  PromptCancel(gRouteSummaryID)
  gRouteSummaryID = 0
  local eta = L''
  if type(VOICE.eta) == 'function' and MODEL.navigation.eta_at_destination.valid() then
    eta = L'. ' .. VOICE.eta(MODEL.navigation.eta_at_destination())
  end
  MODEL.lua.RouteSummaryText = MODEL.sound.voice.get_route_summary() .. eta
  if MODEL.lua.RouteSummaryText() ~= L"" then
    MODEL.lua.RouteSummaryIsSpeaking = true
    gRouteSummaryID = MODEL.sound.speech.say("voice.info", MODEL.lua.RouteSummaryText(), {callback = sc_ReadOutRouteSummary_Callback})
    MODEL.lua.ReadOutRouteSummaryHappened = true
  end
end

--------------------------------------------------------------------
-- end of Cone-30 functions
--------------------------------------------------------------------

wGetNUSupported = EMapMode.Mode_2D_NU == 3 and sc_GetSysEntry("map", "north_up", 0)
sc_start_customize = function()
	doDelayed(1, sc_wReadOutStartInfo)
	sc_wReadOutDASupported()
	sc_wReadOutSCSupported()
	sc_FilesFont_check()
	sc_WarnTypeVoice_set()
	sc_TolTypeReinit()
	sc_wCameraSettingLanguages_Load()
	sc_wCameraSettingProfile_Load()
	sc_wCameraSettingProfile_Set()
	sc_wCameraSetting_Load()
	obs_night:START()
	obs_timer:START()
	MODEL.lua.wSSFlag = nil
	MODEL.lua.wSSFlagSS = nil
	sc_wBuildCockpitMenu()
	ui.fullCockpitMenuList:sort("menu_index")
	sc_wBuildCockpitSkipMenu()
	sc_wLaneInfo_change()
	sc_wSetDynamicVolumeType()
	if MODEL.EXISTS.tmc.present() and MODEL.tmc.present() then
		sc_wTmcChangeTunning()
	end
	obs_wcarposvalid:START()
	MODEL.lua.iconhue = 0
	obs_witinerwaypoint:START("NO_TRIGGER")
	local wkeypanel1, wkeypanel2 = false, false
	for panelModel in ModelList_iter(MODEL.regional.keyboard.panels) do
		if MODEL.lua.wQuickKeyPanel1() == panelModel.name() then
			wkeypanel1 = true
		end
		if MODEL.lua.wQuickKeyPanel2() == panelModel.name() then
			wkeypanel2 = true
		end
	end
	if not wkeypanel1 then
		MODEL.lua.wQuickKeyPanel1 = L"Default"
	end
	if not wkeypanel2 then
		MODEL.lua.wQuickKeyPanel2 = L"Default"
	end
	sc_wCandidateKeyboardLayout_SetName(PERSISTENT.keyboard_panel_alpha())
	if MODEL.lua.wCockpitTrip() >= MODEL.other.trips.size() then
		MODEL.lua.wCockpitTrip = 0
	end
	if MODEL.lua.wCockpitTripSS() >= MODEL.other.trips.size() then
		MODEL.lua.wCockpitTripSS = 0
	end
	sc_wUserPOISearchParams_Load()
	if sc_GetSysEntry("utility", "calibratefix", 0) then
		START_APPLICATION(L"utility/esc.exe","")
		sc_CalibrateScreen()
	end
	obs_wtolerance:START()
	obs_wspeedmode:START()
	sc_wCheckHotButtons()
	MODEL.lua.SignpostOn = true
	lm_CockpitList.no_route:append(lm_CockpitList[wCockpitFieldNoRoute4()])
	lm_CockpitList.has_route:append(lm_CockpitList[wCockpitField4()])
	lm_CockpitList.no_route[0] = lm_CockpitList[wCockpitFieldNoRoute1()]
	lm_CockpitList.no_route[1] = lm_CockpitList[wCockpitFieldNoRoute2()]
	lm_CockpitList.no_route[2] = lm_CockpitList[wCockpitFieldNoRoute3()]
	lm_CockpitList.has_route[0] = lm_CockpitList[wCockpitField1()]
	lm_CockpitList.has_route[1] = lm_CockpitList[wCockpitField2()]
	lm_CockpitList.has_route[2] = lm_CockpitList[wCockpitField3()]
	local wno_route_closed_id = _G["wCockpitFieldNoRoute" .. tostring(wCockpitFieldNoRouteClosed())]()
	lm_CockpitList.no_route_closed[0] = lm_CockpitList[wno_route_closed_id]
	local whas_route_closed_id = _G["wCockpitField" .. tostring(wCockpitFieldClosed())]()
	lm_CockpitList.has_route_closed[0] = lm_CockpitList[whas_route_closed_id]
	lm_CockpitList.track_playing:append(lm_CockpitList[17], lm_CockpitList[18], lm_CockpitList[21], lm_CockpitList[8])
	lm_CockpitListSS.has_route:append(lm_CockpitListSS[wCockpitFieldSS1()], lm_CockpitListSS[wCockpitFieldSS2()], lm_CockpitListSS[wCockpitFieldSS3()])
	lm_CockpitListSS.no_route:append(lm_CockpitListSS[wCockpitFieldNoRouteSS1()], lm_CockpitListSS[wCockpitFieldNoRouteSS2()], lm_CockpitListSS[wCockpitFieldNoRouteSS3()])
	for item in ModelList_iter(lm_CockpitList.has_route) do
		lm_CockpitList.has_route_via:append(item)
	end
	lm_CockpitList.has_route_closed_via:append(lm_CockpitList.has_route_closed[0])
	sc_wSetCockpitListVia()
	ui.btnFA_go.ONRELEASE = function() wFind_createroute = false sc_SmartGo() end
	ui.btnFA_go.ONLONGCLICK = function() wFind_createroute = true sc_SmartGo() end
	if MODEL.lua.vEasyMapMode() > 2 and not wGetNUSupported then
		MODEL.lua.vEasyMapMode = 1
	end
	if MODEL.EXISTS.route.allow_env_zone() then
		obs_wumwelt_nonactive:START("NO_TRIGGER")
		obs_wumwelt_active:START("NO_TRIGGER")
	end
	st_EasyFindMenu:removeLayers("ui_EasyFindMenu", "ui_EasyFindMenuHistoryPanel")
	st_EasyFindMenu:useLayers("ui_wEasyFindMenu", "ui_wEasyFindMenuHistoryPanel")
	sc_start_customize = nil
end
 
MODEL.lua.MainMenuState = L"st_MainMenu"
MODEL.lua.CockpitType = 0
wPortrait = false
st_VisualGuidanceSettings:useLayers("ui_List_Background")
--address.lua
 
sc_FindAddressDone = function()
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	if AddressSearchState.mode == AddressSearchMode.address then
		if st_VR.isEntered or gSkipFirstVRScreen or ui.vPromptMode == 2 and st_MainMenuVR.isEntered and st_FindAddressHousenumber.isActive then
			PREVSTATE()
		elseif gEditFavouriteAddress then
			sc_routeto_show_route()
		else
			sc_wMultiSelect_ItemDone()
		end
	elseif AddressSearchState.mode == AddressSearchMode.poi then
		if wMultiChangeSearchCenter_Edit then
			sc_wMultiInitSearchBase(MODEL.my.map.selected_item.position())
			sc_back()
			if ui.inp_wMultiFind.VALUE() then
				sc_wMultiFindResult()
			end
		else
			MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
			sc_OtherPoi_Search_ByCat()
		end
	elseif AddressSearchState.mode == AddressSearchMode.weather then
		MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
		MODEL.other.weather.add_location(txtAWL_City.prop.TEXT, MODEL.map.cursor.position())
		sc_back()
	elseif AddressSearchState.mode == AddressSearchMode.cityCenter then
		sc_FitCityCenterOnMap()
	elseif AddressSearchState.mode == AddressSearchMode.startPos then
		MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
		sc_GoToRouteMethod()
	end
end
 
sc_wFooterDone_onlongclick = function()
	if vActiveState() == "st_findaddresshousenumber" then
		wFind_createroute = true
		sc_FindAddressHousenumberOK()
	end
end
 
--advmenu.lua
w_InSelectHomeOfficeTemp = -1
wUserSoundType = ""
wAudioVoiceCameraTimer = -1
wAudioVoiceCameraPlayed = false
wInpValueInteger_min = 0
wInpValueInteger_max = 0
wInpValueInteger_needsign = false
wInpValueInteger_model = ""
wTmpdateDelimiter = nil
wUnitConvMeter2Unit = {float.new("1.093613298"), float.new("1.0"), float.new("3.280839895")}
wProvider = 0
wSelectProgramMode = 0
wShowHelpTextTimer = -1
wFind_createroute = false
wSelectedItemHotName = L""
wSelectedItemHotPos = nil
wSelectedItemHotAction = false
 
st_EasyFindMenu.init = function()
	sc_ShowMapUpdateNotification()
	if EditRouteAddVIA == EAddViaMode.ChangeStart then
		txtTitle.TEXT = m_i18n("Set Starting Point")
	elseif MODEL.lua.InEditRoute() then
		txtTitle.TEXT = m_i18n("Add to Route")
	elseif MODEL.lua.wInSelectHomeOffice() then
		txtTitle.TEXT = m_i18n("Select position for quick buttons")
	else
		txtTitle.TEXT = m_i18n("Find")
	end
	MODEL.mydata.history.process_smart_sort()
	sc_SearchFavorites()
	sc_SaveRoute()
end
 
local st_EasyFindMenu_exit_orig = st_EasyFindMenu.exit
st_EasyFindMenu.exit = function()
	st_EasyFindMenu_exit_orig()
	MODEL.lua.wInSelectHomeOffice = false
end
 
sc_FindOnMapOnrelease = function()
	MODEL.my.map.select_gcoor(MODEL.map.cursor.position())
	MODEL.lua.LockToCar = true
	MODEL.lua.ItemHasJustSelected = false
	if MODEL.lua.featured_provider_id() == -1 or not MODEL.network.supported() then
		sc_NextStateAnim(st_FindOnMap, "3d", 0, sc_GetFlipAnim(true, SELF.prop.X, SELF.prop.Y, SELF.prop.W, SELF.prop.H))
	else
		sc_NextStateAnim(st_FindOnMap, "fade", 1, "")
	end
end
 
sc_Go_Find_GeoCoord = function()
	if MODEL.lua.featured_provider_id() == -1 and MODEL.network.supported() then
		sc_close_local_menu()
	end
	sc_NextStateAnim(st_Input_GeoCoord, "fade")
end
 
sc_wLM_DeleteWaypointMSG = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	local waypoints = MODEL.route.list.navigated.waypoints
	waypoints.list.index = waypoints.strapped_waypoint_id()
	local text = (waypoints.list.index() == waypoints.list.lastindex() and translated_format(m_i18n("Are you sure you want to delete your destination?")) or translated_format(m_i18n("Are you sure you want to delete this waypoint?")))
	sc_wShowNewMessageBox(text,"sc_wLM_DeleteWaypoint",m_i18n("Delete"),"ico_del_sml.bmp#3",waypoints.list.current.WSTR.longname())
end
 
sc_wLM_DeleteWaypoint = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	local waypoints = MODEL.route.list.navigated.waypoints
	waypoints.list.index = waypoints.strapped_waypoint_id()
	if waypoints.list.index() == 0 then
		if waypoints.start_is_user_selected() then
			sc_TurnOnGPSMsg()
		else
			sc_ChangeStartPointMSG()
		end
	elseif waypoints.list.size() == 0 then
		sc_ChangeStartPointMSG()
	else
		waypoints.remove()
	end
	MODEL.lua.LastDestination = MODEL.navigation.destination_name_long()
end
 
sc_wCheckHotButtons = function()
	if MODEL.ui.lm_whotbuttons.list.size() ~= 4 then
		MODEL.ui.lm_whotbuttons.clear()
		MODEL.ui.lm_whotbuttons.resize(4)
		MODEL.my.map.select_gcoor(GCOOR.new({lat = 0, lon = 0}))
		for i = 0, 3 do
			MODEL.ui.lm_whotbuttons.list[i].item.save_lastselected()
		end
	end
	MODEL.ui.lm_whotbuttons.save()
end
 
sc_go_wHotFind = function(index)
	if MODEL.ui.lm_whotbuttons.list[index].item.position() == GCOOR.new({lat = 0, lon = 0}) then
		sc_select_wHotFind(index, false)
	else
		MODEL.ui.lm_whotbuttons.list[index].item.select()
		sc_go_wHotFindOk(index)
	end
end
 
sc_select_wHotFind = function(index, closelocal)
	w_InSelectHomeOfficeTemp = index
	if closelocal then
		sc_close_local_menu()
	end
	local text = ((index == 0 and m_i18n("Would you like to select new position of Home?")) or (index == 1 and m_i18n("Would you like to select new position of Office?") or (index == 2 and m_i18n("Would you like to select new position of third favourites?") or m_i18n("Would you like to select new position of fourth favourites?"))))
	MODEL.screen.msgbox.new.setup(3)
	MODEL.screen.msgbox.new.set_line(1, text)
	MODEL.screen.msgbox.new.setup_button(1, "sc_StartSelectPositionOK", m_i18n("Select"), "", "ico_done_mid.bmp#3")
	MODEL.screen.msgbox.new.setup_button(2, "", m_i18n("Cancel"), "", "ico_cancel_mid.bmp#3")
	MODEL.screen.msgbox.new.setup_button(3, "sc_ClearSelectPositionOK", m_i18n("Clear"), "", "ico_cancel_mid.bmp#3")
	MODEL.screen.msgbox.create_new()
end
 
sc_StartSelectPositionOK = function()
	MODEL.lua.wInSelectHomeOffice = true
	st_EasyFindMenu.init()
end
 
sc_FinishSelectPositionOK = function()
	local mypoi = m_i18n("@My POI")
	local poiGroupId = MODEL.poi.find_group(mypoi)
	if poiGroupId == -1 then
		MODEL.my.poi.add_group(0, gUserPOI_Provider, mypoi)
		poiGroupId = MODEL.poi.find_group(mypoi)
	end
	MODEL.my.poi.select_group(poiGroupId)
	MODEL.my.map.select_gcoor(MODEL.map.cursor.position())
	MODEL.my.poi.add_poi_selected(poiGroupId, gUserPOI_Provider)
	MODEL.my.poi.current.name = translate(((w_InSelectHomeOfficeTemp == 0 and m_i18n("Quick~Home")) or (w_InSelectHomeOfficeTemp == 1 and m_i18n("Quick~Work") or (w_InSelectHomeOfficeTemp == 2 and m_i18n("Quick~Third favourite") or m_i18n("Quick~Fourth favourite")))))
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	MODEL.ui.lm_whotbuttons.list[w_InSelectHomeOfficeTemp].item.save_lastselected()
	MODEL.ui.lm_whotbuttons.save()
	MODEL.my.poi.current.remove()
	MODEL.lua.wInSelectHomeOffice = false
	CLEARTOSTATE(st_EasyFindMenu)
end
 
sc_ClearSelectPositionOK = function()
	MODEL.my.map.select_gcoor(GCOOR.new({lat = 0, lon = 0}))
	MODEL.ui.lm_whotbuttons.list[w_InSelectHomeOfficeTemp].item.save_lastselected()
	MODEL.ui.lm_whotbuttons.save()
end
 
sc_go_wHotFindOk = function(index)
	wSelectedItemHotName = MODEL.my.map.selected_item.name()
	wSelectedItemHotPos = MODEL.my.map.selected_item.position()
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	if MODEL.lua.wOnItemCreateRoute() then
		wFind_createroute = not wFind_createroute
	end
	if wFind_createroute then
		sc_FindOnMap_Select_onrelease()
	else
		routeMenuMode = 1
		sc_NextStateAnim(st_FindOnMap, "3d", 0, sc_GetFlipAnim(true, SELF.prop.X, SELF.prop.Y, SELF.prop.W, SELF.prop.H))
		sc_ResetStrappedCursor()
	end
end
 
sc_back_HomeOffice = function()
	MODEL.lua.wInSelectHomeOffice = false
	st_EasyFindMenu.init()
end
	
createState("st_InputValueInteger")
st_InputValueInteger:useLayers(backgroundLayers, "ui_InputValueInteger")
st_InputValueInteger.init = function()
	MODEL.lua.easyShowDoneKey = true
	MODEL.regional.keyboard.load_panel_by_name(L"Core Numbers")
	MODEL.lua.InputValidatorIsDate = true
	wTmpdateDelimiter = MODEL.lua.dateDelimiter()
	MODEL.lua.dateDelimiter = 0
end
 
st_InputValueInteger.done = function()
	closeKeyboard:trigger()
	KEY("RETURN")
	MODEL.lua.InputValidatorIsDate = false
	MODEL.lua.dateDelimiter = wTmpdateDelimiter
	MODEL.regional.keyboard.on_close_panel()
	MODEL.regional.keyboard.smartkey_model("")
end
 
sc_inpValueInteger_onchange = function()
	local inptext = ui.inpValueInteger.VALUE()
	local tempinptext = wstring.sub(inptext, 1, 1) == L"-" and wstring.sub(inptext, 2, #inptext) or inptext
	local acceptable, InputKeys = getNextInput_Int(tempinptext, wInpValueInteger_min, wInpValueInteger_max)
	MODEL.lua.keyb_done = acceptable
	MODEL.lua.fuelinputkeys = InputKeys .. (#inptext == 0 and wInpValueInteger_needsign and L"-" or L"")
	MODEL.regional.keyboard.smartkey_model("lua.fuelinputkeys")
end
 
sc_SelectValueInteger = function(title, donefunction, min, max, needsign, donemodel)
	wInpValueInteger_min = min
	wInpValueInteger_max = max
	wInpValueInteger_needsign = needsign
	if donemodel ~= nil then
		wInpValueInteger_model = donemodel
	end
	local emptytitle = (needsign and (L"-" .. towstring(max)) or towstring(min)) .. L".." .. towstring(max)
	sc_NextStateAnim(st_InputValueInteger, "horz_scroll", 1, "")
	txtTitle.TEXT = m_i18n(title)
	inpValueInteger.value = L""
	inpValueInteger.EMPTYTITLE = translated_format(m_i18n("<Enter Number (%s)>"), emptytitle)
	sc_inpValueInteger_onchange()
	KEY("RETURN", donefunction)
	ui.vKeyTableDone = donefunction
end
 
inpValueInteger_isempty = function()
	local result = var.new()
	inpValueInteger:ISEMPTY(result)
	return result()
end
 
createState("st_wUserSounds")
st_wUserSounds:useLayers(backgroundLayers, "ui_List_Background", "ui_wUserSounds")
st_wUserSounds.init = function()
	txtTitle.TEXT = m_i18n("Select sound")
end
 
sc_wUserSoundsOnRelease = function()
	local name = MODEL["*"].name()
	local volume = 0
	if wUserSoundType == "Overspeed camera" then
		MODEL.lua.wSettingDistSoundName = name
		volume = MODEL.lua.wSettingDistSound()
	elseif wUserSoundType == "Alert sound" then
		MODEL.WSTR.ui.wCameraSettingTmp.current.voicealert = name
		volume = MODEL.lua.wSpeedcamAlertVolume()
	elseif wUserSoundType == "Driver Alert" then
		MODEL.lua.wDASoundName = name
		volume = MODEL.lua.wDASoundVolume()
	elseif wUserSoundType == "Laneinfo SS" then
		MODEL.lua.wLaneSoundNameSS = name
		volume = MODEL.lua.wLaneSoundVolumeSS()
	elseif wUserSoundType == "Start" then
		MODEL.lua.wStartSoundName = name
		volume = MODEL.lua.wStartExitVolume()
	elseif wUserSoundType == "Exit" then
		MODEL.lua.wExitSoundName = name
		volume = MODEL.lua.wStartExitVolume()
	elseif wUserSoundType == "Overspeed sound" then
		MODEL.lua.wWarnOSSoundName = name
		volume = MODEL.lua.wWarnOSVolume()
	elseif wUserSoundType == "Laneinfo" then
		MODEL.lua.wLaneSoundName = name
		volume = MODEL.lua.wLaneSoundVolume()
	elseif wUserSoundType == "Capture" then
		MODEL.lua.wCaptureSoundName = name
		volume = MODEL.lua.wCaptureSoundVolume()
	elseif wUserSoundType == "Power AC" then
		MODEL.lua.wPowerACSoundName = name
		volume = MODEL.lua.wPowerSoundVolume()
	elseif wUserSoundType == "Power Battery" then
		MODEL.lua.wPowerBatterySoundName = name
		volume = MODEL.lua.wPowerSoundVolume()
	elseif wUserSoundType == "Power Low" then
		MODEL.lua.wPowerLowSoundName = name
		volume = MODEL.lua.wPowerSoundVolume()
	elseif wUserSoundType == "Power Crit" then
		MODEL.lua.wPowerCritSoundName = name
		volume = MODEL.lua.wPowerSoundVolume()
	elseif wUserSoundType == "Speed limit" then
		MODEL.lua.wSLSoundName = name
		volume = MODEL.lua.wSLSoundVolume()
	elseif wUserSoundType == "Umwelt zone" then
		MODEL.lua.wUmweltSoundName = name
		volume = MODEL.lua.wUmweltSoundVolume()
	end
	sc_back()
	sc_wplaysound(1, name, volume)
end
 
sc_wUserSoundsPlay_OnRelease = function()
	sc_wplaysound(1, MODEL["*"].name(), 65)
end
 
sc_wUserSoundsDel_OnRelease = function()
	sc_wShowNewMessageBox(translated_format(m_i18n("Are you sure you want to delete this User sound from list?")),"sc_wUserSoundsDel_OnRelease_OK",m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL["*"].name())
end
 
sc_wUserSoundsDel_OnRelease_OK = function()
	MODEL.ui.wUserSoundList.remove(MODEL.ui.wUserSoundList.list.index())
	MODEL.ui.wUserSoundList.save()
end
 
sc_wUserSoundsAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all User sounds from list?"),"sc_wUserSoundsAll_OnRelease_OK",m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wUserSoundsAll_OnRelease_OK = function()
	MODEL.ui.wUserSoundList.clear()
	MODEL.ui.wUserSoundList.save()
end
 
sc_RescanwUserSounds_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("The previous list will be removed. Are you sure you want to rescan user sounds?"),"sc_RescanwUserSounds_OnReleaseOK",m_i18n("Rescan sounds"),"ico_Done_mid.bmp#3")
end
 
sc_RescanwUserSounds_OnReleaseOK = function()
	ui_wSoundScanning:SHOW()
	local oasisFiles = MODEL.oasis.files()
	oasisFiles.useful_dirs_only = true
	oasisFiles.selectable_dir = true
	oasisFiles.unroll_dirs = true
	oasisFiles.path = L"%app%/ui_igo9/audio"
	oasisFiles.filter = L"fcategory:5"
	oasisFiles.create_file_props = false
	oasisFiles.initialize_data()
	if oasisFiles.finished() then
		sc_RescanwUserSounds_done()
	else
		obs_Files_UserSoundScan_Finished:START("NO_TRIGGER")
	end
end
 
sc_RescanwUserSounds_done = function()
	obs_Files_UserSoundScan_Finished:STOP()
	ui_wSoundScanning:HIDE()
	MODEL.ui.wUserSoundList.clear()
	ui.wUserSoundList:add({name=L""})
	local filename, fpath
	for item in ModelList_iter(MODEL.oasis.files.list) do
		filename = item.fname():lower()
		fpath = item.fpath():lower()
		fpath = wstring.sub(fpath, 15, #fpath)
		if fpath == filename then
			ui.wUserSoundList:add({name=wstring.gsub(filename, L".wav", L"")})
		end
	end
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
	MODEL.ui.wUserSoundList.save()
end
 
sc_RescanwUserSounds_stop = function()
	obs_Files_UserSoundScan_Finished:STOP()
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
	ui_wSoundScanning:HIDE()
end
 
sc_wExternalPrograms_OnRelease = function()
	wSelectProgramMode = 0
	sc_NextStateAnim(st_wUserPrograms, "fade", 1, "")
end
 
sc_wSelectProgramMenu_Enter = function()
	wSelectProgramMode = 1
	sc_NextStateAnim(st_wUserPrograms, "fade", 1, "")
end
 
sc_wSelectProgramBT_Enter = function()
	wSelectProgramMode = 2
	sc_NextStateAnim(st_wUserPrograms, "fade", 1, "")
end
 
sc_wSelectProgramMenu_SetName = function(menulc, listsize, progindex)
	local value = L""
	if menulc ~= 2 then
		return value
	end
	value = ((listsize == 0 or progindex == -1 or progindex > (listsize - 1)) and translated_format(m_i18n("Select program")) or MODEL.ui.wUserProgramList[progindex].name())
	return (value == L"" and translated_format(m_i18n("No name")) or value)
end
 
createState("st_wUserPrograms")
st_wUserPrograms:useLayers(backgroundLayers, "ui_List_Background", "ui_wUserPrograms")
st_wUserPrograms.init = function()
	txtTitle.TEXT = m_i18n("Select program")
end
 
sc_wUserProgramsOnRelease = function()
	local current = MODEL.ui.wUserProgramList[index]
	if wSelectProgramMode == 1 then
		MODEL.lua.wMenuLCProgram = index
		sc_back()
	elseif wSelectProgramMode == 2 then
		MODEL.lua.wBTProgram = index
		sc_back()
	elseif current.exit() then
		NEXTSTATE(RestartState)
		doDelayed(15, function()
			START_APPLICATION(current.path(),current.parameter())
			doDelayed(1,EXIT)
		end)
	else
		START_APPLICATION(current.path(),current.parameter())
	end
end
 
sc_wUserProgramsMenuOnRelease = function()
	if MODEL.ui.wUserProgramList.list.isempty() or MODEL.lua.wMenuLCProgram() == -1 or (MODEL.lua.wMenuLCProgram() > (MODEL.ui.wUserProgramList.list.size() - 1)) then
		return
	else
		local current = MODEL.ui.wUserProgramList[MODEL.lua.wMenuLCProgram()]
		if current.exit() then
			NEXTSTATE(RestartState)
			doDelayed(15, function()
				START_APPLICATION(current.path(),current.parameter())
				doDelayed(1,EXIT)
			end)
		else
			START_APPLICATION(current.path(),current.parameter())
		end
	end
end
 
sc_wStartBTOnOff = function()
	if MODEL.ui.wUserProgramList.list.isempty() or MODEL.lua.wBTProgram() == -1 or (MODEL.lua.wBTProgram() > (MODEL.ui.wUserProgramList.list.size() - 1)) then
		sc_wShowNewMessageBox(m_i18n("Bluetooth program is not defined! Would you like to select it?"),"sc_wSelectProgramBT_Enter",m_i18n("Select program"),"ico_done_mid.bmp#3")
	else
		local current = MODEL.ui.wUserProgramList[MODEL.lua.wBTProgram()]
		START_APPLICATION(current.path(),current.parameter())
	end
end
 
sc_wSettingBTOnOff = function()
	sc_NextStateAnim(st_wBTProgramSettings, "fade", 1, "")
end
 
createState("st_wBTProgramSettings")
st_wBTProgramSettings:useLayers(backgroundLayers, "ui_wBTProgramSettings")
st_wBTProgramSettings.init = function()
	txtTitle.TEXT = m_i18n("Bluetooth program setting")
end
 
sc_wUserProgramsEdit_OnRelease = function()
	local current = MODEL["*"]
	wSettingDistOverIndex = index
	MODEL.lua.wSettingDistSoundName = current.name()
	MODEL.lua.wSettingProgramParameter = current.parameter()
	MODEL.lua.wSettingDistOn = current.exit()
	sc_NextStateAnim(st_wUserProgramsEdit, "horz_scroll", 1, "")
end
 
createState("st_wUserProgramsEdit")
st_wUserProgramsEdit:useLayers(backgroundLayers, "ui_wUserProgramsEdit")
st_wUserProgramsEdit.init = function()
	txtTitle.TEXT = m_i18n("Edit program entry")
end
 
st_wUserProgramsEdit.exit = function()
	local current = MODEL.ui.wUserProgramList[wSettingDistOverIndex]
	current.name = MODEL.lua.wSettingDistSoundName()
	current.parameter = MODEL.lua.wSettingProgramParameter()
	current.exit = MODEL.lua.wSettingDistOn()
	MODEL.ui.wUserProgramList.save()
end
 
sc_EditProgramName = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = MODEL.lua.wSettingDistSoundName()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter program name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_EditProgramNameDone
	inputFieldRequired = false
	txtTitle.TEXT = m_i18n("Set program name")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end
 
sc_EditProgramParameter = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = MODEL.lua.wSettingProgramParameter()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter program parameter>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_EditProgramParameterDone
	inputFieldRequired = false
	txtTitle.TEXT = m_i18n("Set program parameter")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end
 
sc_EditProgramNameDone = function()
	MODEL.lua.wSettingDistSoundName = ui.inpSI_Text.VALUE()
	sc_back()
end

sc_EditProgramParameterDone = function()
	MODEL.lua.wSettingProgramParameter = ui.inpSI_Text.VALUE()
	sc_back()
end
 
sc_wUserProgramsDel_OnRelease = function()
	sc_wShowNewMessageBox(translated_format(m_i18n("Are you sure you want to delete this program from list?")),"sc_wUserProgramsDel_OnRelease_OK",m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL["*"].name())
end
 
sc_wUserProgramsDel_OnRelease_OK = function()
	MODEL.ui.wUserProgramList.remove(MODEL.ui.wUserProgramList.list.index())
	MODEL.ui.wUserProgramList.save()
end
 
sc_wUserProgramsAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all programs from list?"),"sc_wUserProgramsAll_OnRelease_OK", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wUserProgramsAll_OnRelease_OK = function()
	MODEL.ui.wUserProgramList.clear()
	MODEL.ui.wUserProgramList.save()
end
 
sc_RescanwUserPrograms_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("The previous list will be removed. Are you sure you want to rescan programs?"),"sc_RescanwUserPrograms_OnReleaseOK", m_i18n("Rescan programs"),"ico_Done_mid.bmp#3")
end
 
sc_RescanwUserPrograms_OnReleaseOK = function()
	ui_wProgramScanning:SHOW()
	local oasisFiles = MODEL.oasis.files()
	oasisFiles.useful_dirs_only = true
	oasisFiles.selectable_dir = true
	oasisFiles.unroll_dirs = true
	oasisFiles.path = L""
	oasisFiles.filter = L"fcategory:2"
	oasisFiles.filter_type = L"PROGRAM"
	oasisFiles.create_file_props = false
	oasisFiles.initialize_data()
	if oasisFiles.finished() then
		sc_RescanwUserPrograms_done()
	else
		obs_Files_UserProgramScan_Finished:START("NO_TRIGGER")
	end
end
 
sc_RescanwUserPrograms_done = function()
	obs_Files_UserProgramScan_Finished:STOP()
	ui_wProgramScanning:HIDE()
	MODEL.ui.wUserProgramList.clear()
	local fpath
	for item in ModelList_iter(MODEL.oasis.files.list) do
		fpath = item.frootpath()
		ui.wUserProgramList:add({name=item.fname(), path=wstring.sub(fpath, 7, #fpath), parameter=L"", exit=0})
	end
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
	MODEL.ui.wUserProgramList.save()
end
 
sc_RescanwUserPrograms_stop = function()
	obs_Files_UserProgramScan_Finished:STOP()
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
	ui_wProgramScanning:HIDE()
end
 
sc_wShowHelpText = function(text)
	if text == "" or text == L"" then
		return
	end
	sprHelpText:BMP("msgbox_bg.bmp")
	txtHelpText.TEXT = text
	if wShowHelpTextTimer ~= -1 then
		killDelayed(wShowHelpTextTimer )
		wShowHelpTextTimer = -1
	end
	ui_wHelpText:SHOW()
	wShowHelpTextTimer = doDelayed(100, function() ui_wHelpText:HIDE() end)
end
 
createState("st_wMapChanger")
st_wMapChanger:useLayers(backgroundLayers, "ui_wMapChanger")
st_wMapChanger.init = function()
	txtTitle.TEXT = m_i18n("MapChanger")
end

sc_wMapChanger_OnRelease = function()
	sc_NextStateAnim(st_wMapChanger, "fade", 1, "")
end

sc_wMapChanger_go = function(provider)
	if MODEL.lua.vgjMCCurrentMap() ~= provider then
		wProvider = provider
		sc_wShowNewMessageBox(m_i18n("Are you sure you want to change Map provider?"),"sc_wMapChanger_goDone",m_i18n("Change provider"),"ico_done_mid.bmp#3",nil,"sc_CancelExit")
	end	
end

sc_wMapChanger_goDone = function()
	MODEL.lua.vgjMCCurrentMap = wProvider
	local param = L"," .. towstring(wProvider)
	NEXTSTATE(RestartState)
	doDelayed(15, function()
		START_APPLICATION(L"utility/mapchanger.exe",param)
		doDelayed(1,EXIT)
	end)
end
 
sc_wMapchangerProvider_check = function()
	local oasisFiles = MODEL.oasis.files()
	oasisFiles.useful_dirs_only = true
	oasisFiles.selectable_dir = true
	oasisFiles.unroll_dirs = true
	oasisFiles.path = L"%content%/map"
	oasisFiles.filter = L"fcategory:1"
	oasisFiles.create_file_props = false
	oasisFiles.initialize_data()
	if oasisFiles.finished() then
		sc_Mapchanger_check_done()
	else
		obs_Files_MapsScan_Finished:START("NO_TRIGGER")
	end
end
 
sc_Mapchanger_check_done = function()
	obs_Files_MapsScan_Finished:STOP()
	local name
	for item in ModelList_iter(MODEL.oasis.files.list) do
		name = item.fname():lower()
		if name == L"!map_ta.txt" then
			MODEL.lua.vgjMCCurrentMap = 1
			break
		end
		if name == L"!map_nt.txt" then
			MODEL.lua.vgjMCCurrentMap = 2
			break
		end
		if name == L"!map_ot.txt" then
			MODEL.lua.vgjMCCurrentMap = 3
			break
		end

                if name == L"!map_us.txt" then
			MODEL.lua.vgjMCCurrentMap = 4
			break
		end
	end
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
end
 
sc_wShowMap_onclick = function(SetPressed)
	sc_wShowMap_UpAlpha()
	if SetPressed then
		SELF:PRESS()
	end
end
 
sc_wShowMap_ondrop = function()
	SELF:SIMULATEHIT()
end
 
sc_wShowMap_DownAlpha = function(SetUnpress)
	SELF.ALPHA = 10
	if SetUnpress then
		SELF:UNPRESS()
	end
end
 
sc_wShowMap_UpAlpha = function()
	SELF.ALPHA = 32
end
 
sc_wSet_CreateRoute = function(action)
	if not action then
		sc_wShowMap_DownAlpha(false)
	end
	if MODEL.lua.wOnItemCreateRoute() then
		wFind_createroute = action
	else
		wFind_createroute = not action
	end
end
 
sc_wAddress_onlongclcick = function()
	if MODEL.ui.lm_whotbuttons.list[0].item.position() == GCOOR.new({lat = 0, lon = 0}) then
		MODEL.screen.msgbox.new.setup(1)
		MODEL.screen.msgbox.new.set_line(1, m_i18n("Home position is not defined!"))
		MODEL.screen.msgbox.new.setup_button(1, "")
		MODEL.screen.msgbox.create_new()
	else
		MODEL.ui.lm_whotbuttons.list[0].item.select()
		MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
		sc_FindOnMap_Select_onrelease()
	end
end

--common.lua
 
local st_SimpleInputText_init_orig = st_SimpleInputText.init
st_SimpleInputText.init = function()
	st_SimpleInputText_init_orig()
	inpSI_Text.ALLOWCURSORCLICK = 1
end
 
local st_SimpleInputText_done_orig = st_SimpleInputText.done
st_SimpleInputText.done = function()
	st_SimpleInputText_done_orig()
	MODEL.lua.wLocalMenuHide = false
end
 
sc_OnBatteryCritical = function()
	if not MODEL.power.on_battery() then
		return 
	end
	local isVisible = var.new()
	ui_ShutdownTimer:ISVISIBLE(isVisible)
	if not isVisible() then
		MODEL.screen.msgbox.close(gBatteryCriticalID)
		MODEL.screen.msgbox.close(gBatteryLowID)
		wMessage_needplay = false
		gBatteryCriticalID = sc_InfoMessageBox(m_i18n("Battery level is critically low.\nPlease recharge battery."), true)
		if sc_wReadOutPowerSupported() and MODEL.lua.wPowerTTS() and MODEL.lua.wPowerCritTTS() then
			sc_wpowersayspeech(translate_voice("Battery level is critically low."))
		else
			sc_wplaysound(1, MODEL.lua.wPowerCritSoundName(), MODEL.lua.wPowerSoundVolume())
		end
	end
end
 
sc_OnBatteryLow = function()
	if not MODEL.power.on_battery() then
		return 
	end
	if MODEL.lua.VRStatus() ~= eVRStatus.inactive then
		sc_ExitVR()
	end
	MODEL.screen.msgbox.close(gBatteryLowID)
	wMessage_needplay = false
	gBatteryLowID = sc_InfoMessageBox(m_i18n("Battery level is low.\nConsider recharging the battery."), true)
	if sc_wReadOutPowerSupported() and MODEL.lua.wPowerTTS() and MODEL.lua.wPowerLowTTS() then
		sc_wpowersayspeech(translate_voice("Battery level is low."))
	else
		sc_wplaysound(1, MODEL.lua.wPowerLowSoundName(), MODEL.lua.wPowerSoundVolume())
	end
end
 
local sc_OnBattery_orig = sc_OnBattery
sc_OnBattery = function()
	sc_OnBattery_orig()
	if sc_wReadOutPowerSupported() and MODEL.lua.wPowerTTS() and MODEL.lua.wPowerBatteryTTS() then
		sc_wpowersayspeech(translate_voice("External power disconnected."))
	else
		sc_wplaysound(1, MODEL.lua.wPowerBatterySoundName(), MODEL.lua.wPowerSoundVolume())
	end
end
 
local sc_OnBatteryFast_orig = sc_OnBatteryFast
sc_OnBatteryFast = function()
	wMessage_needplay = false
	sc_OnBatteryFast_orig()
end
 
sc_OnAC = function()
	sc_CancelShutdown()
	MODEL.lua.DestinationMenuShown = false
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian and msgBoxID_FastPedWarn == -1 then
		wMessage_needplay = false
		sc_wShowNewMessageBox(translated_format(m_i18n("You are currently in pedestrian mode. Would you like to switch back to %s mode?"), sc_GetVehicleTypeFiel(PERSISTENT.lastVehicleProfile(), "name")),"sc_FastPedestrianWarning_SetCar",m_i18n("Switch"),"ico_done_mid.bmp#3")
	end
	MODEL.screen.msgbox.close(gBatteryCriticalID)
	MODEL.screen.msgbox.close(gBatteryLowID)
	MODEL.screen.msgbox.close(gOnBatteryMsgID)
	if sc_wReadOutPowerSupported() and MODEL.lua.wPowerTTS() and MODEL.lua.wPowerACTTS() then
		sc_wpowersayspeech(translate_voice("External power connected."))
	else
		sc_wplaysound(1, MODEL.lua.wPowerACSoundName(), MODEL.lua.wPowerSoundVolume())
	end
end
 
sc_suspend = function()
	if not suspendReceived then
		wGPSSignal = 0
		suspendReceived = true
		if MODEL.lua.wPositionPowChange() then
			sc_add_carpos_to_history("Power off",2)
		end
		if st_DestinationMenu.isActive then
			PREVSTATE(0)
		end
	end
end
 
--driveralerts.lua
wSettingDistOverIndex = 0
wSCTmpPause = -1
wCurrentSCID = ""
wOverSoundDelay = 0
wGlobal_Timer_SCEnabled = true
wprofiles_selectmode = 0
wspeed_units = {kph = "km/h", mph = "mph"}
wDATypesTemp_builded = false
wTimerSLID=-1
wGPSSignal = 0
wGPSSignalTimer = -1
 
obs_wtolerance = var.observer({ONCHANGE = function()
	if MODEL.navigation.is_in_simulation() or not MODEL.warning.driveralert.speed_limit() then
		return
	end
	if MODEL.lua.wToleranceType() then
		local limit = MODEL.warning.driveralert.speed_limit()
		if MODEL.regional.units() ~= 1 then
			limit = regional.units:convert("Speed", "miles/hour", limit)
			limit = double.round(limit):toInt()
		end
		if (limit + MODEL.lua.wTolerance() - 100) > 0 then
			MODEL.warning.speedwarn_tolerance = 100 + (100 * (MODEL.lua.wTolerance() - 100) / limit)
		else
			MODEL.warning.speedwarn_tolerance = 0
		end
		if (limit + MODEL.lua.wToleranceAlt() - 100) > 0 then
			MODEL.warning.speedwarn_alt_tolerance = 100 + (100 * (MODEL.lua.wToleranceAlt() - 100) / limit)
		else
			MODEL.warning.speedwarn_alt_tolerance = 0
		end
	else
		MODEL.warning.speedwarn_tolerance = MODEL.lua.wTolerance()
		MODEL.warning.speedwarn_alt_tolerance = MODEL.lua.wToleranceAlt()
	end
end, MODEL = {MODEL.warning.driveralert.speed_limit, MODEL.navigation.is_in_simulation, MODEL.regional.units}, TRIGGER_ON_START = true})
 
sc_wtranslateunit = function(wstr,type)
	local res = L""
	for _,v in pairs(type) do
		if translate(v) == wstr then
			res = L" " .. translate_voice(v)
			break
		end
	end
	return res
end
 
sc_wSetCorrectionSpeedUnit = function()
	sc_wShowNewMessageBox(translate(m_i18n("You need using this function only if selected TTS voice misspells speed units with some TTSPro features.")),"sc_wSetCorrectionSpeedUnitOK", m_i18n("Turn On"),"ico_done_mid.bmp#3",translate(m_i18n("Turn it on anyway?")))
end
 
sc_wSetCorrectionSpeedUnitOK = function()
	MODEL.lua.wCorrectionSpeedUnit = true
end
 
sc_wGetCorrectionSpeedUnitVisible = function()
	return (MODEL.lua.wReadOutSCSupported() and MODEL.lua.wUltraSoundTTS() and MODEL.warning.speedcam_warning() and MODEL.lua.wUltraSoundTTSUnit()) or (sc_ReadOutCountryInfoSupported(MODEL.regional.voices.index()) and MODEL.lua.ReadOutCountryInfo()) or (sc_wReadOutSpeedLimitSupported(MODEL.regional.voices.index()) and MODEL.lua.wSLTTSVoice() and MODEL.lua.wSLTTSVoiceSecondPhrase() and MODEL.lua.wSLTTSVoiceSecondPhraseUnit())
end
 
sc_wCorrectionSpeedUnitSupported = function()
	return MODEL_regional_is_it_voice_localizable(m_i18n_voice(wspeed_units.kph)) and MODEL_regional_is_it_voice_localizable(m_i18n_voice(wspeed_units.mph)) and MODEL.regional.current_voice.is_tts()
end
 
sc_wCorrectionSpeedUnitTest = function()
	local limitphrasepart = MODEL.lua.wCorrectionSpeedUnit() and 2 or 0
	local limitphraseunit = MODEL.lua.wCorrectionSpeedUnit() and sc_wtranslateunit(MODEL.other.format_speed(60, MODEL.regional.units(), 1, 1), wspeed_units) or L""
	sc_wsayspeech_test(sc_wTransform_numbers2text(MODEL.other.format_speed(60, MODEL.regional.units(), 1, limitphrasepart), limitphrasepart) .. limitphraseunit)
end
 
sc_wTTSProPriorityVisible = function()
	return (MODEL.lua.wReadOutSCSupported() and MODEL.lua.wUltraSoundTTS() and MODEL.warning.speedcam_warning()) or (MODEL.lua.wDATTSVoice() and MODEL.lua.wReadOutDASupported() and MODEL.lua.DAEnabled())
end
 
sc_w_timer = function()
	if MODEL.lua.wSimulateIsTrackPlaying() then
		local timeplaying = MODEL.gps.current_time() - wTrackPlayingStartTime
		timeplaying:normalize()
		local current_second = wTrackPlayingFactor * (3600 * timeplaying.hours + 60 * timeplaying.minutes + timeplaying.seconds)
		local tempvalue = current_second <= wTrackPlayingSeconds and current_second or wTrackPlayingSeconds
		MODEL.lua.wTrackPlayingProgress = wTrackPlayingSeconds - tempvalue
	end
	if MODEL.lua.wTMCTunerMode() == 5 then
		sc_wTmcFixed()
	elseif MODEL.lua.wTMCTunerMode() > 1 then
		sc_wTmcAutoScan()
	end
	if MODEL.lua.wSCAudioVoice() and wGlobal_Timer_SCEnabled and MODEL.lua.wSCCategory() ~= -1 then
		sc_wReinitSC(MODEL.lua.wSCCategory())
	end
	if MODEL.lua.wSCCategory() == -1 and wGlobal_Timer_SCEnabled then
		sc_wResetSC()
	end
	if MODEL.lua.wSCAudioOverspeed() and wGlobal_Timer_SCEnabled and MODEL.lua.wSCCategory() ~= -1 then
		local current = MODEL.ui.wCameraSetting[MODEL.lua.wSCCategory()]
		sc_wplaysound(0, current.overspeedsound(), current.overspeedvolume())
	end
	if MODEL.lua.wOSAudio() then
		sc_spoken_alert_lang_selectOS()
	end
	if vActiveState() == "st_easynav" and wTemp_overview_distance ~= nil then
		sc_overview_check()
	end
	if MODEL.lua.wPositionGPSLost() then
		if MODEL.gps.position.valid() then
			if wGPSSignal < 15 then
				wGPSSignal = wGPSSignal + 1
			end
			if wGPSSignalTimer ~= -1 then
				killDelayed(wGPSSignalTimer)
				wGPSSignalTimer = -1
			end
		else
			if wGPSSignal >= 15 then
				wGPSSignalTimer = doDelayed(500, sc_wGPSLost)
			end
			wGPSSignal = 0
		end
	elseif wGPSSignalTimer ~= -1 then
		killDelayed(wGPSSignalTimer)
		wGPSSignalTimer = -1
	end
	if vActiveState() == "st_easynav" and MODEL.lua.wAutoSS() and MODEL.lua.wUseSS() and not MODEL.lua.dragMode() then
		sc_SS_check()
	end
	if vActiveState() == "st_screensaver" and MODEL.lua.wAutoSS() then
		sc_SS_checkSS()
	end
	if vActiveState() == "st_easynav" and not MODEL.lua.dragMode() and MODEL.lua.wSplitScreenOpen() and (MODEL.lua.wSplitScreenMode() or wPortrait) and MODEL.poi.initialized() then
		sc_wOnSplitScreenPOI_reset()
	end
end
 
sc_wResetSC = function()
	if wSCTmpPause == 0 then
		wCurrentSCID = ""
	elseif wSCTmpPause > 0 then
		wSCTmpPause = wSCTmpPause - 1
	end
	if wTimerSecondPhrase ~= -1 then
		killDelayed(wTimerSecondPhrase)
		wTimerSecondPhrase = -1
	end
	if wAudioVoiceCameraTimer ~= -1 then
		killDelayed(wAudioVoiceCameraTimer)
		wAudioVoiceCameraTimer = -1
		wAudioVoiceCameraPlayed = false
	end
end
 
sc_wReinitSC = function(category)
	wSCTmpPause = category == 3 and 3 or 60
	if wCurrentSCID ~= MODEL.navigation.curr_speedcam.id() then
		wCurrentSCID = MODEL.navigation.curr_speedcam.id()
		if MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported() then
			local current = MODEL.ui.wCameraSetting[category]
			if category == 3 then
				sc_spoken_alert_tts(3,0,MODEL.navigation.curr_speedcam.speed_limit(),0,MODEL.ui.wCameraSetting[3].voicesecondtts(),true)
			else
				sc_spoken_alert_tts(category,MODEL.navigation.curr_speedcam.distance(),MODEL.navigation.curr_speedcam.speed_limit(),current.distsoundtts(),current.voicesecondtts(),true)
			end
		else
			sc_spoken_alert_lang_select(category)
		end
	end
end
 
sc_wSpeedCameraCancel = function()
	MODEL.warning.speedcam_warning = false
	wSCTmpPause = 1
	if MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported() and not MODEL.lua.wTTSProGuidancePriority() then
		MODEL.sound.speech.unlock(wLockSpeakingID)
	end
	sc_wPromptCancel("wSpeedCameraSpeakingID")
	wCurrentSCID = ""
	doDelayed(60, function() MODEL.warning.speedcam_warning = true end)
end
 
sc_wSpeedCameraFastCancel = function()
	MODEL.warning.speedcam_warning = false
	if MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported() and not MODEL.lua.wTTSProGuidancePriority() then
		MODEL.sound.speech.unlock(wLockSpeakingID)
	end
	sc_wPromptCancel("wSpeedCameraSpeakingID")
	doDelayed(20, function() MODEL.warning.speedcam_warning = true end)
end
 
wTimerSecondPhrase = -1
wTimerSecondPhraseTest = -1
sc_spoken_alert_lang_select = function(type)
	if wTimerSecondPhrase ~= -1 then
		killDelayed(wTimerSecondPhrase)
		wTimerSecondPhrase = -1
	end
	local langtype = MODEL.lua.wSpeedcamWarningLangType()
	local current = MODEL.ui.wCameraSetting[type]
	if langtype == 0 then
		sc_wplaysound(1, current.voicealert(), MODEL.lua.wSpeedcamAlertVolume())
	else
		local currentlang = MODEL.ui.wCameraSettingLanguages[langtype]
		local firstphrase = currentlang.folder() .. L"/voice_" .. currentlang.male() .. L"/"
		local speedlimit = MODEL.navigation.curr_speedcam.speed_limit()
		if MODEL.regional.units() ~= 1 then
			speedlimit = regional.units:convert("Speed", "miles/hour", speedlimit)
			speedlimit = double.round(speedlimit):toInt()
		end
		local speedunit = MODEL.regional.units() == 1 and L"_kph" or L"_mph"
		local secondphrase = firstphrase
		firstphrase = firstphrase .. MODEL.ui.wCameraSettingName.unfiltered_list[type].firstphrase()
		sc_wplaysound(300, firstphrase, MODEL.lua.wSpeedcamAlertVolume())
		if current.voicesecond() and not(speedlimit < 20 or speedlimit > 130) then
			secondphrase = secondphrase .. L"Speed_Limit_" .. sc_GetSpeedLimitWSTR(speedlimit) .. speedunit
			local currentlangmodel = MODEL.ui.wCameraSettingLanguages[langtype]()
			local delay = currentlangmodel["delay" .. tostring(current.type())]()
			wTimerSecondPhrase = doDelayed(delay, function()
				if MODEL.lua.wSCAudioVoice() then
					sc_wplaysound(200, secondphrase, MODEL.lua.wSpeedcamAlertVolume())
				end
			end)
		end
	end
end
 
sc_spoken_alert_lang_select_test = function(type, delay)
	if wTimerSecondPhraseTest ~= -1 then
		killDelayed(wTimerSecondPhraseTest)
		wTimerSecondPhraseTest = -1
	end
	local langtype = MODEL.lua.wSpeedcamWarningLangType()
	if langtype == 0 then
		sc_wplaysound(1, MODEL.ui.wCameraSettingTmp[type].voicealert(), MODEL.lua.wSpeedcamAlertVolume())
	else
		local currentlang = MODEL.ui.wCameraSettingLanguages[langtype]
		local firstphrase = currentlang.folder() .. L"/voice_" .. currentlang.male() .. L"/"
		local secondphrase = firstphrase
		firstphrase = firstphrase .. MODEL.ui.wCameraSettingName.unfiltered_list[type].firstphrase()
		sc_wplaysound(1, firstphrase, MODEL.lua.wSpeedcamAlertVolume())
		if delay > 0 then
			local speedunit = MODEL.regional.units() == 1 and L"_kph" or L"_mph"
			secondphrase = secondphrase .. L"Speed_Limit_" .. sc_GetSpeedLimitWSTR(60) .. speedunit
			wTimerSecondPhraseTest = doDelayed(delay, function() sc_wplaysound(1, secondphrase, MODEL.lua.wSpeedcamAlertVolume()) end)
		end
	end
end
 
sc_GetSpeedLimitWSTR = function(speedlimit)
	local factor = speedlimit < 70 and 5 or 10
	local value = factor * float.toInt(float.new(tostring(speedlimit))/ float.new(tostring(factor)))
	return ((speedlimit < 100) and (L"0" .. towstring(value)) or towstring(value))
end
 
st_TTS_Settings.done = function()
	sc_wPromptCancel("wTestSpeakingID")
end
 
st_AlertPointSettings.enter = function()
	MODEL.ui.wCameraSettingTmp.clear()
	MODEL.ui.wCameraSettingTmp.load(MODEL.lua.wCameraSettingFile())
end
 
st_AlertPointSettings.init = function()
	txtTitle.TEXT = m_i18n("Alert Point Settings")
	if MODEL.lua.wSpeedcamWarningLangType() == 0 then
		MODEL.lua.wCameraSettingLangName = translate(m_i18n("Alert sounds"))
		MODEL.lua.wCameraSettingLangIcon = -1
	else
		local currentlang = MODEL.ui.wCameraSettingLanguages[MODEL.lua.wSpeedcamWarningLangType()]
		MODEL.lua.wCameraSettingLangName = translate(currentlang.name()) .. L"(" .. translated_format(m_i18n(tostring(currentlang.male()))) .. L")"
		MODEL.lua.wCameraSettingLangIcon = currentlang.icon()
	end
end
 
st_AlertPointSettings.exit = function()
	sc_wCameraSettingProfile_Save()
	sc_wCameraSetting_Save()
	sc_NEL_CheckObserver()
end
 
sc_btn_ProximitySettingProfile_OnRelease = function()
	wprofiles_selectmode = 0
	sc_NextStateAnim(st_wProfileCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVisual_OnRelease = function()
	MODEL.lua.wSCSettingType = 1
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVoice_OnRelease = function()
	MODEL.lua.wSCSettingType = 2
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingOverspeed_OnRelease = function()
	MODEL.lua.wSCSettingType = 3
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingApproach_OnRelease = function()
	MODEL.lua.wSCSettingType = 4
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingDistance_OnRelease = function()
	MODEL.lua.wSCSettingType = 5
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVoiceSecond_OnRelease = function()
	MODEL.lua.wSCSettingType = 6
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVoiceSecondTTS_OnRelease = function()
	MODEL.ui.wCameraSettingTmp.clear()
	MODEL.ui.wCameraSettingTmp.load(MODEL.lua.wCameraSettingFile())
	MODEL.lua.wSCSettingType = 7
	sc_NextStateAnim(st_wCommonCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVoiceAlert_OnRelease = function()
	sc_NextStateAnim(st_wAlertSoundCameraSettings, "horz_scroll", 1, "")
end
 
sc_btn_ProximitySettingVoiceSelect_OnRelease = function()
	sc_NextStateAnim(st_wCameraSettingVoiceSelect, "horz_scroll", 1, "")
end
 
createState("st_wWarningSignSoundSettings")
st_wWarningSignSoundSettings:useLayers(backgroundLayers, "ui_wWarningSignSoundSettings")
st_wWarningSignSoundSettings.init = function()
	txtTitle.TEXT = m_i18n("Warning Sign Sound Settings")
end
 
sc_wWarningSignSoundTTS_OnRelease = function()
	if not wDATypesTemp_builded then
		sc_wDATypesTemp_build()
	end
	sc_NextStateAnim(st_wWarningSignSoundTTS, "horz_scroll", 1, "")
end
 
sc_wDATypesTemp_build = function()
	MODEL.screen.filter_unique_by_index(DAiconIdx + 1)
	MODEL.screen.set_current_icongroup("sys")
	local iconbmp
	local res = "images/da/" .. (DAiconIdx == 4 and "high/" or (DAiconIdx == 2 and "mid/" or "low/"))
	local iconbmp_saved = "___"
	for item in ModelList_iter(MODEL.screen.icons) do
		iconbmp = MODEL.screen.get_icon_file_and_phase(item(), DAiconIdx + 1)
		if string.find(iconbmp, res, 1, true) ~= nil then
			ui.list_wDATypesTemp:add({bmp=string.gsub(iconbmp, res, "")})
		end
	end
	ui.list_wDATypesTemp:sort("bmp")
	for item in ModelList_iter(MODEL.ui.list_wDATypesTemp) do
		iconbmp = item.bmp()
		if string.find(iconbmp, iconbmp_saved, 1, true) == nil and iconbmp ~= "na.bmp" then
			iconbmp_saved = string.sub(iconbmp, 1, 3)
			local currentDA = MODEL.ui.list_wDATypes.unfiltered_list[tonumber(iconbmp_saved)]
			if currentDA.bmp() == "na.bmp" then
				currentDA.bmp = iconbmp
			end
		end
	end
	MODEL.ui.list_wDATypesTemp.clear()
	wDATypesTemp_builded = true
end
 
createState("st_wWarningSignSoundTTS")
st_wWarningSignSoundTTS:useLayers(backgroundLayers, "ui_wWarningSignSoundTTS")
st_wWarningSignSoundTTS.init = function()
	txtTitle.TEXT = m_i18n("Warning Sign TTS Pro Test")
end
 
sc_SelectSDDASignsDone = function()
	if not inpValueInteger_isempty() then
		MODEL["warning.driveralert.settings.preshow_distance_cat" .. tostring(MODEL.ui.driverAlertsList.index())] = float.toInt(float.new(tostring(ui.inpValueInteger.VALUE()))/ wUnitConvMeter2Unit[MODEL.INT.regional.units() + 1])
	end
	sc_back()
end
 
createState("st_wCameraSettingVoiceSelect")
st_wCameraSettingVoiceSelect:useLayers(backgroundLayers, "ui_List_Background", "ui_wCameraSettingVoiceSelect")
st_wCameraSettingVoiceSelect.init = function()
	txtTitle.TEXT = m_i18n("Select language")
	MODEL.ui.lst_wCameraSettingVoiceSelect.first_visible_index = MODEL.lua.wSpeedcamWarningLangType()
end
 
sc_wCameraSettingVoiceSelect = function()
	sc_spoken_alert_lang_select_test(1,0)
	sc_back()
end
 
sc_wGetFullLanguageName = function(i)
	return (i == 0 and translate(m_i18n("Alert sounds")) or translate(MODEL["*"].name()) .. L"(" .. translated_format(m_i18n(tostring(MODEL["*"].male()))) .. L")")
end
 
sc_wGetFullLanguagePath = function(i)
	return (i == 0 and "" or "ui_igo9/audio/" .. tostring(MODEL["*"].folder()) .. "/voice_" .. tostring(MODEL["*"].male()) .."/")
end
 
createState("st_wAlertSoundCameraSettings")
st_wAlertSoundCameraSettings:useLayers(backgroundLayers, "ui_wAlertSoundCameraSettings")
st_wAlertSoundCameraSettings.enter = function()
	MODEL.ui.lst_wAlertSoundCameraSettings.current_page = 0
end
st_wAlertSoundCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Voice warning(alert sounds)")
end
 
sc_wChangeSelectedProfileInCity = function()
	wprofiles_selectmode = 1
	sc_NextStateAnim(st_wProfileCameraSettings, "horz_scroll", 1, "")
end
 
sc_wChangeSelectedProfileOutCity = function()
	wprofiles_selectmode = 2
	sc_NextStateAnim(st_wProfileCameraSettings, "horz_scroll", 1, "")
end
 
sc_wAutoSCProfilesSettings = function()
	sc_NextStateAnim(st_wAutoProfileCameraSettings, "horz_scroll", 1, "")
end
 
createState("st_wAutoProfileCameraSettings")
st_wAutoProfileCameraSettings:useLayers(backgroundLayers, "ui_wAutoProfileCameraSettings")
st_wAutoProfileCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Auto profiles settings")
end
 
sc_wGetSelectedProfileName = function(profile)
	return MODEL.ui.wCameraSettingProfile[profile].name()
end
 
sc_wAutoProfileCameraOnChangeSelect = function()
	if MODEL.warning.speedcam_warning() and PERSISTENT.wCameraSettingProfile_saved() ~= MODEL.lua.wAutoCameraSettingProfile_incity() and MODEL.ui.wCameraSettingTmp.list.isempty() then
		PERSISTENT.wCameraSettingProfile_saved = MODEL.lua.wAutoCameraSettingProfile_incity()
		sc_wChangeSCProfileDone(MODEL.lua.wAutoCameraSettingProfileMessage())
	end
end
 
sc_wAutoProfileCameraOnChangeDeSelect = function()
	if MODEL.warning.speedcam_warning() and PERSISTENT.wCameraSettingProfile_saved()~=MODEL.lua.wAutoCameraSettingProfile_outcity() and MODEL.ui.wCameraSettingTmp.list.isempty() and MODEL.navigation.car_pos_valid() and MODEL.lua.wAutoCameraSettingProfile() and not MODEL.navigation.is_in_simulation() then
		PERSISTENT.wCameraSettingProfile_saved = MODEL.lua.wAutoCameraSettingProfile_outcity()
		sc_wChangeSCProfileDone(MODEL.lua.wAutoCameraSettingProfileMessage())
	end
end
 
createState("st_wProfileCameraSettings")
st_wProfileCameraSettings:useLayers(backgroundLayers, "ui_wProfileCameraSettings")
st_wProfileCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Select camera setting profile")
	if wprofiles_selectmode == 0 then
		MODEL.ui.wCameraSettingProfile.list.index = PERSISTENT.wCameraSettingProfile_saved()
	elseif wprofiles_selectmode == 1 then
		MODEL.ui.wCameraSettingProfile.list.index = MODEL.lua.wAutoCameraSettingProfile_incity()
	elseif wprofiles_selectmode == 2 then
		MODEL.ui.wCameraSettingProfile.list.index = MODEL.lua.wAutoCameraSettingProfile_outcity()
	end
end

sc_wChangeSCProfile = function()
	if PERSISTENT.wCameraSettingProfile_saved()==3 then 
		PERSISTENT.wCameraSettingProfile_saved = 0
	else
		PERSISTENT.wCameraSettingProfile_saved = PERSISTENT.wCameraSettingProfile_saved() + 1
	end
	sc_wChangeSCProfileDone(true)
end
 
sc_wChangeSCProfileDone = function(changemessage)
	wGlobal_Timer_SCEnabled = false
	MODEL.lua.wCameraSettingLoaded = false
	MODEL.ui.wCameraSetting.clear()
	sc_wCameraSettingProfile_Set()
	sc_wCameraSetting_Load()
	wGlobal_Timer_SCEnabled = true
	if changemessage and vActiveState() ~= "st_start" then
		sc_wShowHelpText(MODEL.lua.wCameraSettingProfileName())
	end
	if MODEL.navigation.curr_speedcam.category.valid() then
		sc_wSpeedCameraCancel()
	end
end
 
sc_swscprofile_onchange = function()
	if wprofiles_selectmode == 0 then
		sc_swscprofile_onchange_0()
	elseif wprofiles_selectmode == 1 then
		MODEL.lua.wAutoCameraSettingProfile_incity = index
		sc_back()
	elseif wprofiles_selectmode == 2 then
		MODEL.lua.wAutoCameraSettingProfile_outcity = index
		sc_back()
	end
end

sc_swscprofile_onchange_0 = function()
	if PERSISTENT.wCameraSettingProfile_saved() == index then
		sc_back()
		return
	end
	sc_wCameraSettingProfile_Save()
	PERSISTENT.wCameraSettingProfile_saved = index
	sc_wCameraSetting_Save()
	sc_wCameraSettingProfile_Set()
	MODEL.ui.wCameraSettingTmp.clear()
	MODEL.ui.wCameraSettingTmp.load(MODEL.lua.wCameraSettingFile())
	if MODEL.ui.wCameraSettingTmp.list.size() ~= 32 or not MODEL.lua.camera_setting114_32() then
		MODEL.lua.camera_setting114_32 = true
		MODEL.ui.wCameraSettingTmp.clear()
		sc_wCameraSetting_LoadDefault("wCameraSettingTmp")
		MODEL.ui.wCameraSettingTmp.save(MODEL.lua.wCameraSettingFile())
	end
	sc_back()
end

sc_wChangeNameSWSCProfile = function()
	gDriverProfileRenameID = index
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = MODEL.ui.wCameraSettingProfile.list[gDriverProfileRenameID].name()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter new profile name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_wChangeNameSWSCProfileDone
	inputFieldRequired = true
	txtTitle.TEXT = m_i18n("Rename speedcamera profile")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end
 
sc_wChangeNameSWSCProfileDone = function()
	local name = ui.inpSI_Text.VALUE()
	if name == L"" then
		name = L"New Profile"
	end
	MODEL.ui.wCameraSettingProfile.list[gDriverProfileRenameID].name = name
	if MODEL.ui.wCameraSettingProfile.list[gDriverProfileRenameID].id() == PERSISTENT.wCameraSettingProfile_saved() then
		MODEL.lua.wCameraSettingProfileName = name
	end
	sc_wCameraSettingProfile_Save()
	sc_back()
end
 
createState("st_wCommonCameraSettings")
st_wCommonCameraSettings:useLayers(backgroundLayers, "ui_wCommonCameraSettings")
st_wCommonCameraSettings.init = function()
	if MODEL.lua.wSCSettingType() == 1 then
		txtTitle.TEXT = m_i18n("Visual warning")
	elseif MODEL.lua.wSCSettingType() == 2 then
		txtTitle.TEXT = m_i18n("Voice warning")
	elseif MODEL.lua.wSCSettingType() == 3 then
		txtTitle.TEXT = m_i18n("Overspeed warning")
	elseif MODEL.lua.wSCSettingType() == 4 then
		txtTitle.TEXT = m_i18n("Audio Warning")
	elseif MODEL.lua.wSCSettingType() == 5 then
		txtTitle.TEXT = m_i18n("Warning distance setting")
	elseif MODEL.lua.wSCSettingType() == 6 then
		txtTitle.TEXT = m_i18n("Voice warning(second phrase)")
	elseif MODEL.lua.wSCSettingType() == 7 then
		txtTitle.TEXT = m_i18n("Voice warning(additional phrases) settings")
	end
end
 
st_wCommonCameraSettings.exit = function()
	if MODEL.lua.wSCSettingType() == 7 then
		sc_wCameraSettingProfile_Save()
		sc_wCameraSetting_Save()
	end
end
 
createState("st_wDistanceCameraSettings")
st_wDistanceCameraSettings:useLayers(backgroundLayers, "ui_wDistanceCameraSettings")
st_wDistanceCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Warning distance setting")
end
 
st_wDistanceCameraSettings.exit = function()
	local current = MODEL.ui.wCameraSettingTmp[wSettingDistOverIndex]
	current.diston = MODEL.lua.wSettingDistOn()
	current.distvisual = MODEL.lua.wSettingDistVisual()
	current.distsound = MODEL.lua.wSettingDistSound()
end
 
sc_SelectIntegerDistanceDone = function()
	if not inpValueInteger_isempty() then
		MODEL[wInpValueInteger_model] = float.toInt(float.new(tostring(ui.inpValueInteger.VALUE()))/ wUnitConvMeter2Unit[MODEL.INT.regional.units() + 1])
	end
	sc_back()
end
 
createState("st_wOverspeedCameraSettings")
st_wOverspeedCameraSettings:useLayers(backgroundLayers, "ui_wOverspeedCameraSettings")
st_wOverspeedCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Overspeed warning")
end
 
st_wOverspeedCameraSettings.exit = function()
	local current = MODEL.ui.wCameraSettingTmp[wSettingDistOverIndex]
	current.overspeedtype = MODEL.lua.wSettingDistOn()
	current.overspeeddelta = MODEL.lua.wSettingDistVisual()
	current.overspeedvolume = MODEL.lua.wSettingDistSound()
	current.overspeedsound = MODEL.lua.wSettingDistSoundName()
end
 
sc_wGetOverspeedText = function(value)
	return ((value < 0 and L"" or L"+") .. towstring(value) .. L" " .. MODEL.other.format_speed(100, MODEL.regional.units(), MODEL.regional.speed_display_mode(), 1))
end
 
sc_SelectIntegerSpeedDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL[wInpValueInteger_model] = text
	end
	sc_back()
end
 
createState("st_wSecondPhraseCameraSettings")
st_wSecondPhraseCameraSettings:useLayers(backgroundLayers, "ui_wSecondPhraseCameraSettings")
st_wSecondPhraseCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Voice warning(second phrase) settings")
end
 
st_wSecondPhraseCameraSettings.exit = function()
	local current = MODEL.ui.wCameraSettingTmp[wSettingDistOverIndex]
	local currentlangmodel = MODEL.ui.wCameraSettingLanguages[MODEL.lua.wSpeedcamWarningLangType()]()
	current.voicesecond = MODEL.lua.wSettingDistOn()
	currentlangmodel["delay" .. tostring(current.type())] = MODEL.lua.wSecondPhraseDelay()
	MODEL.ui.wCameraSettingLanguages.save()
end
 
sc_wSecondPhraseCameraSettings_play = function()
	sc_spoken_alert_lang_select_test(wSettingDistOverIndex, MODEL.lua.wSecondPhraseDelay())
end
 
createState("st_wSecondPhraseTTSCameraSettings")
st_wSecondPhraseTTSCameraSettings:useLayers(backgroundLayers, "ui_wSecondPhraseTTSCameraSettings")
st_wSecondPhraseTTSCameraSettings.init = function()
	txtTitle.TEXT = m_i18n("Voice warning(additional phrases) settings")
end
 
st_wSecondPhraseTTSCameraSettings.exit = function()
	local current = MODEL.ui.wCameraSettingTmp[wSettingDistOverIndex]
	current.voicesecondtts = MODEL.lua.wSettingDistOn()
	current.distsoundtts = MODEL.lua.wSettingDistTTSOn()
	sc_wPromptCancel("wTestSpeakingID")
end
 
sc_wSecondPhraseTTSCameraSettings_play = function()
	sc_spoken_alert_tts(wSettingDistOverIndex,700,60,MODEL.lua.wSettingDistTTSOn(),MODEL.lua.wSettingDistOn(),false)
end
 
sc_wTransform_numbers2text = function(str, need_transform,spell)
	if type(VOICE["format_all_numbers2text"]) == "function" and need_transform then
		return VOICE["format_all_numbers2text"](str,spell)
	else
		return str
	end
end
 
sc_spoken_alert_tts = function(type,dist,speedlimit,diston,limiton,real)
	local phrase = translate_voice(MODEL.ui.wCameraSettingName.unfiltered_list[type].tts())
	local distphrase = diston and (translated_voice_format(m_i18n_voice("After %s"), sc_wVoiceFormat_search_distance(dist)) .. L" ") or L""
	local limitphrasepart = (MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() or not MODEL.lua.wUltraSoundTTSUnit()) and 2 or 0
	local limitphraseunit = MODEL.lua.wUltraSoundTTSUnit() and MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() and sc_wtranslateunit(MODEL.other.format_speed(speedlimit, MODEL.regional.units(), 1, 1), wspeed_units) or L""
	local limitphrase = limiton and (speedlimit>=5) and (L" " .. translated_voice_format(m_i18n_voice("Limit %s"), sc_wTransform_numbers2text(MODEL.other.format_speed(speedlimit, MODEL.regional.units(), 1, limitphrasepart), limitphrasepart) .. limitphraseunit)) or L""
	if real then
		sc_wspeedcamerasayspeech(distphrase .. phrase .. limitphrase)
	else
		sc_wsayspeech_test(distphrase .. phrase .. limitphrase)
	end
end
sc_wCommonCameraSettings_Over = function()
	local current = MODEL["*"]
	wSettingDistOverIndex = index
	MODEL.lua.wSettingDistIcon = current.type()
	if MODEL.lua.wSCSettingType() == 3 then
		MODEL.lua.wSettingDistOn = current.overspeedtype()
		MODEL.lua.wSettingDistVisual = current.overspeeddelta()
		MODEL.lua.wSettingDistSound = current.overspeedvolume()
		MODEL.lua.wSettingDistSoundName = current.overspeedsound()
		sc_NextStateAnim(st_wOverspeedCameraSettings, "horz_scroll", 1, "")
	elseif MODEL.lua.wSCSettingType() == 5 then
		MODEL.lua.wSettingDistOn = current.diston()
		MODEL.lua.wSettingDistVisual = current.distvisual()
		MODEL.lua.wSettingDistSound = current.distsound()
		sc_NextStateAnim(st_wDistanceCameraSettings, "horz_scroll", 1, "")
	elseif MODEL.lua.wSCSettingType() == 6 then
		MODEL.lua.wSettingDistOn = current.voicesecond()
		local langtype = MODEL.lua.wSpeedcamWarningLangType()
		local currentlangmodel = MODEL.ui.wCameraSettingLanguages[langtype]()
		local delaytype = "delay" .. tostring(current.type())
		MODEL.lua.wSecondPhraseDelay = currentlangmodel[delaytype]()
		sc_NextStateAnim(st_wSecondPhraseCameraSettings, "horz_scroll", 1, "")
	elseif MODEL.lua.wSCSettingType() == 7 then
		MODEL.lua.wSettingDistOn = current.voicesecondtts()
		MODEL.lua.wSettingDistTTSOn = current.distsoundtts()
		MODEL.lua.wSettingDistVisual = current.overspeedvalid()
		MODEL.lua.wSettingDistSound = wSettingDistOverIndex ~= 3
		sc_NextStateAnim(st_wSecondPhraseTTSCameraSettings, "horz_scroll", 1, "")
	end
end
 
sc_wCommonCameraSettings_Other = function()
	local current = MODEL["*"]
	if MODEL.lua.wSCSettingType() == 1 then
		current.visualtype = not current.visualtype()
	elseif MODEL.lua.wSCSettingType() == 2 then
		if current.voicetype() == 0 then
			current.voicetype = 2
		elseif not current.overspeedvalid() then
			current.voicetype = 0
		elseif current.voicetype() == 2 then
			current.voicetype = 3
		else
			current.voicetype = 0
		end
	elseif MODEL.lua.wSCSettingType() == 4 then
		current.approachtype = (current.approachtype() == 0 and 2 or 0)
	end
end
 
sc_select_all_speedcams = function(inputaction)
	if not gLocalMenuIsClosed then
		sc_close_local_menu()
	end
	local name_table = {"visualtype","voicetype","overspeedtype","approachtype","diston","voicesecond","voicesecondtts"}
	local action = MODEL.lua.wSCSettingType() > 1 and MODEL.lua.wSCSettingType() < 5 and 2 or 1
	action = action * inputaction
	for item,index in ModelList_iter(MODEL.ui.wCameraSettingTmp.list) do
		if not((MODEL.lua.wSCSettingType() == 3 and not item["overspeedvalid"]()) or (MODEL.lua.wSCSettingType() == 5 and not item["distvalid"]()) or (MODEL.lua.wSCSettingType() == 6 and not item["overspeedvalid"]()) or (MODEL.lua.wSCSettingType() == 7 and not item["overspeedvalid"]())) then
			item[name_table[MODEL.lua.wSCSettingType()]] = action
		end
		if MODEL.lua.wSCSettingType() == 7 and index ~= 3 then
			item["distsoundtts"] = action
		end
	end
end
 
sc_wCameraSettingLanguages_Load = function()
	if MODEL.ui.wCameraSettingLanguages.list.size() == 35 then
		return
	end
	MODEL.ui.wCameraSettingLanguages.clear()
	ui.wCameraSettingLanguages:add({name="Alert sounds", id=0, icon=0, folder=L"", male=L"", delay0=0, delay1=0, delay2=0, delay3=0, delay9=0, delay10=0, delay11=0, delay17=0, delay18=0, delay21=0, delay23=0, delay31=0})
	ui.wCameraSettingLanguages:add({name="Alert~Russian", id=1, icon=31, folder=L"ru", male=L"male", delay0=130, delay1=180, delay2=200, delay3=280, delay9=200, delay10=200, delay11=200, delay17=200, delay18=160, delay21=130, delay23=140, delay31=150})
	ui.wCameraSettingLanguages:add({name="Alert~Russian", id=2, icon=31, folder=L"ru", male=L"female", delay0=120, delay1=170, delay2=190, delay3=280, delay9=200, delay10=200, delay11=200, delay17=170, delay18=130, delay21=140, delay23=100, delay31=175})
	ui.wCameraSettingLanguages:add({name="Alert~Ukrainian", id=3, icon=40, folder=L"ua", male=L"male", delay0=120, delay1=155, delay2=190, delay3=240, delay9=200, delay10=200, delay11=200, delay17=185, delay18=150, delay21=130, delay23=130, delay31=150})
	ui.wCameraSettingLanguages:add({name="Alert~Ukrainian", id=4, icon=40, folder=L"ua", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~English", id=5, icon=41, folder=L"en", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~English", id=6, icon=41, folder=L"en", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Hebrew", id=7, icon=56, folder=L"he", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Hebrew", id=8, icon=56, folder=L"he", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~German", id=9, icon=14, folder=L"de", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~German", id=10, icon=14, folder=L"de", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~French", id=11, icon=13, folder=L"fr", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~French", id=12, icon=13, folder=L"fr", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Italian", id=13, icon=18, folder=L"it", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Italian", id=14, icon=18, folder=L"it", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Dutch", id=15, icon=26, folder=L"nl", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Dutch", id=16, icon=26, folder=L"nl", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Polish", id=17, icon=28, folder=L"pl", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Polish", id=18, icon=28, folder=L"pl", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Romanian", id=19, icon=30, folder=L"ro", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Romanian", id=20, icon=30, folder=L"ro", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Swedish", id=21, icon=37, folder=L"sw", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Swedish", id=22, icon=37, folder=L"sw", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~American", id=23, icon=44, folder=L"us", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~American", id=24, icon=44, folder=L"us", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Hungarian", id=25, icon=16, folder=L"hu", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Hungarian", id=26, icon=16, folder=L"hu", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Spanish", id=27, icon=36, folder=L"es", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Spanish", id=28, icon=36, folder=L"es", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Czech", id=29, icon=8, folder=L"cz", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Czech", id=30, icon=8, folder=L"cz", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Greek", id=31, icon=15, folder=L"gr", male=L"male", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Greek", id=32, icon=15, folder=L"gr", male=L"female", delay0=200, delay1=200, delay2=200, delay3=200, delay9=200, delay10=200, delay11=200, delay17=200, delay18=200, delay21=200, delay23=200, delay31=200})
	ui.wCameraSettingLanguages:add({name="Alert~Lithuanian", id=33, icon=21, folder=L"lt", male=L"male", delay0=130, delay1=180, delay2=200, delay3=280, delay9=200, delay10=200, delay11=200, delay17=200, delay18=160, delay21=130, delay23=140, delay31=150})
	ui.wCameraSettingLanguages:add({name="Alert~Lithuanian", id=34, icon=21, folder=L"lt", male=L"female", delay0=120, delay1=170, delay2=190, delay3=280, delay9=200, delay10=200, delay11=200, delay17=170, delay18=130, delay21=140, delay23=100, delay31=175})
	MODEL.ui.wCameraSettingLanguages.save()
end
 
sc_wCameraSettingProfile_Load = function()
	if MODEL.ui.wCameraSettingProfile.list.size() == 4 then
		return
	end
	MODEL.ui.wCameraSettingProfile.clear()
	ui.wCameraSettingProfile:add({name=L"Profile 1", id=0, file="camera_setting114_1.txt", ultrasound=1, volume=63, lang=0, ultrasoundtts=0})
	ui.wCameraSettingProfile:add({name=L"Profile 2", id=1, file="camera_setting114_2.txt", ultrasound=1, volume=63, lang=0, ultrasoundtts=0})
	ui.wCameraSettingProfile:add({name=L"Profile 3", id=2, file="camera_setting114_3.txt", ultrasound=1, volume=63, lang=0, ultrasoundtts=0})
	ui.wCameraSettingProfile:add({name=L"Profile 4", id=3, file="camera_setting114_4.txt", ultrasound=0, volume=63, lang=0, ultrasoundtts=0})
	MODEL.ui.wCameraSettingProfile.save()
end
 
sc_wCameraSettingProfile_Set = function()
	local current = MODEL.ui.wCameraSettingProfile[PERSISTENT.wCameraSettingProfile_saved()]
	MODEL.lua.wCameraSettingProfileName = current.name()
	MODEL.lua.wCameraSettingFile = current.file()
	MODEL.lua.wUltraSound = current.ultrasound()
	MODEL.lua.wSpeedcamAlertVolume = current.volume()
	MODEL.lua.wSpeedcamWarningLangType = current.lang()
	MODEL.lua.wUltraSoundTTS = current.ultrasoundtts()
end
 
sc_wCameraSettingProfile_Save = function()
	local current = MODEL.ui.wCameraSettingProfile[PERSISTENT.wCameraSettingProfile_saved()]
	current.name = MODEL.lua.wCameraSettingProfileName()
	current.ultrasound = MODEL.lua.wUltraSound()
	current.volume = MODEL.lua.wSpeedcamAlertVolume()
	current.lang = MODEL.lua.wSpeedcamWarningLangType()
	current.ultrasoundtts = MODEL.lua.wUltraSoundTTS()
	MODEL.ui.wCameraSettingProfile.save()
end
 
sc_wCameraSetting_Load = function()
	MODEL.lua.wCameraSettingLoaded = false
	MODEL.ui.wCameraSetting.clear()
	MODEL.ui.wCameraSetting.load(MODEL.lua.wCameraSettingFile())
	if MODEL.ui.wCameraSetting.list.size() ~= 32 or not MODEL.lua.camera_setting114_32() then
		MODEL.lua.camera_setting114_32 = true
		MODEL.ui.wCameraSetting.clear()
		sc_wCameraSetting_LoadDefault("wCameraSetting")
		MODEL.ui.wCameraSetting.save(MODEL.lua.wCameraSettingFile())
	end
	sc_wSCApproachSet()
	MODEL.lua.wCameraSettingLoaded = true
end
 
-- Fidelis - suporte para 32 tipos
sc_wCameraSetting_LoadDefault = function(model)
	local camera_params = {
	{type= 0, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type= 2, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=2000, distsound=2000, distsoundtts=1, voicesecondtts=1},
	{type= 4, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type= 3, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type= 1, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=700, distsound=700, distsoundtts=1, voicesecondtts=1},
	{type= 6, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type= 7, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type= 8, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type= 9, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=10, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=11, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=12, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=2000, distsound=2000, distsoundtts=1, voicesecondtts=0},
	{type=13, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=14, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type=15, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0,  overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=700, distsound=700, distsoundtts=1, voicesecondtts=0},
	{type=16, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type=17, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=700, distsound=700, distsoundtts=1, voicesecondtts=1},
	{type=18, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=19, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=20, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=21, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=22, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=0},
	{type=23, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type=24, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=25, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=26, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=27, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=28, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=29, visualtype=0, voicetype=0, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=0, distvalid=0, diston=0, distvisual=300, distsound=300, distsoundtts=0, voicesecondtts=0},
	{type=30, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=700, distsound=700, distsoundtts=1, voicesecondtts=0},
	{type=31, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=1, overspeedvalid=1, overspeedtype=1, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=300, distsound=300, distsoundtts=1, voicesecondtts=1},
	{type= 5, visualtype=1, voicetype=2, voicealert=L"!passcam", voicesecond=0, overspeedvalid=0, overspeedtype=0, overspeeddelta=0, overspeedsound=L"", overspeedvolume=0, approachtype=2, distvalid=1, diston=0, distvisual=1000, distsound=1000, distsoundtts=1, voicesecondtts=0},
	}
	local current = {}
	local modellist = MODEL.ui[model]
	modellist.resize(#camera_params)
	for i = 1, #camera_params do
		current = camera_params[i]
		for param,value in pairs(current) do
			modellist[i - 1][param] = value
		end
	end
end

 
sc_wCameraSetting_Save = function()
	if MODEL.ui.wCameraSettingTmp.list.size() ~= 32 then
		return
	end
	MODEL.ui.wCameraSettingTmp.save(MODEL.lua.wCameraSettingFile())
	MODEL.ui.wCameraSettingTmp.clear()
	MODEL.lua.wCameraSettingLoaded = false
	MODEL.ui.wCameraSetting.clear()
	MODEL.ui.wCameraSetting.load(MODEL.lua.wCameraSettingFile())
	sc_wSCApproachSet()
	MODEL.lua.wCameraSettingLoaded = true
	if MODEL.navigation.curr_speedcam.category.valid() then
		sc_wSpeedCameraFastCancel()
	end
end
 
sc_wSCApproachSet = function()
	for item in ModelList_iter(MODEL.ui.wCameraSetting) do
		MODEL.warning["speedcam_soundtype_" .. tostring(item.type())] = (not (MODEL.lua.wUltraSound() or (MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported())) and item.approachtype()) or 0
	end
end
 
st_SpeedWarningSettings.exit = function()
	sc_WarnTypeVoice_set()
	obs_wtolerance:TRIGGER()
end
 
sc_WarnTypeVoice_set = function()
	MODEL.warning.speedlimit_warning_voice = MODEL.lua.wAudioOS() and (MODEL.lua.wWarnTypeOS() ~= 1)
end
 
sc_spoken_alert_lang_selectOS = function()
	wOverSoundDelay = wOverSoundDelay - 1
	if wOverSoundDelay < 1 then
		MODEL.lua.wOSFlag = not MODEL.lua.wWarnModeOS()
		sc_wplaysound(0, MODEL.lua.wWarnOSSoundName(), MODEL.lua.wWarnOSVolume())
		wOverSoundDelay = MODEL.lua.wWarnOSPause()
	end
end
 
sc_wspeedmode_change = function()
	if MODEL.lua.wSimulateIsTrackPlaying() then
		return
	end
	if MODEL.warning.driveralert.speed_limit() and MODEL.lua.wSpeedLimit() and MODEL.warning.driveralert.speed_limit() > MODEL.lua.wSpeedLimit() and MODEL.warning.driveralert.speed_limit() > MODEL.navigation.car.current_speed() then
		MODEL.lua.wSpeedLimit = MODEL.warning.driveralert.speed_limit()
		sc_StartTimerSL()
		if MODEL.lua.wSLTTSVoice() and sc_wReadOutSpeedLimitSupported() then
			sc_wspeedlimitsayspeech(sc_wGetSL_sayphase(MODEL.lua.wSpeedLimit()))
		else
			sc_wplaysound(0, MODEL.lua.wSLSoundName(), MODEL.lua.wSLSoundVolume())
		end
	else
		sc_StopTimerSL()
		MODEL.lua.wSpeedLimit = MODEL.warning.driveralert.speed_limit()
	end
end
 
sc_wReadOutSpeedLimitSupported = function()
	return MODEL_regional_is_it_voice_localizable(m_i18n_voice("You can increase speed.")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Limit %s")) and MODEL.regional.current_voice.is_tts()
end
 
sc_StartTimerSL = function()
	if MODEL.lua.wSLVisual() and not MODEL.lua.wAnimateOSValid() then
		sc_StopTimerSL()
		MODEL.lua.wAnimateSLValid = true
		wTimerSLID = doDelayed(200, function() MODEL.lua.wAnimateSLValid = false end)
	end
end
 
sc_StopTimerSL = function()
	if wTimerSLID ~= -1 then
		killDelayed(wTimerSLID)
		wTimerSLID = -1
	end
	MODEL.lua.wAnimateSLValid = false
end
 
sc_btnSR_SL_OnRelease = function()
	sc_NextStateAnim(st_wSLSettings, "horz_scroll", 1, "")
end
 
createState("st_wSLSettings")
st_wSLSettings:useLayers(backgroundLayers, "ui_wSLSettings")
st_wSLSettings.init = function()
	txtTitle.TEXT = m_i18n("Speed Limit Increasing Settings")
end
 
sc_wSLTTS_OnRelease = function()
	sc_NextStateAnim(st_wSLSoundTTS, "horz_scroll", 1, "")
end
 
createState("st_wSLSoundTTS")
st_wSLSoundTTS:useLayers(backgroundLayers, "ui_wSLSoundTTS")
st_wSLSoundTTS.init = function()
	txtTitle.TEXT = m_i18n("Speed Limit TTS Pro Test")
end
 
st_wSLSoundTTS.done = function()
	sc_wPromptCancel("wTestSpeakingID")
end
 
sc_wSecondPhraseTTSSL_play = function()
	sc_wsayspeech_test(sc_wGetSL_sayphase(90))
end
 
sc_wGetSL_sayphase = function(limit)
	local limitphrasepart = (MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() or not MODEL.lua.wSLTTSVoiceSecondPhraseUnit()) and 2 or 0
	local limitphraseunit = MODEL.lua.wSLTTSVoiceSecondPhraseUnit() and MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() and sc_wtranslateunit(MODEL.other.format_speed(limit, MODEL.regional.units(), 1, 1), wspeed_units) or L""
	local limitphrase = MODEL.lua.wSLTTSVoiceSecondPhrase() and translated_voice_format(m_i18n_voice("Limit %s"), sc_wTransform_numbers2text(MODEL.other.format_speed(limit, MODEL.regional.units(), 1, limitphrasepart), limitphrasepart) .. limitphraseunit) or L""
	return translate_voice("You can increase speed.") .. L" " .. limitphrase
end
 
btnSR_OverspeedWarn_OnRelease = function()
	if not MODEL.warning.speedlimit_warning_visual() then
		MODEL.warning.speedlimit_warning_visual = true
	elseif MODEL.lua.wAudioOS() then
		MODEL.warning.speedlimit_warning_visual = false
		MODEL.lua.wAudioOS = false
	else
		MODEL.lua.wAudioOS = true
	end
end

sc_SelectIntegerNumberDone = function()
	if not inpValueInteger_isempty() then
		MODEL[wInpValueInteger_model] = tonumber(ui.inpValueInteger.VALUE())
	end
	sc_back()
end
 
createState("st_SpeedWarningSettingsVisual")
st_SpeedWarningSettingsVisual:useLayers(backgroundLayers, "ui_SettingsSpeedWarningVisual")
st_SpeedWarningSettingsVisual.init = function()
	txtTitle.TEXT = m_i18n("Advanced Overspeed visual settings")
end
 
createState("st_SpeedWarningSettingsAudio")
st_SpeedWarningSettingsAudio:useLayers(backgroundLayers, "ui_List_Background", "ui_SettingsSpeedWarningAudio")
 
st_SpeedWarningSettingsAudio.init = function()
	txtTitle.TEXT = m_i18n("Advanced Overspeed audio settings")
end
 
createState("st_SpeedWarningSettingsTolerance")
st_SpeedWarningSettingsTolerance:useLayers(backgroundLayers, "ui_SpeedWarningSettingsTolerance")
st_SpeedWarningSettingsTolerance.init = function()
	txtTitle.TEXT = m_i18n("Speed Warnings Tolerance")
end

sc_TolTypeReinit = function()
	MODEL.warning.speedwarn_alt_toltype = 0
	MODEL.warning.speedwarn_toltype = 0
end
 
sc_wGetToleranceText = function(toltype, value)
	local unit = toltype and MODEL.other.format_speed(100, MODEL.regional.units(), MODEL.regional.speed_display_mode(), 1) or L"%"
	return ((value < 100 and L"" or L"+") .. towstring(value - 100) .. L" " .. unit)
end
 
sc_SelectToleranceDone = function()
	if not inpValueInteger_isempty() then
		MODEL[wInpValueInteger_model] = tonumber(ui.inpValueInteger.VALUE()) + 100
	end
	sc_back()
end
 
sc_DADing = function()
	if not (vDAIsVisible() and MODEL.lua.DAEnabled()) then
		return
	end
	if vActiveState() == "st_easynav" and not MODEL.lua.dragMode() and MODEL.route.vehicle_type() ~= EVehicleType.Pedestrian then
		if MODEL.lua.wDATTSVoice() and MODEL.lua.wReadOutDASupported() then
			sc_wDAsayspeech(sc_wGetDADing_sayphase())
		else
			sc_wplaysound(0, MODEL.lua.wDASoundName(), MODEL.lua.wDASoundVolume())
		end
	end
	if vActiveState() == "st_screensaver" and MODEL.lua.wDASS() then
		if MODEL.lua.wDATTSVoice() and MODEL.lua.wReadOutDASupported() then
			sc_wDAsayspeech(sc_wGetDADing_sayphase())
		else
			sc_wplaysound(0, MODEL.lua.wDASoundName(), MODEL.lua.wDASoundVolume())
		end
	end
end
 
sc_wGetDADing_sayphase = function()
	local da = MODEL.warning.driveralert
	if da.settings.warn_method() == 1 then
		return da.alerts.size() > 1 and sc_wGetDADing_sayphase_sign(da.alerts[0].type(), da.alerts[0].is_active()) .. L" " .. sc_wGetDADing_sayphase_sign(da.alerts[1].type(), da.alerts[1].is_active(), da.alerts[0].is_active()) or sc_wGetDADing_sayphase_sign(da.alerts[0].type(), da.alerts[0].is_active())
	else
		local iconmodel = da.alerts.size() > 1 and da.alerts[1].is_active() and 1 or 0
		return da.alerts.size() > 1 and da.alerts[0].is_active() and da.alerts[1].is_active() and sc_wGetDADing_sayphase_sign(da.alerts[0].type(),true) .. L" " .. sc_wGetDADing_sayphase_sign(da.alerts[1].type(),true) or sc_wGetDADing_sayphase_sign(da.alerts[iconmodel].type(),true)
	end
end
 
sc_wGetDADing_sayphase_sign = function(signindex,signactive,signprevactive)
	local phrase = signindex < MODEL.ui.list_wDATypes.unfiltered_list.size() and MODEL.ui.list_wDATypes.unfiltered_list[signindex].text() or ""
	return translate_voice(not signactive and (signprevactive ~= nil and not signprevactive and "and" or "Soon") or "") .. (not signactive and L" " or L"") .. translate_voice(phrase)
end
 
sc_wGetPhaseBmpDA_sayTest = function()
	return "images/da/" .. (DAiconIdx == 4 and "high/" or (DAiconIdx == 2 and "mid/" or "low/")) .. MODEL["*"].bmp()
end
 
sc_wDATTSVoice_play = function()
	sc_wsayspeech_test(translate_voice(MODEL["*"].text()))
end
 
sc_wDASignhide = function()
	ui.vDAIsVisible = 0
	if MODEL.lua.wDATTSVoice() and MODEL.lua.wReadOutDASupported() and not MODEL.lua.wTTSProGuidancePriority() then
		MODEL.sound.speech.unlock(wLockSpeakingID)
	end
	sc_wPromptCancel("wDASpeakingID")
end
sc_wGetDriveralertSpeedLimit = function(conditional,limit)
	local value = limit
	if conditional then
		value = MODEL.warning.driveralert.speed_limit_conditional()
	end
	return MODEL.other.format_speed(value, MODEL.regional.units(), 1, 2)
end
 
sc_wVoiceFormat_search_distance = function(inputdistance)
	local unit_names = {"yards","meters","feet"}
	local voicetable_name = type(VOICE.distances["ttspro_"..unit_names[MODEL.regional.units() + 1]]) == "table" and "ttspro_" or ""
	local dist_table = VOICE.distances[voicetable_name..unit_names[MODEL.regional.units() + 1]]
	local _,_,outputdistance = VOICE.distance_formatter(inputdistance)
	if #dist_table == 0 or inputdistance > dist_table[#dist_table-1] then
		return builtin.format(L"%{distance:3}",outputdistance)
	end
	local ind = sc_wVoiceFormat_search_index(outputdistance,dist_table)
	if outputdistance ~= dist_table[ind] then
		ind = sc_wVoiceFormat_search_index(inputdistance,dist_table)
	end
	return VOICE.decode_string(dist_table[ind + 1], 1)
end
 
sc_wVoiceFormat_search_index = function(distance, dist_table)
	if distance <= dist_table[1] then
		return 1
	elseif distance >= dist_table[#dist_table-1] then
		return #dist_table-1
	else
		local lo = 1
		local hi = #dist_table >> 1
		local dist, idx
		repeat
			idx = (lo+hi)>>1
			dist = dist_table[idx<<1 - 1]
			if dist < distance then
				lo = idx
			elseif dist > distance then
				hi = idx
			else
				break
			end
		until (hi-lo < 2)
		if (dist < distance) then idx = idx+1 end
		return idx<<1 - 1
	end
end
 
--e_maplayer.lua
local sc_Map_States_Init_orig = sc_Map_States_Init
sc_Map_States_Init = function()
	sc_Map_States_Init_orig()
	sc_wLabelsReinit2D()
	sc_wLabelsReinit3D()
end
 
sc_wLabelsReinit2D = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.setglobal = true
	mapLayer.setglobal_filter = wGetNUSupported and "2dheadup,2dnorthup,simulate_2d,simulate_2d_nu" or "2dheadup,simulate_2d"
	mapLayer.show_labels_2d = MODEL.lua.wLabels_2d()
	mapLayer.setglobal = false
end
 
sc_wLabelsReinit3D = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.setglobal = true
	mapLayer.setglobal_filter = "navmap3d,simulate"
	mapLayer.show_labels_3d = MODEL.lua.wLabels_3d()
	mapLayer.navi_mode_3d_labels = MODEL.lua.wLabels_navi3d()
	mapLayer.setglobal = false
end
 
--favorite.lua
 
sc_et_FindFavorite_OnRelease = function(currentFavorite)
	local currentPoi = currentFavorite ~= nil and currentFavorite or MODEL["*"]
	MODEL.my.poi.select_poi(currentPoi.provider_id(), currentPoi.id())
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	MODEL.poi.resultpoi.clear()
	MODEL.poi.resultpoi.add_poi_by_id(currentPoi.provider_id(), currentPoi.id())
	isFromFavorite = true
	gIsFromFavoriteVR = true
	PoiSelected = true
	sc_wMultiSelect_ItemDone()
end
 
local sc_CreateFavoritesGroup_orig = sc_CreateFavoritesGroup
sc_CreateFavoritesGroup = function()
	sc_CreateFavoritesGroup_orig()
	wCurrentGroupFav = MODEL.poi.find_group(FavGroup)
end
 
sc_ModifyFavouritePos_done = function()
	gFavAddressChanged = true
	local favName = MODEL.my.poi.current.name()
	local favPhone = MODEL.my.poi.current.phone()
	local favIcon = MODEL.my.poi.current.icon()
	local favInfo = MODEL.my.poi.current.ext_STR_OTHER()
	local poiGroupId = MODEL.my.poi.current.group_id()
	MODEL.my.poi.current.remove()
	MODEL.my.poi.add_poi_selected(poiGroupId, gUserPOI_Provider)
	MODEL.my.poi.current.name = favName
	MODEL.my.poi.current.phone = favPhone
	MODEL.my.poi.current.icon = favIcon
	MODEL.my.poi.current.ext_STR_OTHER = favInfo
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	CLEARTOSTATE(st_ShowPOIInfo)
end
 
--general.lua
wMessage_needplay = true
 
sc_ShowMessageBox = function()
	if MODEL.screen.msgbox.on_screen.layer() == nil then
		wMessage_needplay = true
		return 
	end
	if MODEL.EXISTS.oasis.media() and sc_Media_Video_RemotePause ~= nil then
		sc_Media_Video_RemotePause()
	end
	ui.vMessageBoxEnabled = 0
	doDelayed(30, function() ui.vMessageBoxEnabled = 1 end)
	MODEL.screen.msgbox.on_screen.layer():SHOW()
	local playSound = true
	local prioText = MODEL.screen.msgbox.on_screen.layer() ~= ui_RestrictedMsg and "voice.ui" or "voice.danger"
	if gMessageBoxShowed ~= MODEL.screen.msgbox.on_screen.id() then
		gMessageboxDuringVR = false
		if MODEL.regional.current_language.lcid() == MODEL.regional.current_voice.lcid() and MODEL.regional.current_voice.is_tts() then
			if sc_GetMessageboxVRNeeded() then
				if MODEL.screen.msgbox.on_screen.number_of_buttons() ~= 1 then
					doDelayed(1, function() MODEL.screen.msgbox.on_screen.stop_timer() end)
					sc_VRMessageActivate()
				elseif wMessage_needplay then
					gMessageboxDuringVR = MODEL.lua.VRStatus() ~= eVRStatus.inactive
					MODEL.screen.msgbox.on_screen.restart_timer(1000)
					doDelayed(1, function() MODEL.screen.msgbox.on_screen.stop_timer() end)
					gMessageboxReadoutID = MODEL.sound.speech.say(prioText, MODEL.screen.msgbox.on_screen.first_line(), {lock_id = gVRLockId, unlock_after_done = false, callback = sc_ReadOutMessagebox_Callback})
				end
				playSound = false
			elseif vReadOutSystemMessages() and (not sc_ReadOutCountryInfoSupported() or not MODEL.lua.ReadOutCountryInfo() or not MODEL.screen.msgbox.on_screen.has_tag("mute_countryinfo_msg")) and (st_EasyNav.isActive or MODEL.screen.msgbox.on_screen.layer() == ui_RestrictedMsg) and wMessage_needplay then
				local text = MODEL.screen.msgbox.on_screen.first_line()
				if MODEL.screen.msgbox.on_screen.title() == "OnHardRestriction" or MODEL.screen.msgbox.on_screen.title() == "OnSoftRestriction" then
					text = sc_getHardRestrictionSpeechText()
				end
				doDelayed(1, function() MODEL.screen.msgbox.on_screen.stop_timer() end)
				gMessageboxReadoutID = MODEL.sound.speech.say(prioText, text, {callback = sc_ReadOutMessagebox_Callback})
				playSound = false
			end
		end
		if playSound and wMessage_needplay then
			if MODEL.screen.msgbox.on_screen.has_tag("hardrestriction") then
				sc_StartHardRestrictSound()
			elseif MODEL.screen.msgbox.on_screen.title() ~= "quickdetour" then
				PLAYSOUND("!msgbox")
			end
		end
	end
	wMessage_needplay = true
	gMessageBoxShowed = MODEL.screen.msgbox.on_screen.id()
end
 
local sc_HideMessageBox_orig = sc_HideMessageBox
sc_HideMessageBox = function()
	sc_wPromptCancel("wPowerSpeakingID")
	sc_HideMessageBox_orig()
end
 
sc_GetStartState = function()
	State = sc_GetSysEntry("interface", "start_state", MODEL.lua.MainMenuState())
	MODEL.lua.MainMenuState = State == "st_MainMenu" and L"st_MainMenu" or towstring(State)
	return _G[tostring(MODEL.lua.MainMenuState())]
end
 
sc_back = function()
	if st_EasyFindMenu.isActive and MODEL.lua.wInSelectHomeOffice() then
		sc_back_HomeOffice()
	elseif st_ManagePOIGroupVisibility.isActive then
		sc_back_POIGroupVisibility()
		Back:trigger()
	elseif (st_AddPOI.isActive or st_wUserPOISearchParamsPOIGroupSettings.isActive or st_wChangePOIGroup.isActive or st_wSplitScreenPOIGroupSettings.isActive) and MODEL.poi.structure.to_parent.valid() then
		sc_Structure_ToParentAP()
	elseif st_FindPOIStructuredList.isActive and MODEL.poi.struct_search.to_parent.valid() then
		sc_StructSearch_ToParent()
	elseif st_POIVisibilities.isActive and MODEL.poi.structure.to_parent.valid() then
		sc_Structure_ToParent()
	elseif st_HighwayPoiCatList.isActive and MODEL.poi.structure.to_parent.valid() then
		sc_HwyPoiStructure_ToParent()
	elseif st_TMC_list.isActive then
		st_TMC_list.backButtonPressed = true
		Back:trigger()
	else
		Back:trigger()
	end
end
 
sc_wShowNewMessageBox = function(text1,f_button1,text_button1,icon_button1,text2,f_button2)
	local typetext1 = type(text1) == "wstring" and "_wstr" or ""
	local f_cancel = f_button2 ~= "nil" and f_button2 or ""
	MODEL.screen.msgbox.new.setup(2)
	MODEL.screen.msgbox.new["set_line"..typetext1](1, text1)
	if text2 ~= nil then
		local typetext2 = type(text2) == "wstring" and "_wstr" or ""
		MODEL.screen.msgbox.new["set_line"..typetext2](2, text2)
	end
	MODEL.screen.msgbox.new.setup_button(1, f_button1, text_button1, "", icon_button1)
	MODEL.screen.msgbox.new.setup_button(2, f_cancel, m_i18n("Cancel"), "", "ico_cancel_mid.bmp#3")
	MODEL.screen.msgbox.create_new()
end
--history.lua
 
sc_SelectHistoryMain = function(index)
	local deletedpoi = false
	if MODEL.mydata.history.list[index].type() == 1 then
		local historyPoi = MODEL.mydata.history.list[index].poi
		local pid = historyPoi.provider_id()
		local id = historyPoi.id()
		if pid ~= 0 and id ~= 0 then
			MODEL.my.poi.select_poi(pid, id)
			if MODEL.my.poi.current.valid() then
				MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
				MODEL.poi.resultpoi.clear()
				MODEL.poi.resultpoi.add_poi_by_id(pid, id)
			else
				MODEL.poi.resultpoi.clear()
				deletedpoi = true
			end
			PoiSelected = MODEL.my.poi.current.valid()
		else
			deletedpoi = true
		end
	end
	MODEL.my.map.select_history(index)
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	if deletedpoi then
		MODEL.my.map.select_address(MODEL.map.cursor.position())
	end
	sc_wMultiSelect_ItemDone()
end
 
sc_HistoryClearAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all history entries?"),"sc_btnMH_ClearAll_OnRelease_OK", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wbtnFH_FilterAfter = function()
	inpSI_Text.ALLOWCURSORCLICK = 0
end
 
local st_FindHistory_exit_orig = st_FindHistory.exit
st_FindHistory.exit = function()
	st_FindHistory_exit_orig()
	MODEL.regional.keyboard.smartkey_model("")
end
 
sc_SaveLastSelectedToHistory = function()
	if MODEL.my.map.selected_item.name() ~= L"" and MODEL.my.map.selected_item.address.long_format() ~= L"" and not wSelectedItemHotAction then
		MODEL.mydata.history.insert(0)
	end
	wSelectedItemHotName = L""
	wSelectedItemHotPos = nil
	wSelectedItemHotAction = false
end
 
--keyboard.lua
f_wSelectKeyboardLayoutDone = nil
sc_keyboard_panel_selected = function()
	sc_close_local_menu()
	PERSISTENT.keyboard_panel_alpha = MODEL["*"].panelname()
	sc_wCandidateKeyboardLayout_SetName(PERSISTENT.keyboard_panel_alpha())
	sc_keyboard_panel_selected_done()
end
 
sc_keyboard_panel_selected_done = function()
	MODEL.regional.keyboard.load_panel_by_name(PERSISTENT.keyboard_panel_alpha())
	if g_runthis_after_sc_keyboard_panel_selected_shameful_hack ~= nil then
		g_runthis_after_sc_keyboard_panel_selected_shameful_hack()
	end
	sc_SetEnabledKeyboardPanels()
end
 
sc_wchangekeyboard = function()
	if PERSISTENT.keyboard_panel_alpha() == MODEL.lua.wQuickKeyPanel1() then
		PERSISTENT.keyboard_panel_alpha = MODEL.lua.wQuickKeyPanel2()
	else
		PERSISTENT.keyboard_panel_alpha = MODEL.lua.wQuickKeyPanel1()
	end
	sc_wCandidateKeyboardLayout_SetName(PERSISTENT.keyboard_panel_alpha())
	sc_keyboard_panel_selected_done()
end
 
sc_wCandidateKeyboardLayout_SetName = function(layout)
	local candidate = layout == MODEL.lua.wQuickKeyPanel1() and MODEL.lua.wQuickKeyPanel2() or MODEL.lua.wQuickKeyPanel1()
	for panelModel in ModelList_iter(MODEL.regional.keyboard.panels) do
		if candidate == panelModel.name() then
			MODEL.lua.wCurrentKeyPanel = panelModel.name()
			break
		end
	end
end
 
sc_wSelectKeyboardLayout = function(selectedIndex)
	MODEL.lua.wQuickKeyPanelSelected = selectedIndex == 1 and MODEL.lua.wQuickKeyPanel1() or MODEL.lua.wQuickKeyPanel2()
	f_wSelectKeyboardLayoutDone = selectedIndex == 1 and sc_wSelectKeyboardLayoutDone1 or sc_wSelectKeyboardLayoutDone2
	sc_NextStateAnim(st_wSelectKeyboardLayout, "horz_scroll", 1, "")
end
 
createState("st_wSelectKeyboardLayout")
st_wSelectKeyboardLayout:useLayers(backgroundLayers, "ui_List_Background", "ui_wSelectKeyboardLayout")
st_wSelectKeyboardLayout.init = function()
	txtTitle.TEXT = m_i18n("Select keyboard layout")
end
 
sc_wSelectKeyboardLayoutSelect = function()
	f_wSelectKeyboardLayoutDone()
	sc_back()
end
 
sc_wSelectKeyboardLayoutDone1 = function()
	MODEL.lua.wQuickKeyPanel1 = MODEL.lua.wQuickKeyPanelSelected()
end
 
sc_wSelectKeyboardLayoutDone2 = function()
	MODEL.lua.wQuickKeyPanel2 = MODEL.lua.wQuickKeyPanelSelected()
end
 
--langvoice.lua
 
wSpeedCameraSpeakingID = 0
wTestSpeakingID = 0
wDASpeakingID = 0
wPowerSpeakingID = 0
wTurnRestSayDelayed = -1
wRealSpeakingID = 0
wSpeedLimitSpeakingID = 0
wDetourSpeakingID = 0
wLockSpeakingID = -1
sc_wplaysound = function(delay, sound, volume)
	if sound == L"" or (delay == 0 and wAudioVoiceCameraPlayed) then
		return
	end
	if delay then
		if wAudioVoiceCameraTimer ~= -1 then
			killDelayed(wAudioVoiceCameraTimer)
			wAudioVoiceCameraTimer = -1
		end
		wAudioVoiceCameraPlayed = true
		wAudioVoiceCameraTimer = doDelayed(delay, function() wAudioVoiceCameraPlayed = false end)
	end
	if MODEL.sound.alert_volume() ~= volume then
		MODEL.sound.alert_volume = volume
	end
	MODEL.sound.playchanneltest("alarmeffect", sound)
end

sc_wsayspeech = function(text,prio,boostedprio)
	if MODEL.regional.current_voice.is_tts() and not (wDASpeakingID or wSpeedCameraSpeakingID or MODEL.sound.os_muted() or MODEL.sound.voice_muted() or MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
		sc_wPromptCancel("wRealSpeakingID")
		wRealSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = prio, boosted_priority = boostedprio, callback = function(res) if res > 1 then wRealSpeakingID = 0 end end})
	end
end
 
sc_wsayspeech_test = function(text)
	sc_wPromptCancel("wTestSpeakingID")
	if not (MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
		wTestSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 21, boosted_priority = 25, callback = function(res) if res > 1 then wTestSpeakingID = 0 end end})
	end
end

sc_wspeedlimitsayspeech = function(text)
	local wsaying = wTestSpeakingID or wRealSpeakingID or wPowerSpeakingID or wDASpeakingID or wSpeedCameraSpeakingID
	if wDetourSpeakingID then
		wsaying = true
	end
	if wSpeedLimitSpeakingID then
		wsaying = false
		PromptCancel(wSpeedLimitSpeakingID)
		wSpeedLimitSpeakingID = 0
	end
	if not wsaying and not (MODEL.sound.os_muted() or MODEL.sound.voice_muted() or MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
		wSpeedLimitSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 19, boosted_priority = 20, callback = function(res) if res > 1 then wSpeedLimitSpeakingID = 0 end end})
	end
end
 
sc_wspeedcamerasayspeech = function(text)
	if MODEL.sound.os_muted() or MODEL.sound.voice_muted() then
		return
	end
	if not MODEL.lua.wTTSProGuidancePriority() then
		MODEL.sound.speech.unlock(wLockSpeakingID)
	end
	sc_wPromptCancel("wSpeedCameraSpeakingID")
	sc_wPromptCancel("wDASpeakingID")
	sc_wsayspeech_uicancel()
	if MODEL.lua.wTTSProGuidancePriority() then
		if not (MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
			wSpeedCameraSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 26, boosted_priority = 29, callback = function(res) if res > 1 then wSpeedCameraSpeakingID = 0 end end})
		end
	else
		wLockSpeakingID = MODEL.sound.speech.lock()
		wSpeedCameraSpeakingID = MODEL.sound.speech.say("voice.ui", text, {lock_id = wLockSpeakingID, unlock_after_done = true, priority = 100, boosted_priority = 100, callback = function(res) if res > 1 then wSpeedCameraSpeakingID = 0 end end})
	end
end
 
sc_wDAsayspeech = function(text)
	if wSpeedCameraSpeakingID or MODEL.sound.os_muted() or MODEL.sound.voice_muted() then
		return
	end
	if not MODEL.lua.wTTSProGuidancePriority() then
		MODEL.sound.speech.unlock(wLockSpeakingID)
	end
	sc_wPromptCancel("wDASpeakingID")
	sc_wsayspeech_uicancel()
	if MODEL.lua.wTTSProGuidancePriority() then
		if not (MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
			wDASpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 26, boosted_priority = 29, callback = function(res) if res > 1 then wDASpeakingID = 0 end end})
		end
	else
		wLockSpeakingID = MODEL.sound.speech.lock()
		wDASpeakingID = MODEL.sound.speech.say("voice.ui", text, {lock_id = wLockSpeakingID, unlock_after_done = true, priority = 100, boosted_priority = 100, callback = function(res) if res > 1 then wDASpeakingID = 0 end end})
	end
end
 
sc_wpowersayspeech = function(text)
	if not (wDASpeakingID or wSpeedCameraSpeakingID or MODEL.sound.os_muted() or MODEL.sound.voice_muted() or MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
		sc_wPromptCancel("wPowerSpeakingID")
		wPowerSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 5, boosted_priority = 10, callback = sc_wpowersayspeech_done})
	end
end
 
sc_wpowersayspeech_done = function(res)
	if res > 1 then
		wPowerSpeakingID = 0
	end
end
 
sc_wsayspeech_uicancel = function()
	local t = {"wTestSpeakingID","wRealSpeakingID","wSpeedLimitSpeakingID","wPowerSpeakingID","wDetourSpeakingID","gMessageboxReadoutID"}
	for _,v in pairs(t) do
		sc_wPromptCancel(v)
	end
end
 
sc_ReadOutRouteSummary_test = function()
	local text = MODEL.sound.voice.get_route_summary()
	if text ~= L"" then
		sc_wsayspeech_test(text)
	end
end
 
wcountry_info_keys_test = {enter = m_i18n_voice("You have entered %s. Keep to the following speed limits."), in_town = m_i18n_voice("Within towns, %s."), country = m_i18n_voice("Countryside, %s."), expressway = m_i18n_voice("Expressway, %s."), motorway = m_i18n_voice("Motorway, %s.")}
sc_ReadOutCountryInfo_test = function()
	MODEL.other.country_info.select_country_by_pos(MODEL.navigation.car.position())
	local countryindex = MODEL.other.country_info.list.index()
	if countryindex ~= nil then
		sc_wsayspeech_test(sc_wCountryInfoGetSpeechText(MODEL.other.country_info.list[countryindex]))
	end
end
 
sc_wCountryInfoGetSpeechText = function(country)
	local countryname = translate_voice(country.name())
	if countryname == towstring(country.name()) then
		countryname = country.name()
	end
	local countryInfotts = translated_voice_format(wcountry_info_keys_test.enter, countryname)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.in_city(),wcountry_info_keys_test.in_town,country.given_in_miles(),0)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.out_of_city(),wcountry_info_keys_test.country,country.given_in_miles(),0)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.expressway(),wcountry_info_keys_test.expressway,country.given_in_miles(),0)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.motorway(),wcountry_info_keys_test.motorway,country.given_in_miles(),0)
	return countryInfotts
end
 
sc_wCountryInfoGetSpeedLimit = function(invalue, translatedtext, inmiles, full)
	local value = inmiles and (invalue * EUnits.MileToKm):toInt() or invalue
	local limitphrasepart = full == 2 and 2 or (MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() and 2 or 0)
	local limitunitphrase = full == 2 and L"" or (MODEL.lua.wCorrectionSpeedUnit() and sc_wCorrectionSpeedUnitSupported() and sc_wtranslateunit(MODEL.other.format_speed(value, MODEL.regional.units(), 1, 1), wspeed_units) or L"")
	return (value == 0 and L"" or (L" " .. translated_voice_format(translatedtext, sc_wTransform_numbers2text(MODEL.other.format_speed(value, MODEL.regional.units(), 1, limitphrasepart), limitphrasepart) .. limitunitphrase)))
end
 
local wcountry_info_keys = {enter = m_i18n_voice("%s. Limits."), in_town = m_i18n_voice("Within towns, %s."), country = m_i18n_voice("Countryside, %s."), expressway = m_i18n_voice("Expressway, %s."), motorway = m_i18n_voice("Motorway, %s."), code = m_i18n_voice("Phone country code, %s."), emergency = m_i18n_voice("Emergency number, %s."), alcohol = m_i18n_voice("Maximum Blood Alcohol Content: %s permille."), vest = m_i18n_voice("Visibility vest required."), exting = m_i18n_voice("Fire extinguisher required."), light = m_i18n_voice("Headlights must be on at all times."), sparebulb = m_i18n_voice("Spare bulbs required."), first_aid_kit = m_i18n_voice("First aid kit required."), triangle = m_i18n_voice("Warning triangle required."), helmet = m_i18n_voice("Helmets required for motorcyclists."), chains_mandatory = m_i18n_voice("Snow chains required in winter."), chains_recommended = m_i18n_voice("Snow chains recommended in winter."), tyres_mandatory = m_i18n_voice("Winter tyres required in winter."), tyres_recommended = m_i18n_voice("Winter tyres recommended in winter.")}
sc_wReadOutCountryInfoFullSupported = function()
	local res = MODEL.regional.current_voice.is_tts()
	if not res then
		return res
	end
	for _,v in pairs(wcountry_info_keys) do
		res = MODEL_regional_is_it_voice_localizable(v)
		if not res then
			break
		end
	end
	return res
end
 
sc_wLMFCountryInfoPlay_onrelease = function()
	MODEL.other.country_info.select_country_by_pos(MODEL.navigation.car.position())
	local countryindex = MODEL.other.country_info.list.index()
	sc_close_local_menu()
	if countryindex == nil then
		return
	end
	local country = MODEL.other.country_info.list[countryindex]
	local countryname = translate_voice(country.name())
	if countryname == towstring(country.name()) then
		countryname = country.name()
	end
	local countryInfotts = translated_voice_format(wcountry_info_keys.enter, countryname)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.in_city(),wcountry_info_keys.in_town,country.given_in_miles(),2)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.out_of_city(),wcountry_info_keys.country,country.given_in_miles(),2)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.expressway(),wcountry_info_keys.expressway,country.given_in_miles(),2)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetSpeedLimit(country.motorway(),wcountry_info_keys.motorway,country.given_in_miles(),2)
	countryInfotts = countryInfotts .. (country.country_code() ~= L"" and (L" " .. translated_voice_format(wcountry_info_keys.code, sc_wTransform_numbers2text(towstring(country.country_code()), true, true))) or L"")
	countryInfotts = countryInfotts .. (country.emergency_number() ~= L"" and (L" " .. translated_voice_format(wcountry_info_keys.emergency, sc_wTransform_numbers2text(towstring(country.emergency_number()), true, true))) or L"")
	countryInfotts = countryInfotts .. (country.alcohol() ~= L"" and (L" " .. translated_voice_format(wcountry_info_keys.alcohol, towstring(country.alcohol()))) or L"")
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.vest(), wcountry_info_keys.vest)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.exting(), wcountry_info_keys.exting)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.light(), wcountry_info_keys.light)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.sparebulb(), wcountry_info_keys.sparebulb)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.first_aid_kit(), wcountry_info_keys.first_aid_kit)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.warning_triangle(), wcountry_info_keys.triangle)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.motorcycle_helmet(), wcountry_info_keys.helmet)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.snow_chains_mandatory(), wcountry_info_keys.chains_mandatory)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.snow_chains_recommended(), wcountry_info_keys.chains_recommended)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.winter_tyres_mandatory(), wcountry_info_keys.tyres_mandatory)
	countryInfotts = countryInfotts .. sc_wCountryInfoGetTrafficLaw(country.winter_tyres_recommended(), wcountry_info_keys.tyres_recommended)
	sc_wsayspeech(countryInfotts,21,25)
end
 
sc_wCountryInfoGetTrafficLaw = function(enabled, text)
	return enabled and (L" " .. text) or L""
end
 
sc_wReadOutDestinationInfoSupported = function()
	return (type(VOICE.eta) == "function" or MODEL_regional_is_it_voice_localizable(m_i18n_voice("Arrival to destination at %s."))) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Distance %s.")) and MODEL.regional.current_voice.is_tts()
end
 
sc_wReadOutDestinationInfo_test = function()
	sc_wsayspeech_test(sc_wReadOutDestinationInfo_GetTimeText(MODEL.gps.current_time()) .. translated_voice_format(m_i18n_voice("Distance %s."), sc_wVoiceFormat_search_distance(1500)))
end
 
sc_wReadOutDestinationInfo = function()
	if MODEL.lua.wDestinationInfoTTS() and sc_wReadOutDestinationInfoSupported() then
		local distance = MODEL.navigation.distance_to_destination()
		sc_wsayspeech(sc_wReadOutDestinationInfo_GetTimeText(MODEL.navigation.eta_at_destination()) .. translated_voice_format(m_i18n_voice("Distance %s."), sc_wVoiceFormat_search_distance(distance)),21,25)
	end
end
 
sc_wReadOutDestinationInfo_GetTimeText = function(etatime)
	if type(VOICE.eta) == "function" then
		return sc_wReadOutDestinationInfo_FormatTime(etatime)
	else
		return translated_voice_format(m_i18n_voice("Arrival to destination at %s."),builtin.format(L"%{time[%T]}",etatime)..builtin.format(L"%{time[%P]}",etatime))
	end
end
 
sc_wReadOutDestinationInfo_FormatTime = function(time)
	return VOICE.eta(time)
end
 
sc_wReadOutTunnelSupported = function()
	return MODEL_regional_is_it_voice_localizable(m_i18n_voice("Tunnel length %s")) and MODEL.regional.current_voice.is_tts()
end
 
sc_wReadOutTunnel_test = function()
	sc_wsayspeech_test(translated_voice_format(m_i18n_voice("Tunnel length %s"), sc_wVoiceFormat_search_distance(1500)))
end
 
sc_wReadOutTunnel = function()
	if MODEL.lua.wTunnelTTS() and sc_wReadOutTunnelSupported() and MODEL.navigation.remaining_tunnel_length.valid() and MODEL.navigation.remaining_tunnel_length() > 50 then
		local distance = MODEL.navigation.remaining_tunnel_length()
		sc_wsayspeech(translated_voice_format(m_i18n_voice("Tunnel length %s"), sc_wVoiceFormat_search_distance(distance)),21,25)
	end
end
 
sc_wReadOutDASupported = function()
	local res = MODEL.regional.current_voice.is_tts() and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Soon")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("and"))
	if not res then
		MODEL.lua.wReadOutDASupported = res
		return
	end
	for item in ModelList_iter(MODEL.ui.list_wDATypes.unfiltered_list) do
		if not MODEL_regional_is_it_voice_localizable(item.text()) then
			res = false
			break
		end
	end
	MODEL.lua.wReadOutDASupported = res
end
 
sc_wReadOutSCSupported = function()
	local res = MODEL_regional_is_it_voice_localizable(m_i18n_voice("After %s")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Limit %s")) and MODEL.regional.current_voice.is_tts()
	if not res then
		MODEL.lua.wReadOutSCSupported = res
		return
	end
	for item in ModelList_iter(MODEL.ui.wCameraSettingName.unfiltered_list) do
		if not MODEL_regional_is_it_voice_localizable(item.tts()) then
			res = false
			break
		end
	end
	MODEL.lua.wReadOutSCSupported = res
end
 
sc_wReadOutTurnRestSupported = function()
	local res = MODEL.regional.current_voice.is_tts()
	for item in ModelList_iter(MODEL.ui.list_wTurnRestTypes) do
		if not MODEL_regional_is_it_voice_localizable(item.text()) then
			res = false
			break
		end
	end
	return res
end

sc_ReadOutStartExitSupported = function()
	return MODEL_regional_is_it_voice_localizable(m_i18n_voice("Welcome!")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Bye!")) and MODEL.regional.current_voice.is_tts()
end
 
sc_wReadOutPowerSupported = function()
	return MODEL_regional_is_it_voice_localizable(m_i18n_voice("External power disconnected.")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("External power connected.")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Battery level is low.")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Battery level is critically low.")) and MODEL.regional.current_voice.is_tts()
end
 
sc_wturnrest_change_start = function()
	wTurnRestSayDelayed = doDelayed(1, function() sc_wsay_aboutturnrestriction(true) end)
end
 
sc_wturnrest_change_stop = function()
	if wTurnRestSayDelayed ~= -1 then
		killDelayed(wTurnRestSayDelayed)
		wTurnRestSayDelayed = -1
	end
	obs_wturnrest_change:STOP()
end
 
sc_wsay_aboutturnrestriction = function(fromstart)
	local isVisible = var.new()
	ui_EasyNav_NextMan:ISVISIBLE(isVisible)
	if ((MODEL.lua.wTurnRestriction() == 1 and not MODEL.navigation.has_route()) or MODEL.lua.wTurnRestriction() == 2) and isVisible and not (MODEL.lua.ptp_navigation() and MODEL.route.list.navigated.off_road()) and MODEL.navigation.turn_restriction_icon.valid() then
		sc_wsayspeech(translate_voice(MODEL.ui.list_wTurnRestTypes[MODEL.navigation.turn_restriction_icon()].text()),15,18)
	end
	if MODEL.navigation.turn_restriction_icon.valid() and fromstart then
		obs_wturnrest_change:START("NO_TRIGGER")
	end
end
 
sc_SettingWarningsTurnRestTest = function()
	sc_wsayspeech_test(translate_voice(MODEL["*"].text()))
end
 
sc_wTurnRestSettingTTS_OnRelease = function()
	sc_NextStateAnim(st_wTurnRestSettingTTS, "horz_scroll", 1, "")
end
 
createState("st_wTurnRestSettingTTS")
st_wTurnRestSettingTTS:useLayers(backgroundLayers, "ui_wTurnRestSettingTTS")
st_wTurnRestSettingTTS.init = function()
	txtTitle.TEXT = m_i18n("Turn Restrictions TTS Pro Test")
end
 
local st_SettingRegionalVoice_done_orig = st_SettingRegionalVoice.done
st_SettingRegionalVoice.done = function()
	st_SettingRegionalVoice_done_orig()
	sc_wReadOutDASupported()
	local readout = MODEL.lua.wReadOutSCSupported()
	sc_wReadOutSCSupported()
	if readout ~= MODEL.lua.wReadOutSCSupported() then 
		sc_wSCApproachSet()
	end
end
 
sc_wReadOutStartInfo = function()
	if sc_ReadOutStartExitSupported() and MODEL.lua.wStartExitTTSStart() then
		sc_wsayspeech(translate_voice("Welcome!"),21,25)
	else
		sc_wplaysound(1, MODEL.lua.wStartSoundName(), MODEL.lua.wStartExitVolume())
	end
end
 
sc_wPromptCancel = function(say_id)
	if _G[say_id] > 0 then
		PromptCancel(_G[say_id])
		_G[say_id] = 0
	end
end
 
--local_menu.lua
 
sc_Show_Calculator = function()
	sc_NextStateAnim(st_Calculator, "fade", 1, "")
end

sc_FindFirstNotUsedItemInFullList = function()
	for item,index in ModelList_iter(MODEL.ui.fullMapLocalMenuList) do
		local used = false
		for i = 0, 7 do
			local itemIdx = PERSISTENT.w_111savedMapLocalMenu[i]()
			if itemIdx == item.id() then
				used = true
			end
		end
		if not used then
			return index
		end
	end
end
 
sc_BuildMapLocalMenu = function()
	local menuItems = {}
	for i = 0, 7 do
		local itemIdx = sc_FindItemInFullList(PERSISTENT.w_111savedMapLocalMenu[i]())
		MODEL.ui.fullMapLocalMenuList[itemIdx].is_in_menu = true
		MODEL.ui.fullMapLocalMenuList[itemIdx].menu_index = i
		PERSISTENT.w_111savedMapLocalMenu[i] = MODEL.ui.fullMapLocalMenuList[itemIdx].id()
	end
end
 
sc_ReplaceSelectedMapLocalMenuItem = function(itemId)
	local oldId = PERSISTENT.w_111savedMapLocalMenu[vMapMenuButtonAct]()
	local oldItemIdx = sc_FindItemInFullList(oldId)
	local newItemIdx = sc_FindItemInFullList(itemId)
	if MODEL.ui.fullMapLocalMenuList[newItemIdx].is_in_menu() then
		if itemId == oldId then
			return 
		end
		local newItemIdxForSwap = MODEL.ui.fullMapLocalMenuList[newItemIdx].menu_index()
		MODEL.ui.fullMapLocalMenuList[oldItemIdx].menu_index = MODEL.ui.fullMapLocalMenuList[newItemIdx].menu_index()
		MODEL.ui.fullMapLocalMenuList[newItemIdx].menu_index = vMapMenuButtonAct
		PERSISTENT.w_111savedMapLocalMenu[vMapMenuButtonAct] = itemId
		PERSISTENT.w_111savedMapLocalMenu[newItemIdxForSwap] = oldId
	else
		MODEL.ui.fullMapLocalMenuList[oldItemIdx].is_in_menu = false
		MODEL.ui.fullMapLocalMenuList[oldItemIdx].menu_index = 100
		MODEL.ui.fullMapLocalMenuList[newItemIdx].is_in_menu = true
		MODEL.ui.fullMapLocalMenuList[newItemIdx].menu_index = vMapMenuButtonAct
		PERSISTENT.w_111savedMapLocalMenu[vMapMenuButtonAct] = itemId
	end
end
 
sc_MapSettings_RightMenu = function()
	sc_NextStateAnim(st_wCustomizeCockpitMenu, "fade", 1, "")
end
 
createState("st_wCustomizeCockpitMenu")
st_wCustomizeCockpitMenu:useLayers(primary, "ui_Footer_onmap", "ui_wCustomizeCockpitMenu", uieffect)
 
sc_SM_AddCam_onlongclick = function()
	sc_NextStateAnim(st_SMAddCamSetting, "fade", 1, "")
end

sc_OpenMapLocalMenu_onlongclick = function()
	sc_NextStateAnim(st_CustomizeQuickMenu, "fade", 1, "")
end
 
sc_Quick_mute = function()
	MODEL.sound.os_muted = not MODEL.sound.os_muted()
end
 
sc_Quick_mute_onlongclick = function()
	sc_NextStateAnim(st_VolumeSetting, "fade", 1, "")
end
 
sc_Quick_record_onlongclick = function()
	sc_NextStateAnim(st_tracklog, "fade", 1, "")
end
 
sc_wFindFirstNotUsedItemInCockpitList = function()
	for item,index in ModelList_iter(MODEL.ui.fullCockpitMenuList) do
		local used = false
		for i = 0, 3 do
			local itemIdx = PERSISTENT.w_savedCockpitMenu133[i]()
			if itemIdx == item.id() then
				used = true
			end
		end
		if not used then
			return index
		end
	end
end
 
sc_wFindItemInCockpitList = function(itemId)
	for item, index in ModelList_iter(MODEL.ui.fullCockpitMenuList) do
		if item.id() == itemId then
			return index
		end
	end
	return sc_wFindFirstNotUsedItemInCockpitList()
end
 
sc_wBuildCockpitMenu = function()
	local itemIdx = 0
	for i = 0, 3 do
		itemIdx = sc_wFindItemInCockpitList(PERSISTENT.w_savedCockpitMenu133[i]())
		MODEL.ui.fullCockpitMenuList[itemIdx].cockpitvisible = PERSISTENT.w_visibleCockpitMenu133[i]()
		MODEL.ui.fullCockpitMenuList[itemIdx].is_in_menu = true
		MODEL.ui.fullCockpitMenuList[itemIdx].menu_index = i
		PERSISTENT.w_savedCockpitMenu133[i] = MODEL.ui.fullCockpitMenuList[itemIdx].id()
	end
end
 
createState("st_wCockpitMenuReplaceList")
st_wCockpitMenuReplaceList:useLayers(backgroundLayers, "ui_List_Background", "ui_wCockpitMenuReplaceList")
st_wCockpitMenuReplaceList.init = function()
	txtTitle.TEXT = m_i18n("Select a Shortcut")
	ui.fullCockpitMenuList:sort("uniq_id")
end
 
st_wCockpitMenuReplaceList.exit = function()
	ui.fullCockpitMenuList:sort("menu_index")
end
 
sc_wReplaceSelectedCockpitMenuItem = function(itemId)
	local oldId = PERSISTENT.w_savedCockpitMenu133[vMapMenuButtonAct]()
	local oldItemIdx = sc_wFindItemInCockpitList(oldId)
	local newItemIdx = sc_wFindItemInCockpitList(itemId)
	if MODEL.ui.fullCockpitMenuList[newItemIdx].is_in_menu() then
		if itemId == oldId then
			return 
		end
		local newItemIdxForSwap = MODEL.ui.fullCockpitMenuList[newItemIdx].menu_index()
		MODEL.ui.fullCockpitMenuList[oldItemIdx].menu_index = MODEL.ui.fullCockpitMenuList[newItemIdx].menu_index()
		MODEL.ui.fullCockpitMenuList[newItemIdx].menu_index = vMapMenuButtonAct
		MODEL.ui.fullCockpitMenuList[oldItemIdx].cockpitvisible = PERSISTENT.w_visibleCockpitMenu133[newItemIdxForSwap]()
		MODEL.ui.fullCockpitMenuList[newItemIdx].cockpitvisible = PERSISTENT.w_visibleCockpitMenu133[vMapMenuButtonAct]()
		PERSISTENT.w_savedCockpitMenu133[vMapMenuButtonAct] = itemId
		PERSISTENT.w_savedCockpitMenu133[newItemIdxForSwap] = oldId
	else
		MODEL.ui.fullCockpitMenuList[oldItemIdx].is_in_menu = false
		MODEL.ui.fullCockpitMenuList[oldItemIdx].menu_index = 100
		MODEL.ui.fullCockpitMenuList[oldItemIdx].cockpitvisible = true
		MODEL.ui.fullCockpitMenuList[newItemIdx].is_in_menu = true
		MODEL.ui.fullCockpitMenuList[newItemIdx].menu_index = vMapMenuButtonAct
		MODEL.ui.fullCockpitMenuList[newItemIdx].cockpitvisible = PERSISTENT.w_visibleCockpitMenu133[vMapMenuButtonAct]()
		PERSISTENT.w_savedCockpitMenu133[vMapMenuButtonAct] = itemId
	end
end
 
sc_wChangeVisibleMenuItem = function(index)
	PERSISTENT.w_visibleCockpitMenu133[index] = not PERSISTENT.w_visibleCockpitMenu133[index]()
	MODEL.ui.fullCockpitMenuList.quick_list[index].cockpitvisible = PERSISTENT.w_visibleCockpitMenu133[index]()
end
 
sc_wOpenCockpitMenuItem = function(index)
	if vActiveState() == "st_easynav" then
		sc_NaviMenuAlphaRestore()
		if MODEL.lua.wCockpitMenuTTS() and MODEL["*"].tts_enabled() then
			sc_wsayspeech(translate_voice(MODEL["*"].text()),5,5)
		end
		MODEL["*"].onrelease()()
	else
		vMapMenuButtonAct = index
		sc_NextStateAnim(st_wCockpitMenuReplaceList, "horz_scroll", 1, "")
	end
end
 
sc_wOpenLongCockpitMenuItem = function()
	sc_NaviMenuAlphaRestore()
	MODEL["*"].onlongclick()()
end
 
local sc_OpenMapLocalMenuItem_orig = sc_OpenMapLocalMenuItem
sc_OpenMapLocalMenuItem = function()
	sc_OpenMapLocalMenuItem_orig()
	if MODEL.lua.wCockpitMenuTTS() and MODEL["*"].uniq_id() ~= 26 and MODEL["*"].uniq_id() ~= 34 then
		sc_wsayspeech(translate_voice(MODEL["*"].text()),5,5)
	end
end
 
sc_OpenMapLocalMenuItem_onlongclick = function()
	sc_CloseMapLocalMenu(true)
	MODEL["*"].onlongclick()()
end
 
--multisearch
local multipriority = ";" .. sc_GetSysEntry("address.multi", "search_priority", "") .. ";"
multipriority = string.gsub(multipriority, " ", "")
local wMulti_SearchSetup = {Center = qWord_0, Country  = L"", CityID = qWord_0}
local wMulti_CategoryNames = {"poi", "poi_container", "kmlpoi", "favourites", "gls", "history", "street", "junction", "location"}
local wmultisearch = MODEL.address.multi
wMulti_CategoryTypes = {Poi = 0, Container = 1, Kml = 2, Favorite = 3, Google = 4, History = 5, Address = 6, Junction = 7, Mixed = 8, All = 9}
wMultiSettingsGoogleNotStarted = true
local wmultisearch_cats = MODEL.ui.lm_wMultiCategories.unfiltered_list

sc_wMultiTypeEnabled = function(type)
	type = ";" .. type .. ";"
	return string.find(multipriority, type, 1, true) ~= nil
end

wMultiLocationEnabled = sc_wMultiTypeEnabled("location")
wMultiGoogleEnabled = sc_wMultiTypeEnabled("gls")
wMultiAllowEmptyCategories = sc_GetSysEntry("address.multi", "allow_empty_categories", 0)

sc_wMultiTypesFill = function()
	local index_correct = 1
	MODEL.lua.wMultiSearchCategory_junction = false
	MODEL.ui.lm_wMultiCategories.resize(9)
	for k,v in pairs(wMulti_CategoryNames) do
		wmultisearch_cats[k-index_correct].name = v
		wmultisearch_cats[k-index_correct].on = MODEL.lua["wMultiSearchCategory_" .. v]()
		wmultisearch_cats[k-index_correct].enabled = sc_wMultiTypeEnabled(v)
		wmultisearch_cats[k-index_correct].visible = v ~= "gls" and v ~= "junction"
		if v == "gls" and not wMultiGoogleEnabled then
			index_correct = 2
		end
		if v == "street" then
			MODEL.lua["wMultiSearchCategory_" .. v .. "_enabled"] = MODEL.lua["wMultiSearchCategory_" .. v]() and sc_wMultiTypeEnabled(v)
		end
	end
	if not wMultiGoogleEnabled then
		wmultisearch_cats[wmultisearch_cats.lastindex()].name = "gls"
		wmultisearch_cats[wmultisearch_cats.lastindex()].on = MODEL.lua["wMultiSearchCategory_gls"]()
		wmultisearch_cats[wmultisearch_cats.lastindex()].enabled = true
		wmultisearch_cats[wmultisearch_cats.lastindex()].visible = false
	end
end

sc_wMultiTypesFill()

sc_wMultiSettingsOnRelease = function()
	sc_NextStateAnim(st_wMultiSettings, "horz_scroll", 1, "")
end

createState("st_wMultiSettings")
st_wMultiSettings:useLayers(backgroundLayers, "ui_wMultiSettings")
st_wMultiSettings.init = function()
	txtTitle.TEXT = m_i18n("Multi-search settings")
end

st_wMultiSettings.exit = function()
	for item in ModelList_iter(MODEL.ui.lm_wMultiCategories) do
		MODEL.lua["wMultiSearchCategory_" .. item.name()] = item.on()
	end
end

sc_et_wMultiSettings = function()
	local current = MODEL["*"]
	current.on = not current.on()
	if current.name() == "street" then
		MODEL.lua["wMultiSearchCategory_" .. current.name() .. "_enabled"] = current.on()
	end
end

sc_et_wMultiSettings_GetIcon = function(name)
	for k,v in pairs(wMulti_CategoryNames) do
		if v == name then
			return (k-1)
		end
	end
end

sc_et_wMultiSettings_GetTooltip = function()
	local name= MODEL["*"].name()
	local enabled = MODEL["*"].enabled()
	local text = enabled and "The category %s is disabled. This category don't work if the category %s is turned on." or "The category %s isn't activated. For activation of this category the parameter search_priority(sys.txt, section [address.multi]) should contain record %s. Completely filled parameter is(the search priority depends on an order of categories):"
	MODEL.lua.wMultiSettings_HintText = enabled and translated_format(m_i18n(text), translate(m_i18n("MULTISEARCH_CATEGORY~" .. name)), translate(m_i18n("MULTISEARCH_CATEGORY~street"))) or translated_format(m_i18n(text), translate(m_i18n("MULTISEARCH_CATEGORY~" .. name)), towstring(name))
	if enabled then
		MODEL.screen.msgbox.new.setup(1)
		MODEL.screen.msgbox.new.set_line_wstr(1, MODEL.lua.wMultiSettings_HintText())
		MODEL.screen.msgbox.new.setup_button(1, "")
		MODEL.screen.msgbox.create_new()
	else
		ui_wMultiSettings_Hint:SHOW()
	end
end

sc_wMultiSettingsGoogleStarted = function()
	for item in ModelList_iter(wmultisearch_cats) do
		if item.name() == "gls" then
			item.visible = true
			break
		end
	end
	wMultiSettingsGoogleNotStarted = false
end

sc_wMultiOnRelease = function()
	sc_NextStateAnim(st_wMultiFind, "fade", 0, "")
	sc_ShowMapUpdateNotification()
	sc_wCheckKMLIsLogicalProvider(false)
end

sc_wMultiOnChangeCategory = function()
	sc_wMultiSetStartCategory(wmultisearch.category_filter())
end

sc_wMultiSetStartCategory = function(type)
	local ind = -1
	if type == nil then
		type = wMulti_CategoryTypes.All
	end
	for item,index in ModelList_iter(wmultisearch.category_list) do
		if item.type() == type then
			ind = index
			break
		end
	end
	wmultisearch.category_list.setcurrent(ind)
end

sc_wMultiInitSearchBase = function(pos)
	wmultisearch.do_spellcheck = true
	MODEL.map.cursor.position = pos
	wMulti_SearchSetup.Center = MODEL.map.cursor.position()
	wmultisearch.center_for_distance_ordering = wMulti_SearchSetup.Center
	wmultisearch.distance = MODEL.lua.wMultiSearchDistance()
	if MODEL.address.search.support_streetsearch_in_state(MODEL.map.cursor.address.state():sub(2, 4)) then
		wmultisearch.country_code = MODEL.map.cursor.address.state():sub(2, 4)
		wMulti_SearchSetup.CityID = qWord_0
		MODEL.my.map.select_country(wmultisearch.country_code())
		MODEL.lua.wMultiCenterName = MODEL.address.search.get_country_and_state_text(wmultisearch.country_code())
		MODEL.lua.wMultiCenterDescription = L""
	else
		wmultisearch.country_code = ""
		wMulti_SearchSetup.CityID = MODEL.map.cursor.city_id()
		MODEL.my.map.select_cos(wMulti_SearchSetup.CityID)
		local name, desc = MODEL.address.search.get_city_text(wMulti_SearchSetup.CityID)
		MODEL.lua.wMultiCenterName = name
		MODEL.lua.wMultiCenterDescription = desc 
	end
	wmultisearch.baseposition = wMulti_SearchSetup.Center
	wmultisearch.city_id = wMulti_SearchSetup.CityID 
	wmultisearch.drop_result()
	wmultisearch.suggest_keywords(0, L"")
	wmultisearch.result_filtering = false
	wmultisearch.category_list.setcurrent(-1)
end

sc_wMultiShowKeyboard = function()
	wmultisearch.result_filtering = false
	MODEL.regional.keyboard.load_panel_by_type(EInputPanelType.Alpha, false)
	MODEL.regional.keyboard.load_panel_by_name(PERSISTENT.keyboard_panel_alpha())
	sc_init_local_menu("ui.lm_keyboardPanels", nil, "IME")
	sc_SetEnabledKeyboardPanels()
end

createState("st_wMultiFind")
st_wMultiFind:useLayers(backgroundLayers, "ui_wMultiFind", localMenuLayers)
st_wMultiFind.enter = function()
	btn_wMultiCityCenter.TEXT = m_i18n("City Center")
	inp_wMultiFind.value = L""
	sc_wMultiInitSearchBase(MODEL.navigation.car.position())
	MODEL.lua.wMultiSortBy = "distance"
	MODEL.other.force_init_finish("poi")
	if wMultiSettingsGoogleNotStarted and MODEL.lua.featured_provider_id() ~= -1 then
		sc_wMultiSettingsGoogleStarted()
	end
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = wMultiGoogleEnabled
end

st_wMultiFind.init = function()
	AddressSearchState.mode	= AddressSearchMode.address
	txtTitle.TEXT = m_i18n("Multi-search")
	sc_wMultiShowKeyboard()
	for item in ModelList_iter(wmultisearch_cats) do
		wmultisearch["find_" .. item.name()] = item.on() and item.enabled() and item.visible() and not (item.name() == "location" and MODEL.lua.wMultiSearchCategory_street_enabled())
	end
	wmultisearch.enable_mixed_category = true
	wmultisearch.exact_parse = 2
	local poisetup = wmultisearch.poi_query()
	poisetup.area = MODEL.lua.wOtherSearchAroundArea()
	poisetup.center = "fixed"
	poisetup.position = wmultisearch.baseposition()
	wmultisearch.custom_favourites_query = true
	poisetup = wmultisearch.favourites_query()
	poisetup.area = -1
	poisetup.center = "fixed"
	poisetup.position = wmultisearch.baseposition()
	KEY("RETURN", sc_wMultiShowResultList)
	ui.vKeyTableDone = sc_wMultiShowResultList
	MODEL.lua.easyShowDoneKey = false
	wmultisearch.category_filter = wMulti_CategoryTypes.All
	wmultisearch.do_filter()
	wmultisearch.sort_filtered(MODEL.lua.wMultiSortBy())
	MODEL.lua.keyb_result_count_model = "address.multi.filtered_list.size"
	inputFieldRequired = true
	inputFieldRequired_space = true
	sc_INP_onchange(0, ui.inp_wMultiFind.value)
end

st_wMultiFind.done = function()
	KEY("RETURN")
	MODEL.lua.keyb_result_count_model = ""
end

st_wMultiFind.exit = function()
	killDelayed(MODEL.lua.wMultiSearchDelayID())
	MODEL.lua.wMultiSearchDelayID = -1
	wmultisearch.cancel_search()
	wmultisearch.drop_result()
	MODEL.poi.wmulti_search.drop_result()
	sc_wCheckKMLIsLogicalProvider(true)
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = false
end

sc_wMultiFindResult = function()
	local value = ui.inp_wMultiFind.VALUE()
	wmultisearch.cancel_search()
	if MODEL.lua.wMultiSearchDelayID() ~= -1 then
		killDelayed(MODEL.lua.wMultiSearchDelayID())
		MODEL.lua.wMultiSearchDelayID = -1
	end
	if wstring.len(value) >= 1 then
		wmultisearch.predefined_category_order = " "
		MODEL.lua.wMultiSearchDelayID = doDelayed(50*MODEL.lua.wMultiSearchDelay(), sc_wMultiFindResult_Delayed )
	else
		wmultisearch.name_filter = value
	end
	wmultisearch.suggest_keywords(0, value)
end

sc_wMultiFindResult_Delayed = function()
	MODEL.lua.wMultiSearchDelayID = -1
	local value = ui.inp_wMultiFind.VALUE()
	wMulti_SearchSetup.Center = wmultisearch.baseposition()
	wMulti_SearchSetup.Country = wmultisearch.country_code()
	wMulti_SearchSetup.CityID = wmultisearch.city_id()
	wmultisearch.center_for_distance_ordering = wMulti_SearchSetup.Center
	wmultisearch.separate_corrected = true
	wmultisearch.name_filter = value
	wmultisearch.set_exclusive_query(-1)
	wmultisearch.sort("setting")
	wmultisearch.distance = MODEL.lua.wMultiSearchDistance()
	wmultisearch.execute()
end

sc_wMultiShowResultList = function()
	if MODEL.lua.wMultiSearchDelayID() ~= -1 then
		killDelayed(MODEL.lua.wMultiSearchDelayID())
		sc_wMultiFindResult_Delayed()
	end
	sc_NextStateAnim(st_wMultiFind_Result, "horz_scroll", 1, "")
end

createState("st_wMultiFind_Result")
st_wMultiFind_Result:useLayers(backgroundLayers, "ui_wMultiFind_Result", "ui_wMultiFind_Result_Category", "ui_wMultiFind_Result_Poi_Providers", "ui_List_Background", localMenuLayers)
st_wMultiFind_Result.enter = function()
	sc_wMultiSetStartCategory()
	MODEL.lua.wMultiResultListType = ""
end

st_wMultiFind_Result.init = function()
	txtTitle.TEXT = m_i18n("Search Results")
	sc_init_local_menu("ui.lm_wmulti_localmenu", nil, "Sort")
	g_OnPoiListItemClicked = sc_FlatSearch_OnPoiItemClicked
	wmultisearch.resume_search()
end

st_wMultiFind_Result.exit = function()
	Back:unregister(sc_wMultiBackFromPOIResult)
end

sc_wMultiFilterCategoryList = function()
	local item = MODEL["*"]
	local type = item.type()
	item._list.setcurrent(index)
	wmultisearch.result_filtering = true
	wmultisearch.category_filter = item.id()
	wmultisearch.do_filter()
	wmultisearch.sort_filtered(MODEL.lua.wMultiSortBy())
	MODEL.lua.wMultiResultListType = item.original_name() == "POI Container" and "POI_Container_Result" or ""
	wmultisearch.sort_filtered(MODEL.lua.wMultiSortBy())
	wmultisearch.set_exclusive_query(type)
	MODEL.ui.lst_wMultiResultList.scroll_pos = 0
	if item.original_name() == "POI" and MODEL.lua.PoiProviderFiltering() then
		gLastProviderID = gROPoi_Provider
		MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
		uieffect:GRAB()
		MODEL.lua.wMultiResultListType = "ProviderFilter_All"
		Back:register(sc_wMultiBackFromPOIResult)
		if MODEL.interface.uieffect_enabled() and MODEL.interface.default_anim_off() then
			uieffect:DO_ANIM( "horz_scroll", 1, "" )
		end
	end
end

sc_wMultiFilterCategoryList_NetLocalSearch = function()
	wmultisearch.category_list.setcurrent(-1)
	wmultisearch.category_filter = wMulti_CategoryTypes.Google
	MODEL.lua.wMultiResultListType = "NetLocalSearch"
	local flat_search = MODEL.poi.wmulti_search
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = true
	flat_search.clear_providers()
	flat_search.search_root = 0
	flat_search.name_filter = wmultisearch.name_filter()
	flat_search.exclude_provider = true
	flat_search.non_idle = false
	flat_search.add_provider(gROPoi_Provider)
	flat_search.add_provider(MODEL.poi.find_provider("kmlpoi"))
	flat_search.add_provider(gUserPOI_Provider)
	flat_search.center = "fixed"
	flat_search.position = wMulti_SearchSetup.Center
	flat_search.no_sort()
	flat_search.execute()
	obs_wmulti_google_ready:START()
end

sc_wMultiNetLocalSearchReady = function()
	obs_wmulti_google_ready:STOP()
	local response = MODEL.poi.providers[MODEL.lua.featured_provider_id()].last_response_status()
	if response ~= 0 and response ~= 6 and response ~= 200 then
		local newMsgBox = MODEL.screen.msgbox.new
		newMsgBox.setup(1)
		newMsgBox.set_line(1, m_i18n("Cannot connect to server!"))
		newMsgBox.setup_button(1, "")
		MODEL.screen.msgbox.create_new()
	end
end

sc_wMultiResultSortBy = function(sort)
	sc_close_local_menu()
	MODEL.lua.wMultiSortBy = sort
	if MODEL.lua.wMultiResultListType() == "ProviderFilter" then
		MODEL.poi.wmulti_provider.sort(sort)
	else
		wmultisearch.sort_filtered(sort)
	end
	MODEL.ui.lst_wMultiResultList.scroll_pos = 0
end

sc_wMultiSelect_Item = function()
	wmultisearch.pause_search()
	local item = MODEL["*"]
	local type = item.type()
	if type == "Street" then
		if item.subtype() == "City" then
			MODEL.my.map.select_cos(item.city_id())
		elseif item.street_id() ~= "" and item.subtype() ~= "Junction" then
			MODEL.my.map.select_street(item.street_id(), item.address.city(), item.address.street())
		else
			local JunctionStreetID = item.junction_street_id()
			if JunctionStreetID ~= "" then
				MODEL.my.map.select_junction(JunctionStreetID, item.street_id())
			else
				MODEL.my.map.select_address(item.position(), item.address.city(), item.address.street(), item.address.housenum())
			end
			MODEL.my.map.selected_item.name = wstring.gsub(item.override_name(), L"%^", L"")
		end
		sc_wMultiSelect_ItemDone()
	elseif type == "POI" or type == "KMLPOI" or type == "Favourites" or type == "Google" then
		sc_FlatSearch_OnPoiItemClicked(item)
	elseif type == "History" then
		sc_SelectHistoryMain(item.history_index())
	elseif type == "Location" then
		if item.subtype() == "Country" or item.subtype() == "State" then
			MODEL.my.map.select_country(item.country_id())
		elseif item.subtype() == "City" or item.subtype() == "Zip" then
			MODEL.my.map.select_cos(item.city_id())
		end
		sc_wMultiSelect_ItemDone()
	end
end

sc_wMultiSelect_ItemDone = function()
	if wFind_createroute then
		sc_FindOnMap_Select_onrelease()
	else
		sc_routeto_show_route()
	end
end

sc_wMultiSelect_POIContainer = function()
	local flat_search = MODEL.poi.flat_search()
	flat_search.reset()
	flat_search.center = "fixed"
	flat_search.position = wmultisearch.baseposition()
	flat_search.distance_on_route = "default"
	flat_search.calculate_detour = "default"
	flat_search.area = MODEL.lua.wOtherSearchAroundArea()
	flat_search.sort = MODEL.lua.wMultiSortBy()
	flat_search.search_root = MODEL["*"].poicontainer_index()
	flat_search.execute()
	g_OnPoiListItemClicked = sc_FlatSearch_OnPoiItemClicked
	MODEL.lua.PoiSort = MODEL.lua.wMultiSortBy() == "distance" and EPoiSort.Distance or EPoiSort.Name
	sc_NextStateAnim(st_FindPOIFlatList, "horz_scroll", 1, "")
end

sc_wMultiChangeSearchCenter = function()
	if wMultiLocationEnabled then
		sc_NextStateAnim(st_wMultiCenter, "vert_scroll", 1, "")
	else
		wMultiChangeSearchCenter_Edit = true
		AddressSearchState.mode = AddressSearchMode.poi
		sc_FindAddressInitPosition()
		sc_NextStateAnim(st_FindPoiByAddress, "horz_scroll", 1, "")
	end
end

createState("st_wMultiCenter")
st_wMultiCenter:useLayers(backgroundLayers, "ui_wMultiCenter", localMenuLayers)
st_wMultiCenter.enter = function()
	if MODEL.lua.wMultiSearchDelayID() ~= -1 then
		killDelayed(MODEL.lua.wMultiSearchDelayID())
		MODEL.lua.wMultiSearchDelayID = -1
	end
	wmultisearch.cancel_search()
	inp_wMultiFindCenter.value = L""
	if PERSISTENT.wMultiHintCount_Center() < 5 then
		PERSISTENT.wMultiHintCount_Center = PERSISTENT.wMultiHintCount_Center() + 1 
		ui_wMultiCenter_Hint:SHOW()
	end
end

st_wMultiCenter.init = function()
	txtTitle.TEXT = m_i18n("Select Search Area")
	sc_wMultiShowKeyboard()
	sc_wMultiSetupCenterSearch()
	KEY("RETURN", sc_wMultiShowCenterResultList)
	ui.vKeyTableDone = sc_wMultiShowCenterResultList
	MODEL.lua.keyb_result_count_model = "address.multi.list.size"
	inputFieldRequired = true
	inputFieldRequired_space = true
	wmultisearch.category_filter = wMulti_CategoryTypes.All
	sc_INP_onchange(0, ui.inp_wMultiFindCenter.value)
end

sc_wMultiSetupCenterSearch = function()
	for item in ModelList_iter(wmultisearch_cats) do
		wmultisearch["find_" .. item.name()] = false
	end
	wmultisearch.find_location = true
	wmultisearch.enable_mixed_category = false
end

st_wMultiCenter.done = function()
	MODEL.lua.keyb_result_count_model = ""
end

st_wMultiCenter.exit = function()
	wmultisearch.cancel_search()
	wmultisearch.drop_result()
	obs_wmulti_searchcenter_ready:STOP()
end

sc_wMultiSearchCenter = function()
	local value = ui.inp_wMultiFindCenter.VALUE()
	wmultisearch.cancel_search()
	if value:len() == 0 then
		MODEL.ui.lm_wMultiSavedCenterItem[0].name_highlighted = L""
	end
	if wstring.len(value) >= 1 then
		if MODEL.lua.wMultiSearchDelayID() ~= -1 then
			killDelayed(MODEL.lua.wMultiSearchDelayID())
			MODEL.lua.wMultiSearchDelayID = -1
		end
		sc_wMultiSearchCenter_Results()
	else
		wmultisearch.name_filter = value
	end
	wmultisearch.suggest_keywords(1, value)
end

sc_wMultiSearchCenter_Results = function()
	MODEL.lua.wMultiSearchDelayID = -1
	local value = ui.inp_wMultiFindCenter.VALUE()
	wmultisearch.name_filter = value
	wmultisearch.set_exclusive_query(-1)
	wmultisearch.distance = MODEL.lua.wMultiSearchDistance()
	wmultisearch.center_for_distance_ordering = wMulti_SearchSetup.Center
	wmultisearch.execute()
	obs_wmulti_searchcenter_ready:START()
end

sc_wMultiSearchCenterSearchReady = function()
	obs_wmulti_searchcenter_ready:STOP()
	local item = MODEL.ui.lm_wMultiSavedCenterItem[0]
	local item_orig	= wmultisearch.list[0]
	item.name = item_orig.name()
	item.name_highlighted = item_orig.name_highlighted()
	item.description = item_orig.description()
	item.subtype = item_orig.subtype()
	item.country_id = item_orig.country_id()
	item.city_id = item_orig.city_id()
	item.position = item_orig.position()
end

sc_wMultiShowCenterResultList = function()
	sc_NextStateAnim(st_wMultiCenter_Result, "horz_scroll", 1, "")
end

sc_wMultiSelectNewSearchCenter = function()
	wmultisearch.result_filtering = false
	wmultisearch.country_code = ""
	wmultisearch.city_id = qWord_0
	local item = MODEL["*"]
	local subtype = item.subtype()
	if subtype == "Country" or subtype == "State" then
		wmultisearch.country_code = item.country_id()
		MODEL.my.map.select_country(item.country_id())
		wMulti_SearchSetup.CityID = qWord_0
		wMulti_SearchSetup.Center = MODEL.my.map.selected_item.position()
		MODEL.lua.wMultiCenterName = item.name()
		MODEL.lua.wMultiCenterDescription = L""
	elseif subtype == "City" or subtype == "Zip" then
		local CityID = item.city_id()
		MODEL.my.map.select_cos(CityID)
		local name, desc = MODEL.address.search.get_city_text(CityID)
		MODEL.lua.wMultiCenterName = name
		MODEL.lua.wMultiCenterDescription = desc 
		wMulti_SearchSetup.CityID = CityID
		wMulti_SearchSetup.Center = item.position()
		sc_wMultiSetZIPCityID(CityID)
		wmultisearch.center_for_distance_ordering = wMulti_SearchSetup.Center
	else
		ASSERT( false , 'Subtype :' .. subtype)
	end
	if MODEL.lua.wMultiCenterName() == L"" then
		MODEL.lua.wMultiCenterName = item.name()
		MODEL.lua.wMultiCenterDescription = L""
	end
	wmultisearch.baseposition = wMulti_SearchSetup.Center
	wmultisearch.city_id = wMulti_SearchSetup.CityID
	if st_wMultiCenter_Result.isActive then
		uieffect:GRAB()
		CLEARTOSTATE(st_wMultiCenter)
		PREVSTATE()
	else
		sc_PrevStateAnim()
	end
	if ui.inp_wMultiFind.VALUE() then
		sc_wMultiFindResult()
	end
end

sc_wMultiGotoCityCenter = function()
	MODEL.my.map.select_cos(wMulti_SearchSetup.CityID)
	sc_FindAddressDone()
end

sc_wMultiSetZIPCityID = function(CityID)
	local IdType = MODEL.my.map.get_admidx_type(CityID)
	if IdType == 4 then
		wmultisearch.city_id = CityID
	else
		wmultisearch.city_id = qWord_0
	end
end

createState("st_wMultiCenter_Result")
st_wMultiCenter_Result:useLayers(backgroundLayers, "ui_List_Background", "ui_wMultiCenter_Result")
st_wMultiCenter_Result.init = function()
	sc_wMultiSetStartCategory()
	txtTitle.TEXT = m_i18n("Search Results")
end

sc_wMultiSetPoiProviderFilter = function(providerID)
	MODEL["*"]._list.setcurrent(index)
	if gLastProviderID == providerID then
		return
	end
	gLastProviderID = providerID
	MODEL.lua.wMultiResultListType = "ProviderFilter"
	local flat_search = MODEL.poi.wmulti_provider()
	flat_search.reset()
	flat_search.area = wmultisearch.distance()
	flat_search.exclude_provider = false
	flat_search.clear_providers()
	flat_search.add_provider(providerID)
	flat_search.search_root = 0
	if MODEL.address.multi.phone_search() then
		flat_search.phone_filter = wmultisearch.poi_query.phone_filter()
	else
		flat_search.name_filter = wmultisearch.name_filter()
	end
	flat_search.non_idle = false
	flat_search.center = "fixed"
	flat_search.position = wMulti_SearchSetup.Center
	flat_search.sort(MODEL.lua.wMultiSortBy())
	flat_search.execute()
end

sc_wMultiRemovePoiProviderFilter = function()
	MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
	gLastProviderID = gROPoi_Provider
	MODEL.poi.wmulti_provider.drop_result()
	MODEL.lua.wMultiResultListType = "ProviderFilter_All"
end

sc_wMultiBackFromPOIResult = function()
	if (MODEL.lua.wMultiResultListType() == "ProviderFilter_All" or MODEL.lua.wMultiResultListType() == "ProviderFilter") and st_wMultiFind_Result.isActive then
		Back:prevent_default()
		uieffect:GRAB()
		sc_wMultiSetStartCategory()
		wmultisearch.category_filter = wMulti_CategoryTypes.All
		wmultisearch.do_filter()
		wmultisearch.sort_filtered(MODEL.lua.wMultiSortBy())
		MODEL.lua.wMultiResultListType = ""
		if MODEL.interface.uieffect_enabled() and MODEL.interface.default_anim_off() then
			uieffect:DO_ANIM( "horz_scroll", 0, "" )
		end
		Back:unregister(sc_wMultiBackFromPOIResult)
	end
end

local st_FindPoiByAddress_init_orig = st_FindPoiByAddress.init
st_FindPoiByAddress.init = function()
	st_FindPoiByAddress_init_orig()
	if wMultiChangeSearchCenter_Edit then
		txtTitle.TEXT = m_i18n("Select Search Area")	
	end
end
 
st_FindPoiByAddress.exit = function()
	wMultiChangeSearchCenter_Edit = false
end
 
--screensaver.lua
createState("st_wSSSetting")
st_wSSSetting:useLayers(backgroundLayers, "ui_List_Background", "ui_wSSSetting")
 
st_wSSSetting.init = function()
	txtTitle.TEXT = m_i18n("Screen Saver Settings")
end
 
createState("st_ScreenSaver")
st_ScreenSaver:useLayers("ui_PropLayerSS", "ui_NavigateMapSS", "ui_NavigateMapButtonSS", "ui_SpeedCamWarningLayerSS", "ui_EasyNav_RoundaboutIcons", "ui_NavigateMapSSSpeed", "ui_NavigateMapRouteNavigationSS", "ui_NavigateLaneInfoSS", "ui_NavigateMapSingpostSS", "ui_NavigateMapJunctionView", "ui_TunnelOverview", "ui_NavigateMapDriverAlerts", "ui_EasyNav_TripInfoSS", "ui_NavigateMapnight", "ui_NavigateMapSpeedLimitSS", "ui_NavigateMapTruckAlert")
if MODEL.EXISTS.route.allow_env_zone() then
	st_ScreenSaver:useLayers("ui_wUmweltZoneWarningLayer")
end
st_ScreenSaver.init = function()
	MODEL.navigation.junction_view_on = MODEL.lua.wShowJunction_savedSS()
	MODEL.navigation.tunnel_view.enabled = MODEL.lua.wShowTunnelSS()
	MODEL.lua.wLaneInfoHiddenByUser = false
	MODEL.lua.JunctionViewHiddenByUser = false
	ATTACH_LANEINFO(sprLaneInfoSS, "laneinfo.ini")
	ATTACH_LANEINFO(sprLaneInfoSignpostSS, "laneinfo_signpost.ini")
	ui.bLaneInfoSignpostForceRedraw = 1
	local junctionViewType = sc_GetSysEntry("navigation", "junction_view_type", "NNG")
	local junctionViewContentResolution = sc_GetSysEntry("navigation", "junction_view_content_resolution_override", gJunctionViewContentResolution)
	gJunctionViewNeedsSignpost = false
	if junctionViewType == "NNG" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory)
	elseif junctionViewType == "mixed" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory .. ";" .. junctionViewContentResolution)
	elseif junctionViewType == "NNG_NQ" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], "16_9_NQ_Roads")
	elseif junctionViewType == "NQ" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory .. ";" .. junctionViewContentResolution)
	end
	obs_JVValid:START()
	obs_want_junctionview:START()
	obs_want_junctionview:TRIGGER()
	obs_TunnelOverview:START()
	MODEL.lua.wLaneInfoSS = MODEL.lua.wLaneInfo_savedSS()
	if MODEL.lua.wLaneInfoSS() then
		obs_laneinfo:START("NO_TRIGGER")
	end
	MODEL.lua.wShowSignpostSS = MODEL.lua.wShowSignpost_savedSS()
	obs_SignPostValid:START()
	if showDriveCarefully and MODEL.interface.drive_carefully() then
		sc_drive_carefully_init()
	end
	ui.vDAIsVisible = 1
	MODEL.navigation.restrictions_turn_change_handler = sc_TruckTurnRestrictionAlert
	MODEL.lua.wSSFlagSS = MODEL.lua.wSSFlag()
	if MODEL.lua.wAutoSS() then
		obs_wSSFlagSS:START("NO_TRIGGER")
	end
end
 
st_ScreenSaver.done = function()
	obs_laneinfo:STOP()
	obs_want_junctionview:STOP()
	obs_TunnelOverview:STOP()
	ATTACH_TUNNELOVERVIEW()
	MODEL.navigation.want_junctionview = false
	obs_SignPostValid:STOP()
	obs_JVValid:STOP()
	obs_wSSFlagSS:STOP()
	MODEL.navigation.restrictions_turn_change_handler = nil
end

createState("st_TripInfoChangeSS")
st_TripInfoChangeSS:useLayers(backgroundLayers, "ui_List_Background", "ui_TripInfoChangeSS")
st_TripInfoChangeSS.init = function()
	txtTitle.TEXT = m_i18n("Select Data Field")
	lst_TripInfoSS.prop.SUBLAYER.models.scroll_off()
end
sc_GoToTripInfoChangeSS = function(selectedIndex)
	sc_NextStateAnim(st_TripInfoChangeSS, "vert_scroll", 1, "")
	if selectedIndex ~= nil then
		if MODEL.lua.isValidRoute() then
			MODEL.ui.lm_CockpitListSS.has_route.index = selectedIndex
		else
			MODEL.ui.lm_CockpitListSS.no_route.index = selectedIndex
		end
	else
		selectedIndex = 0
	end
	MODEL.lua.editSelectedTripInfo = selectedIndex
	if MODEL.lua.isValidRoute() then
		MODEL.ui.lm_CockpitListSS.full_list.index = lm_CockpitListSS.full_list:get_index(lm_CockpitListSS.has_route[selectedIndex])
	else
		MODEL.ui.lm_CockpitListSS.full_list.index = lm_CockpitListSS.full_list:get_index(lm_CockpitListSS.no_route[selectedIndex])
	end
	sc_Cockpit_SetFirstVisibleIndexSS()
end
 
sc_Cockpit_SetFirstVisibleIndexSS = function()
	local SeparatorCount = -1
	local group = ""
	local ListIndex = MODEL.ui.lm_CockpitListSS.full_list.index()
	for item,i in ModelList_iter(MODEL.ui.lm_CockpitListSS.full_list) do
		if group ~= item.group() then
			group = item.group()
			SeparatorCount = SeparatorCount + 1
		end
		if ListIndex == i then
			break
		end
	end
	MODEL.ui.lst_TripInfoSS.first_visible_index = ListIndex + (SeparatorCount)
end
 
sc_GetCockpitIndexesSS = function()
	local t = {}
	local group = ""
	for item,index in ModelList_iter(ui.lm_CockpitListSS.full_list) do
		if group ~= item.group() then
			group = item.group()
			table.insert(t, index)
		end
	end
	return t
end
 
sc_wCockpitConfigSettingsSSSelect= function()
	MODEL["*"]._list.index = index
	if MODEL.lua.isValidRoute() then
		lm_CockpitListSS.has_route[MODEL.lua.editSelectedTripInfo()] = lm_CockpitListSS.full_list[index]
		_G["wCockpitFieldSS" .. MODEL.lua.editSelectedTripInfo() + 1].value = lm_CockpitListSS:get_index(MODEL["*"])
	else
		lm_CockpitListSS.no_route[MODEL.lua.editSelectedTripInfo()] = lm_CockpitListSS.full_list[index]
		_G["wCockpitFieldNoRouteSS" .. MODEL.lua.editSelectedTripInfo() + 1].value = lm_CockpitListSS:get_index(MODEL["*"])
	end
	sc_back()
end

sc_signpost_changeSS = function()
	if MODEL.lua.wShowSignpostSS() and bLaneinfoSignpostValid() then
		sc_SignPostShowSS()
	else
		sc_SignPostHideSS()
	end
end
 
sc_SignPostHideSS = function()
	MODEL.lua.wShowSignpostSS = MODEL.lua.wShowSignpost_savedSS()
	if MODEL.lua.SignpostVisible() then
		MODEL.lua.SignpostIsValid = false
		MODEL.lua.wLaneInfoSS = MODEL.lua.wLaneInfo_savedSS()
		if MODEL.lua.wLaneInfoSS() then
			obs_laneinfo:START("NO_TRIGGER")
		end
	end
end
 
sc_SignPostShowSS = function()
	if not MODEL.lua.SignpostVisible() then
		if MODEL.lua.wHideLaneinfoSPSS() == 1 then
			obs_laneinfo:STOP()
			MODEL.lua.wLaneInfoSS = false
		end
		MODEL.lua.SignpostIsValid = true
		sc_laneinfo_onshowSS()
	end
end
 
btn_sp_on_onreleaseSS = function()
	MODEL.lua.wShowSignpostSS = not MODEL.lua.SignpostVisible()
	sc_signpost_change()
end

sc_sp_SS = function()
	MODEL.lua.wShowSignpostSS = false
	sc_signpost_change()
end

sc_sp_lcSS = function()
	if MODEL.lua.SignpostVisible() then
		MODEL.lua.wShowSignpost_savedSS = true
	end
	MODEL.lua.wShowSignpost_savedSS = not MODEL.lua.wShowSignpost_savedSS()
	MODEL.lua.wShowSignpostSS = MODEL.lua.wShowSignpost_savedSS()
	sc_signpost_change()
end

sc_SS_check = function()
	MODEL.lua.wSSFlag = (MODEL.lua.wAutoDistanceSS() < MODEL.navigation.distance_to_maneuver())
end
 
sc_SS_checkSS = function()
	MODEL.lua.wSSFlagSS = (MODEL.lua.wAutoDistanceSS() < MODEL.navigation.distance_to_maneuver())
end

sc_SSShow = function()
	sc_NextStateAnim(st_ScreenSaver, "fade", 1, "")
end
 
sc_SSHide = function()
	sc_back()
end
 
--navigatemap.lua
st_EasyNav:useLayers("ui_NavigateMapnight")
tSimControlsObjectsNew = {"spr_SC_bg", "btn_ManNext", "spr_ManNext", "btn_sim_play", "spr_sim_play", "btn_sim_pause", "spr_sim_pause", "btn_ManPrev", "spr_ManPrev", "btnSpeedSimUp", "sprSpeedSimUp", "btnSpeedSimNormal", "sprSpeedSimNormal", "btnSpeedSimDown", "sprSpeedSimDown"}
wTimerOSID=-1
wTimerExitDragModeID=-1
wTimerAlphaRestore=-1
wTemp_overview_distance = nil
wSplitScreenOpen_saved = false
wSplitScreenPOIReady = false
if MODEL.EXISTS.route.allow_env_zone() then
	st_EasyNav:useLayers("ui_wUmweltZoneWarningLayer")
end
obs_wcockpitcarposition = var.observer({ONCHANGE = function()
	local positions = wCockpitStatesPosition
	local value = positions[1]
	if MODEL.lua.tripInfoVisible() and MODEL.navigation.has_route() and not MODEL.route.list.navigated.off_road() then
		value = positions[2]
	end
	if MODEL.lua.HwyPoiListIsVisible() or MODEL.lua.wSplitScreenOpen() or (MODEL.screen.msgbox.is_onscreen() and MODEL.screen.msgbox.on_screen.has_tag("popup")) then
		value = value - positions[3]
	end
	sc_wSetNavCarPos(value)
end, MODEL = {MODEL.navigation.has_route, MODEL.screen.msgbox.is_onscreen, MODEL.lua.HwyPoiListIsVisible, MODEL.lua.wSplitScreenOpen}, TRIGGER_ON_START = true})
st_EasyNav.init = function()
	wTemp_overview_distance = nil
	local messageBoxY = scGetMapPopupY()
	sc_PosRecalcLayer()
	sc_Set_Presets()
	ui.ui_PropLayer.rmemptystart, ui.ui_PropLayer.rmemptysize = sc_wGetRightMenuEmpty(false)
	wCurrentGroupFav = MODEL.poi.find_group(FavGroup)
	sc_init_local_menu("ui.lm_st_EasyNav")
	primary:ONMAPCLICK(sc_EasyMapClick)
	primary:ONMAPDRAGGED(sc_wEasyMapDrag)
	obs_enter_drag_mode:START("no_trigger")
	if MODEL.lua.dragMode() then
		sc_dragmode(true)
		MODEL.lua.mainMenuMode = false
		sc_wBlockCheck()
		sc_start_ExitDragMode()
		MODEL.lua.wSpeedcamMapClicked = not MODEL.map.primary.clicked_speedcam_list.isempty()
	else
		if MODEL.navigation.is_in_simulation() then
			sc_SetFlyOverMode()
		else
			sc_set_Nav2D3D()
			MODEL.lua.mainMenuMode = false
		end
		sc_SetCockpitMap()
		if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
			MODEL.map.primary.camera_settings.overview_enabled = false
		elseif MODEL.lua.wUserZoomSetting() then
			sc_Set_wUser_Presets()
		else
			MODEL.map.primary.camera_settings.overview_enabled = (MODEL.lua.wOverviewMode() ~= 0)
		end
		sc_Set_Follow_On()
		MODEL.map.primary.show_cursor = false
	end
	MODEL.navigation.junction_view_on = MODEL.lua.wJVOn()
	MODEL.navigation.tunnel_view.enabled = MODEL.lua.wShowTunnel()
	MODEL.lua.wLaneInfoHiddenByUser = false
	MODEL.lua.JunctionViewHiddenByUser = false
	ATTACH_LANEINFO(sprLaneInfoEasy, "laneinfo.ini")
	ATTACH_LANEINFO(sprLaneInfoSignpost, "laneinfo_signpost.ini")
	ui.bLaneInfoSignpostForceRedraw = 1
	local junctionViewType = sc_GetSysEntry("navigation", "junction_view_type", "NNG")
	local junctionViewContentResolution = sc_GetSysEntry("navigation", "junction_view_content_resolution_override", gJunctionViewContentResolution)
	gJunctionViewNeedsSignpost = false
	if junctionViewType == "NNG" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory)
	elseif junctionViewType == "mixed" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory .. ";" .. junctionViewContentResolution)
	elseif junctionViewType == "NNG_NQ" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], "16_9_NQ_Roads")
	elseif junctionViewType == "NQ" then
		ATTACH_JUNCTIONVIEW(sprJunctionView, junctionViewIni[junctionViewType], gJunctionViewDirectory .. ";" .. junctionViewContentResolution)
	end
	MODEL.map.primary.car_posy = MODEL.map.primary.state() ~= "2dnorthup" and MODEL.map.primary.state() ~= "simulate_2d_nu" and 80 or 50
	st_EasyNav.active = true
	obs_JVValid:START()
	obs_want_junctionview:START()
	obs_want_junctionview:TRIGGER()
	obs_TunnelOverview:START()
	MODEL.lua.wLaneInfo = MODEL.lua.wLaneInfo_saved() ~= 0
	if MODEL.lua.wLaneInfo() then
		obs_laneinfo:START("NO_TRIGGER")
	end
	MODEL.lua.wShowSignpost = MODEL.lua.wSignpostOn()
	obs_SignPostValid:START()
	ui_Local_Menu_Background.ALPHA = 0
	ui_Local_Menu_Background_Disabled:HIDE()
	if not MODEL.map.primary.center_follow() and not gKeepMapPosAfterBack then
		MODEL.map.primary.center_noanim(MODEL.map.cursor.position())
	end
	gKeepMapPosAfterBack = false
	MODEL.mydata.tracks.show_on_map = MODEL.lua.TrackShowOnMap()
	if showDriveCarefully and MODEL.interface.drive_carefully() then
		sc_drive_carefully_init()
	end
	obs_wcockpitcarposition:START()
	ui.vTmcButtonBlinkCounter = 0
	ui.vDAIsVisible = 1
	MODEL.traffic.events.sort_by("distance")
	sc_UpdateFullDelayTextOnMap()
	satPhaseTimerId = doDelayed(20, sc_CycleSatPhase, true)
	MODEL.lua.ismapvisible = true
	MODEL.navigation.restrictions_turn_change_handler = sc_TruckTurnRestrictionAlert
	MODEL.lua.vEasyNavMapMenuOpen = false
	MODEL.lua.wOverviewFlag = false
	if MODEL.map.primary.camera_settings.overview_enabled() then
		wTemp_overview_distance = MODEL.map.primary.camera_settings.overview_distance()
		if not MODEL.lua.wUserZoomSetting() and MODEL.lua.wOverviewMode() == 1 then
			sc_wOverviewHighwayPause()
			obs_wOverviewHighwayFlag:START()
		else
			obs_wOverviewFlag:START("NO_TRIGGER")
		end
	end
	if not MODEL.lua.wSSFlagSS() then
		MODEL.lua.wSSFlag = false
	else
		MODEL.lua.wSSFlag = true
		MODEL.lua.wSSFlagSS = false
	end
	if MODEL.lua.wUseSS() and MODEL.lua.wAutoSS() then
		obs_wSSFlag:START("NO_TRIGGER")
	end
	if MODEL.lua.wTurnRestriction() and MODEL.lua.wTurnRestrictionVoice() and sc_wReadOutTurnRestSupported() then
		obs_wturnrest:START("NO_TRIGGER")
		if MODEL.navigation.turn_restriction_icon.valid() then
			obs_wturnrest_change:START("NO_TRIGGER")
		end
	end
	sc_NaviMenuAlphaRestore()
	MODEL.lua.wLocalMenuHide = true
	if MODEL.lua.wSimulateIsTrackPlaying() then
		MODEL.map.primary.route_model = "navigated,PL1,PL2,PL3,PL4,wblockroute"
	end
	sc_wUnsetEasyNavTripInfoRouteDestShowName()
	MODEL.lua.wEasyNavTripInfoRouteDestShowName = ""
end

st_EasyNav.done = function()
	sc_wobs_witinerchange()
	sc_Kill_wTimerAlphaRestore()
	sc_Kill_wTimerExitDragModeID()
	obs_wcockpitcarposition:STOP()
	sc_reset_primary(true)
	sc_wSetNavCarPos(50)
	obs_wOverviewHighwayFlag:STOP()
	obs_wOverviewFlag:STOP()
	obs_wSSFlag:STOP()
	killDelayed(satPhaseTimerId)
	ui_Quick_Menu_Background.ALPHA = 0
	ui_Quick_Menu_Background_Disabled:HIDE()
	MODEL.screen.msgbox.pause_tags("popup", true)
	obs_enter_drag_mode:STOP()
	st_EasyNav.active = nil
	obs_laneinfo:STOP()
	obs_want_junctionview:STOP()
	obs_TunnelOverview:STOP()
	ATTACH_TUNNELOVERVIEW()
	MODEL.navigation.want_junctionview = false
	obs_SignPostValid:STOP()
	obs_JVValid:STOP()
	obs_wturnrest:STOP()
	sc_wturnrest_change_stop()
	MODEL.mydata.tracks.show_on_map = false
	if MODEL.lua.wSplitScreenOpen() then
		sc_wOffSplitScreenItiner()
		sc_wOffSplitScreenPOI()
	end
	obs_user_browsing_map:STOP()
	obs_clicked_tmc_id_changed:STOP()
	MODEL.traffic.events.sort_by(MODEL.lua.trafficEventSorting())
	MODEL.lua.ismapvisible = false
	MODEL.lua.wLocalMenuHide = false
	MODEL.navigation.restrictions_turn_change_handler = nil
end

-- .ad. B  

ad_wSetNavCarPosON = function()
	local mapLayer = MODEL.map.primary
	mapLayer.car_posx = 75
	mapLayer.center_posx = 75
	MODEL.screen.msgbox.pause_tags("popup", true)
end

ad_wSetNavCarPosOFF = function()
	local mapLayer = MODEL.map.primary
	mapLayer.car_posx = 50
	mapLayer.center_posx = 50
	if st_EasyNav.isActive then
    		MODEL.screen.msgbox.resume_tags("popup")
  	end
end

-- .ad. E

sc_wSetNavCarPos = function(posx)
	if posx~=50 and (MODEL.lua.dragMode() or not st_EasyNav.isActive) then
		return
	end
	local mapLayer = MODEL.map.primary
	if mapLayer.car_posx() ~= posx then
		mapLayer.car_posx = posx
		mapLayer.center_posx = posx
	end
end
 
sc_wChangeHwyPanelSplitScreen = function()
	sc_wOnSplitScreen()
	sc_wOpenCloseHwyPanel()
end
 
sc_wChangeSplitScreenHwyPanel = function()
	sc_CloseHwyPanel()
	sc_wOnSplitScreen()
end
 
sc_wOpenCloseHwyPanel = function()
	MODEL.lua.HwyPoiListIsVisible = not MODEL.lua.HwyPoiListIsVisible()
	sc_NaviMenuAlphaRestore()
end
 
sc_wCloseHwyPanel = function()
	MODEL.lua.HwyPoiListIsVisible = false
	sc_NaviMenuAlphaRestore()
end
 
sc_wSplitScreenTrigger = function()
	MODEL.lua.wSplitScreenOpen = MODEL.lua.wUseSplitScreen() and not MODEL.navigation.is_in_simulation() and not MODEL.lua.dragMode() and wSplitScreenOpen_saved
	if MODEL.lua.wSplitScreenOpen() then
		sc_wOnSplitScreenInitModes()
	else
		sc_wOffSplitScreenItiner()
		sc_wOffSplitScreenPOI()
	end
end
 
sc_wOnSplitScreen = function()
	MODEL.lua.wSplitScreenOpen = not MODEL.lua.wSplitScreenOpen()
	wSplitScreenOpen_saved = MODEL.lua.wSplitScreenOpen()
	if MODEL.lua.wSplitScreenOpen() then
		sc_wOnSplitScreenInitModes()
	else
		sc_wOffSplitScreenItiner()
		sc_wOffSplitScreenPOI()
	end
	sc_NaviMenuAlphaRestore()
end
 
sc_wOnSplitScreenInitModes = function()
	if MODEL.lua.wSplitScreenMode() or wPortrait then
		sc_wOffSplitScreenItiner()
		sc_wOnSplitScreenPOI()
	else
		sc_wOffSplitScreenPOI()
		sc_wOnSplitScreenItiner()
	end
end
 
sc_wSplitScreenItinerChange = function()
	if MODEL.lua.wSplitScreenItinerDetailMode() == (MODEL.ui.itinerModeList.list.size() - 1) then 
		MODEL.lua.wSplitScreenItinerDetailMode = 0
	else
		MODEL.lua.wSplitScreenItinerDetailMode = MODEL.lua.wSplitScreenItinerDetailMode() + 1
	end
end
 
sc_wOnSplitScreenItiner = function()
	MODEL.route.list.navigated.itiner.detailmode = MODEL.ui.itinerModeList[MODEL.lua.wSplitScreenItinerDetailMode()].detail()
	MODEL.ui.lst_wSplitScreen_itiner.current_page = 0
	MODEL.route.list.navigated.itiner.enable_update_list = true
end
 
sc_wOffSplitScreenItiner = function()
	MODEL.route.list.navigated.itiner.enable_update_list = false
end
 
sc_wOnSplitScreenPOI = function()
	if MODEL.poi.initialized() then
		sc_wSplitPoiInitialized()
	else
		obs_splitpoiinitialized:START("NO_TRIGGER")
		MODEL.other.force_init_finish("poi")
	end
end
 
sc_wSplitPoiInitialized = function()
	obs_splitpoiinitialized:STOP()
	local changed_groups = false
	if MODEL.ui.lm_splitpoi_groups.size() > 8 then
		MODEL.ui.lm_splitpoi_groups.resize(8)
		changed_groups = true
	end
	local before_size = MODEL.ui.lm_splitpoi_groups.size() - 1
	local removed = 0
	for i = 0, before_size do
		if sc_wSplitScreenPOIGroupGetName(MODEL.ui.lm_splitpoi_groups[i-removed].name()) == nil then
			MODEL.ui.lm_splitpoi_groups.remove(i-removed)
			removed = removed + 1
			changed_groups = true
		end
	end
	if changed_groups then
		MODEL.ui.lm_splitpoi_groups.save()
	end
	sc_wOnSplitScreenPOI_reset_done()
end
 
sc_wOffSplitScreenPOI = function()
	obs_splitpoiinitialized:STOP()
	obs_wSplitScreenPOI_search_done:STOP()
	wSplitScreenPOIReady = false
	local flat_search = MODEL.poi.flat_search
	flat_search.drop_result()
	flat_search.remove_from_filter_chain("poi_pre", "show_groups")
	MODEL.ui.lm_splitpoi.clear()
end
 
sc_wGetSplitScreenModeSettText = function()
	return MODEL.ui.itinerModeList[MODEL.lua.wSplitScreenItinerDetailMode()].text()
end
 
sc_wGetSplitScreenModeIcon = function()
	return (MODEL.lua.wSplitScreenMode() and "ico_places_sml.bmp#3" or MODEL.ui.itinerModeList[MODEL.lua.wSplitScreenItinerDetailMode()].icon())
end
 
sc_wChangeSplitScreenMode = function()
	MODEL.lua.wSplitScreenMode = not MODEL.lua.wSplitScreenMode()
	sc_NaviMenuAlphaRestore()
	sc_wOnSplitScreenInitModes()
end
 
sc_wSettingSplitScreenMode = function()
	if MODEL.lua.wSplitScreenMode() or wPortrait then
		sc_NextStateAnim(st_wSplitScreenPOISettings, "horz_scroll", 1, "")
	else
		sc_NextStateAnim(st_wSplitScreenItinerSettings, "horz_scroll", 1, "")
	end
end
 
sc_wOnSplitScreenPOI_reset = function()
	if MODEL.navigation.car.current_speed() and not MODEL.navigation.is_in_simulation() and wSplitScreenPOIReady then
		sc_wOnSplitScreenPOI_reset_done()
	end
end
 
sc_wOnSplitScreenPOI_reset_done = function()
	wSplitScreenPOIReady = false
	local flat_search = MODEL.poi.flat_search
	flat_search.reset()
	if MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() then
		flat_search.max_result = 20
	end
	flat_search.center = MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() and "route" or "gps"
	flat_search.distance_on_route = MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() and "enabled" or "disabled"
	flat_search.calculate_detour = MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() and "forced" or "disabled"
	flat_search.show_groups.remove_all()
	for item in ModelList_iter(MODEL.ui.lm_splitpoi_groups) do
		flat_search.show_groups.add(MODEL.poi.find_group(item.name()))
	end
	flat_search.add_to_filter_chain("poi_pre", "show_groups")
	if MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() then
		flat_search.area = MODEL.lua.wSplitScreenPOIDistance_20()
	else
		flat_search.area = gGlobalSearchAroundArea
	end
	flat_search.name_filter = MODEL.lua.wSplitScreenPOIFilter()
	flat_search.sort = MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() and "detour_group" or "distance"
	flat_search.execute()
	obs_wSplitScreenPOI_search_done:STOP()
	if flat_search.ready() then
		sc_wOnSplitScreenPOI_reset_doneOK()
	else
		obs_wSplitScreenPOI_search_done:START("NO_TRIGGER")
	end
end
 
sc_wOnSplitScreenPOI_reset_doneOK = function()
	obs_wSplitScreenPOI_search_done:STOP()
	local current
	local count, detour, dist, detour_length = 0, 0, 0, 0
	for currentpoi in ModelList_iter(MODEL.poi.flat_search.list) do
		if sc_wOnSplitScreenPOI_checkangle(currentpoi.position()) then
			dist = currentpoi.distance()
			if MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() then
				detour = currentpoi.detour_icon()
				dist = currentpoi.distance_on_route()
				detour_length = currentpoi.detour_length()
			end
			if MODEL.ui.lm_splitpoi.size() < (count + 1) then
				ui.lm_splitpoi:add({name = currentpoi.name(), icon_id = currentpoi.icon(), detour_id = detour, position = currentpoi.position(), distance = dist, detour_len = detour_length, provider_id = currentpoi.provider_id(), id = currentpoi.id()})
			else
				current = MODEL.ui.lm_splitpoi[count]
				current.name = currentpoi.name()
				current.icon_id = currentpoi.icon()
				current.detour_id = detour
				current.position = currentpoi.position()
				current.distance = dist
				current.detour_len = detour_length
				current.provider_id = currentpoi.provider_id()
				current.id = currentpoi.id()
			end
			count = count + 1
		end
		if count > 4 then
			break
		end
	end
	MODEL.ui.lm_splitpoi.resize(count)
	wSplitScreenPOIReady = true
end
 
sc_wOnSplitScreenPOI_checkangle = function(pos)
	if MODEL.lua.wSplitScreenPOIOnRoute() and MODEL.route.list.navigated.has_navigable_path() then
		return true
	end
	ui.ui_SimulationStop.position_splitpoi = pos
	local angle = ui.ui_SimulationStop.direction_splitpoi()
	if angle < 0 then
		angle = 4096 + angle
	end
	angle = angle - 2048
	if angle < 0 then
		angle = - angle
	end
	return angle <= (2048 * MODEL.lua.wSplitScreenPOIAngle()/180)
end
 
local st_TripInfoChange_init_orig = st_TripInfoChange.init
st_TripInfoChange.init = function()
	st_TripInfoChange_init_orig()
	btn_Footer_back_1:HIDE()
end
 
st_TripInfoChange.done = function()
	btn_Footer_back_1:SHOW()
	sc_wSetCockpitListVia()
end
sc_Angle_SP = function()
	local camerasettings = MODEL.map.primary.camera_settings()
	camerasettings.restore()
	camerasettings.roundabout.centery = 65
	camerasettings.presetid = 10 * (MODEL.lua.vEasyViewMode() + 1) + 1
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		camerasettings.overview_enabled = false
	elseif MODEL.lua.wUserZoomSetting() then
		sc_Set_wUser_Presets()
		camerasettings.maxangle = MODEL.lua.wZoom_maxangleSP()
		camerasettings.angleoffset = MODEL.lua.wZoom_maxangleSP()
		camerasettings.defaultangle = MODEL.lua.wZoom_maxangleSP()
	else
		camerasettings.overview_enabled = (MODEL.lua.wOverviewMode() ~= 0)
	end
end
 
sc_Angle_notSP = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.camera_settings.restore()
	mapLayer.camera_settings.roundabout.centery = 50
	mapLayer.car_posy = (MODEL.lua.vEasyMapMode() == EMapMode.Mode_3D and 80 or (MODEL.lua.vEasyMapMode() == 3 and 50 or (MODEL.route.vehicle_type() == EVehicleType.Pedestrian and 70 or 80)))
	mapLayer.camera_settings.presetid = MODEL.lua.vEasyViewMode() + 1
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		mapLayer.camera_settings.overview_enabled = false
	elseif MODEL.lua.wUserZoomSetting() then
		sc_Set_wUser_Presets()
	else
		mapLayer.camera_settings.overview_enabled = (MODEL.lua.wOverviewMode() ~= 0)
	end
end
 
sc_RestoreSmartZoom = function()
	sc_Angle_notSP()
end
 
sc_Set_Presets = function()
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		sc_Set_Pedestrian_Presets()
	end
	MODEL.map.primary.camera_settings.restore()
	MODEL.map.primary.camera_settings.presetid = MODEL.lua.vEasyViewMode() + 1
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		MODEL.map.primary.camera_settings.overview_enabled = false
	elseif MODEL.lua.wUserZoomSetting() then
		sc_Set_wUser_Presets()
	else
		MODEL.map.primary.camera_settings.overview_enabled = (MODEL.lua.wOverviewMode() ~= 0)
	end
end
 
sc_Set_wUser_Presets = function()
	local settings = MODEL.map.primary.camera_settings()
	sc_Set_wUser_Presets_followzoom()
	settings.minangle = MODEL.lua.wZoom_minangle()
	settings.maxangle = MODEL.lua.wZoom_maxangle()
	settings.angleoffset = MODEL.lua.wZoom_maxangle()
	settings.defaultangle = MODEL.lua.wZoom_maxangle()
	settings.lowspeed = MODEL.lua.wZoom_speedlow()
	settings.highspeed = MODEL.lua.wZoom_speedhigh()
	if not MODEL.lua.wZoom_lockzoom() then
		settings.speedzoom = MODEL.lua.wZoom_speedzoom()
		if MODEL.lua.wZoom_speedzoom() then
			settings.speedzoom_use_minmax = true
		end
	end
	settings.speedangle = MODEL.lua.wZoom_speedangle()
	if MODEL.lua.wZoom_speedangle() then
		settings.speedangle_use_minmax = true
	end
	settings.overview_enabled = MODEL.lua.wZoom_overview_enabled() and not MODEL.lua.wZoom_lockzoom()
	if MODEL.lua.wZoom_overview_enabled() then
		settings.overview_distance = MODEL.lua.wZoom_overview_distance()
		settings.overview_zoom2d = MODEL.lua.wZoom_overview_zoom2d()
		settings.overview_zoom3d = MODEL.lua.wZoom_overview_zoom3d()
		settings.overview_angle = MODEL.lua.wZoom_overview_angle()
	end
end
 
sc_Set_wUser_Presets_followzoom = function()
	if MODEL.lua.wUserZoomSetting() and MODEL.lua.wZoom_lockzoom() then
		MODEL.map.primary.zoom_follow = false
		MODEL.map.primary.zoom = (MODEL.map.primary.mode() == "3d" and MODEL.lua.wZoom_defaultzoom3d() or MODEL.lua.wZoom_defaultzoom2d())
	else
		MODEL.map.primary.zoom_follow = not MODEL.lua.dragMode()
	end
end
 
sc_Easy3D = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.save_state(mapLayer.state())
	mapLayer.switch_state("navmap3d", 1)
	mapLayer.mode = "3d"
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		sc_Set_Pedestrian_Presets_3D()
		mapLayer.zoom_follow = false
		mapLayer.tilt_follow = false
	elseif not MODEL.lua.dragMode() then
		sc_Set_wUser_Presets_followzoom()
		mapLayer.tilt_follow = true
	end
	if not MODEL.lua.dragMode() then
		mapLayer.center_follow = true
		mapLayer.rotate_follow = true
	end
end
 
sc_Easy2D = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.save_state(mapLayer.state())
	mapLayer.switch_state("2dheadup", 1)
	mapLayer.mode = "2d"
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		sc_Set_Pedestrian_Presets_2D()
		mapLayer.zoom_follow = false
		mapLayer.car_posy = 70
		mapLayer.center_posy = 70
	elseif not MODEL.lua.dragMode() then
		sc_Set_wUser_Presets_followzoom()
		mapLayer.car_posy = 80
		mapLayer.center_posy = 80
	end
	if not MODEL.lua.dragMode() then
		mapLayer.center_follow = true
		mapLayer.rotate_follow = true
	end
	mapLayer.breadcrumbs = MODEL.route.vehicle_type() == EVehicleType.Pedestrian
end
 
sc_Easy2D_NU = function()
	local mapLayer = MODEL.map.primary()
	mapLayer.save_state(mapLayer.state())
	mapLayer.switch_state("2dnorthup", 1)
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		sc_Set_Pedestrian_Presets_2D()
	end
	mapLayer.zoom_follow = true
	mapLayer.car_posy = 50
	mapLayer.center_posy = 50
	if not MODEL.lua.dragMode() then
		sc_Set_wUser_Presets_followzoom()
		mapLayer.center_follow = true
		mapLayer.rotate = 0
		mapLayer.rotate_follow = false
	end
	mapLayer.breadcrumbs = MODEL.route.vehicle_type() == EVehicleType.Pedestrian
end
 
sc_Easy3DFromDragmode = function()
	local mapLayer = MODEL.map.primary()
	MODEL.lua.dragMode = false
	MODEL.lua.tiltVisible = false
	mapLayer.switch_state("navmap3d", 1)
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		mapLayer.zoom_follow = false
		mapLayer.tilt_follow = false
		mapLayer.rotate_follow = false
	else
		sc_Set_wUser_Presets_followzoom()
		mapLayer.tilt_follow = true
		mapLayer.rotate_follow = true
	end
end
 
sc_Easy2DFromDragmode = function()
	local mapLayer = MODEL.map.primary()
	MODEL.lua.dragMode = false
	MODEL.lua.tiltVisible = false
	mapLayer.switch_state("2dheadup", 1)
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		mapLayer.zoom_follow = false
		mapLayer.breadcrumbs = true
		mapLayer.center_posy = 50
	else
		sc_Set_wUser_Presets_followzoom()
		mapLayer.breadcrumbs = false
		mapLayer.center_posy = 80
	end
end
 
sc_Easy2D_NU_FromDragmode = function()
	local mapLayer = MODEL.map.primary()
	MODEL.lua.dragMode = false
	MODEL.lua.tiltVisible = false
	mapLayer.switch_state("2dnorthup", 1)
	mapLayer.breadcrumbs = MODEL.route.vehicle_type() == EVehicleType.Pedestrian
	sc_Set_wUser_Presets_followzoom()
	mapLayer.center_posy = 50
	mapLayer.car_posy = 50
end
 
sc_set_3dDem = function()
	local value = MODEL.map.primary["3d_dem"]()
	local valueNeg = 0
	if value == 0 then
		valueNeg = 3
	end
	MODEL.map.primary.setglobal = true
	MODEL.map.primary.setglobal_filter = wGetNUSupported and "navmap3d,2dheadup,2dnorthup,simulate,simulate_2d,simulate_2d_nu" or "navmap3d,2dheadup,simulate,simulate_2d"
	MODEL.map.primary["3d_dem"] = valueNeg
	MODEL.map.primary["3d_dem"] = value
	MODEL.map.primary.setglobal = false
end
 
sc_Set_Follow_On = function()
	local mapLayer = MODEL.map.primary()
	if MODEL.route.vehicle_type() ~= EVehicleType.Pedestrian then
		sc_Set_wUser_Presets_followzoom()
		mapLayer.tilt_follow = true
	end
	mapLayer.center_follow = true
	mapLayer.rotate_follow = mapLayer.state() ~= "2dnorthup" and mapLayer.state() ~= "simulate_2d_nu"
	if mapLayer.state() == "2dnorthup" or mapLayer.state() == "simulate_2d_nu" then
		mapLayer.rotate = 0
	end
end
 
sc_HideLaneInfocock = function()
	MODEL.lua.wLaneInfoHiddenByUser = true
	doDelayed(170, function() MODEL.lua.wLaneInfoHiddenByUser = false end)
	sc_ShowJunctionViewcock()
end
 
sc_NewJunctioncock = function()
	MODEL.lua.JunctionViewHiddenByUser = false
	MODEL.navigation.new_junctionview = false
	obs_want_junctionview:TRIGGER()
end
 
sc_ShowJunctionViewcock = function()
	MODEL.lua.JunctionViewHiddenByUser = false
	obs_want_junctionview:TRIGGER()
end
 
sc_HideJunctionViewcock = function()
	MODEL.lua.JunctionViewHiddenByUser = true
	obs_want_junctionview:TRIGGER()
end
 
sc_signpost_change = function()
	if vActiveState() == "st_screensaver" then
		sc_signpost_changeSS()
	elseif MODEL.lua.wShowSignpost() and bLaneinfoSignpostValid() then
		sc_SignPostShow()
	else
		sc_SignPostHide()
	end
	obs_want_junctionview:TRIGGER()
end
 
sc_SignPostLayerHide = function()
	sc_SignPostHide()
	obs_want_junctionview:TRIGGER()
end

sc_SignPostHide = function()
	MODEL.lua.wShowSignpost = MODEL.lua.wSignpostOn()
	if MODEL.lua.SignpostVisible() then
		sc_Angle_notSP()
		MODEL.lua.SignpostIsValid = false
		MODEL.lua.wLaneInfo = MODEL.lua.wLaneInfo_saved() ~= 0
		if MODEL.lua.wLaneInfo() then
			obs_laneinfo:START("NO_TRIGGER")
		end
	end
end
 
sc_SignPostLayerShow = function()
	if vActiveState() == "st_screensaver" then
		if MODEL.lua.wShowSignpostSS() then
			sc_SignPostShowSS()
		end
		obs_want_junctionview:TRIGGER()
	end
	if vActiveState() == "st_easynav" and st_EasyNav.active then
		if MODEL.lua.wShowSignpost() then
			sc_SignPostShow()
		end
		obs_want_junctionview:TRIGGER()
	end
end
 
sc_SignPostShow = function()
	if not MODEL.lua.SignpostVisible() then
		if not MODEL.lua.wHideLaneinfoSP() then
			obs_laneinfo:STOP()
			MODEL.lua.wLaneInfo = false
		end
		sc_Angle_SP()
		MODEL.lua.SignpostIsValid = true
		sc_laneinfo_onshow()
	end
end
 
btn_sp_on_onrelease = function()
	MODEL.lua.wShowSignpost = not MODEL.lua.SignpostVisible()
	sc_signpost_change()
end

sc_sp = function()
	MODEL.lua.wShowSignpost = false
	sc_signpost_change()
end

sc_sp_lc = function()
	if MODEL.lua.SignpostVisible() then
		MODEL.lua.wSignpostOn = true
	end
	MODEL.lua.wSignpostOn = not MODEL.lua.wSignpostOn()
	MODEL.lua.wShowSignpost = MODEL.lua.wSignpostOn()
	sc_signpost_change()
end

sc_laneinfo_onshow = function()
	if vActiveState() == "st_easynav" then
		sc_wplaysound(0, MODEL.lua.wLaneSoundName(), MODEL.lua.wLaneSoundVolume())
	else
		sc_wplaysound(0, MODEL.lua.wLaneSoundNameSS(), MODEL.lua.wLaneSoundVolumeSS())
	end
end
 
sc_wLaneInfo_change = function()
	if MODEL.lua.wLaneInfo_saved() == 2 then
		MODEL.lua.wHideLaneinfoSP = false
	end
end
 
sc_MyRouteCockpit_Onrelease = function()
	MODEL.lua.mainMenuMode = true
	routeMenuMode = 0
	sc_NextStateAnim(st_MyRouteMenu, "fade", 1, "")
	if MODEL.lua.wCockpitMenuTTS() then
		sc_wsayspeech(translate_voice("Route Menu"),5,5)
	end
end
 
sc_MyRouteCockpit_Onlongclick = function()
	sc_wReadOutDestinationInfo()
	sc_NaviMenuAlphaRestore()
end
local sc_nVehicle_change_orig = sc_nVehicle_change
sc_nVehicle_change = function()
	sc_nVehicle_change_orig()
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian and MODEL.lua.wPositionLeaveCar() then
		sc_add_carpos_to_history("Car position",0)
	end
end
 
sc_LMBack_onrelease = function()
	sc_backFromdragmode()
	primary:ONMAPCLICK(sc_EasyMapClick)
	primary:ONMAPDRAGGED(sc_wEasyMapDrag)
	sc_NaviMenuAlphaRestore()
end
 
sc_LMBlockRoad = function()
	MODEL.route.add_roadblock(MODEL.map.cursor.position(), true, true)
	MODEL.mydata.blocked_roads.current_weekdays_all_blocked(true)
	sc_wBlockCheck()
end
 
sc_LMBlockRoad_lc = function()
	MODEL.route.add_roadblock(MODEL.map.cursor.position(), true, true)
	MODEL.lua.newBlockedSection = true
	wBlockedFromCockpit = true
	sc_NextStateAnim(st_ChangeBlockedRoad, "fade", 1, "")
end
 
sc_LMPlaceInfo_onrelease = function()
	if st_FindPOIFlatList.isEntered then
		MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
		gLastProviderID = gROPoi_Provider
		if MODEL.lua.wInPicturePOIList() then
			st_FindPOIFlatList:useLayers("ui_FindPOIFlatList", "ui_ModeVR", "ui_List_Background")
			st_FindPOIFlatList:removeLayers("ui_wFindPOIFlatListPictures")
			MODEL.lua.wInPicturePOIList = false
		end
		CLEARTOSTATE(st_FindPOIFlatList)
	else
		MODEL.poi.copy_query("poi.flat_search", "poi.tmp_flat", 1)
	end
	sc_ShowPlacesAroundCursor("fade", 0, "")
end
 
sc_LMCursorPos_onrelease = function()
	MODEL.map.primary.center = MODEL.my.map.selected_item.position()
	if vActiveState() == "st_easynav" then
		MODEL.map.primary.center_posy = 60
		sc_start_ExitDragMode()
	end
	sc_close_local_menu()
end
 
sc_LMCurrentPos_onrelease = function()
	MODEL.map.primary.center = MODEL.navigation.car.position()
	if vActiveState() == "st_easynav" then
		MODEL.map.primary.center_posy = 60
		sc_start_ExitDragMode()
	end
	sc_close_local_menu()
end
 
sc_LMLastPos_onrelease = function()
	MODEL.map.primary.center = MODEL.navigation.car.position()
	if vActiveState() == "st_easynav" then
		MODEL.map.primary.center_posy = 60
		sc_start_ExitDragMode()
	end
	sc_close_local_menu()
end
 
local sc_ResetStrappedCursor_orig = sc_ResetStrappedCursor
sc_ResetStrappedCursor = function()
	sc_ResetStrappedCursor_orig()
	MODEL.lua.wSpeedcamMapClicked = false
end
 
 
sc_wDeleteFavorite_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete this Favourite?"),"sc_wDeleteFavorite_OnRelease_OK", m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL.my.map.selected_item.name())
end
 
sc_wDeleteFavorite_OnRelease_OK = function()
	MODEL.my.poi.current.remove()
	MODEL.poi.resultpoi.clear()
	MODEL.my.map.select_address(MODEL.map.cursor.position())
	sc_ResetStrappedCursor()
	if vActiveState() == "st_easynav" then
		sc_start_ExitDragMode()
	end
end
 
sc_wHistoricalTraffic_onrelease = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	gTrafficViewStartCenter = MODEL.map.primary.center()
	sc_NextStateAnim(st_HistoricalView, "fade", 1, "")
end
 
sc_backFromdragmode = function()
	obs_InvalidateClickedListEvent:STOP()
	nextRotate = 0
	MODEL.lua.dragMode = false
	MODEL.map.primary.autochange_mode_for_zoom = true
	obs_Dragmode_Type:STOP()
	sc_SetCockpitMap()
	if g_MapModeBeforeDragMode > -1 then
		MODEL.lua.vEasyMapMode = g_MapModeBeforeDragMode
		g_MapModeBeforeDragMode = -1
	end
	MODEL.lua.wSplitScreenOpen = MODEL.lua.wUseSplitScreen() and not MODEL.navigation.is_in_simulation() and wSplitScreenOpen_saved
	if MODEL.lua.wSplitScreenOpen() then
		sc_wOnSplitScreenInitModes()
	end
	if MODEL.lua.vEasyMapMode() == EMapMode.Mode_2D then
		sc_Easy2DFromDragmode()
	elseif MODEL.lua.vEasyMapMode() == 3 then
		sc_Easy2D_NU_FromDragmode()
	else
		sc_Easy3DFromDragmode()
	end
	obs_wcockpitcarposition:TRIGGER()
end
 
sc_ChangeFlyOverModeState = function()
	local mapLayer = MODEL.map.primary
	mapLayer.save_state(mapLayer.state())
	local next_state = MODEL.lua.vEasyMapMode() == 3 and "simulate_2d_nu" or (MODEL.lua.vEasyMapMode() == 2 and "simulate_2d" or "simulate")
	mapLayer.switch_state(next_state,1)
	mapLayer.rotate_follow = MODEL.lua.vEasyMapMode() ~= 3
	if MODEL.lua.vEasyMapMode() == 3 then
		mapLayer.rotate = 0
	else
		mapLayer.rotate = 4096 - MODEL.navigation.car.heading()
	end
	primary:ONMAPCLICK(sc_ShowHideSimulateControls)
	primary:ONMAPDRAGGED(sc_ShowHideSimulateControls)
	sc_ShowHideSimulateControls()
	if MODEL.lua.wSimulateIsTrackPlaying() then
		MODEL.map.primary.route_model = "navigated,PL1,PL2,PL3,PL4,wblockroute"
	end
end

sc_ChangeVertSpeedInfo = function()
	MODEL.lua.wVertSpeedInfo = not MODEL.lua.wVertSpeedInfo()
	sc_NaviMenuAlphaRestore()
end
 
sc_SelectCockpit_Map = function()
	if MODEL.lua.wSimulateIsTrackPlaying() or wPortrait then
		sc_NaviMenuAlphaRestore()
		return
	end
	local topen = MODEL.lua.wEasyNavTripInfoOpenWithoutRoute()
	if MODEL.lua.isValidRoute() then
		topen = MODEL.lua.wEasyNavTripInfoOpenRoute()
	end
	if topen then
		if MODEL.lua.isValidRoute() then
			lm_CockpitList.has_route_closed[0] = lm_CockpitList.has_route[index]
			lm_CockpitList.has_route_closed_via[0] = lm_CockpitList.has_route_via[index]
			ui.wCockpitFieldClosed = index + 1
		else
			lm_CockpitList.no_route_closed[0] = lm_CockpitList.no_route[index]
			ui.wCockpitFieldNoRouteClosed = index + 1
		end
	end
	if MODEL.lua.isValidRoute() then
		MODEL.lua.wEasyNavTripInfoOpenRoute = not MODEL.lua.wEasyNavTripInfoOpenRoute()
	else
		MODEL.lua.wEasyNavTripInfoOpenWithoutRoute = not MODEL.lua.wEasyNavTripInfoOpenWithoutRoute()
	end
	sc_NaviMenuAlphaRestore()
end
 
sc_SelectCockpit_Right = function()
	local topen = MODEL.lua.wEasyNavTripInfoOpenWithoutRoute()
	if MODEL.lua.isValidRoute() then
		topen = MODEL.lua.wEasyNavTripInfoOpenRoute()
	end
	if wPortrait then
		topen = true
	end
	MODEL["*"]._list.index = index
	if vCockpitList_Mode() == 1 then
		lm_CockpitList.has_route[MODEL.lua.editSelectedTripInfo()] = lm_CockpitList.full_list[index]
		_G["wCockpitField" .. MODEL.lua.editSelectedTripInfo() + 1].value = lm_CockpitList:get_index(MODEL["*"])
		if not topen then
			lm_CockpitList.has_route_closed[0] = lm_CockpitList.full_list[index]
		end
	else
		lm_CockpitList.no_route[MODEL.lua.editSelectedTripInfo()] = lm_CockpitList.full_list[index]
		_G["wCockpitFieldNoRoute" .. MODEL.lua.editSelectedTripInfo() + 1].value = lm_CockpitList:get_index(MODEL["*"])
		if not topen then
			lm_CockpitList.no_route_closed[0] = lm_CockpitList.full_list[index]
		end
	end
end
 
sc_GoToTripInfoChange = function(selectedIndex)
	if MODEL.lua.wSimulateIsTrackPlaying() then
		return
	end
	local animType = st_EasyNav.isActive and "fade" or "horz_scroll"
	sc_NextStateAnim(st_TripInfoChange, animType, 1, "")
	if selectedIndex == nil then
		selectedIndex = 0
	end
	MODEL.lua.editSelectedTripInfo = selectedIndex
	if MODEL.lua.isValidRoute() then
		if MODEL.lua.wEasyNavTripInfoOpenRoute() or wPortrait then
			MODEL.ui.lm_CockpitList.has_route.index = selectedIndex
			MODEL.ui.lm_CockpitList.full_list.index = lm_CockpitList.full_list:get_index(lm_CockpitList.has_route[selectedIndex])
		else
			MODEL.ui.lm_CockpitList.full_list.index = lm_CockpitList.full_list:get_index(lm_CockpitList.has_route_closed[0])
			MODEL.ui.lm_CockpitList.has_route.index = lm_CockpitList.has_route:get_index(lm_CockpitList.full_list[MODEL.ui.lm_CockpitList.full_list.index()])
			MODEL.lua.editSelectedTripInfo = MODEL.ui.lm_CockpitList.has_route.index()
		end
	elseif MODEL.lua.wEasyNavTripInfoOpenWithoutRoute() or wPortrait then
		MODEL.ui.lm_CockpitList.no_route.index = selectedIndex
		MODEL.ui.lm_CockpitList.full_list.index = lm_CockpitList.full_list:get_index(lm_CockpitList.no_route[selectedIndex])
	else
		MODEL.ui.lm_CockpitList.full_list.index = lm_CockpitList.full_list:get_index(lm_CockpitList.no_route_closed[0])
		MODEL.ui.lm_CockpitList.no_route.index = lm_CockpitList.no_route:get_index(lm_CockpitList.full_list[MODEL.ui.lm_CockpitList.full_list.index()])
		MODEL.lua.editSelectedTripInfo = MODEL.ui.lm_CockpitList.no_route.index()
	end
	sc_Cockpit_SetFirstVisibleIndex()
end
 
sc_GetCockpitIndexes = function()
	local t = {}
	local group = ""
	for item,index in ModelList_iter(ui.lm_CockpitList.full_list) do
		if group ~= item.group() then
			group = item.group()
			table.insert(t, index)
		end
	end
	return t
end
 
sc_wSetCockpitListVia = function()
	local fullindex = 0
	for item,index in ModelList_iter(lm_CockpitList.has_route) do
		fullindex = lm_CockpitList:get_index(item)
		if fullindex < 3 then
			fullindex = fullindex + 3
		end
		lm_CockpitList.has_route_via[index] = lm_CockpitList[fullindex]
	end
	fullindex = lm_CockpitList:get_index(lm_CockpitList.has_route_closed[0])
	if fullindex < 3 then
		fullindex = fullindex + 3
	end
	lm_CockpitList.has_route_closed_via[0] = lm_CockpitList[fullindex]
end
 
sc_wSelectCockpit_Map = function()
	if MODEL.lua.isValidRoute() and wPortrait then
		MODEL.lua.wEasyNavTripInfoRouteDest = not MODEL.lua.wEasyNavTripInfoRouteDest()
		sc_wUnsetEasyNavTripInfoRouteDestShowName()
		MODEL.lua.wEasyNavTripInfoRouteDestShowName = MODEL.lua.wEasyNavTripInfoRouteDest() and "navigation.destination_name_short" or "navigation.next_viapoint_name_short"
		wEasyNavTripInfoRouteDestShowNameTimer = doDelayed(100, function() MODEL.lua.wEasyNavTripInfoRouteDestShowName = "" end)
		sc_NaviMenuAlphaRestore()
	else
		sc_SelectCockpit_Map()
	end
end
 
sc_wGoToTripInfoChange = function(selectedIndex)
	if MODEL.lua.isValidRoute() and not wPortrait then
		MODEL.lua.wEasyNavTripInfoRouteDest = not MODEL.lua.wEasyNavTripInfoRouteDest()
		sc_wUnsetEasyNavTripInfoRouteDestShowName()
		MODEL.lua.wEasyNavTripInfoRouteDestShowName = MODEL.lua.wEasyNavTripInfoRouteDest() and "navigation.destination_name_short" or "navigation.next_viapoint_name_short"
		wEasyNavTripInfoRouteDestShowNameTimer = doDelayed(100, function() MODEL.lua.wEasyNavTripInfoRouteDestShowName = "" end)
		sc_NaviMenuAlphaRestore()
	else
		sc_GoToTripInfoChange(selectedIndex)
	end
end
 
sc_wUnsetEasyNavTripInfoRouteDestShowName = function()
	if wEasyNavTripInfoRouteDestShowNameTimer ~= -1 then
		killDelayed(wEasyNavTripInfoRouteDestShowNameTimer)
		wEasyNavTripInfoRouteDestShowNameTimer = -1
	end
end
 
local sc_EasyMapClick_orig = sc_EasyMapClick
sc_EasyMapClick = function()
	sc_wBlockCheck()
	MODEL.lua.wSpeedcamMapClicked = not MODEL.map.primary.clicked_speedcam_list.isempty()
	sc_EasyMapClick_orig()
	if vActiveState() == "st_easynav" and MODEL.lua.dragMode() then
		sc_start_ExitDragMode()
	end
end
 
sc_wEasyMapDrag = function()
	if vActiveState() == "st_easynav" and MODEL.lua.dragMode() then
		sc_start_ExitDragMode()
	end
end
 
sc_wBlockCheck = function()
	MODEL.lua.wBlockValid = MODEL.route.is_segment_roadblock(MODEL.map.cursor.position(), 50)
end
 
sc_StartFadeSimControls = function(from, to, time)
	for _,v in pairs(tSimControlsObjectsNew) do
		_G[v]:BLENDALPHA(from, to, time)
	end
	scroll_SC.ALPHA = to
end
 
local sc_RestartSimControlsDelay_orig = sc_RestartSimControlsDelay
sc_RestartSimControlsDelay = function()
	sc_NaviMenuAlphaRestore()
	sc_RestartSimControlsDelay_orig()
end
 
sc_MainDestinationCockpit_Onrelease = function(fromskip)
	MODEL.lua.mainMenuMode = false
	sc_NextStateAnim(st_EasyFindMenu, "fade", 1, "")
	if MODEL.lua.wCockpitMenuTTS() and fromskip then
		sc_wsayspeech(translate_voice("Find"),5,5)
	end
end
 
sc_MainMoreCockpit_Onrelease = function()
	sc_NextStateAnim(st_MoreMenu, "fade", 1, "")
	if MODEL.lua.wCockpitMenuTTS() then
		sc_wsayspeech(translate_voice("More..."),5,5)
	end
end
 
sc_MainSettingsCockpit_Onrelease = function(fromskip)
	sc_NextStateAnim(st_EasySettingsMenu, "fade", 1, "")
	if MODEL.lua.wCockpitMenuTTS() and fromskip then
		sc_wsayspeech(translate_voice("Settings"),5,5)
	end
end
 
sc_StartTimerOS = function()
	MODEL.lua.ShowConditionalSpeedLimit = false
	sc_StopTimerSL()
	if MODEL.lua.wAdvOverVisualAnim() then
		sc_StopTimerOS()
		MODEL.lua.wAnimateOSValid = true
		wTimerOSID = doDelayed(250, sc_StopTimerOS_done)
	end
end
 
sc_KillTimerOS = function()
	if wTimerOSID ~= -1 then
		killDelayed(wTimerOSID)
		wTimerOSID = -1
	end
end
 
sc_StopTimerOS = function()
	wOverSoundDelay = 0
	sc_KillTimerOS()
	sc_StopTimerOS_done()
end
 
sc_StopTimerOS_done = function()
	MODEL.lua.wAnimateOSValid = false
end
 
sc_change2d3d = function()
	if MODEL.lua.vEasyMapMode() < (wGetNUSupported and 3 or 2) then
		MODEL.lua.vEasyMapMode = MODEL.lua.vEasyMapMode() + 1
	else
		MODEL.lua.vEasyMapMode = 1
	end
	if MODEL.navigation.is_in_simulation() then
		sc_ChangeFlyOverModeState()
	else
		sc_set_Nav2D3D()
	end
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian then
		MODEL.map.primary.camera_settings.overview_enabled = false
	elseif MODEL.lua.wUserZoomSetting() then
		sc_Set_wUser_Presets()
	else
		MODEL.map.primary.camera_settings.overview_enabled = (MODEL.lua.wOverviewMode() ~= 0)
	end
	obs_wcockpitcarposition:TRIGGER()
end
 
sc_ExitOverview = function()
	MODEL.map.primary.camera_settings.overview_distance = 9999999
	sc_NaviMenuAlphaRestore()
end

sc_wOverviewHighwayPause = function()
	MODEL.map.primary.camera_settings.overview_distance = 9999999
end

sc_wOverviewReset = function()
	if MODEL.map.primary.camera_settings.overview_distance() == 9999999 and wTemp_overview_distance ~= nil then
		MODEL.map.primary.camera_settings.overview_distance = wTemp_overview_distance
	end
end
 
sc_overview_check = function()
	MODEL.lua.wOverviewFlag = (wTemp_overview_distance < MODEL.navigation.distance_to_maneuver())
end
 
sc_start_ExitDragMode = function()
	sc_Kill_wTimerExitDragModeID()
	wTimerExitDragModeID = doDelayed(1500, function()
		if not gLocalMenuIsClosed then
			sc_close_local_menu()
		end
		sc_backFromdragmode()
		primary:ONMAPCLICK(sc_EasyMapClick)
		primary:ONMAPDRAGGED(sc_wEasyMapDrag)
	end)
end

sc_do_ExitDragMode = function()
	sc_Kill_wTimerExitDragModeID()
	sc_NaviMenuAlphaRestore()
end

sc_Kill_wTimerExitDragModeID = function()
	if wTimerExitDragModeID ~= -1 then
		killDelayed(wTimerExitDragModeID)
		wTimerExitDragModeID = -1
	end
end

sc_NaviMenuAlphaRestore = function()
	MODEL.lua.wBtn_ALPHA = 32
	MODEL.lua.wBackground_ALPHA = 32
	MODEL.lua.wBackgroundStreet_ALPHA = 32
	sc_Kill_wTimerAlphaRestore()
	wTimerAlphaRestore = doDelayed(200, sc_NaviMenuAlphaDown)
end

sc_NaviMenuAlphaDown = function()
	if vActiveState() == "st_easynav" and not MODEL.lua.dragMode() then
		MODEL.lua.wBtn_ALPHA = wBtnTransparency
		MODEL.lua.wBackground_ALPHA = wBGTransparency
		MODEL.lua.wBackgroundStreet_ALPHA = wBGStreetTransparency
		MODEL.lua.small_wBackgroundnkspeed_ALPHA = small_wBGnkspeedTransparency
		MODEL.lua.big_wBackgroundnkspeed_ALPHA = big_wBGnkspeedTransparency
		MODEL.lua.vEasyNavMapMenuOpen = false
	end
end

sc_Kill_wTimerAlphaRestore = function()
	if wTimerAlphaRestore ~= -1 then
		killDelayed(wTimerAlphaRestore)
		wTimerAlphaRestore = -1
	end
end
 
createState("st_sm_addpoi")
st_sm_addpoi:useLayers(backgroundLayers, "ui_SM_AddPOI")
st_sm_addpoi.init = function()
	txtTitle.TEXT = m_i18n("Select group")
end

sc_SM_AddPOI = function()
	wAddPOIposition = MODEL.navigation.car.position()
	local mypoi = m_i18n("@My POI")
	local poiGroupId = MODEL.poi.find_group(mypoi)
	if poiGroupId == -1 then
		MODEL.my.poi.add_group(0, gUserPOI_Provider, mypoi)
		poiGroupId = MODEL.poi.find_group(mypoi)
	end
	MODEL.poi.structure.reset()
	MODEL.poi.structure.execute()
	MODEL.poi.structure.search_root = poiGroupId
	MODEL.poi.structure.execute()
	if MODEL.poi.structure.group_list.isempty() then
		MODEL.screen.msgbox.new.setup(1)
		MODEL.screen.msgbox.new.set_line(1, m_i18n("There are no groups in -My POI-!"))
		MODEL.screen.msgbox.new.setup_button(1, "")
		MODEL.screen.msgbox.create_new()
	else
		sc_NextStateAnim(st_sm_addpoi, "fade", 1, "")
	end
end
 
sc_SM_AddPOIEnd = function()
	if wAddPOIposition ~= 0 then
		MODEL.poi.structure.group_list.index = index
		MODEL.poi.structure.to_child()
		MODEL.poi.structure.execute()
		MODEL.my.poi.select_group(MODEL.poi.structure.search_root())
		MODEL.my.map.select_gcoor(wAddPOIposition)
		MODEL.my.poi.add_poi_selected(MODEL.poi.structure.search_root(), gUserPOI_Provider)
		MODEL.my.poi.current.name = towstring(MODEL.my.poi.current_group.name()) .. L"(" .. sc_DateToWStr(MODEL.gps.current_date()) .. L")"
		MODEL.my.poi.current.WSTR.ext_STR_OTHER = translated_format(m_i18n("Created at (%s)(Add POI to GPS)"), towstring(MODEL.other.format_time(MODEL.gps.current_time(), MODEL.regional.timeformat())))
	end
	sc_back()
end
 
sc_wGetWideHouseNumbers = function(lefthn,righthn)
	return (#lefthn > 3 or #righthn > 3)
end
 
sc_wGetRightMenuEmpty = function(portrait)
	local value = 0
	local valuestart = 0
	if wPortrait then
		valuestart = 1
	end
	for i = 0, 3 do
		if MODEL.ui.fullCockpitMenuList.quick_list[i].cockpitvisible() and valuestart then
			break
		end
		if not MODEL.ui.fullCockpitMenuList.quick_list[i].cockpitvisible() then
			if not valuestart then
				valuestart = i + 1
			end
			value = value + 1
		end
	end
	return valuestart, value
end
 
local sc_OnMapInfo_orig = sc_OnMapInfo
sc_OnMapInfo = function()
	MODEL.lua.wSMAddCamCurrentDirection = 360 * tonumber(MODEL.map.primary.rotate())/4096
	sc_OnMapInfo_orig()
end
 
sc_wOpenCockpitSkipMenuItem = function(i)
	MODEL.ui.fullCockpitMenuList.skipmenu[i].onrelease()()
	MODEL.lua.vEasyNavMapMenuOpen = false
end
 
sc_wOpenLongCockpitSkipMenuItem = function(i)
	local item = MODEL.ui.fullCockpitMenuList.skipmenu[i]
	if item.id() == "skip_minimize" then
		item.onlongclick()()
	else
		MODEL.lua.editSelectedTripInfo = i
		sc_NextStateAnim(st_wCockpitSkipMenuSettingElement, "fade", 1, "")
	end
end
 
sc_wFindItemInCockpitSkipMenuList = function(itemId)
	for item, index in ModelList_iter(MODEL.ui.fullCockpitMenuList) do
		if item.id() == itemId then
			return index
		end
	end
	return 0
end
 
sc_wBuildCockpitSkipMenu = function()
	local itemIdx = 0
	for i = 0, 3 do
		itemIdx = sc_wFindItemInCockpitSkipMenuList(PERSISTENT.wcockpitskipmenu[i]())
		fullCockpitMenuList.skipmenu:append(fullCockpitMenuList[itemIdx])
	end
	itemIdx = sc_wFindItemInCockpitSkipMenuList("skip_minimize")
	fullCockpitMenuList.skipmenu:append(fullCockpitMenuList[itemIdx])
end
 
createState("st_wCockpitSkipMenuSettingElement")
st_wCockpitSkipMenuSettingElement:useLayers(backgroundLayers, "ui_List_Background", "ui_wCockpitSkipMenuSettingElement")
st_wCockpitSkipMenuSettingElement.init = function()
	txtTitle.TEXT = m_i18n("Select a Shortcut")
end
 
sc_wCockpitSkipMenuSettingElement_onrelease = function()
	fullCockpitMenuList.skipmenu[MODEL.lua.editSelectedTripInfo()] = fullCockpitMenuList.full_list[index]
	PERSISTENT.wcockpitskipmenu[MODEL.lua.editSelectedTripInfo()] = MODEL.ui.fullCockpitMenuList.skipmenu[MODEL.lua.editSelectedTripInfo()].id()
	sc_PrevStateAnim()
end
 
sc_InvalidateClickedListEvent = function()
	MODEL.map.primary.cursor_icon = "cursor"
	g_cursor_strapped = false
	MODEL.lua.wSpeedcamMapClicked = false
end
 
--netlocalsearch.lua
local st_POI_Flat_Con_0_InputText_init_orig = st_POI_Flat_Con_0_InputText.init
st_POI_Flat_Con_0_InputText.init = function()
	inp_POI_Flat_Con_0.ALLOWCURSORCLICK = 1
	st_POI_Flat_Con_0_InputText_init_orig()
end
 
sc_POI_Flat_Con_0_DoSearch = function(SkipState)
	if SkipState == nil then
		SkipState = false
	end
	MODEL.poi.flat_search.reset()
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = true
	MODEL.poi.flat_search.clear_providers()
	MODEL.poi.flat_search.search_root = 0
	MODEL.poi.flat_search.name_filter = ui.inp_POI_Flat_Con_0.value
	MODEL.poi.flat_search.exclude_provider = true
	MODEL.poi.flat_search.non_idle = false
	MODEL.poi.flat_search.add_provider(gROPoi_Provider)
	MODEL.poi.flat_search.add_provider(MODEL.poi.find_provider("kmlpoi"))
	MODEL.poi.flat_search.add_provider(gUserPOI_Provider)
	MODEL.poi.flat_search.center = "gps"
	MODEL.poi.flat_search.no_sort()
	if SkipState == false then
		sc_NextStateAnim(st_POI_Flat_Con_0_List, "fade", 1, "")
	end
	MODEL.poi.flat_search.execute()
	obs_google_flat_search_ready:START()
end
 
--notifications.lua
wUmweltSpeakingID = 0
sc_CongestionOn = function()
	MODEL.screen.msgbox.new.setup(1)
	MODEL.screen.msgbox.new.set_layer(ui_wMapSidePanel_Congestion)
	MODEL.screen.msgbox.new.add_tag("popup")
	gCongestionMsgID = MODEL.screen.msgbox.create_new()
end
 
sc_ShowQuickDetourPopup = function()
	sc_RemoveMapPopupById(gQuickDetourPopupID)
	if st_QuickDetourPreview.isActive then
		return 
	end
	MODEL.screen.msgbox.new.setup(1)
	MODEL.screen.msgbox.new.set_layer(ui_wMapSidePanel_QuickDetour)
	MODEL.screen.msgbox.new.add_tag("popup")
	MODEL.screen.msgbox.new.set_title("quickdetour")
	gQuickDetourPopupID = MODEL.screen.msgbox.create_new()
	if (st_EasyNav.isActive or vActiveState() == "st_screensaver") and MODEL.screen.msgbox.is_onscreen() and MODEL.screen.msgbox.on_screen.title() == "quickdetour" and MODEL.lua.wQuickDetourTTSVoice() and sc_wReadOutQuickDetourSupported() and not (wDASpeakingID or wSpeedCameraSpeakingID or MODEL.sound.os_muted() or MODEL.sound.voice_muted()) then
		local text = sc_wGetTextReadOutQuickDetour(MODEL.navigation.quickdetour_distance_on_route.valid(), MODEL.navigation.quickdetour_distance_on_route(), MODEL.navigation.quickdetour_calculated(), MODEL.navigation.quickdetour_dist(), MODEL.navigation.quickdetour_streetname(), MODEL.navigation.quickdetour_icon())
		sc_wPromptCancel("wDetourSpeakingID")
		if not (MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance") then
			wDetourSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 21, boosted_priority = 25, callback = function(res) if res > 1 then wDetourSpeakingID = 0 end end})
		end
	end
end
 
local sc_RemoveQuickDetourPopup_orig = sc_RemoveQuickDetourPopup
sc_RemoveQuickDetourPopup = function()
	sc_wPromptCancel("wDetourSpeakingID")
	sc_RemoveQuickDetourPopup_orig()
end
 
sc_wReadOutQuickDetourSupported = function()
	local res = MODEL.regional.current_voice.is_tts() and MODEL_regional_is_it_voice_localizable(m_i18n_voice("After %s")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Possible alternative route")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("more shortly on %s")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("more long on %s"))
	if not res then
		return res
	end
	local t = {"straight","left","right","slight left","slight right", "sharp left", "sharp right"}
	for _,v in pairs(t) do
		if not MODEL_regional_is_it_voice_localizable(m_i18n_voice("QuickDetour~" .. v)) then
			res = false
			break
		end
	end
	return res
end
 
sc_wGetTextReadOutQuickDetour = function(distvalid,dist,calculated,sparedist,streetname,icon)
	local distphrase = distvalid and dist >= 50 and MODEL.lua.wQuickDetourTTSVoiceFirstPhrase() and (translated_voice_format(m_i18n_voice("After %s"), sc_wVoiceFormat_search_distance(dist)) .. L" ") or L""
	local sparephrase = calculated and MODEL.lua.wQuickDetourTTSVoiceSparePhrase() and sc_wFormatSpareDistanceTTS(sparedist) or L""
	local streetphrase = calculated and MODEL.lua.wQuickDetourTTSVoiceStreetPhrase() and sc_TransformStreetNameforTurn(streetname) or L""
	local directionphrase = calculated and MODEL.lua.wQuickDetourTTSVoiceDirectionPhrase() and sc_wFormatDetourDirectionTTS(icon) or L""
	return distphrase .. translate_voice("Possible alternative route") .. directionphrase .. streetphrase .. sparephrase
end
 
sc_wFormatDetourDirectionTTS = function(icon)
	if icon == "from_test" then
		return L" " .. translate_voice("QuickDetour~right")
	end
	local _,_,str_id = string.find(MODEL.screen.get_icon_file_and_phase(icon, 0), "(%d+)%.bmp")
	if str_id == nil then
		return L""
	end
	local t = { [0] = "straight", [1] = "left", [2] = "right", [3] = "slight left", [4] = "slight right", 
	[17] = "sharp right", [19] = "sharp left", [23] = "slight right", [24] = "slight left", [29] = "right", 
	[30] = "left", [31] = "straight", [32] = "straight", [33] = "straight", 
	[42] = "slight right", [43] = "slight left", [45] = "left", [46] = "right"}
	local matched = t[tonumber(str_id)]
	if matched then
		return L" " .. translate_voice("QuickDetour~" .. matched)
	end
	return L""
end
 
sc_wFormatSpareDistanceTTS = function(sparedistance)
	if sparedistance == 0 then
		return L""
	end
	local absdistance = sparedistance
	if sparedistance < 0 then
		absdistance = -sparedistance
	end
	local prefix = (sparedistance < 0 and "more shortly on %s") or (sparedistance > 0 and "more long on %s" or "")
	return (L" " .. translated_voice_format(m_i18n_voice(prefix), sc_wVoiceFormat_search_distance(absdistance)))
end
 
sc_wQuickDetourTTS_play = function()
	local streetname = L""
	if MODEL.navigation.car_pos_valid() then
		streetname = MODEL.navigation.car.current_street()
	end
	sc_wsayspeech_test(sc_wGetTextReadOutQuickDetour(true,200,true,-100,streetname,"from_test"))
end
 
sc_wQuickDetourSetting_OnRelease = function()
	sc_NextStateAnim(st_wQuickDetourTTS, "horz_scroll", 1, "")
end
 
createState("st_wQuickDetourTTS")
st_wQuickDetourTTS:useLayers(backgroundLayers, "ui_wQuickDetourTTS")
st_wQuickDetourTTS.init = function()
	txtTitle.TEXT = m_i18n("Quick Detour TTS Pro Test")
end
 
st_wQuickDetourTTS.done = function()
	sc_wPromptCancel("wTestSpeakingID")
end
 
sc_TransformStreetNameforTurn = function(street)
	if street == L"" then
		return L""
	end
	local tempstreet = MODEL.sound.voice.format_street_name(L"for_turns" .. street)
	if wstring.find(tempstreet, L"for_turns", 1, true) == nil then
		return L" " .. tempstreet
	else
		return L" " .. sc_TransformStreetName(street)
	end
end
 
sc_wUmweltZoneActive = function()
	MODEL.lua.wUmweltZoneHidden = false
	if MODEL.route.vehicle_type() == EVehicleType.Pedestrian or not (st_EasyNav.isActive or vActiveState() == "st_screensaver") or not (MODEL.navigation.is_in_simulation() or MODEL.gps.connection_status() < 3 and not MODEL.lua.dragMode() and (MODEL.navigation.car_pos_valid() or MODEL.gps.valid() or MODEL.navigation.dead_reckoning())) then
		return
	end

-- .ad. Rafael2San B
--	if MODEL.lua.wUmweltZoneTTS() and sc_wReadOutUmweltZoneSupported() then
	if MODEL.lua.wUmweltZoneTTS() and sc_wReadOutUmweltZoneSupported() and MODEL.lua.ADshowRodizio() then
-- .ad. Rafel2San E

		local text = sc_wGetTextReadOutUnweltZone(MODEL.navigation.env_zone_distance(), MODEL.navigation.env_zone_remaining.valid(), MODEL.navigation.env_zone_remaining_limit_reached(), MODEL.navigation.env_zone_remaining_destination_reached(), MODEL.navigation.env_zone_remaining())
		sc_wPromptCancel("wUmweltSpeakingID")
		if not (MODEL.sound.speech.is_say_bool() and MODEL.sound.speech.saying_source() == "voice.guidance" or wDASpeakingID or wSpeedCameraSpeakingID or MODEL.sound.os_muted() or MODEL.sound.voice_muted()) then
			wUmweltSpeakingID = MODEL.sound.speech.say("voice.ui", text, {priority = 21, boosted_priority = 25, callback = function(res) if res > 1 then wUmweltSpeakingID = 0 end end})
		end
	else
		sc_wplaysound(0, MODEL.lua.wUmweltSoundName(), MODEL.lua.wUmweltSoundVolume())
	end
end
 
sc_wUmweltZoneHide = function()
	MODEL.lua.wUmweltZoneHidden = true
	sc_wplaysound(1, L"!!!", 1)
	sc_wPromptCancel("wUmweltSpeakingID")
end
 
sc_wReadOutUmweltZoneSupported = function()
	return MODEL.regional.current_voice.is_tts() and MODEL_regional_is_it_voice_localizable(m_i18n_voice("After %s")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Environmental Zone")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Remaining more than %s")) and MODEL_regional_is_it_voice_localizable(m_i18n_voice("Remaining %s"))
end
 
sc_wGetTextReadOutUnweltZone = function(dist,rem_valid,rem_limit_reached,rem_dest_reached,rem_dist)
	if dist>0 and not rem_valid then
		local distphrase = MODEL.lua.wUmweltZoneTTSDistance() and (translated_voice_format(m_i18n_voice("After %s"), sc_wVoiceFormat_search_distance(dist)) .. L" ") or L""
		return (MODEL.lua.wUmweltZoneTTSDistance() and (translated_voice_format(m_i18n_voice("After %s"), sc_wVoiceFormat_search_distance(dist)) .. L" ") or L"") .. translate_voice("Environmental Zone")
	elseif rem_limit_reached then
		return translate_voice("Environmental Zone") .. L" " .. (MODEL.lua.wUmweltZoneTTSRemaining() and translated_voice_format(m_i18n_voice("Remaining more than %s"), sc_wVoiceFormat_search_distance(rem_dist)) or L"")
	elseif rem_valid or rem_dest_reached then
		local distance_rem = rem_valid and rem_dist or MODEL.navigation.distance_to_destination()
		return translate_voice("Environmental Zone") .. L" " .. (MODEL.lua.wUmweltZoneTTSRemaining() and translated_voice_format(m_i18n_voice("Remaining %s"), sc_wVoiceFormat_search_distance(distance_rem)) or L"")
	end
end
 
sc_btnSR_UmweltZone_OnRelease = function()
	sc_NextStateAnim(st_wUmweltZoneSettings, "horz_scroll", 1, "")
end
 
createState("st_wUmweltZoneSettings")
st_wUmweltZoneSettings:useLayers(backgroundLayers, "ui_wUmweltZoneSettings")
st_wUmweltZoneSettings.init = function()
	txtTitle.TEXT = m_i18n("Environmental Zone Warning Settings")
end
 
sc_wUmweltZoneTTS_play = function()
	local disttext = MODEL.lua.wUmweltZoneTTSDistance() and (translated_voice_format(m_i18n_voice("After %s"), sc_wVoiceFormat_search_distance(1500)) .. translate_voice("Environmental Zone") .. L" ") or L""
	local remtext = MODEL.lua.wUmweltZoneTTSRemaining() and (translate_voice("Environmental Zone") .. L" " .. translated_voice_format(m_i18n_voice("Remaining %s"), sc_wVoiceFormat_search_distance(2500))) or L""
	local text = disttext .. remtext
	if text == L"" then
		text = translate_voice("Environmental Zone")
	end
	sc_wsayspeech_test(text)
end
 
sc_wUmweltZoneTTS_OnRelease = function()
	sc_NextStateAnim(st_wUmweltZoneTTS, "horz_scroll", 1, "")
end
 
createState("st_wUmweltZoneTTS")
st_wUmweltZoneTTS:useLayers(backgroundLayers, "ui_wUmweltZoneTTS")
st_wUmweltZoneTTS.init = function()
	txtTitle.TEXT = m_i18n("Environmental Zone TTS Pro Test")
end
 
st_wUmweltZoneTTS.done = function()
	sc_wPromptCancel("wTestSpeakingID")
end
 
st_wSearchCountryUmweltSign = function(country)
	local country_icons = {"_GER","_GBR","_NED","_BRA"}
	local bmp = "_eu"
	for _,v in pairs(country_icons) do
		if v == country then
			bmp = v:lower()
			break
		end
	end
	return "umwelt_zone" .. bmp .. ".bmp#2"
end
 
--place.lua
 
wWhereAmISayed = nil
local st_FindOnMap_init_orig = st_FindOnMap.init
st_FindOnMap.init = function()
	wCurrentGroupFav = MODEL.poi.find_group(FavGroup)
	sc_wBlockCheck()
	MODEL.lua.wSpeedcamMapClicked = not MODEL.map.primary.clicked_speedcam_list.isempty()
	st_FindOnMap_init_orig()
	MODEL.lua.wLocalMenuHide = true
end
 
local st_FindOnMap_done_orig = st_FindOnMap.done
st_FindOnMap.done = function()
	st_FindOnMap_done_orig()
	MODEL.lua.wLocalMenuHide = false
end
 
st_WhereAmI.enter = function()
	wWhereAmISayed = false
end
 
local st_WhereAmI_init_orig = st_WhereAmI.init
st_WhereAmI.init = function()
	st_WhereAmI_init_orig()
	if MODEL.lua.wWhereIAmTTSInfo() and MODEL.regional.current_voice.is_tts() and not wWhereAmISayed then
		wWhereAmISayed = true
		sc_wsayspeech(sc_wGetTextWhereIAm(),21,25)
	end
end
 
sc_SettingWarningsWhereIAmTest = function()
	MODEL.my.map.select_address(MODEL.navigation.car.position())
	if MODEL.navigation.car_pos_valid() then
		sc_wsayspeech_test(sc_wGetTextWhereIAm())
	else
		MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
		local country = MODEL.map.cursor.address.country()
		if country ~= "" then
			local currentAddress = not MODEL_regional_is_it_voice_localizable(country) and MODEL.map.cursor.address.loccountrylong() or translate_voice(country)
			if string.find(MODEL.regional.current_voice.key(), "_loq_", 1, true) == nil then
				currentAddress = gTTS_AddressMode .. L" " .. currentAddress .. L" " .. gTTS_NormalMode
			end
			sc_wsayspeech_test(currentAddress)
		end
	end
end
 
sc_wGetTextWhereIAm = function()
	local currentAddress, currentStreet
	if not MODEL.navigation.car.is_incity() then
		currentAddress = sc_TransformStreetName(MODEL.navigation.car.current_street())
	elseif MODEL.navigation.car.address.city() then
		if MODEL.navigation.car.address.street() ~= L"" then
			currentStreet = sc_TransformStreetName(MODEL.navigation.car.address.street())
		else
			currentStreet = sc_TransformStreetName(MODEL.navigation.car.current_street())
		end
		currentAddress = sc_wGetTextWhereIAmCountry() .. L" , " .. sc_TransformStreetName(MODEL.navigation.car.address.city()) .. L" " .. currentStreet
	else
		currentAddress = sc_wGetTextWhereIAmCountry()
	end
	if string.find(MODEL.regional.current_voice.key(), "_loq_", 1, true) == nil then
		currentAddress = gTTS_AddressMode .. L" " .. currentAddress .. L" " .. gTTS_NormalMode
	end
	return currentAddress
end
 
sc_wGetTextWhereIAmCountry = function()
	local country = MODEL.navigation.car.last_known_countrycode()
	return (country == "" or not MODEL_regional_is_it_voice_localizable(country)) and MODEL.navigation.car.address.loccountrylong() or translate_voice(country)
end
 
st_CursorLocation:removeLayers(localMenuLayers)
st_CursorLocation.init = function()
	MODEL.lua.ismapvisible = false
	txtTitle.TEXT = m_i18n("Cursor Location")
end
 
sc_wPlacesAroundCursor_onrelease = function()
	if st_FindPOIFlatList.isEntered then
		MODEL.lua.PoiListFilterString = L""
		local flat_search = MODEL.poi.flat_search
		st_FindPOIFlatList.filter_is_postfilter = false
		flat_search.ext_name_filter.name = L""
		flat_search.add_to_filter_chain("poi_result", "ext_name_filter")
		MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
		gLastProviderID = gROPoi_Provider
		if MODEL.lua.wInPicturePOIList() then
			st_FindPOIFlatList:useLayers("ui_FindPOIFlatList", "ui_ModeVR", "ui_List_Background")
			st_FindPOIFlatList:removeLayers("ui_wFindPOIFlatListPictures")
			MODEL.lua.wInPicturePOIList = false
		end
		CLEARTOSTATE(st_FindPOIFlatList)
		sc_ShowPlacesAroundCursor("fade", 0, "")
	else
		MODEL.poi.copy_query("poi.flat_search", "poi.tmp_flat", 1)
		if st_ManageFavorite.isEntered then
			CLEARTOSTATE(st_ManageFavorite)
			STATE(st_FindPOIFlatList)
		end
		sc_ShowPlacesAroundCursor("fade", 0, "")
	end
end
 
sc_FindOnMap_Select_onrelease = function()
	if MODEL.lua.wInSelectHomeOffice() then
		sc_FinishSelectPositionOK()
	else
		wSelectedItemHotAction = (wSelectedItemHotName == MODEL.my.map.selected_item.name() and wSelectedItemHotPos == MODEL.my.map.selected_item.position())
		gKeepMapPosAfterBack = true
		sc_SetRoutePlanErrorMarker()
		MODEL.lua.mainMenuMode = false
		sc_GoMyRouteMenuMessage()
		wFind_createroute = false
	end
end
 
local sc_lock_plan_mode_orig = sc_lock_plan_mode
sc_lock_plan_mode = function()
	MODEL.map.primary.rotate = 0
	sc_lock_plan_mode_orig()
	sc_wBlockCheck()
	MODEL.lua.wSpeedcamMapClicked = false
end
 
--poi.lua
wCurrentGroup = 0
wCurrentGroupFav = -1
wAddPOIposition	= 0
wGroupIcon = nil
wGroupIconVisibility = nil
wGroupInheritVisibility = nil
wGroupNameVisibility = nil
wGroupDistanceVisibility = nil
 
st_LoadPOIVisibilities:removeLayers(localMenuLayers)
st_LoadPOIVisibilities.init = function()
	txtTitle.TEXT = m_i18n("Load Place Marker Settings")
end
 
sc_PoiVisibilityListClearAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all Place Marker configurations?"),"sc_PoiVisibilityClearAll_OnRelease_OK", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
st_POIVisibilities.enter = function()
	EPoiScrollPos = {}
	wCurrentGroupFav = MODEL.poi.find_group(FavGroup)
end
 
st_POIVisibilities.done = function()
end
 
sc_back_POIGroupVisibility = function()
	local action = false
	if wGroupIconVisibility ~= MODEL.lua.wSettingDistVisual() then
		MODEL.my.poi.current_group.icon = MODEL.lua.wSettingDistVisual()
		action = true
	end
	if wGroupNameVisibility ~= MODEL.lua.wSettingDistSoundName() then
		local newname = L"@"..MODEL.lua.wSettingDistSoundName()
		MODEL.my.poi.rename_group(wCurrentGroup, newname, gUserPOI_Provider)
		action = true
	end
	if wGroupDistanceVisibility ~= MODEL.lua.wPoiGroupAltitude() or wGroupInheritVisibility ~= MODEL.poi.inherit_visibility() then
		MODEL.my.poi.current_group[tostring(MODEL.lua.poi.selectedPOIVis())].visible_at = MODEL.lua.wPoiGroupAltitude()
		action = true
	end
	if action then
		MODEL.poi.structure.execute()
		sc_SavePOIVisibility()
	end
end
 
sc_ManagePOIGroupVisibility = function()
	wCurrentGroup = MODEL["*"].id()
	MODEL.lua.wSettingDistOn = MODEL["*"].writable()
	MODEL.lua.wSettingDistVisual = MODEL["*"].icon()
	MODEL.lua.wSettingDistSound = MODEL["*"].has_child()
	MODEL.lua.wSettingDistSoundName = MODEL["*"].name()
	MODEL.my.poi.select_group(wCurrentGroup)
	MODEL.lua.wPoiGroupAltitude = MODEL.my.poi.current_group[tostring(MODEL.lua.poi.selectedPOIVis())].visible_at()
	wGroupIconVisibility = MODEL.lua.wSettingDistVisual()
	wGroupNameVisibility = MODEL.lua.wSettingDistSoundName()
	wGroupDistanceVisibility = MODEL.lua.wPoiGroupAltitude()
	wGroupInheritVisibility = MODEL.poi.inherit_visibility()
	sc_NextStateAnim(st_ManagePOIGroupVisibility, "horz_scroll", 1, "")
end
 
sc_et_ManagePOIGroupVisibility_onrelease = function()
	local item = MODEL["*"]
	item._list.setcurrent(index)
	MODEL.lua.wPoiGroupAltitude = item.distance()
end

sc_ChangeCurrentPoiGroupIcon = function(group)
	wGroupIcon = group
	if not sc_GetSysEntry("poi", "sort_icons", 1) then
		MODEL.screen.filter_unique_by_index(2)
		MODEL.screen.set_current_icongroup("poi")
	elseif MODEL.ui.list_wScreenIcons.isempty() then
		MODEL.screen.filter_unique_by_index(2)
		MODEL.screen.set_current_icongroup("poi")
		local iconbmp, iconphase
		for item in ModelList_iter(MODEL.screen.icons) do
			iconbmp, iconphase = MODEL.screen.get_icon_file_and_phase(item(), 2)
			if not (string.sub(iconbmp,1,1) == "*" or string.sub(iconbmp,1,1) == ";") then
				ui.list_wScreenIcons:add({bmp=iconbmp, phase=iconphase, icon=item()})
			end
		end
		ui.list_wScreenIcons:sort("phase")
		ui.list_wScreenIcons:sort("bmp")
	end
	sc_NextStateAnim(st_ManagePOIGroupIcon, "horz_scroll", 1, "")
end

sc_CurrentPoiGroupIconSelected = function()
	if wGroupIcon then
		MODEL.lua.wSettingDistVisual = MODEL["*"].icon()
	else
		MODEL.my.poi.current.icon = MODEL["*"].icon()
	end
	sc_back()
end

createState("st_ManagePOIGroupVisibility")
st_ManagePOIGroupVisibility:useLayers(backgroundLayers, "ui_ManagePOIGroupVisibility")
st_ManagePOIGroupVisibility.init = function()
	txtTitle.TEXT = m_i18n("Set Place Visibility")
	local ind = -1
	local distance_list = MODEL.ui.lm_ManagePOIGroupVisibility.list
	distance_list[distance_list.lastindex()].distance = MODEL.lua.wPoiGroupAltitude()
	for item,index in ModelList_iter(distance_list) do
		if item.distance() == MODEL.lua.wPoiGroupAltitude() then
			ind = index
			break
		end
	end
	distance_list.setcurrent(ind)
	if ind ~= distance_list.lastindex() then
		distance_list[distance_list.lastindex()].distance = 30000
	end
end
 
st_ManagePOIGroupVisibility.exit = function()
	sc_wUserPOISearchParams_CheckRemoved()
end
 
createState("st_ManagePOIGroupIcon")
st_ManagePOIGroupIcon:useLayers(backgroundLayers, "ui_ManagePOIGroupIcon")
st_ManagePOIGroupIcon.init = function()
	txtTitle.TEXT = m_i18n("Select Place Icon")
end
 
st_ShowPOIInfo.enter = function()
	wCurrentGroupFav = MODEL.poi.find_group(FavGroup)
end
local st_ShowPOIInfo_init_orig = st_ShowPOIInfo.init
st_ShowPOIInfo.init = function()
	wCurrentPoiPicture = L""
	st_ShowPOIInfo_init_orig()
end
 
sc_Poi_Visibilities = function()
	sc_ForcePoiInit()
	sc_SetPoiVisibilities()
	MODEL.poi.structure.reset()
	MODEL.poi.structure.clear_providers()
	MODEL.poi.structure.add_provider(gROPoi_Provider)
	MODEL.poi.structure.add_provider(MODEL.poi.find_provider("kmlpoi"))
	MODEL.poi.structure.add_provider(gUserPOI_Provider)
	MODEL.poi.structure.add_provider(MODEL.poi.find_provider("picturepoi"))
	MODEL.lua.poi.selectedPOIVis = MODEL.poi.structure.visibility_array()
	MODEL.poi.structure.sort = "name"
	MODEL.poi.structure.execute()
	sc_NextStateAnim(st_POIVisibilities, "horz_scroll", 1, "")
end

sc_AddPOI = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	sc_wPOIStructureMainReset(false)
	sc_NextStateAnim(st_AddPOI, "fade", 1, "")
end

createState("st_AddPOI")
st_AddPOI:useLayers(backgroundLayers, "ui_List_Background", "ui_AddPOI")
st_AddPOI.enter = function()
	EPoiScrollPos = {}
end

st_AddPOI.init = function()
	sc_wSetTitle_AP()
end

sc_Structure_ToChildAP = function()
	table.insert(EPoiScrollPos, MODEL.ui.lst_AP.scroll_pos())
	local structure = MODEL.poi.structure
	structure.group_list.index = index
	structure.to_child()
	structure.execute()
	MODEL.ui.lst_AP.scroll_pos = 0
	sc_wSetTitle_AP()
end

sc_Structure_ToParentAP = function()
	local structure = MODEL.poi.structure
	local LastScrollPos = EPoiScrollPos[table.maxn(EPoiScrollPos)]
	table.remove(EPoiScrollPos)
	structure.to_parent()
	structure.execute()
	sc_wSetTitle_AP()
	doDelayed(1, function() MODEL.ui.lst_AP.scroll_pos = LastScrollPos end)
end

sc_wSetTitle_AP = function()
	local title = translate(m_i18n("Add POI")) .. (MODEL.poi.structure.parent_name() and L" - " or L"") .. MODEL.poi.structure.parent_name()
	local titlealt = translate(m_i18n("Select group")) .. (MODEL.poi.structure.parent_name() and L" - " or L"") .. MODEL.poi.structure.path_text()
	txtTitle.TEXT = vActiveState() == "st_addpoi" and title or titlealt
end

sc_CreateNewGroupMainAP = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = L""
	inpSI_Text.EMPTYTITLE	= m_i18n("<Enter new POI group name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_CreateNewGroupDoneAP
	inputFieldRequired = true
	txtTitle.TEXT = m_i18n("Create POI Group")
	MODEL.lua.wLocalMenuHide = true
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
	MODEL.regional.keyboard.load_panel_by_name(L"QWERTY")
end
 
sc_CreateNewGroupDoneAP = function()
	name = ui.inpSI_Text.VALUE()
	if name == L"" then
		name = L"<New Group>"
	end
	name = "@"..tostring(name)
	name = m_i18n(name)
	MODEL.my.poi.add_group(MODEL.poi.structure.search_root(), gUserPOI_Provider, name)
 	MODEL.poi.structure.execute()
	sc_back()
end
 
sc_AddPOIToGroupMain = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = L""
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter new POI name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_SetNewPOIName
	inputFieldRequired = true
	txtTitle.TEXT = m_i18n("Create POI")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end

sc_SetNewPOIName = function()
	local name = ui.inpSI_Text.VALUE()
	if name == L"" then
		name = L"<New POI>"
	end
	MODEL.my.poi.add_poi_selected(MODEL.poi.structure.search_root(), gUserPOI_Provider)
	MODEL.my.poi.current.name = name
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	sc_SelectSavedFavorites()
	if st_ShowPOIInfo.isEntered then
		CLEARTOSTATE(st_ShowPOIInfo)
	else
		sc_back()
		sc_wToParentLast()
		sc_back()
		sc_NextStateAnim(st_ShowPOIInfo, "fade", 1, "")
	end
end

sc_ModifyPOINameMain = function()
	sc_close_local_menu()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = MODEL.my.poi.current.name()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter new POI name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_ModifyPOIName
	inputFieldRequired = true
	txtTitle.TEXT = m_i18n("New POI name")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end

sc_ModifyPOIName = function()
	local name = ui.inpSI_Text.VALUE()
	if name == L"" then
		name = L"<New POI>"
	end
	MODEL.my.poi.current.name = name
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	sc_back()
end
sc_ModifyPOIInfoMain = function()
	sc_close_local_menu()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text:MAXLENGTH(100)
	inpSI_Text.VALUE = MODEL.my.poi.current.address.ext()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter new POI Info>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_ModifyPOIInfoDone
	inputFieldRequired = false
	txtTitle.TEXT = m_i18n("New POI Info")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end

sc_ModifyPOIInfoDone = function()
	MODEL.my.poi.current.address.ext = ui.inpSI_Text.VALUE()
	sc_back()
end

sc_wLMDeletePOI = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete this POI?"),"sc_wLMDeletePOI_OK", m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL.my.map.selected_item.name())
end
 
sc_wLMDeletePOI_OK = function()
	MODEL.my.poi.current.remove()
	MODEL.poi.resultpoi.clear()
	MODEL.my.map.select_address(MODEL.map.cursor.position())
	sc_ResetStrappedCursor()
	if vActiveState() == "st_easynav" then
		sc_start_ExitDragMode()
	end
end

sc_wLMDeletePOIfromInfo = function()
	sc_close_local_menu()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete this POI?"),"sc_wLMDeletePOIfromInfo_OK", m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL.my.poi.current.name())
end
 
sc_wLMDeletePOIfromInfo_OK = function()
	sc_back()
	MODEL.my.poi.current.remove()
	if vActiveState() == "st_poiselectiononmapresult" then
		sc_back()
	end
	if vActiveState() == "st_easynav" then
		MODEL.poi.resultpoi.clear()
		MODEL.my.map.select_address(MODEL.map.cursor.position())
		sc_start_ExitDragMode()
		sc_ResetStrappedCursor()
	end
end

sc_wRenamePoiGroup = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = L""
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter new POI group name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_wRenamePoiGroupDone
	inputFieldRequired = true
	txtTitle.TEXT = m_i18n("Rename POI Group")
	MODEL.lua.wLocalMenuHide = true
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
	MODEL.regional.keyboard.load_panel_by_name(L"QWERTY")
end
 
sc_wRenamePoiGroupDone = function()
	name = ui.inpSI_Text.VALUE()
	if name == L"" then
		name = L"<New Group>"
	end
	MODEL.lua.wSettingDistSoundName = name
	sc_back()
end
 
sc_DeletePoiGroup = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete Group and all POIs in this Group?"),"sc_DeletePoiGroupDone", m_i18n("Delete"),"ico_DeleteAll_mid.bmp#3")
end

sc_DeletePoiGroupDone = function()
	MODEL.my.poi.delete_content(wCurrentGroup, gUserPOI_Provider)
	MODEL.my.poi.delete_group(wCurrentGroup, gUserPOI_Provider)
	MODEL.poi.structure.execute()
	sc_back()
end

sc_StructSearch_OnPoiItemClicked = function()
	local currentPoi = MODEL["*"]
	gPOIProvider_save = currentPoi.provider_id()
	gPOIId_save = currentPoi.id()
	gStructSearchHasSelectedPOI = true
	MODEL.my.poi.select_poi(gPOIProvider_save, gPOIId_save)
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	MODEL.poi.resultpoi.clear()
	MODEL.poi.resultpoi.add_poi_by_id(currentPoi.provider_id(), currentPoi.id())
	PoiSelected = true
	if wFind_createroute then
		sc_FindOnMap_Select_onrelease()
	else
		sc_NextStateAnim(st_FindOnMap, "horz_scroll", 1, "")
	end
end
 
sc_FlatSearch_OnPoiItemClicked = function(thisPOI)
	local currentPoi = thisPOI ~= nil and thisPOI or MODEL["*"]
	MODEL.my.poi.select_poi(currentPoi.provider_id(), currentPoi.id())
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	MODEL.poi.resultpoi.clear()
	MODEL.poi.resultpoi.add_poi_by_id(currentPoi.provider_id(), currentPoi.id())
	PoiSelected = true
	MODEL.map.primary.clear_clicked_lists()
	if MODEL.lua.VRStatus() ~= eVRStatus.inactive or wFind_createroute then
		sc_FindOnMap_Select_onrelease()
	else
		sc_NextStateAnim(st_FindOnMap, "horz_scroll", 1, "")
	end
end
 
local st_FindPlaces_init_orig = st_FindPlaces.init
st_FindPlaces.init = function()
	st_FindPlaces_init_orig()
	sc_wUserQuickSearchesForButtons()
end
 
sc_wUserQuickSearchesForButtons = function()
	for i = 0, 3 do
		sc_SetupQuickSearchAreas(MODEL.poi["wuser_find_places_quick" .. tostring(i)](), MODEL.ui.lm_wuser_poi_search_params[i].distance())
		st_FindPlaces.Exec_Search(MODEL.poi["wuser_find_places_quick" .. tostring(i)]())
	end
end
 
sc_wUserPOISearchParams_Load = function()
	if MODEL.ui.lm_wuser_poi_search_params.list.size() ~= 4 then
		MODEL.ui.lm_wuser_poi_search_params.clear()
		ui.lm_wuser_poi_search_params:add({group=m_i18n("@My POI"), on_route=0, distance=1000})
		ui.lm_wuser_poi_search_params:add({group="Finance\1Cash_Dispenser", on_route=1, distance=1000})
		ui.lm_wuser_poi_search_params:add({group="Cafe_or_Bar", on_route=1, distance=1000})
		ui.lm_wuser_poi_search_params:add({group="Medical\1Pharmacy", on_route=1, distance=1000})
		MODEL.ui.lm_wuser_poi_search_params.save()
	end
end
 
sc_wUserPOISearchParams_CheckRemoved = function()
	local removed = false
	for i = 0, 3 do
		if MODEL.poi.find_group(MODEL.ui.lm_wuser_poi_search_params[i].group()) == -1 then
			MODEL.ui.lm_wuser_poi_search_params[i].group = (i == 0 and "Petrol_Station" or (i == 1 and "Finance\1Cash_Dispenser" or (i == 2 and "Cafe_or_Bar" or "Accommodation")))
			MODEL.ui.lm_wuser_poi_search_params[i].on_route = true
			MODEL.ui.lm_wuser_poi_search_params[i].distance = 1500
			removed = true
		end
	end
	if removed then
		MODEL.ui.lm_wuser_poi_search_params.save()
	end
end
 
sc_wbtnFP_Searches_GetIcon = function(group)
	MODEL.my.poi.select_group(MODEL.poi.find_group(group))
	return MODEL.my.poi.current_group.icon()
end
 
sc_wbtnFP_Searches_GetName = function(group)
	MODEL.my.poi.select_group(MODEL.poi.find_group(group))
	return MODEL.my.poi.current_group.name()
end
 
sc_Search_For_wbtnFP = function()
	local flat_search = MODEL.poi.flat_search
	flat_search.reset()
	flat_search.max_result = 100
	flat_search.center = MODEL["*"].on_route() and MODEL.route.list.navigated.has_navigable_path() and "route" or "destination"
	flat_search.distance_on_route = MODEL["*"].on_route() and MODEL.route.list.navigated.has_navigable_path() and "enabled" or "disabled"
	flat_search.calculate_detour = MODEL["*"].on_route() and MODEL.route.list.navigated.has_navigable_path() and "forced" or "disabled"
	flat_search.search_root = MODEL.poi.find_group(MODEL["*"].group())
	sc_SetupQuickSearchAreas(MODEL.poi.flat_search(), MODEL["*"].distance())
	flat_search.sort = "multi_sort:igo9_specialpoi_first+" .. (MODEL["*"].on_route() and MODEL.route.list.navigated.has_navigable_path() and "detour_group" or "distance")
	st_FindPlaces.Exec_Search(flat_search)
	sc_NextStateAnim(st_FindPOIFlatList, "horz_scroll", 1, "")
end
 
sc_Setup_For_wbtnFP = function()
	MODEL.lua.wSettingDistIcon = index
	MODEL.lua.wSettingDistOn = MODEL["*"].on_route()
	MODEL.lua.wSettingDistVisual = MODEL["*"].distance()
	MODEL.lua.wUserPOIParamsPOIGroup = MODEL["*"].group()
	sc_NextStateAnim(st_wUserPOISearchParamsSettings, "horz_scroll", 1, "")
end
 
createState("st_wUserPOISearchParamsSettings")
st_wUserPOISearchParamsSettings:useLayers(backgroundLayers, "ui_wUserPOISearchParamsSettings")
st_wUserPOISearchParamsSettings.init = function()
	txtTitle.TEXT = m_i18n("User quick search settings")
end
 
st_wUserPOISearchParamsSettings.exit = function()
	local param = MODEL.ui.lm_wuser_poi_search_params[MODEL.lua.wSettingDistIcon()]
	param.on_route = MODEL.lua.wSettingDistOn()
	param.distance = MODEL.lua.wSettingDistVisual()
	MODEL.ui.lm_wuser_poi_search_params.save()
	local search = MODEL.poi["wuser_find_places_quick" .. tostring(MODEL.lua.wSettingDistIcon())]
	search.center = param.on_route() and "route" or "destination"
	search.area = param.distance()
	search.search_root = MODEL.poi.find_group(param.group())
end
 
sc_wUserPOISearchParamsGroupStartSelect = function()
	sc_wSplitScreenPOIGroupPreStartSelect()
	MODEL.lua.wUserPOIParamsPOIGroup = MODEL.ui.lm_wuser_poi_search_params[MODEL.lua.wSettingDistIcon()].group()
	sc_NextStateAnim(st_wUserPOISearchParamsPOIGroupSettings, "fade", 1, "")
end
 
createState("st_wUserPOISearchParamsPOIGroupSettings")
st_wUserPOISearchParamsPOIGroupSettings:useLayers(backgroundLayers, "ui_List_Background", "ui_AddPOI")
st_wUserPOISearchParamsPOIGroupSettings.enter = function()
	EPoiScrollPos = {}
end

st_wUserPOISearchParamsPOIGroupSettings.init = function()
	sc_wSetTitle_AP()
end

sc_wUserPOISearchParamsPOIGroupSelectStart = function()
	MODEL.lua.wUserPOIParamsPOIGroup = MODEL["*"].path()
end
 
sc_wUserPOISearchParamsPOIGroupSelectDone = function()
	MODEL.ui.lm_wuser_poi_search_params[MODEL.lua.wSettingDistIcon()].group = MODEL.lua.wUserPOIParamsPOIGroup()
	sc_wToParentLast()
	sc_back()
end
 
sc_wToParentLast = function()
	local structure = MODEL.poi.structure
	while structure.to_parent.valid() do
		structure.to_parent()
		structure.execute()
	end
end
 
sc_wUserPOIParamsPOIGroupChildIsSelected = function(selectedGroup, currentID)
	return MODEL.poi.is_group_descendant_of(MODEL.poi.find_group(selectedGroup), currentID)
end
 
sc_wPOIStructureMainReset = function(pictures)
	sc_ForcePoiInit()
	MODEL.poi.structure.reset()
	MODEL.poi.structure.clear_providers()
	MODEL.poi.structure.add_provider(gROPoi_Provider)
	MODEL.poi.structure.add_provider(MODEL.poi.find_provider("kmlpoi"))
	MODEL.poi.structure.add_provider(gUserPOI_Provider)
	if pictures then
		MODEL.poi.structure.add_provider(MODEL.poi.find_provider("picturepoi"))
	end
	MODEL.poi.structure.sort = "name"
	MODEL.poi.structure.execute()
end

sc_wChangePOIGroup = function()
	sc_close_local_menu()
	sc_wPOIStructureMainReset(false)
	sc_NextStateAnim(st_wChangePOIGroup, "fade", 1, "")
end

sc_wChangePOIGroupDone = function()
	MODEL.my.poi.current.set_group(MODEL.poi.structure.search_root())
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	sc_wToParentLast()
	sc_back()
end

createState("st_wChangePOIGroup")
st_wChangePOIGroup:useLayers(backgroundLayers, "ui_List_Background", "ui_AddPOI")
st_wChangePOIGroup.enter = function()
	EPoiScrollPos = {}
end

st_wChangePOIGroup.init = function()
	sc_wSetTitle_AP()
end

sc_SelectGlobalSearchAroundAreaDone = function()
	if not inpValueInteger_isempty() then
		MODEL.lua.wGlobalSearchAroundArea = float.toInt(float.new(tostring(ui.inpValueInteger.VALUE()))/ wUnitConvMeter2Unit[MODEL.INT.regional.units() + 1])
		gGlobalSearchAroundArea = MODEL.lua.wGlobalSearchAroundArea()
	end
	sc_back()
end
 
local sc_OtherPoi_SetupSearch_orig = sc_OtherPoi_SetupSearch
sc_OtherPoi_SetupSearch = function()
	sc_OtherPoi_SetupSearch_orig()
	if selectedSearchCenter ~= ESearchCenter.around_route then
		MODEL.poi.struct_search.area = MODEL.lua.wOtherSearchAroundArea()
	end
end
local sc_CollectPoiContacts_orig = sc_CollectPoiContacts
sc_CollectPoiContacts = function(poi)
	sc_CollectPoiContacts_orig(poi)
	if MODEL.EXISTS.my.poi.current.ext_haspicture() and poi.ext_haspicture() then
		wCurrentPoiPicture = L"%root%\\" .. MODEL.WSTR.my.poi.current.ext_picturefilepath() .. L"\\" .. MODEL.WSTR.my.poi.current.ext_picturefilename()
		ui.lm_poiInfoContacts:add({category = "", text = MODEL.WSTR.my.poi.current.ext_picturefilename(), web = false, picture = true})
	end
end
 
sc_wHidePoiPicture = function()
	ui_wShowPoiPicture:HIDE()
end
 
sc_Go_PicturePoiList = function()
	sc_close_local_menu()
	sc_ExecuteFlatSearch(poi_search_params.picturepoi_search)
	MODEL.lua.wInPicturePOIList = true
	st_FindPOIFlatList:removeLayers("ui_FindPOIFlatList", "ui_ModeVR", "ui_List_Background")
	st_FindPOIFlatList:useLayers("ui_wFindPOIFlatListPictures")
	sc_NextStateAnim(st_FindPOIFlatList, "fade")
end
 
local st_FindPOIFlatList_exit_orig = st_FindPOIFlatList.exit
st_FindPOIFlatList.exit = function()
	st_FindPOIFlatList_exit_orig()
	if MODEL.lua.wInPicturePOIList() then
		st_FindPOIFlatList:useLayers("ui_FindPOIFlatList", "ui_ModeVR", "ui_List_Background")
		st_FindPOIFlatList:removeLayers("ui_wFindPOIFlatListPictures")
		MODEL.lua.wInPicturePOIList = false
	end
end
 
sc_wGetBMPFindPOIFlatListPictures = function()
	MODEL.my.poi.select_poi(MODEL["*"].provider_id(), MODEL["*"].id())
	return L"%root%\\" .. MODEL.WSTR.my.poi.current.ext_picturefilepath() .. L"\\" .. MODEL.WSTR.my.poi.current.ext_picturefilename()
end
 
sc_wPoiSearch_PostFilter_ClearFilterString = function()
	sc_close_local_menu()
	sc_PoiSearch_PostFilter_ClearFilterString()
end
 
sc_wFlatSearch_PostFilter_OnRelease = function()
	sc_close_local_menu()
	sc_FlatSearch_PostFilter_OnRelease()
end
 
sc_FlatSearch_SetPoiProviderFilter = function(provider_id)
	if gLastProviderID == provider_id then
		return 
	end
	gLastProviderID = provider_id
	local flat_search = MODEL.poi.flat_search
	flat_search.clear_providers()
	flat_search.exclude_provider = false
	flat_search.add_provider(provider_id)
	if provider_id == gROPoi_Provider then
		flat_search.add_provider(MODEL.poi.find_provider("kmlpoi"))
		flat_search.add_provider(gUserPOI_Provider)
	end
	flat_search.execute()
end
 
local wProvider_Filtering = sc_GetSysEntry("poi", "provider_filtering", 1)
local wKMLAsLogicalProvider = sc_GetSysEntry("poi", "kml_as_logical_provider", 0)
sc_wCheckKMLIsLogicalProvider = function(kml)
	local kml_select = wKMLAsLogicalProvider and kml and 1 or 0
	MODEL.ui.lm_POI_ProviderAll.resize(kml_select + 1)
	MODEL.lua.PoiProviderFiltering = wProvider_Filtering and (#MODEL.poi.logical_providers + kml_select) > 1
end
 
local sc_PoiInitialized_orig = sc_PoiInitialized
sc_PoiInitialized = function()
	sc_PoiInitialized_orig()
	sc_wCheckKMLIsLogicalProvider(not st_wMultiFind.isEntered)
end
 
sc_SetFavoritesVisibility = function() end
 
--route.lua
wBlockedFromCockpit = false
wNeedDestinationTimer = nil
wDestinationBackIdleTimer = nil
wavoideduid = nil
wavoidedmessage_id = -1
wTrackStartTime = TIMETYPE.new({hour = 0, min = 0, sec = 0, millisec = 0})
wTrackPlayingTotalDistance = 0
wTrackPlayingTotalTime = TIMESPAN.new(0)
wTrackPlayingMaxSpeed = 0
wTrackPlayingFactor = SysConfig:get("navigation", "track_simulation_speed", 2)
wTrackPlayingSeconds = 1000
sc_wGetTripComputerName = function(i)
	return (i==0 and translate(m_i18n("TRACK_TIME~Current Route")) or (i==1 and translate(m_i18n("TRACK_TIME~Statistics")) or translated_format(m_i18n("TRACK_TIME~User Trip %s"), towstring(i-1))))
end
 
sc_wTripComputer_OnRelease = function()
	sc_NextStateAnim(st_wTripComputer, "fade", 1, "")
end
 
createState("st_wTripComputer")
st_wTripComputer:useLayers(backgroundLayers, "ui_wTripComputer")
st_wTripComputer.init = function()
	txtTitle.TEXT = m_i18n("Trip Computer")
end
 
sc_wTripComputerPause = function()
	MODEL.other.trips[index].pause()
end
 
sc_wTripComputerReset = function()
	sc_wShowNewMessageBox(m_i18n("This will reset this trip."),"sc_wTripComputerResetOK", m_i18n("Trip~Reset"),"ico_done_mid.bmp#3")
end
 
sc_wTripComputerResetOK = function()
	MODEL.other.trips[MODEL.other.trips.index()].reset()
end
 
sc_route_finished_Speedcheck = function()
	if MODEL.navigation.car.current_speed() < MODEL.lua.wDestinationSpeed() and not MODEL.route.list.navigated.calculating() then
		gIdleTime_SpeedCheckTime = gIdleTime_SpeedCheckTime + 1
	else
		gIdleTime_SpeedCheckTime = 0
	end
	if gIdleTime_SpeedCheckTime > 5 then
		if MODEL.lua.wDestinationMessage() then
			sc_route_finished_UIObserver()
		else
			sc_GotoDestinationMenu()
		end
		obs_destination_speedcheck:STOP()
	end
end
 
sc_GotoDestinationMenu = function()
	if not MODEL.other.trips[0].paused() then
		MODEL.other.trips[0].pause()
	end
	if MODEL.mydata.tracks.record_auto_track() then
		sc_SplitTrackLog()
	end
	ui.vDestinationReachedPopoUpID = -1
	if gArrivedAtParking then
		MODEL.navigation.parking_ad.wait_for_dest()
	else
		sc_DeleteRouteKeepStart()
	end
	gEnableSummaryInDestinationMenu = true
	MODEL.lua.DestinationMenuShown = false
	MODEL.lua.ShowTripInfo_automotive = true
	if not MODEL.lua.wDestinationMenu() then
		return
	elseif MODEL.lua.automotive() then
		MODEL.ui.vTripLogSavedAtDestination = false
		sc_NextStateAnim(st_trackinfo, "horz_scroll", 1, "")
	else
		sc_NextStateAnim(st_DestinationMenu, "horz_scroll", 1, "")
	end
end
 
local st_DestinationMenu_enter_orig = st_DestinationMenu.enter
st_DestinationMenu.enter = function()
	st_DestinationMenu_enter_orig()
	wNeedDestinationTimer = not MODEL.lua.DestinationMenuShown()
end
 
st_DestinationMenu:removeLayers(localMenuLayers)
st_DestinationMenu.init = function()
	MODEL.screen.msgbox.pause()
	txtTitle.TEXT = MODEL.lua.DestinationMenuShown() and m_i18n("External power removed.") or m_i18n("Destination Menu")
	if wNeedDestinationTimer then
		wDestinationBackIdleTimer = 0
		obs_wDestinationBackTimer:START("NO_TRIGGER")
		MODEL.ui._reset_idle_timer()
	end
end
 
sc_CheckDestinationBackIdleTimer = function()
	if wDestinationBackIdleTimer > MODEL.ui._idle_time() then
		obs_wDestinationBackTimer:STOP()
		wNeedDestinationTimer = false
	elseif MODEL.ui._idle_time() >= MODEL.lua.wDestinationMenuTimer() then
		sc_CheckDestinationBackIdleTimerDone()
	else
		wDestinationBackIdleTimer = MODEL.ui._idle_time()
	end
end
 
sc_CheckDestinationBackIdleTimerDone = function()
	obs_wDestinationBackTimer:STOP()
	wNeedDestinationTimer = false
	if MODEL.lua.wDestinationMenu() == 1 then
		MODEL.power.shutdown()
	elseif MODEL.lua.wDestinationMenu() == 2 then
		sc_DoExit()
	end
end
 
sc_wGetDestinationBackText = function()
	if MODEL.ui._idle_time() == 0 or not wNeedDestinationTimer then
		return m_i18n("Back")
	end
	return translated_format(m_i18n("Back (%s)"), towstring(MODEL.lua.wDestinationMenuTimer() - MODEL.ui._idle_time()))
end
 
sc_wGetDestinationAutoActionText = function()
	if MODEL.ui._idle_time() == 0 or not wNeedDestinationTimer then
		return translated_format(m_i18n("\fnYou have arrived at: \fb%s."), MODEL.lua.LastDestination())
	end
	if MODEL.lua.wDestinationMenu() == 2 then
		return translated_format(m_i18n("\fnYou have arrived at: %s. The program will exit in \fb%s \fnseconds."), MODEL.lua.LastDestination(), towstring(MODEL.lua.wDestinationMenuTimer() - MODEL.ui._idle_time()))
	elseif MODEL.lua.wDestinationMenu() == 1 then
		return translated_format(m_i18n("\fnYou have arrived at: %s. The device will turn off in \fb%s \fnseconds."), MODEL.lua.LastDestination(), towstring(MODEL.lua.wDestinationMenuTimer() - MODEL.ui._idle_time()))
	end
end
 
sc_wSettingsDestination_Enter = function()
	sc_NextStateAnim(st_wSettingsDestination, "horz_scroll", 1, "")
end
 
createState("st_wSettingsDestination")
st_wSettingsDestination:useLayers(backgroundLayers, "ui_List_Background", "ui_wSettingsDestination")
st_wSettingsDestination.init = function()
	txtTitle.TEXT = m_i18n("Arriving Destination")
end
 
createState("st_wSimulateFromCockpit")
st_wSimulateFromCockpit.init = function()
	if gSimulationEndPrevstate then
		sc_Simulate_Navigation()
	else
		doDelayed(1, function() CLEARTOSTATE(st_EasyNav) end)
	end
end
 
st_SetBlockedRoads:removeLayers(localMenuLayers)
st_SetBlockedRoads.init = function()
	txtTitle.TEXT = m_i18n("Blocked Roads")
end
 
st_ChangeBlockedRoad.exit = function()
	wBlockedFromCockpit = false
end
 
sc_ChangeBlockedRoadOK_onrelease = function()
	sc_BlockedRoadsData_SaveToCurrent()
	if wBlockedFromCockpit then
		MODEL.lua.newBlockedSection = false
		sc_back()
		return
	end
	CLEARTOSTATE(st_FindOnMap)
	if st_FindOnMap.isEntered then
		CLEARTOSTATE(st_FindOnMap)
	else
		CLEARTOSTATE(st_SetBlockedRoads)
	end
	MODEL.lua.newBlockedSection = false
end
 
sc_DelBlockedRoadsMSG = function()
	sc_wShowNewMessageBox(m_i18n("Delete all roadblocks?"),"sc_DelBlockedRoads", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_LMBlockRoadCurrentUsage = function()
	wBlockedFromCockpit = true
	sc_LMBlockRoadCurrentUsageFind()
end
 
sc_LMBlockRoadCurrentUsageFind = function()
	if sc_wBlockRoadCurrentItemFind() then
		sc_BlockedRoadsData_LoadFromCurrent()
		sc_NextStateAnim(st_ChangeBlockedRoad, "fade", 1, "")
	else
		sc_NextStateAnim(st_SetBlockedRoads, "fade", 1, "")
	end
end
 
sc_wBlockRoadCurrentItemFind = function()
	MODEL.route.add_roadblock(MODEL.map.cursor.position(), true, true)
	MODEL.mydata.blocked_roads.current_weekdays_all_blocked(false)
	MODEL.mydata.blocked_roads.list.setcurrent(0)
	local topLeftNeed, bottomRightNeed = MODEL.mydata.blocked_roads.get_boundrect()
	local topLeft, bottomRight
	local successfind = false
	MODEL.mydata.blocked_roads.delete_current()
	for i = 0, MODEL.mydata.blocked_roads.list.size() - 1 do
		MODEL.mydata.blocked_roads.list.setcurrent(i)
		topLeft, bottomRight = MODEL.mydata.blocked_roads.get_boundrect()
		if topLeft == topLeftNeed and bottomRight == bottomRightNeed then
			successfind = true
			break
		end
	end
	return successfind
end
 
sc_wDeleteSegmentMSG = function()
	sc_wShowNewMessageBox(m_i18n("Delete this roadblock?"),"sc_wDeleteSegment", m_i18n("Delete"),"ico_Delete_mid.bmp#3")
end
 
sc_wDeleteSegment = function()
	if sc_wBlockRoadCurrentItemFind() then
		MODEL.mydata.blocked_roads.delete_current()
	else
		MODEL.route.remove_roadblock(MODEL.map.cursor.position())
		MODEL.route.recalculate()
	end
	sc_wBlockCheck()
end
 
createState("st_wBlockedRoadItem")
st_wBlockedRoadItem:useLayers(backgroundLayers, "ui_BlockedRoadItem")
st_wBlockedRoadItem.enter = function()
	sc_BlockedRoadsData_LoadFromCurrent()
end
 
st_wBlockedRoadItem.init = function()
	txtTitle.TEXT = m_i18n("Blocked Road")
end
 
sc_wDelBlockedRoad = function()
	sc_wShowNewMessageBox(m_i18n("Delete this roadblock?"),"sc_DelBlockedRoadOK", m_i18n("Delete"),"ico_Delete_mid.bmp#3")
end
 
sc_DelBlockedRoadOK = function()
	MODEL.mydata.blocked_roads.delete_current()
	sc_back()
	if MODEL.mydata.blocked_roads.list.isempty() then
		sc_back()
	end
end
 
sc_BlockRoadSectionPermanent = function()
	MODEL.route.add_roadblock(MODEL.map.cursor.position(), true, true)
	MODEL.mydata.blocked_roads.current_weekdays_all_blocked(true)
	sc_wBlockCheck()
end
 
sc_BlockRoadSectionPermanent_lc = function()
	MODEL.route.add_roadblock(MODEL.map.cursor.position(), true, true)
	MODEL.lua.newBlockedSection = true
	CLEARTOSTATE(st_FindOnMap)
	sc_NextStateAnim(st_ChangeBlockedRoad, "fade", 1, "" )
end
 
sc_BlockedRoadDays_SetDay = function(day_index)
	if MODEL.ui.blocked_roads_dayusage[day_index].usage() == 0 then
		blocked_roads.dayranges[day_index] = {Range1 = {Start = 0, End = 24}, Range2 = {Start = -1, End = -1}}
	else
		blocked_roads.dayranges[day_index] = {Range1 = {Start = -1, End = -1}, Range2 = {Start = -1, End = -1}}
	end
	sc_BlockedRoadsData_RefreshDayUsage(day_index)
end
 
sc_BlockedRoadsData_RefreshDayUsage = function(day_index)
	local weekday = blocked_roads.dayranges[day_index]
	if weekday.Range1.Start == -1 then
		MODEL.ui.blocked_roads_dayusage[day_index].usage = blocked_roads.usage.off
	elseif weekday.Range1.Start == 0 and weekday.Range1.End == 24 then
		MODEL.ui.blocked_roads_dayusage[day_index].usage = blocked_roads.usage.full_time
	else
		MODEL.ui.blocked_roads_dayusage[day_index].usage = blocked_roads.usage.part_time
	end
end
 
sc_BlockedRoadDays_ChangeTime = function(day_index)
	MODEL.mydata.blocked_roads.current_weekdays.index = day_index
	MODEL.ui.blocked_roads_dayusage.index = day_index
	sc_NextStateAnim(st_SetBlockingTime, "fade", 1, "" )
end
 
sc_wGetBlockRoadStatus = function()
	local text = ""
	if not MODEL.mydata.blocked_roads.list[MODEL.mydata.blocked_roads.list.index()].is_permanent() then
		text = "blocked for current route"
	else
		for day_index = 0, 6 do
			if MODEL.ui.blocked_roads_dayusage[day_index].usage() ~= blocked_roads.usage.full_time then
				text = "intermittently blocked"
			end
		end
		if text == "" then
			text = "completely blocked"
		end
	end
	return text
end
 
sc_wSimulate_Navigation_OnRelease_Quick_menu = function()
	gSimulationEndPrevstate = true
	sc_NextStateAnim(st_wSimulateFromCockpit, "fade", 1, "")
end
 
sc_3DFlyOverModeOff_Easy = function()
	obs_flyover_stopped:STOP()
	MODEL.navigation.autoreplan = true
	MODEL.route.list.navigated.waypoints.autocreate_start = MODEL.navigation.autoreplan()
	if MODEL.lua.simulateIsDemo() then
		MODEL.lua.simulateIsDemo = false
		MODEL.route.list.navigated.clear()
	else
		primary:ONMAPCLICK(sc_EasyMapClick)
	end
	if MODEL.lua.wSimulateIsTrackPlaying() then
		MODEL.route.list.wblockroute.clear()
		MODEL.route.load_from_buffer(true)
		sc_CheckOffroadParams()
		sc_UpdateRouteParams()
		MODEL.route.list.navigated.settings.check_consistency_with_global_settings()
		MODEL.lua.wSimulateIsTrackPlaying = false
	end
	local primary = MODEL.map.primary
	if primary.state() == "simulate_2d_nu" or primary.state() == "simulate_2d" or primary.state() == "simulate" then
		obs_enter_drag_mode:STOP()
		primary.exit_state()
		obs_enter_drag_mode:START("NO_TRIGGER")
	end
	if gSimulationEndPrevstate then
		gSimulationEndPrevstate = false
		sc_back()
	end
	if gDetourAcceptanceMode_BeforeSimulation ~= -1 then
		MODEL.traffic.settings.detour_acceptance_mode = gDetourAcceptanceMode_BeforeSimulation
		gDetourAcceptanceMode_BeforeSimulation = -1
	end
	MODEL.screen.msgbox.switch_on()
end
 
sc_GetStartTimeText = function(hour, minute)
	local time = TIMETYPE.new({hour = hour, min = minute, sec = 0, millisec = 0})
	return builtin.format(L"%{time}", time)
end
 
sc_GetBlockRoadTimeTwoLines = function(day_index)
	local first, second = 0, 0
	if blocked_roads.dayranges[day_index].Range1.End > 0 then
		first = blocked_roads.dayranges[day_index].Range1.Start ~= blocked_roads.dayranges[day_index].Range1.End and 10 or 0
		second = blocked_roads.dayranges[day_index].Range2.Start ~= blocked_roads.dayranges[day_index].Range2.End and blocked_roads.dayranges[day_index].Range2.End > 0 and 1 or 0
	end
	return (first + second)
end
 
sc_GetBlockRoadTimeLine = function(day_index, interval)
	if interval == 1 then
		return (Format_Timespan(TIMESPAN.new(blocked_roads.dayranges[day_index].Range1.Start * 3600 * 1000), 5) .. L" - " .. Format_Timespan(TIMESPAN.new(blocked_roads.dayranges[day_index].Range1.End * 3600 * 1000), 5))
	elseif interval == 2 then
		return (Format_Timespan(TIMESPAN.new(blocked_roads.dayranges[day_index].Range2.Start * 3600 * 1000), 5) .. L" - " .. Format_Timespan(TIMESPAN.new(blocked_roads.dayranges[day_index].Range2.End * 3600 * 1000), 5))
	end
end
 
sc_GetBlockRoadTimeOneLine = function(day_index)
	if sc_GetBlockRoadTimeTwoLines(day_index) == 0 then
		return "no blocking"
	elseif sc_GetBlockRoadTimeTwoLines(day_index) == 1 then
		return sc_GetBlockRoadTimeLine(day_index, 2)
	elseif sc_GetBlockRoadTimeTwoLines(day_index) == 10 then
		return sc_GetBlockRoadTimeLine(day_index, 1)
	end
end
 
sc_RouteItinerMap_Fit = function()
	MODEL.map.primary.rotate = 0
	local fit_avoid = false
	if MODEL.lua.avoidActive() and not MODEL.route.list.temporary.waypoints.list.isempty() and MODEL.route.list.temporary.calculation_finished() and not MODEL.route.list.temporary.is_equal_to("navigated") then
		fit_avoid = sc_Avoid_Fit(sc_RouteItinerMap_GetAvoidBounds)
	end
	if not fit_avoid then
		local w_itiner = MODEL.route.list.navigated.itiner
		if not MODEL.lua.avoidActive() then
			w_itiner.highlight_clear()
			w_itiner.highlight_entry(w_itiner.list.current.INT.uid())
		end
		sc_FitItinerEntry(w_itiner.list.current)
	end
	MODEL.lua.TempMapCenter = MODEL.map.primary.center()
	MODEL.lua.TempMapZoom = MODEL.map.primary.zoom()
end
 
btn_AvoidSpecManeuver_Onrelease = function()
	MODEL.lua.InAvoidManeuver = true
	sc_NextStateAnim(st_AvoidItinerEntry, "fade", 1, "")
	MODEL.route.list.navigated.itiner.detailmode = "normal"
	txtTitle.TEXT = m_i18n("Avoid Specific Maneuver")
end
 
st_AvoidItinerEntry.exit = function()
	MODEL.lua.avoidActive = false
	MODEL.lua.InAvoidManeuver = false
end
 
sc_UpdateAvoidMenu = function()
	MODEL.lua.EnableAvoidSection = MODEL.route.list.navigated.itiner.get_list_size("warnings") > 0
	MODEL.lua.EnableAvoidRoad = MODEL.route.list.navigated.itiner.get_list_size("road") > 0
	MODEL.lua.EnableAvoidManeuver = MODEL.route.list.navigated.itiner.get_list_size("normal") > 0
end
 
st_RouteItinerMap.init = function()
	obs_center_follow:STOP()
	MODEL.map.arrow_needs_to_fade = false
	sc_PosRecalcLayer()
	local mapLayer = MODEL.map.primary
	mapLayer.save_state(mapLayer.state())
	mapLayer.enter_state("routemap")
	mapLayer.show_cursor = false
	primary:ONMAPCLICK()
	if MODEL.lua.avoidActive() then
		if not st_RouteItinerMap.init_on_enter then
			MODEL.route.list.navigated.copy_from("backup")
			MODEL.route.list.navigated.settings.check_consistency_with_global_settings()
			sc_UpdateOffroadModelsFromRoute()
		end
		mapLayer.highlight_color = "blocked_road"
		mapLayer.show_blocked_segments = not MODEL.lua.InAvoidManeuver()
		obs_temporary_route_calculated:ONSELECT(sc_RouteItinerMap_TempRouteUpdated)
		obs_temporary_route_calculated:START("NO_TRIGGER")
		gTmpSpeedcam = MODEL.warning.speedcam_warning()
		MODEL.warning.speedcam_warning = false
	end
	if MODEL.route.list.navigated.calculation_finished() then
		sc_RouteItinerMap_FirstUpdate()
	else
		obs_route_calculated:ONSELECT(sc_RouteItinerMap_FirstUpdate)
		obs_route_calculated:START("NO_TRIGGER")
	end
	st_RouteItinerMap.exit_with_back = true
	sc_SelectMapProfile(gMinimalColor_Name, gMinimalColorNight_Name)
	sc_SetItinerViewMode()
end
 
st_RouteItinerMap.done = function()
	sc_IntersectionZoomOff()
	sc_RestoreSmartZoom()
	local mapLayer = MODEL.map.primary
	mapLayer.show_cursor = false
	mapLayer.highlight_color = ""
	mapLayer.show_blocked_segments = true
	mapLayer.exit_state()
	MODEL.route.list.navigated.itiner.highlight_clear()
	if MODEL.lua.avoidActive() then
		sc_Avoid_KillDelayedUpdate()
		obs_temporary_route_calculated:STOP()
		MODEL.route.list.navigated.recalculate_on_modify = true
		MODEL.map.primary.route_model = ""
		MODEL.warning.speedcam_warning = gTmpSpeedcam
	end
	obs_route_calculated:STOP()
	sc_SelectOriginalMapProfile()
	MODEL.map.arrow_needs_to_fade = true
	obs_center_follow:START()
	obs_center_follow:TRIGGER()
end
 
sc_RouteItinerMap_PrepareUpdate = function()
	local itiner = MODEL.route.list.navigated.itiner
	local UID = itiner.list.current.INT.uid()
	if MODEL.lua.avoidActive() then
		MODEL.route.restrictions.load_snapshot()
	end
	itiner.highlight_clear()
	if (MODEL.lua.avoidActive() or itiner.list.current.INT.priority() ~= EItinerEntryPriority.Maneuver) and not MODEL.lua.InAvoidManeuver() then
		itiner.highlight_entry(UID, Skip_FOW_Mask)
	end
	MODEL.map.primary.route_model = ""
	return sc_RouteItinerMap_GetAvoidSpec()
end
 
sc_wCreateAvoidCockpit = function()
	sc_NaviMenuAlphaRestore()
	local wroute = MODEL.route.list.navigated.itiner
	wroute.enable_update_list = true
	wroute.detailmode = "normal"
	wavoideduid = nil
	for i = 0, wroute.list.size() - 1 do
		if wroute.list[i].INT.priority() == EItinerEntryPriority.Maneuver then
			if not (wroute.list[i].type() > 46 or wroute.list[i].type() == 8 or wroute.list[i].type() == 20) and wroute.list[i].avoidable() then
				wavoideduid = wroute.list[i].INT.uid()
			end
			break
		end
	end
	if wavoideduid == nil then
		sc_wCreateAvoidCockpitCancel()
		MODEL.screen.msgbox.new.setup(1)
		MODEL.screen.msgbox.new.set_line(1, m_i18n("This section cannot be avoided."))
		MODEL.screen.msgbox.new.setup_button(1, "")
		MODEL.screen.msgbox.new.set_time_out(5000)
		MODEL.screen.msgbox.create_new()
	else
		MODEL.screen.msgbox.new.setup(2)
		MODEL.screen.msgbox.new.set_line_wstr(1, translated_format(m_i18n("Would you like to avoid the next maneuver?")))
		MODEL.screen.msgbox.new.set_line_wstr(2, MODEL.navigation.next_street())
		MODEL.screen.msgbox.new.setup_button(1, "sc_wCreateAvoidCockpitOK", m_i18n("Avoid"), "", "ico_Avoidances_sml.bmp#3")
		MODEL.screen.msgbox.new.setup_button(2, "sc_wCreateAvoidCockpitCancel", m_i18n("Cancel"), "", "ico_cancel_mid.bmp#3")
		MODEL.screen.msgbox.new.set_time_out(10000)
		MODEL.screen.msgbox.new.set_default_action(2)
		wavoidedmessage_id = MODEL.screen.msgbox.create_new()
		obs_witinerchange:START("NO_TRIGGER")
	end
end
 
sc_wCreateAvoidCockpitOK = function()
	obs_witinerchange:STOP()
	MODEL.route.restrictions.save_snapshot()
	if MODEL.route.list.navigated.itiner.add_avoid_restrictions(wavoideduid, "M", 0) then
		MODEL.route.list.navigated.recalculate(0, 1, unpack({EAvoidType.Dist}))
	else
		MODEL.route.restrictions.load_snapshot()
	end
	MODEL.route.restrictions.delete_snapshot()
	sc_wCreateAvoidCockpitCancel()
end
 
sc_wCreateAvoidCockpitCancel = function()
	obs_witinerchange:STOP()
	if MODEL.lua.wSplitScreenOpen() and not MODEL.lua.wSplitScreenMode() and not wPortrait then
		sc_wOnSplitScreenItiner()
	else
		sc_wOffSplitScreenItiner()
	end
end
 
sc_wobs_witinerchange = function()
	obs_witinerchange:STOP()
	if wavoidedmessage_id ~= -1 then
		MODEL.screen.msgbox.close(wavoidedmessage_id)
		wavoidedmessage_id = -1
		sc_wCreateAvoidCockpitCancel()
	end
end
 
st_RoutingMethod.init = function()
	saved_vRouteType = MODEL.route.route_type()
	txtTitle.TEXT = m_i18n("Route Planning Method")
	sc_init_local_menu("ui.moremenu_routemethod")
end
 
sc_wEasyRouteMethodGetPriceValid = function()
	local vehicle = MODEL.mydata.vehicle_profile.list[MODEL.mydata.vehicle_profile.selected_profile()]()
	return vehicle.fuel_cost() and vehicle.fuel_cost.valid()
end
 
local wMainMenuMode_tmp, wCalculatedRoute, wRouteCount, wAlternativeType
st_EasyRouteMethod.init = function()
	sc_CheckOffroadParams()
	ASSERT(not MODEL.route.list.navigated.off_road(), "Should not try to create alternatives for off-road route.")
	if MODEL.lua.wFindAlternativesOriginal() or MODEL.route.vehicle_type() == EVehicleType.Pedestrian or MODEL.route.vehicle_type() == EVehicleType.Bicycle then
		sc_EasyRouteMethodEnter()
	else
		sc_wEasyRouteMethodEnterUser()
	end
	gVoiceMutedSave = MODEL.sound.voice_muted()
	local primary = MODEL.map.primary
	if primary.state() ~= "simulate_2d_nu" and primary.state() ~= "simulate_2d" and primary.state() ~= "simulate" then
		primary.save_state(primary.state())
	end
	primary.enter_state("routemap")
	MODEL.lua.routeMethodScreen = true
	st_EasyRouteMethod.pedestrianWarnIgnored = pedestrianWarnIgnored
	pedestrianWarnIgnored = true
	wMainMenuMode_tmp = MODEL.lua.mainMenuMode()
	MODEL.lua.mainMenuMode = false
	if not (MODEL.lua.wFindAlternativesOriginal() or MODEL.route.vehicle_type() == EVehicleType.Pedestrian or MODEL.route.vehicle_type() == EVehicleType.Bicycle) then
		sc_wRefreshShowedRouteModel()
		gTmpSpeedcam = MODEL.warning.speedcam_warning()
		MODEL.warning.speedcam_warning = false
	end
	if MODEL.route.list.navigated.calculation_finished() then
		sc_wEasyRouteMethod_GoStart()
	else
		obs_route_calculated:ONSELECT(sc_wEasyRouteMethod_GoStart)
		obs_route_calculated:START("NO_TRIGGER")
	end
end
 
st_EasyRouteMethod.done = function()
	obs_walternative_calculated:STOP()
	MODEL.map.primary.route_model = ""
	if st_EasyRouteMethod.calcTimerId ~= nil then
		killDelayed(st_EasyRouteMethod.calcTimerId)
		st_EasyRouteMethod.calcTimerId = nil
	end
	MODEL.map.primary.exit_state()
	obs_route_calculated:STOP()
	MODEL.lua.mainMenuMode = wMainMenuMode_tmp
	pedestrianWarnIgnored = st_EasyRouteMethod.pedestrianWarnIgnored
	MODEL.lua.routeMethodScreen = false
	vRouteCalcFinishedCallback:CLEAR()
	MODEL.sound.voice_muted = gVoiceMutedSave
	if MODEL.lua.wFindAlternativesOriginal() or MODEL.route.vehicle_type() == EVehicleType.Pedestrian or MODEL.route.vehicle_type() == EVehicleType.Bicycle then
		sc_EasyRouteMethodExit()
	else
		MODEL.warning.speedcam_warning = gTmpSpeedcam
		sc_wEasyRouteMethodExitUser()
	end
end
 
sc_wEasyRouteMethodEnterUser = function()
	MODEL.navigation.autoreplan = false
	wAlternativeType = 0
	wRouteCount = 5
	for i = 1, wRouteCount do
		MODEL.route.create_route_model("multiplan"..i)
	end
end
 
sc_wEasyRouteMethodFormatFuelCost = function(cost)
	local value = DOUBLE.new(tostring(cost)) / 100
	local digits = (cost % 100 > 0) and (cost < 10000) and 1 or 0
	if value == DOUBLE_0 then
		return translate(m_i18n("n/a"))
	else
		return sc_TrimString(value, digits)
	end
end
 
sc_wEasyRouteMethodExitUser = function()
	local selectedIdx = MODEL.lua.alternativeModes()
	local name = "multiplan"..selectedIdx
	if MODEL.route.list["multiplan_current"].valid() then
		MODEL.route.list["multiplan_current"].delete()
	end
	if MODEL.route.list[name].valid() then
		for i = 1, wRouteCount do
			if i ~= selectedIdx then
				MODEL.route.list["multiplan"..i].delete()
			end
		end
		MODEL.route.list.navigated.migrate_from(name)
		MODEL.route.list.navigated.settings.check_consistency_with_global_settings()
		sc_CheckOffroadParams()
		MODEL.route.list.navigated.calculation_priority = 10
		MODEL.route.list[name].delete()
	end
	MODEL.route.destroy_route_model("multiplan_current")
	for i = 1, wRouteCount do
		MODEL.route.destroy_route_model("multiplan"..i)
	end
	MODEL.ui.lm_RouteMethodUser.clear()
	MODEL.navigation.autoreplan = true
	sc_RecalcGreen()
end
 
sc_wEasyRouteMethod_GoStart = function()
	if MODEL.lua.wFindAlternativesOriginal() or MODEL.route.vehicle_type() == EVehicleType.Pedestrian or MODEL.route.vehicle_type() == EVehicleType.Bicycle then
		sc_EasyRouteMethod_StartAlternatives()
	else
		sc_wEasyRouteMethod_StartAlternativesUser()
	end
end
 
sc_wEasyRouteMethod_StartAlternativesUser = function()
	MODEL.lua.alternativeModes = 0
	MODEL.route.create_route_model("multiplan_current")
	local navigatedRouteModel = MODEL.route.list.navigated
	local targetRouteModel = MODEL.route.list.multiplan_current
	local startFromGps = (not navigatedRouteModel.waypoints.list.isempty() and not navigatedRouteModel.waypoints.start_is_user_selected() and navigatedRouteModel.waypoints.list[0].type() == "start")
	targetRouteModel.copy_from("navigated")
	if startFromGps and not targetRouteModel.move_start_to_gps() then
		targetRouteModel.waypoints.set_start(true)
	end
	wAlternativeType = 1
	wCalculatedRoute = 0
	MODEL.ui.lm_RouteMethodUser.clear()
	if MODEL.route.list.multiplan_current.calculation_finished() then
		sc_wEasyRouteMethod_CalcFinishedUser()
	else
		obs_walternative_calculated:BOOLMODEL("route.list.multiplan_current.calculation_finished")
		obs_walternative_calculated:ONSELECT(sc_wEasyRouteMethod_CalcFinishedUser)
		obs_walternative_calculated:START("NO_TRIGGER")
	end
end
 
sc_wEasyRouteMethod_CalcFinishedUser = function()
	sc_wRefreshShowedRouteModel()
	obs_walternative_calculated:STOP()
	sc_wEasyRouteMethod_FitUser()
	sc_wEasyRouteMethod_CalculateNextAlternativeUser()
end
 
sc_wEasyRouteMethod_CalculateNextAlternativeUser = function()
	if wAlternativeType > #RouteTypes and wCalculatedRoute < wRouteCount then
		MODEL.ui.lm_RouteMethodUser.resize(wCalculatedRoute)
		return
	end 
	wCalculatedRoute = wCalculatedRoute+1
	if wCalculatedRoute > wRouteCount then
		wRouteCount = wRouteCount+1
		MODEL.route.create_route_model("multiplan"..wCalculatedRoute)
	end
	local routeModel = MODEL.route.list["multiplan"..wCalculatedRoute]
	routeModel.delete()
	local route_name
	if wAlternativeType <= #RouteTypes then
		if RouteTypes[wAlternativeType].setting == MODEL.route.route_type() then
			routeModel.copy_from("multiplan_current")
		else
			routeModel.copy_waypoints_from("multiplan_current", false)
			routeModel.settings.route_type = RouteTypes[wAlternativeType].setting
			routeModel.recalculate()
		end
		wAlternativeType = wAlternativeType + 1
		route_name = translate(RouteTypes[wAlternativeType - 1].name)
		if MODEL.ui.lm_RouteMethodUser.lastindex() + 1 == wCalculatedRoute then
			lm_RouteMethodUser[MODEL.ui.lm_RouteMethodUser.lastindex()].text = route_name
			lm_RouteMethodUser[MODEL.ui.lm_RouteMethodUser.lastindex()].showed = true
		else
			ui.lm_RouteMethodUser:add({text = route_name, showed = true})
		end
		sc_wRefreshShowedRouteModel()
		if routeModel.calculation_finished() then
			sc_wEasyRouteMethod_CalcFinishedUser()
		else
			obs_walternative_calculated:BOOLMODEL("route.list.multiplan" .. wCalculatedRoute .. ".calculation_finished")
			obs_walternative_calculated:ONSELECT(sc_wEasyRouteMethod_CalcFinishedUser)
			obs_walternative_calculated:START("NO_TRIGGER")
		end
	end
end
 
sc_wEasyRouteMethod_DrawSelectedAlternativeUser = function()
	MODEL.sound.voice_muted = true
	sc_wRefreshShowedRouteModel()
	if not MODEL.lua.map.FitEnabled() then
		sc_wEasyRouteMethod_FitUser()
	end
end
 
sc_wOnOffShowedRoutes = function()
	MODEL["*"].showed = not MODEL["*"].showed()
	sc_wRefreshShowedRouteModel()
end
 
sc_wOnOffShowedRoutes_longclick = function()
	for item in ModelList_iter(MODEL.ui.lm_RouteMethodUser) do
		item.showed = true
	end
	sc_wRefreshShowedRouteModel()
end
 
sc_wRefreshShowedRouteModel = function()
	MODEL.map.primary.route_model = sc_wGetShowedRouteModel(MODEL.lua.alternativeModes())
end
 
sc_wGetShowedRouteModel = function(selected)
	local t = MODEL.ui.lm_RouteMethodUser
	local out = "nonexistent"
	if #t == 0 then
		return out
	end
	for item,index in ModelList_iter(t) do
		out = out .. ((selected == 0 and item.showed() or (index + 1) == selected) and ",multiplan" or ",PL") .. (index + 1)
	end
	return out
end
 
sc_wEasyRouteMethod_FitUser = function()
	local gcTL, gcBR, succ
	local sumTopLeft = GCOOR.new()
	local sumBottomRight = GCOOR.new()
	for item,index in ModelList_iter(MODEL.ui.lm_RouteMethodUser) do
		if MODEL.route.list["multiplan"..(index+1)].valid() then
			gcTL, gcBR, succ = MODEL.route.list["multiplan"..(index+1)].get_bounding_box()
			if succ then
				sumTopLeft, sumBottomRight = sc_AddGCPointToBoundaries(gcTL, sumTopLeft, sumBottomRight)
				sumTopLeft, sumBottomRight = sc_AddGCPointToBoundaries(gcBR, sumTopLeft, sumBottomRight)
			end
		end
	end
	if sumTopLeft:IsValid() and sumBottomRight:IsValid() then
		sc_routemenu_info_fit_open_from_main(sumTopLeft, sumBottomRight)
	else
		gcTL, gcBR, succ = MODEL.route.list["multiplan_current"].get_bounding_box()
		if succ then
			sc_routemenu_info_fit_open_from_main(gcTL, gcBR)
		end
	end
end
 
sc_SetRouteTypesTable = function()
	local tmp = false
	if MODEL.lua.green_routing_enabled() then
		if sc_VehicleIsGreen(MODEL.mydata.vehicle_profile.list[MODEL.mydata.vehicle_profile.selected_profile()].vehicle_type()) then
			for cntr = 1, #RouteTypes do
				if RouteTypes[cntr].name == "Economical" then
					table.remove(RouteTypes, cntr)
					break
				end
			end
		else
			for cntr = 1, #RouteTypes do
				if RouteTypes[cntr].name == "Economical" then
					tmp = true
					break
				end
			end
			if not tmp then
				table.insert(RouteTypes, 2, {name = "Economical", setting = L"ECO"})
			end
		end
		if MODEL.lua.showGreenUI() then
			tmp = false
			for cntr = 1, #RouteTypes do
				if RouteTypes[cntr].name == "Green" then
					tmp = true
					break
				end
			end
			if not tmp then
				table.insert(RouteTypes, 2, {name = "Green", setting = L"GREEN"})
			end
		else
			for cntr = 1, #RouteTypes do
				if RouteTypes[cntr].name == "Green" then
					table.remove(RouteTypes, cntr)
					break
				end
			end
		end
	end
	sc_SetRouteTypesTableFreeways()
end
 
sc_SetRouteTypesTableFreeways = function()
	local tmp = false
	for cntr = 1, #RouteTypes do
		if RouteTypes[cntr].setting == L"ECO" then
			tmp = true
			table.remove(RouteTypes, cntr)
			break
		end
	end
	if tmp then
		table.insert(RouteTypes, 2, {name = "Economical", setting = L"ECO"})
	end
	tmp = false
	for cntr = 1, #RouteTypes do
		if RouteTypes[cntr].setting == L"MOST_FREEWAYS" then
			tmp = true
			break
		end
	end
	if not tmp then
		table.insert(RouteTypes, 5, {name = "More highways", setting = L"MOST_FREEWAYS"})
	end
	sc_SetCalcmethodText()
end
 
sc_wBlockRoute_OnRelease = function(closelocal)
	if closelocal then
		sc_close_local_menu()
	end
	sc_NextStateAnim(st_wBlockRoute, "fade", 1, "")
end
 
wBlockRouteStart = nil
wBlockRouteEnd = nil
createState("st_wBlockRoute")
st_wBlockRoute:useLayers(primary, "ui_wBlockRoute", uieffect)
st_wBlockRoute.enter = function()
	wBlockRouteStart = nil
	wBlockRouteEnd = nil
	MODEL.lua.wBlockRoutePoint = 0
	MODEL.lua.wBlockRouteStatus = 0
	MODEL.lua.wBlockRouteDir = 2
	MODEL.my.map.select_address(MODEL.navigation.car.position())
	sc_SaveTempPos()
	MODEL.map.primary.cursor_icon = "cursor_places"
end
 
st_wBlockRoute.init = function()
	local mapLayer = MODEL.map.primary
	mapLayer.save_state(mapLayer.state())
	mapLayer.enter_state("browsemap")
	mapLayer.rotate = 0
	mapLayer.zoom = mapLayer.minzoom2d()
	mapLayer.breadcrumbs = false
	mapLayer.center = MODEL.my.map.selected_item.position()
	primary:ONMAPCLICK(sc_wBlockRouteClick)
	mapLayer.show_cursor = false
end
 
st_wBlockRoute.done = function()
	obs_wblockroute_calculated:STOP()
	MODEL.map.primary.route_model = ""
	MODEL.map.primary.exit_state()
end
 
st_wBlockRoute.exit = function()
	MODEL.route.list.wblockroute.clear()
	MODEL.map.primary.clear_clicked_lists()
end
 
sc_wBlockRouteClick = function()
	if not st_wBlockRoute.isActive then
		return
	end
	MODEL.map.primary.show_cursor = true
	MODEL.route.list.wblockroute.create_empty_route()
	MODEL.route.list.wblockroute.recalculate_on_modify = true
	if MODEL.lua.wBlockRoutePoint() then
		wBlockRouteEnd = MODEL.map.cursor.position()
	else
		wBlockRouteStart = MODEL.map.cursor.position()
	end
	MODEL.lua.wBlockRouteStatus = 1
	MODEL.my.map.select_gcoor(wBlockRouteStart)
	MODEL.route.list.wblockroute.waypoints.set_start()
	if wBlockRouteStart and wBlockRouteEnd then
		MODEL.my.map.select_gcoor(wBlockRouteEnd)
		MODEL.route.list.wblockroute.waypoints.add_destination()
		if MODEL.route.list.wblockroute.calculation_finished() then
			sc_wBlockRouteCalculated()
		else
			obs_wblockroute_calculated:START("NO_TRIGGER")
		end
	end
end
 
sc_wBlockRouteCalculated = function()
	obs_wblockroute_calculated:STOP()
	MODEL.route.list.wblockroute.show_on_map = true
	MODEL.route.list.wblockroute.draw_flags = true
	MODEL.map.primary.route_model = "navigated,PL1,PL2,PL3,PL4,wblockroute"
	MODEL.lua.wBlockRouteStatus = 2
	doDelayed(1, sc_wBlockRoute_Fit)
end
 
sc_wBlockRoute_Fit = function()
	local blockroute = MODEL.route.list.wblockroute
	if blockroute.waypoints.list.size() ~= 2 or not blockroute.calculation_finished() then
		return
	end
	local gcTL, gcBR, succ = MODEL.route.list.wblockroute.get_bounding_box()
	if succ then
		sc_routemenu_info_fit_open_from_main(gcTL, gcBR)
	end
end
 
sc_wBlockRoute_Center = function()
	MODEL.map.primary.rotate = 0
	sc_LoadTempPos()
	local Pos = MODEL.my.map.selected_item.position()
	MODEL.map.cursor.position = Pos
	MODEL.map.primary.center = Pos
	MODEL.map.primary.cursor_icon = "cursor_places"
end
 
sc_wBlockRouteSave = function()
	local name = MODEL.lua.wBlockRouteDir() == 2 and "Both directions" or (MODEL.lua.wBlockRouteDir() == 1 and "Opposite direction" or "Direct direction")
	name = wstring.gsub(MODEL.route.list.wblockroute.waypoints.list[0].longname(), L"\n", L" ") .. L"\n" .. wstring.gsub(MODEL.route.list.wblockroute.waypoints.list[1].longname(), L"\n", L" ") .. L"\n" .. translated_format(m_i18n(name))
	MODEL.route.block_route("wblockroute", name, true, MODEL.lua.wBlockRouteDir())
	sc_back()
	wBlockedFromCockpit = true
	sc_NextStateAnim(st_wBlockedRoadItem, "fade", 1, "" )
end
 
sc_wPlayTrack = function()
	sc_close_local_menu()
	gSimulationEndPrevstate = true
	MODEL.route.save_to_buffer()
	MODEL.route.list.navigated.clear()
	wCurrentTrack = MODEL.mydata.tracks.list.current
	MODEL.mydata.tracks.play(MODEL.mydata.tracks.list.index())
	if MODEL.navigation.is_in_simulation() then
		MODEL.lua.wTrackPlayingCurrentName = wstring.gsub(MODEL.mydata.tracks.list[MODEL.mydata.tracks.list.index()].name(), L"\n", L" ")
		wTrackStartTime = wCurrentTrack.start_time.time()
		wTrackPlayingTotalDistance = MODEL.mydata.tracks.list[MODEL.mydata.tracks.list.index()].distance_total()
		wTrackPlayingTotalTime = MODEL.mydata.tracks.list[MODEL.mydata.tracks.list.index()].time_total()
		wTrackPlayingMaxSpeed = MODEL.mydata.tracks.list[MODEL.mydata.tracks.list.index()].speed_max()
		wTrackPlayingStartTime = MODEL.gps.current_time()
		local timeplaying = wTrackPlayingTotalTime
		timeplaying:normalize()
		wTrackPlayingSeconds = 3600 * timeplaying.hours + 60 * timeplaying.minutes + timeplaying.seconds
		MODEL.lua.wTrackPlayingProgress = wTrackPlayingSeconds
		sc_wTempRouteCreate()
		MODEL.lua.wSimulateIsTrackPlaying = true
		gDetourAcceptanceMode_BeforeSimulation = MODEL.traffic.settings.detour_acceptance_mode()
		MODEL.traffic.settings.detour_acceptance_mode = 0
		MODEL.screen.msgbox.switch_off()
		MODEL.navigation.autoreplan = false
		MODEL.lua.dragMode = false
		ui_PreSimulation_Disabled:SHOW()
		gSimulateDelayID = replaceDelayed(gSimulateDelayID, 20, sc_Simulate_Navigation_Delayed)
	end
end
 
local sc_btnSim_Stop_Easy_onrelease_orig = sc_btnSim_Stop_Easy_onrelease
sc_btnSim_Stop_Easy_onrelease = function()
	if MODEL.lua.wSimulateIsTrackPlaying() then
		uieffect:GRAB()
		primary:ONMAPCLICK(sc_EasyMapClick)
		local primary = MODEL.map.primary
		if primary.state() == "simulate_2d_nu" or primary.state() == "simulate_2d" or primary.state() == "simulate" then
			obs_enter_drag_mode:STOP()
			primary.exit_state()
			obs_enter_drag_mode:START("NO_TRIGGER")
		else
			ASSERT(false, "Not in simulation mapstate?")
		end
		MODEL.mydata.tracks.stop_playback()
		MODEL.navigation.autoreplan = true
		MODEL.navigation.car.is_on_highway = false
		MODEL.route.list.navigated.waypoints.autocreate_start = MODEL.navigation.autoreplan()
		uieffect:DO_ANIM("fade", 1, "")
	else
		sc_btnSim_Stop_Easy_onrelease_orig()
	end
end
 
sc_wTempRouteCreate = function()
	local temproute = MODEL.route.list.wblockroute
	temproute.create_empty_route()
	temproute.recalculate_on_modify = false
	MODEL.my.map.select_gcoor(sc_wTempRouteGetWaypoint(0))
	temproute.waypoints.set_start()
	MODEL.my.map.select_gcoor(sc_wTempRouteGetWaypoint(wTrackPlayingSeconds))
	temproute.waypoints.add_destination()
	temproute.show_on_map = true
	temproute.draw_flags = true
end
 
sc_wTempRouteGetWaypoint = function(i)
	local success, position
	local n = i
	repeat
		success, _, _, position, _, _ = MODEL.mydata.tracks.get_current_track_record_data_at_index(n)
		n = n - 1
	until (success or n <= 0 or (i - n) > 300)
	return position
end
local st_MyRouteMenu_init_orig = st_MyRouteMenu.init
st_MyRouteMenu.init = function()
	st_MyRouteMenu_init_orig()
	txtTitle.TEXT = m_i18n("My Route")
end
--setting.lua
wBGTransparency = 0
wBGStreetTransparency = 0
wBtnTransparency = 0
 
createState("st_wSplitScreenItinerSettings")
st_wSplitScreenItinerSettings:useLayers(backgroundLayers, "ui_wSplitScreenItinerSettings")
st_wSplitScreenItinerSettings.init = function()
	txtTitle.TEXT = m_i18n("Split Screen(Itiner Page) Settings")
end
 
st_wSplitScreenItinerSettings.exit = function()
	SAVESETTINGS()
end
 
createState("st_wSplitScreenPOISettings")
st_wSplitScreenPOISettings:useLayers(backgroundLayers, "ui_wSplitScreenPOISettings")
st_wSplitScreenPOISettings.init = function()
	txtTitle.TEXT = m_i18n("Split Screen(POI Page) Settings")
end
 
st_wSplitScreenPOISettings.exit = function()
	SAVESETTINGS()
end
 
sc_wSplitScreenPOIGroupGetName = function(cat)
	local groupID = MODEL.poi.find_group(cat)
	if groupID == -1 then
		return nil
	end
	MODEL.my.poi.select_group(groupID)
	return MODEL.my.poi.current_group.name()
end
 
sc_wSplitScreenPOIGroupGetPath = function(cat)
	local groupID = MODEL.poi.find_group(cat)
	if groupID == -1 then
		return nil
	end
	local path, char = L"", L""
	while groupID > 0 do
		MODEL.my.poi.select_group(groupID)
		path = MODEL.my.poi.current_group.name() .. char .. path
		char = L"  "
		groupID = MODEL.my.poi.current_group.parent_id()
	end
	return path
end
 
sc_wSplitScreenPOIGroupDel_OnRelease = function()
	sc_wShowNewMessageBox(translated_format(m_i18n("Are you sure you want to delete this element from list?")),"sc_wSplitScreenPOIGroupDel_OnRelease_OK", m_i18n("Delete"),"ico_Delete_mid.bmp#3",sc_wSplitScreenPOIGroupGetName(MODEL["*"].name()))
end
 
sc_wSplitScreenPOIGroupDel_OnRelease_OK = function()
	MODEL.ui.lm_splitpoi_groups.remove(MODEL.ui.lm_splitpoi_groups.list.index())
	MODEL.ui.lm_splitpoi_groups.save()
end
 
sc_wSplitScreenPOISettingsGroupList_OnRelease = function()
	sc_NextStateAnim(st_wSplitScreenPOISettingsGroupList, "horz_scroll", 1, "")
end
 
createState("st_wSplitScreenPOISettingsGroupList")
st_wSplitScreenPOISettingsGroupList:useLayers(backgroundLayers, "ui_List_Background", "ui_wSplitScreenPOISettingsGroupList", localMenuLayers)
st_wSplitScreenPOISettingsGroupList.init = function()
	txtTitle.TEXT = m_i18n("POI category list")
	sc_init_local_menu("ui.lm_moremenu_splitpoi_groups")
end
 
sc_wSplitScreenPOIGroupPreStartSelect = function()
	sc_wPOIStructureMainReset(true)
end

sc_wSplitScreenPOIGroupSave_OnRelease = function()
	sc_close_local_menu()
	txtTitle.TEXT = m_i18n("Save POI category list")
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter a name for the list>")
	inpSI_Text.value = L""
	ui.vKeyTableDone = sc_wSplitScreenPOIGroupSave_OnReleaseDone
	MODEL.lua.easyShowDoneKey = true
	inputFieldRequired = true
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end
 
sc_wSplitScreenPOIGroupSave_OnReleaseDone = function()
	local str = ""
	local text = ui.inpSI_Text.value
	for item in ModelList_iter(MODEL.ui.lm_splitpoi_groups) do
		str = str .. item.name() .. "|||"
	end
	ui.lm_splitpoi_savedgroups:add({name = text, groups = str})
	MODEL.ui.lm_splitpoi_savedgroups.save()
	sc_back()
end
 
sc_wSplitScreenPOIGroupLoad_OnRelease = function()
	sc_close_local_menu()
	sc_NextStateAnim(st_wSplitScreenPOISettingsGroupListSaved, "horz_scroll", 1, "")
end
 
createState("st_wSplitScreenPOISettingsGroupListSaved")
st_wSplitScreenPOISettingsGroupListSaved:useLayers(backgroundLayers, "ui_List_Background", "ui_wSplitScreenPOISettingsGroupListSaved")
st_wSplitScreenPOISettingsGroupListSaved.init = function()
	txtTitle.TEXT = m_i18n("Saved POI category lists")
end
 
sc_wSplitScreenPOIGroupSavedDel_OnRelease = function()
	sc_wShowNewMessageBox(translated_format(m_i18n("Are you sure you want to delete this element from list?")),"sc_wSplitScreenPOIGroupSavedDel_OnRelease_OK", m_i18n("Delete"),"ico_Delete_mid.bmp#3",MODEL["*"].name())
end
 
sc_wSplitScreenPOIGroupSavedDel_OnRelease_OK = function()
	MODEL.ui.lm_splitpoi_savedgroups.remove(MODEL.ui.lm_splitpoi_savedgroups.list.index())
	MODEL.ui.lm_splitpoi_savedgroups.save()
	if MODEL.ui.lm_splitpoi_savedgroups.list.isempty() then
		sc_back()
	end
end
 
sc_wSplitScreenPOIGroupSavedDelAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all saved POI category lists?"),"sc_wSplitScreenPOIGroupSavedDelAll_OnRelease_OK", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wSplitScreenPOIGroupSavedDelAll_OnRelease_OK = function()
	MODEL.ui.lm_splitpoi_savedgroups.clear()
	MODEL.ui.lm_splitpoi_savedgroups.save()
	sc_back()
end
 
sc_wSplitScreenPOIGroupSavedLoad_OnRelease = function()
	MODEL.ui.lm_splitpoi_groups.clear()
	for value in string.gmatch(MODEL["*"].groups(), "(.-)|||") do 
		ui.lm_splitpoi_groups:add({name = value})
	end
	if MODEL.ui.lm_splitpoi_groups.size() > 8 then
		MODEL.ui.lm_splitpoi_groups.resize(8)
	end
	local before_size = MODEL.ui.lm_splitpoi_groups.size() - 1
	local removed = 0
	for i = 0, before_size do
		if sc_wSplitScreenPOIGroupGetName(MODEL.ui.lm_splitpoi_groups[i-removed].name()) == nil then
			MODEL.ui.lm_splitpoi_groups.remove(i-removed)
			removed = removed + 1
		end
	end
	MODEL.ui.lm_splitpoi_groups.save()
	sc_back()
end
 
sc_wSplitScreenPOIGroupStartSelect = function()
	sc_wSplitScreenPOIGroupPreStartSelect()
	sc_NextStateAnim(st_wSplitScreenPOIGroupSettings, "fade", 1, "")
end

createState("st_wSplitScreenPOIGroupSettings")
st_wSplitScreenPOIGroupSettings:useLayers(backgroundLayers, "ui_List_Background", "ui_AddPOI")
st_wSplitScreenPOIGroupSettings.enter = function()
	EPoiScrollPos = {}
end

st_wSplitScreenPOIGroupSettings.init = function()
	sc_wSetTitle_AP()
end

sc_wSplitScreenPOIGroupSelectStart = function()
	MODEL.lua.wSplitScreenPOIGroup = MODEL["*"].path()
end
 
sc_wSplitScreenPOIGroupSelectDone = function()
	local value = false
	for item in ModelList_iter(MODEL.ui.lm_splitpoi_groups.unfiltered_list) do
		if item.name() == MODEL.lua.wSplitScreenPOIGroup() then
			value = true
			break
		end
	end
	if not value then
		ui.lm_splitpoi_groups:add({name=MODEL.lua.wSplitScreenPOIGroup()})
		MODEL.ui.lm_splitpoi_groups.save()
	end
	sc_wToParentLast()
	sc_back()
end
 
sc_wSplitScreenPOIFilterStartSelect = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = L""
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter the Name of the Place>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_wSplitScreenPOIFilterSelectDone
	inputFieldRequired = false
	txtTitle.TEXT = m_i18n("Enter Filter")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end

sc_wSplitScreenPOIFilterSelectDone = function()
	MODEL.lua.wSplitScreenPOIFilter = ui.inpSI_Text.VALUE()
	sc_back()
end
 
sc_wRestart_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("The program will restart."),"sc_wRestart_OnReleaseDone", m_i18n("Restart"),"ico_done_mid.bmp#3",nil,"sc_CancelExit")
end
 
sc_wRestart_OnReleaseDone = function()
	SAVESETTINGS()
	NEXTSTATE(RestartState)
	doDelayed(25, APP_RESTART)
end
 
sc_btnSR_StartExit_OnRelease = function()
	sc_NextStateAnim(st_wStartExitSounds, "horz_scroll", 1, "")
end
 
createState("st_wStartExitSounds")
st_wStartExitSounds:useLayers(backgroundLayers, "ui_wStartExitSounds")
st_wStartExitSounds.init = function()
	txtTitle.TEXT = m_i18n("Start/exit sounds")
end
 
sc_btnSR_Power_OnRelease = function()
	sc_NextStateAnim(st_wPowerSounds, "horz_scroll", 1, "")
end
 
createState("st_wPowerSounds")
st_wPowerSounds:useLayers(backgroundLayers, "ui_List_Background", "ui_wPowerSounds")
st_wPowerSounds.init = function()
	txtTitle.TEXT = m_i18n("Power sounds")
end
createState("st_wPowerSoundTTSTest")
st_wPowerSoundTTSTest:useLayers(backgroundLayers, "ui_wPowerSoundTTSTest")
st_wPowerSoundTTSTest.init = function()
	txtTitle.TEXT = m_i18n("Power sounds(TTSPro test)")
end
 
st_wPowerSoundTTSTest.done = function()
	sc_wPromptCancel("wTestSpeakingID")
end
 
sc_use_captureScreen = function()
	GESTURE("CI0", sc_wCaptureScreen)
end
 
sc_wCaptureSettings_Enter = function()
	sc_NextStateAnim(st_wCaptureSettings, "horz_scroll", 1, "")
end
 
createState("st_wCaptureSettings")
st_wCaptureSettings:useLayers(backgroundLayers, "ui_wCaptureSettings")
st_wCaptureSettings.init = function()
	txtTitle.TEXT = m_i18n("Capture Settings")
end
 
sc_wCaptureScreen = function()
	MODEL.ui.__screenshot()
	if MODEL.lua.wCaptureWarning() then
		doDelayed(15, function()
			if MODEL.lua.wCaptureWarning() ~= 2 then
				sc_wplaysound(1, MODEL.lua.wCaptureSoundName(), MODEL.lua.wCaptureSoundVolume())
			end
			if MODEL.lua.wCaptureWarning() > 1 then
				sc_wShowHelpText(m_i18n("DEBUG~Screen Captured"))
			end
		end)
	end
end
 
local st_SettingRouteParam_enter_orig = st_SettingRouteParam.enter
st_SettingRouteParam.enter = function()
	st_SettingRouteParam_enter_orig()
	if MODEL.EXISTS.route.allow_env_zone() then
		wEnvZoneParam = MODEL.route["allow_env_zone"]()
	end
end
 
st_SettingRouteParam:removeLayers(localMenuLayers)
st_SettingRouteParam.init = function()
	txtTitle.TEXT = m_i18n("Route Settings")
	if not MODEL.lua.vEasyWizModeOnFirstStart() and not MODEL.lua.truck_UI() and (not MODEL.EXISTS.other.license.activation_manager.activation_done() or not MODEL.network.supported() or not not MODEL.other.license.activation_manager.activation_done()) then
		SettingRouteParamWizFooter:TEXT("Finish")
	else
		SettingRouteParamWizFooter:TEXT("Next")
	end
	MODEL.ui.lst_lmRouteParamsList.current_index = 0
	sc_SetCalcmethodText()
end
 
local st_SettingRouteParam_exit_orig = st_SettingRouteParam.exit
st_SettingRouteParam.exit = function()
	if MODEL.EXISTS.route.allow_env_zone() then
		routeParamsChanged = wEnvZoneParam ~= MODEL.route["allow_env_zone"]()
	end
	st_SettingRouteParam_exit_orig()
end
 
local st_SettingRouteParam_loadparams_orig = st_SettingRouteParam.sc_LoadParams
st_SettingRouteParam.sc_LoadParams = function()
	if MODEL.EXISTS.route.allow_env_zone() then
		MODEL.route["allow_env_zone"] = PERSISTENT.route[MODEL.route.vehicle_type()].allow_env_zone()
	end
	st_SettingRouteParam_loadparams_orig()
end
 
local st_SettingRouteParam_saveparams_orig = st_SettingRouteParam.sc_SaveParams
st_SettingRouteParam.sc_SaveParams = function()
	if MODEL.EXISTS.route.allow_env_zone() then
		PERSISTENT.route[MODEL.route.vehicle_type()].allow_env_zone = MODEL.route["allow_env_zone"]()
	end
	st_SettingRouteParam_saveparams_orig()
end
local sc_ResetAllRouteParams_orig = sc_ResetAllRouteParams
sc_ResetAllRouteParams = function()
	for vehicle = 0, EVehicleType.Last do
		PERSISTENT.route[vehicle].allow_env_zone = false
	end
	sc_ResetAllRouteParams_orig()
end
sc_ResetParams_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Would you like to reset all route settings to their defaults?"),"sc_ResetAllRouteParams", m_i18n("Reset to Defaults"),"ico_done_mid.bmp#3")
end
 
sc_MapSettings_Color_Filter = function()
	sc_NextStateAnim(st_MapSettings_ColorFilter, "horz_scroll", 1, "")
end
 
createState("st_MapSettings_ColorFilter")
st_MapSettings_ColorFilter:useLayers(backgroundLayers, "ui_MapSettings_ColorFilter")
st_MapSettings_ColorFilter.init = function()
	txtTitle.TEXT = m_i18n("Color Filter Settings")
end

sc_MapSettings_Transparency = function()
	sc_NextStateAnim(st_MapSettings_Transparency, "horz_scroll", 1, "")
end
 
createState("st_MapSettings_Transparency")
st_MapSettings_Transparency:useLayers(backgroundLayers, "ui_MapSettings_Transparency")
st_MapSettings_Transparency.init = function()
	txtTitle.TEXT = m_i18n("Transparency settings")
end

st_MapSettings.exit = function()
	SAVESETTINGS()
end
 
sc_change_day_night = function()
	sc_wDayNightTrigger()
	sc_BGTransparencyChange()
	sc_BGStreetTransparencyChange()
	sc_BtnTransparencyChange()
end
 
sc_wDayNightTrigger = function()
	MODEL.lua.wDayNightTrigger = false
	MODEL.lua.wDayNightTrigger = true
end
 
local sc_SetTheme_orig = sc_SetTheme
sc_SetTheme = function()
	sc_SetTheme_orig()
	sc_wDayNightTrigger()
end
 
sc_BGTransparencyChange = function()
	if MODEL.screen.nightmode() then
		wBGTransparency = MODEL.lua.wBGTransparencyN()
	else
		wBGTransparency = MODEL.lua.wBGTransparencyD()
	end
end
 
sc_BGStreetTransparencyChange = function()
	if MODEL.screen.nightmode() then
		wBGStreetTransparency = MODEL.lua.wBGStreetTransparencyN()
	else
		wBGStreetTransparency = MODEL.lua.wBGStreetTransparencyD()
	end
end
 
sc_small_BGnkspeedTransparencyChange = function()
	if MODEL.screen.nightmode() then
		small_wBGnkspeedTransparency = MODEL.lua.small_wBGnkspeedTransparencyN()
	else
		small_wBGnkspeedTransparency = MODEL.lua.small_wBGnkspeedTransparencyD()
	end
end

sc_big_BGnkspeedTransparencyChange = function()
	if MODEL.screen.nightmode() then
		big_wBGnkspeedTransparency = MODEL.lua.big_wBGnkspeedTransparencyN()
	else
		big_wBGnkspeedTransparency = MODEL.lua.big_wBGnkspeedTransparencyD()
	end
end

sc_BtnTransparencyChange = function()
	if MODEL.screen.nightmode() then
		wBtnTransparency = MODEL.lua.wBtnTransparencyN()
	else
		wBtnTransparency = MODEL.lua.wBtnTransparencyD()
	end
end
 
sc_MapSettings_Zoom = function()
	sc_NextStateAnim(st_MapSettings_Zoom, "horz_scroll", 1, "")
end
 
sc_ConvertInputDistToCurrent = function(dist)
	return float.toInt(float.new(tostring(dist)) * wUnitConvMeter2Unit[MODEL.INT.regional.units() + 1])
end
 
sc_wGetZoomSettingIndexes = function()
	local t = {}
	local group = ""
	for item,index in ModelList_iter(ui.ZoomSettingList.list) do
		if group ~= item.group() then
			group = item.group()
			table.insert(t, index)
		end
	end
	return t
end
 
sc_Select_wZoom_minangleDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		MODEL.lua.wZoom_minangle = text
		if MODEL.lua.wZoom_maxangle() < text then
			MODEL.lua.wZoom_maxangle = text
		end
		if MODEL.lua.wZoom_maxangleSP() < text then
			MODEL.lua.wZoom_maxangleSP = text
		end
	end
	sc_back()
end
 
sc_Select_wZoom_maxangleDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		MODEL.lua.wZoom_maxangle = text
		if MODEL.lua.wZoom_minangle() > text then
			MODEL.lua.wZoom_minangle = text
		end
		if MODEL.lua.wZoom_maxangleSP() < text then
			MODEL.lua.wZoom_maxangleSP = text
		end
	end
	sc_back()
end
 
sc_Select_wZoom_maxangleSPDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		MODEL.lua.wZoom_maxangleSP = text
		if MODEL.lua.wZoom_maxangle() > text then
			MODEL.lua.wZoom_maxangle = text
		end
		if MODEL.lua.wZoom_minangle() > text then
			MODEL.lua.wZoom_minangle = text
		end
	end
	sc_back()
end
 
sc_Select_wZoom_speedlowDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.lua.wZoom_speedlow = text
		if MODEL.lua.wZoom_speedhigh() < text then
			MODEL.lua.wZoom_speedhigh = text
		end
	end
	sc_back()
end
 
sc_Select_wZoom_speedhighDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.lua.wZoom_speedhigh = text
		if MODEL.lua.wZoom_speedlow() > text then
			MODEL.lua.wZoom_speedlow = text
		end
	end
	sc_back()
end
 
createState("st_MapSettings_Zoom")
st_MapSettings_Zoom:useLayers(backgroundLayers, "ui_List_Background", "ui_MapSettings_Zoom")
st_MapSettings_Zoom.init = function()
	txtTitle.TEXT = m_i18n("User zoom settings")
end

st_MapSettings_Zoom.exit = function()
	sc_Set_Presets()
end

sc_MapSettings_SS = function()
	sc_NextStateAnim(st_wSSSetting, "fade", 1, "")
end
 
sc_wSettingsRet2Car_Enter = function()
	sc_NextStateAnim(st_wSettingsRet2Car, "horz_scroll", 1, "")
end
 
createState("st_wSettingsRet2Car")
st_wSettingsRet2Car:useLayers(backgroundLayers, "ui_wSettingsRet2Car")
st_wSettingsRet2Car.init = function()
	txtTitle.TEXT = m_i18n("Save GPS position to history on:")
end
 
sc_wGPSLost = function()
	if MODEL.lua.wPositionGPSLost() and MODEL.gps.connection_status() < 3 then
		sc_add_carpos_to_history("GPS lost",3)
	end
end
 
sc_wListRet2Car_Enter = function()
	sc_close_local_menu()
	sc_NextStateAnim(st_wListRet2Car, "horz_scroll", 1, "")
end

createState("st_wListRet2Car")
st_wListRet2Car:useLayers(backgroundLayersNoFooter, "ui_List_Background", "ui_wListRet2Car")
st_wListRet2Car.init = function()
	txtTitle.TEXT = m_i18n("DEBUG~Return to car")
	MODEL.lua.wSettingDistIcon = 0
end
 
sc_wSelectRet2Car = function()
	MODEL["*"].item.select()
	wSelectedItemHotName = MODEL.my.map.selected_item.name()
	wSelectedItemHotPos = MODEL.my.map.selected_item.position()
	MODEL.map.cursor.position = MODEL.my.map.selected_item.position()
	if wFind_createroute then
		sc_FindOnMap_Select_onrelease()
	else
		routeMenuMode = 1
		sc_NextStateAnim(st_FindOnMap, "fade", 1, "")
		sc_ResetStrappedCursor()
	end
end
 
sc_wRet2Car_DeleteAll = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all history entries?"),"sc_wRet2Car_DeleteAll_OK", m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wRet2Car_DeleteAll_OK = function()
	MODEL.ui.wret2car.clear()
	MODEL.ui.wret2car.save()
end
 
sc_add_carpos_to_history = function(action, lsource)
	local prev_poi, prev_poiprovider = nil, nil
	if MODEL.my.poi.current.valid() then
		prev_poi = MODEL.my.poi.current.id()
		prev_poiprovider = MODEL.my.poi.current.provider_id()
	end
	local position = MODEL.navigation.car.position()
	local savedposition = GCOOR.new({lat = 0, lon = 0})
	local savedsource = -1
	local mypoi = m_i18n("@My POI")
	local poiGroupId = MODEL.poi.find_group(mypoi)
	if poiGroupId == -1 then
		MODEL.my.poi.add_group(0, gUserPOI_Provider, mypoi)
		poiGroupId = MODEL.poi.find_group(mypoi)
	end
	MODEL.my.poi.select_group(poiGroupId)
	MODEL.my.map.select_gcoor(position)
	MODEL.my.poi.add_poi_selected(poiGroupId, gUserPOI_Provider)
	local name = action .. "(%s|%s)"
	MODEL.my.poi.current.name = translated_format(m_i18n(name), towstring(MODEL.other.format_time(MODEL.gps.current_time(), MODEL.regional.timeformat())), sc_DateToWStr(MODEL.gps.current_date()))
	MODEL.my.poi.select_poi(MODEL.my.poi.current.provider_id(), MODEL.my.poi.current.id())
	if not MODEL.ui.wret2car.unfiltered_list.isempty() then
		savedposition = MODEL.ui.wret2car.unfiltered_list[0].item.position()
		savedsource = MODEL.ui.wret2car.unfiltered_list[0].source()
	end
	if MODEL.other.calc_distance(position, savedposition) > 25 or savedsource ~= lsource then 
		ui.wret2car:insert(0, {item=nil, source=lsource})
	end
	MODEL.ui.wret2car.unfiltered_list[0].item.save_lastselected()
	MODEL.my.poi.current.remove()
	if MODEL.ui.wret2car.unfiltered_list.size() > 24 then
		MODEL.ui.wret2car.resize(24)
	end
	MODEL.ui.wret2car.save()
	if prev_poi ~= nil and prev_poiprovider ~= nil then
		MODEL.my.poi.select_poi(prev_poiprovider, prev_poi)
	end
end
 
sc_SetHwyPoiCategories = function()
	MODEL.lua.selectedHwyPoiCat = index
	sc_wPOIStructureMainReset(true)
	sc_NextStateAnim(st_HighwayPoiCatList, "horz_scroll", 1, "")
end
 
sc_SaveHwyPoiCat = function()
	gHwyPoiCatSaved = true
	local m = MODEL.other.highway_drive.poi_category_list
	for cntr = 0, 3 do
		if cntr ~= MODEL.lua.selectedHwyPoiCat() and m[MODEL.lua.selectedHwyPoiCat()].group() == m[cntr].group() then
			MODEL.other.highway_drive["poi_search_category" .. cntr] = gHwyPoiCatPathOrig
			m[cntr].group = gHwyPoiCatGroupOrig
			m[cntr].icon = gHwyPoiCatIconOrig
		end
	end
	MODEL.other.highway_drive.refresh_poi_categories()
	sc_wToParentLast()
	sc_back()
end
 
sc_btn_DynamicVolumeOnRelease = function()
	sc_NextStateAnim(st_wDynamicVolumeSetting, "horz_scroll", 1, "")
end
 
createState("st_wDynamicVolumeSetting")
st_wDynamicVolumeSetting:useLayers(backgroundLayers, "ui_List_Background", "ui_wDynamicVolumeSetting")
st_wDynamicVolumeSetting.init = function()
	txtTitle.TEXT = m_i18n("Dynamic volume settings")
	MODEL.sound.tts_manager.starting_test()
end

st_wDynamicVolumeSetting.done = function()
	sc_wPreSetDynamicVolumeType()
	MODEL.sound.tts_manager.stoping_test()
end

st_wDynamicVolumeSetting.exit = function()
	SAVESETTINGS()
end

sc_wPreSetDynamicVolumeType = function()
	if MODEL.lua.wDynamicVolumeType() > 1 then
		MODEL.lua.wDynamicVolumeMasterMax = MODEL.sound.dynamic_volume_os_volume_max()
		MODEL.lua.wDynamicVolumeGuidanceMax = MODEL.sound.dynamic_volume_voice_volume_max()
	end
end
 
sc_wSetDynamicVolumeType = function()
	MODEL.sound.dynamic_volume_type = MODEL.lua.wDynamicVolumeType()
	if MODEL.lua.wDynamicVolumeType() == 1 then
		MODEL.sound.dynamic_volume_autocalc_maxvoicespeed()
		MODEL.sound.dynamic_volume_os_volume_max = 255
		MODEL.sound.dynamic_volume_voice_volume_max = 63
	elseif MODEL.lua.wDynamicVolumeType() then
		MODEL.sound.dynamic_volume_voicemaxspeed = MODEL.lua.wDynamicVolumeMaxSpeedGuidance()
		MODEL.sound.dynamic_volume_os_volume_max = MODEL.lua.wDynamicVolumeMasterMax()
		MODEL.sound.dynamic_volume_voice_volume_max = MODEL.lua.wDynamicVolumeGuidanceMax()
	end
end
 
sc_SelectDynamicVolumeMinSpeedDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.sound.dynamic_volume_minspeed = text
		if MODEL.sound.dynamic_volume_maxspeed() < text then
			MODEL.sound.dynamic_volume_maxspeed = text
		end
		if MODEL.sound.dynamic_volume_voicemaxspeed() < text then
			MODEL.sound.dynamic_volume_voicemaxspeed = text
			MODEL.lua.wDynamicVolumeMaxSpeedGuidance = text
		end
	end
	if MODEL.lua.wDynamicVolumeType() == 1 then
		MODEL.sound.dynamic_volume_autocalc_maxvoicespeed()
	elseif MODEL.lua.wDynamicVolumeType() then
		MODEL.sound.dynamic_volume_voicemaxspeed = MODEL.lua.wDynamicVolumeMaxSpeedGuidance()
	end
	sc_back()
end
 
sc_SelectDynamicVolumeMaxSpeedDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.sound.dynamic_volume_maxspeed = text
		if MODEL.sound.dynamic_volume_minspeed() > text then
			MODEL.sound.dynamic_volume_minspeed = text
		end
		if MODEL.sound.dynamic_volume_voicemaxspeed() > text then
			MODEL.sound.dynamic_volume_voicemaxspeed = text
			MODEL.lua.wDynamicVolumeMaxSpeedGuidance = text
		end
	end
	if MODEL.lua.wDynamicVolumeType() == 1 then
		MODEL.sound.dynamic_volume_autocalc_maxvoicespeed()
	elseif MODEL.lua.wDynamicVolumeType() then
		MODEL.sound.dynamic_volume_voicemaxspeed = MODEL.lua.wDynamicVolumeMaxSpeedGuidance()
	end
	sc_back()
end
 
sc_SelectDynamicVolumeMaxSpeedGuidanceDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.lua.wDynamicVolumeMaxSpeedGuidance = text
		MODEL.sound.dynamic_volume_voicemaxspeed = text
		if MODEL.sound.dynamic_volume_minspeed() > text then
			MODEL.sound.dynamic_volume_minspeed = text
		end
		if MODEL.sound.dynamic_volume_maxspeed() < text then
			MODEL.sound.dynamic_volume_maxspeed = text
		end
	end
	sc_back()
end
 
sc_wDynamicVolumeMaster_onchange = function()
	if MODEL.sound.dynamic_volume_os_volume_max() < MODEL.sound.os_volume() then
		MODEL.sound.dynamic_volume_os_volume_max = MODEL.sound.os_volume()
	end
end
 
sc_wDynamicVolumeMasterMax_onchange = function()
	if MODEL.sound.dynamic_volume_os_volume_max() < MODEL.sound.os_volume() then
		MODEL.sound.os_volume = MODEL.sound.dynamic_volume_os_volume_max()
	end
end
 
sc_wDynamicVolumeGuidance_onchange = function()
	if MODEL.sound.dynamic_volume_voice_volume_max() < MODEL.sound.voice_volume() then
		MODEL.sound.dynamic_volume_voice_volume_max = MODEL.sound.voice_volume()
	end
end
 
sc_wDynamicVolumeGuidanceMax_onchange = function()
	if MODEL.sound.dynamic_volume_voice_volume_max() < MODEL.sound.voice_volume() then
		MODEL.sound.voice_volume = MODEL.sound.dynamic_volume_voice_volume_max()
	end
end
 
st_ExtraSettings.init = function()
	txtTitle.TEXT = m_i18n("DEBUG~UI Labs")
	if MODEL.lua.MainMenuState() == L"st_MainMenu_2x2" then
		MODEL.lua.wSettingDistIcon = 1
	elseif MODEL.lua.MainMenuState() == L"st_MainMenu_list" then
		MODEL.lua.wSettingDistIcon = 2
	elseif MODEL.lua.MainMenuState() == L"st_MainMenu_more" then
		MODEL.lua.wSettingDistIcon = 3
	else
		MODEL.lua.wSettingDistIcon = 0
	end
	tmp_lastState = MODEL.lua.MainMenuState()
	ui.btn_Footer_back_1.ONRELEASE = st_ExtraSettings_back
end
 
st_ExtraSettings_back = function()
	sc_back()
	if tmp_lastState ~= MODEL.lua.MainMenuState() then
		STATE(sc_GetStartState())
	end
end
 
st_wSetMainMenuState = function(value)
	MODEL.lua.MainMenuState = value
end
 
createState("st_wSoundEQ")
st_wSoundEQ:useLayers(backgroundLayers, "ui_wSoundEQ")
st_wSoundEQ.init = function()
	txtTitle.TEXT = m_i18n("Equalizer")
end

createState("st_wSoundTone")
st_wSoundTone:useLayers(backgroundLayers, "ui_wSoundTone")
st_wSoundTone.init = function()
	txtTitle.TEXT = m_i18n("Tone")
end

sc_wGetSoundEQBand = function(band)
	return tostring(band-50)
end

sc_wGetCompassSettingIcon = function(value)
	if value==1 or value==3 then
		return ""
	else
		return MODEL.ui.fullCockpitMenuList.quick_list[0].icon()
	end
end

sc_wTurnOffMenuLC = function()
	MODEL.power.shutdown()
end

sc_wNavModeChange = function()
	MODEL.lua.ptp_navigation = not MODEL.lua.ptp_navigation()
	sc_NavModeChange()
end
sc_wSSVerbosity_OnRelease = function()
	if MODEL.INT.sound.voice.verbosity_level() < 2 then
		MODEL.INT.sound.voice.verbosity_level = MODEL.INT.sound.voice.verbosity_level() + 1
	else
		MODEL.INT.sound.voice.verbosity_level = 0
	end
end
 
sc_wSSVerbosityType = function(level)
	local type = level == 2 and "Minimal" or (level == 1 and "Compact" or "Verbose")
	return translated_format(m_i18n(type))
end
 
sc_wGetTransparencyPercent = function(mode, nvalue, dvalue)
	return mode and (tostring(100*nvalue/32) .. "%") or (tostring(100*dvalue/32) .. "%")
end
 
sc_SetAutoCloseHwyTime = function()
	MODEL.lua.AutoCloseHwyTime = MODEL.lua.AutoCloseHwyPanel_saved() and MODEL.lua.AutoCloseHwyTime_saved() or -1
end
 
sc_SelectAutoCloseHwyTimeDone = function()
	MODEL.lua.AutoCloseHwyTime_saved = (not inpValueInteger_isempty() and tonumber(ui.inpValueInteger.VALUE()))
	MODEL.lua.AutoCloseHwyTime = MODEL.lua.AutoCloseHwyTime_saved()
	sc_back()
end
 
sc_wRealTimeCollectChanged = function()
	if type(sc_RealTimeCollectChanged) == "function" then
		sc_RealTimeCollectChangedStart()
	end
end
 
sc_wRealTimeCollectChangedStart = function()
	sc_RealTimeCollectChanged()
end
 
local sc_InternetDisconnected_orig = sc_InternetDisconnected
sc_InternetDisconnected = function()
	if SysConfig.get("network", "disconnect_messagebox", true) then
		sc_InternetDisconnected_orig()
	end
end
 
--start.lua 
 
local sc_reset_primary_orig = sc_reset_primary
sc_reset_primary = function(ResetMapClick)
	sc_reset_primary_orig(ResetMapClick)
	MODEL.map.primary.show_labels_3d = MODEL.lua.wLabels_3d()
	MODEL.map.primary.show_labels_2d = MODEL.lua.wLabels_2d()
end
ExitState.init = function()
	local delay = 1
	if MODEL.lua.wPositionExit() then
		sc_add_carpos_to_history("Program exit",1)
		delay = 20
	end
	if sc_ReadOutStartExitSupported() and MODEL.lua.wStartExitTTSExit() then
		sc_wsayspeech(translate_voice("Bye!"),21,25)
		delay = 200
	else
		sc_wplaysound(1, MODEL.lua.wExitSoundName(), MODEL.lua.wStartExitVolume())
		delay = 100
	end
	doDelayed(delay, EXIT)
end
 
sc_FilesFont_check = function()
	local oasisFiles = MODEL.oasis.files()
	oasisFiles.useful_dirs_only = true
	oasisFiles.selectable_dir = true
	oasisFiles.unroll_dirs = true
	oasisFiles.path = L"%app%/font"
	oasisFiles.filter = L"fcategory:1"
	oasisFiles.create_file_props = false
	oasisFiles.initialize_data()
	if oasisFiles.finished() then
		sc_FilesFont_check_done()
	else
		obs_Files_FontScan_Finished:START("NO_TRIGGER")
	end
end
 
sc_FilesFont_check_done = function()
	obs_Files_FontScan_Finished:STOP()
	for item in ModelList_iter(MODEL.oasis.files.list) do
		if item.fname():lower() == L"digital.ttf" then
			MODEL.lua.wDigitalExist = true
			break
		end
	end
	if not MODEL.lua.wDigitalExist() then
		MODEL.lua.wDigitalFontSS = false
	end
	MODEL.oasis.files.deinitialize_data()
	MODEL.oasis.files.unroll_dirs = false
	sc_wMapchangerProvider_check()
end
 
--tmc.lua
wTmcF1 = L"75"
wTmcF2 = L"75"
wTmcScan = sc_GetSysEntry("tmc", "hold_station_time", 15)
wTmcSearchMode = false
wTmcSearch = -1
wTmcScanFixed = sc_GetSysEntry("tmc", "test_fixedstation_time", 2)
sc_wGetSignificantEventsSize = function(value)
	return (translate(m_i18n("Significant Events:")) .. towstring(value))
end

sc_wGetTmcListFrequencyText = function(value)
	return translated_format(m_i18n("%s MHz"), value)
end

sc_wTmcChangeTunning = function()
	if MODEL.lua.wTMCTunerMode() == 1 then
		obs_wtmctuner:STOP()
		if MODEL.tmc.auto_tuning_available() then
			sc_wTmcChangeTunning_done(true)
		else
			sc_wTmcChangeTunning_done(false)
			MODEL.lua.wTMCTunerMode = 0
		end
	elseif MODEL.lua.wTMCTunerMode() == 0 then
		obs_wtmctuner:STOP()
		sc_wTmcChangeTunning_done(false)
	else
		sc_wTmcChangeTunning_done(false)
		obs_wtmctuner:START()
	end
end

sc_wTmcChangeTunning_done = function(mode)
	if not ((mode and not MODEL.tmc.auto_tuning_available()) or MODEL.tmc.auto_tuning() == mode) then
		MODEL.tmc.auto_tuning = mode
		MODEL.tmc.change_tuning_mode()
	end
end

sc_wtmcstatechange = function()
	if MODEL.tmc.station_tuned() then
		wTmcScan = sc_GetSysEntry("tmc", "hold_station_time", 15)
	else
		wTmcScan = sc_GetSysEntry("tmc", "test_station_time", 3)
	end
end

sc_wTmcAutoScan = function()
	if MODEL.tmc.station_tuned() then
		wTmcScan = sc_GetSysEntry("tmc", "hold_station_time", 15)
	elseif MODEL.EXISTS.tmc.present() and MODEL.tmc.present() then
		wTmcF1 = wTmcF2
		wTmcF2 = MODEL.tmc.current_station_frequency_short()
		if wTmcSearchMode and DOUBLE.new(tostring(wTmcF1)) > DOUBLE.new(tostring(wTmcF2)) then
			wTmcSearchMode = false
			wTmcSearch = -1
		end
		if wTmcScan > 0 then
			wTmcScan = wTmcScan - 1
		else
			if MODEL.lua.wTMCTunerMode() == 5 or MODEL.lua.wTMCTunerMode() == 2 or (wTmcSearchMode and MODEL.lua.wTMCTunerMode() ~= 3) or MODEL.ui.wSelectStation.list.isempty() then
				MODEL.tmc.tuner_search_up()
			else
				wTmcSearch = wTmcSearch + 1
				if wTmcSearch < MODEL.ui.wSelectStation.list.size() then
					MODEL.tmc.set_frequency_manual(MODEL.ui.wSelectStation[wTmcSearch].frequency())
				elseif MODEL.lua.wTMCTunerMode() == 3 then
					wTmcSearch = -1
				else
					wTmcSearch = -1
					wTmcSearchMode = true
					wTmcF1 = L"75"
					wTmcF2 = wTmcF1
					MODEL.tmc.set_frequency_manual(wTmcF1)
				end
			end
			wTmcScan = sc_GetSysEntry("tmc", "test_station_time", 3)
		end
	end
end

sc_wTmcFixed = function()
	if MODEL.lua.wTMCFixedStation() == L"" then
		sc_wTmcAutoScan()
	elseif not (MODEL.tmc.station_tuned() and MODEL.tmc.current_station_frequency_short() == MODEL.lua.wTMCFixedStation()) and	MODEL.EXISTS.tmc.present() and MODEL.tmc.present() then
		if wTmcScanFixed > 0 then
			wTmcScanFixed = wTmcScanFixed - 1
		else
			MODEL.tmc.set_frequency_manual(MODEL.lua.wTMCFixedStation())
			wTmcScanFixed = sc_GetSysEntry("tmc", "test_fixedstation_time", 2)
		end
	end
end

sc_wEnterfreqFixedStation = function()
	sc_wEditStationFrequency_init(MODEL.lua.wTMCFixedStation(), sc_wInputFrequencyFixedStationDone)
end

sc_wInputFrequencyFixedStationDone = function()
	MODEL.lua.wTMCFixedStation = ui.inpwFrequency.VALUE()
	sc_back()
end
 
sc_wAutoAddTmcStation = function()
	if MODEL.ui.wSelectStation.list.size() < sc_GetSysEntry("tmc", "saved_stations", 30) then
		wTmcF1 = wTmcF2
		wTmcF2 = MODEL.tmc.current_station_frequency_short()
		if DOUBLE.new(tostring(wTmcF2)) > DOUBLE.new("108") or DOUBLE.new(tostring(wTmcF1)) < DOUBLE.new("75") then
			return
		end
		local station_exist = false
		for item in ModelList_iter(MODEL.ui.wSelectStation) do
			if DOUBLE.new(tostring(item.frequency())) == DOUBLE.new(tostring(MODEL.tmc.current_station_frequency_short())) then
				station_exist = true
				break
			end
		end
		if not station_exist then
			ui.wSelectStation:add({name=MODEL.tmc.current_station_name(), frequency=MODEL.tmc.current_station_frequency_short()})
			MODEL.ui.wSelectStation.save()
		end
	end
end

sc_wSelectStation = function()
	sc_NextStateAnim(st_wSelectStation, "horz_scroll", 1, "")
end

createState("st_wSelectStation")
st_wSelectStation:useLayers(backgroundLayers, "ui_List_Background", "ui_wSelectStation")
st_wSelectStation.init = function()
	txtTitle.TEXT = m_i18n("Select station")
end
 
sc_wSelectStationOnRelease = function()
	if MODEL["*"].frequency() ~= L"" then
		MODEL.tmc.set_frequency_manual(MODEL["*"].frequency())
	end
	sc_back()
end
 
sc_wSelectStationDel_OnRelease = function()
	sc_wShowNewMessageBox(translated_format(m_i18n("Are you sure you want to delete this station from list?")),"sc_wSelectStationDel_OnRelease_OK", m_i18n("Delete"),"ico_del_sml.bmp#3",MODEL["*"].name())
end
 
sc_wSelectStationDel_OnRelease_OK = function()
	MODEL.ui.wSelectStation.remove(MODEL.ui.wSelectStation.list.index())
	MODEL.ui.wSelectStation.save()
end
 
sc_wSelectStationAll_OnRelease = function()
	sc_wShowNewMessageBox(m_i18n("Are you sure you want to delete all stations from list?"),"sc_wSelectStationAll_OnRelease_OK",m_i18n("Delete All"),"ico_DeleteAll_mid.bmp#3")
end
 
sc_wSelectStationAll_OnRelease_OK = function()
	MODEL.ui.wSelectStation.clear()
	MODEL.ui.wSelectStation.save()
end
 
sc_wAddSelectStation_OnRelease = function()
	ui.wSelectStation:add({name=L"", frequency=L""})
	MODEL.ui.wSelectStation.save()
	local add_index = MODEL.ui.wSelectStation.list.size() - 1
	local current = MODEL.ui.wSelectStation[add_index]
	wSettingDistOverIndex = add_index
	MODEL.lua.wSettingDistSoundName = current.name()
	MODEL.lua.wSettingProgramParameter = current.frequency()
	sc_NextStateAnim(st_wSelectStationEdit, "horz_scroll", 1, "")
end
 
sc_wSelectStationEdit_OnRelease = function()
	local current = MODEL["*"]
	wSettingDistOverIndex = index
	MODEL.lua.wSettingDistSoundName = current.name()
	MODEL.lua.wSettingProgramParameter = current.frequency()
	sc_NextStateAnim(st_wSelectStationEdit, "horz_scroll", 1, "")
end
 
createState("st_wSelectStationEdit")
st_wSelectStationEdit:useLayers(backgroundLayers, "ui_wSelectStationEdit")
st_wSelectStationEdit.init = function()
	txtTitle.TEXT = m_i18n("Edit station entry")
end
 
st_wSelectStationEdit.exit = function()
	local current = MODEL.ui.wSelectStation[wSettingDistOverIndex]
	current.name = MODEL.lua.wSettingDistSoundName()
	current.frequency = MODEL.lua.wSettingProgramParameter()
	MODEL.ui.wSelectStation.save()
end
 
sc_wEditStationName = function()
	MODEL.regional.keyboard.smartkey_model("")
	inpSI_Text.VALUE = MODEL.lua.wSettingDistSoundName()
	inpSI_Text.EMPTYTITLE = m_i18n("<Enter Station Name>")
	MODEL.lua.easyShowDoneKey = true
	ui.vKeyTableDone = sc_EditStationNameDone
	inputFieldRequired = false
	txtTitle.TEXT = m_i18n("Set Station Name")
	sc_NextStateAnim(st_SimpleInputText, "fade", 1, "")
end
 
sc_EditStationNameDone = function()
	MODEL.lua.wSettingDistSoundName = ui.inpSI_Text.VALUE()
	sc_back()
end

sc_wEnterfreqManual = function()
	sc_wEditStationFrequency_init(L"", sc_wInputFrequencyManualDone)
end

sc_wEditStationFrequency = function()
	sc_wEditStationFrequency_init(MODEL.lua.wSettingProgramParameter(), sc_wInputFrequencyDone)
end

sc_wEditStationFrequency_init = function(startvalue,donescript)
	sc_NextStateAnim(st_wInputFrequency, "horz_scroll", 1, "")
	inpwFrequency.VALUE = startvalue
	ui.vKeyTableDone = donescript
end

createState("st_wInputFrequency")
st_wInputFrequency:useLayers(backgroundLayers, "ui_wInputFrequency")
st_wInputFrequency.init = function()
	MODEL.lua.easyShowDoneKey = true
	local keyboard = MODEL.regional.keyboard
	keyboard.load_panel_by_type(EInputPanelType.Numeric)
	keyboard.load_panel_by_name(L"Core Numbers")
	sc_wInputFrequency_onchange()
	keyboard.smartkey_model("lua.validator_chars")
	MODEL.lua.keyb_done = MODEL.lua.validator_done()
	keyboard.modifiers = 0
	inpwFrequency.EMPTYTITLE = translated_format(m_i18n("<Enter Number (%s)>"), L"75.0-108.0")
	inpwFrequency:SELECT()
	inpwFrequency:SYNCKBPANEL()
	txtTitle.TEXT = m_i18n("Set Station Frequency")
end
 
st_wInputFrequency.done = function()
	closeKeyboard:trigger()
	MODEL.regional.keyboard.on_close_panel()
	MODEL.regional.keyboard.smartkey_model("")
end
 
sc_wInputFrequency_onchange = function()
	sc_CheckNextChar("double", ui.inpwFrequency.VALUE(), "75.00", "108.00", 1)
	MODEL.lua.keyb_done = MODEL.lua.validator_done()
end
 
sc_wInputFrequencyManualDone = function()
	MODEL.tmc.set_frequency_manual(ui.inpwFrequency.VALUE())
	sc_back()
end
 
sc_wInputFrequencyDone = function()
	MODEL.lua.wSettingProgramParameter = ui.inpwFrequency.VALUE()
	PREVSTATE()
end
 
local sc_TMC_SearchResult_orig = sc_TMC_SearchResult
sc_TMC_SearchResult = function()
	sc_TMC_SearchResult_orig()
	if MODEL.lua.tmcWasPresented() and MODEL.tmc.present() then
		sc_wTmcChangeTunning()
	end
end
 
st_Traffic_Summary:removeLayers(localMenuLayers)
st_Traffic_Summary.init = function()
	txtTitle.TEXT = m_i18n("Traffic Summary")
	MODEL.traffic.events.auto_update(true)
	sc_UpdateNextTrafficEventText()
	nextEventUpdateTimerId = doDelayed(100, sc_UpdateNextTrafficEventText, true)
end
 
sc_LocalMenuOpenTrafficSettings = function()
	gTmcSettingsFromSum = true
	sc_btnASM_Traffic_OnRelease()
end
 
--vehicle.lua
sc_wVehicleProfileEngineType_OnRelease = function()
	if MODEL.INT.mydata.vehicle_profile.list.current.engine_type() < 2 then
		MODEL.INT.mydata.vehicle_profile.list.current.engine_type = MODEL.INT.mydata.vehicle_profile.list.current.engine_type() + 1
	else
		MODEL.INT.mydata.vehicle_profile.list.current.engine_type = 0
	end
	sc_TriggerVehicleSettingChanged()
end
 
sc_wGetVehicleProfileEngineType = function()
	local type = MODEL.INT.mydata.vehicle_profile.list.current.engine_type()
	return (type == 2 and "Hybrid Engine (Gasoline)" or (type == 1 and "Diesel Engine" or "Otto Engine (Gasoline)"))
end
 
sc_VehicleProfileMaxSpeed_OnRelease = function()
	local min = (MODEL.mydata.vehicle_profile.list.current.vehicle_type() == 5 and 1 or (MODEL.mydata.vehicle_profile.list.current.vehicle_type() == 6 and 5 or 50))
	local max = (MODEL.mydata.vehicle_profile.list.current.vehicle_type() == 5 and 20 or (MODEL.mydata.vehicle_profile.list.current.vehicle_type() == 6 and 100 or 200))
	sc_SelectValueInteger("Set maximum speed for this vehicle profile", sc_VehicleProfileMaxSpeedDone, min, max, false)
end
 
sc_VehicleProfileMaxSpeedDone = function()
	if not inpValueInteger_isempty() then
		local text = tonumber(ui.inpValueInteger.VALUE())
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.INT.mydata.vehicle_profile.list.current.maxspeed = text
		sc_TriggerVehicleSettingChanged()
	end
	sc_back()
end
 
createState("st_tomsoft_Settings_v")
st_tomsoft_Settings_v:useLayers(backgroundLayers, ui_tomsoft_Settings_v)
st_tomsoft_Settings_v.init = function()
	txtTitle:SET(m_i18n("Visual settings"))
end

sc_btnASM_tomsoft_v_OnRelease = function()
  sc_NextStateAnim(st_tomsoft_Settings_v, "horz_scroll", 1, "")
end

createState("st_Wiman_extra_Settings")
st_Wiman_extra_Settings:useLayers(backgroundLayers, ui_Wiman_extra_Settings)
st_Wiman_extra_Settings.init = function()
	txtTitle:SET(m_i18n("Wiman & Gpsforum - Extra settings"))
end

sc_btnASM_Wiman_extra_OnRelease = function()
  sc_NextStateAnim(st_Wiman_extra_Settings, "horz_scroll", 1, "")
end 

createState("st_fontsize_Settings")
st_fontsize_Settings:useLayers(backgroundLayers, ui_fontsize_Settings)
st_fontsize_Settings.init = function()
	txtTitle:SET(m_i18n("Font size"))
end

sc_wiman_fontsize_OnRelease = function()
  sc_NextStateAnim(st_fontsize_Settings, "horz_scroll", 1, "")
end  

createState("st_fontcolour_Settings")
st_fontcolour_Settings:useLayers(backgroundLayers, ui_fontcolour_Settings)
st_fontcolour_Settings.init = function()
	txtTitle:SET(m_i18n("Font color day"))
end

sc_wiman_fontcolour_OnRelease = function()
  sc_NextStateAnim(st_fontcolour_Settings, "horz_scroll", 1, "")
end 

createState("st_fontcolourN_Settings")
st_fontcolourN_Settings:useLayers(backgroundLayers, ui_fontcolourN_Settings)
st_fontcolourN_Settings.init = function()
	txtTitle:SET(m_i18n("Font color night"))
end

sc_wiman_fontcolourN_OnRelease = function()
  sc_NextStateAnim(st_fontcolourN_Settings, "horz_scroll", 1, "")
end 

createState("st_maneuver_Settings")
st_maneuver_Settings:useLayers(backgroundLayers, ui_maneuver_Settings)
st_maneuver_Settings.init = function()
	txtTitle:SET(m_i18n("Maneuver"))
end

sc_wiman_maneuver_OnRelease = function()
  sc_NextStateAnim(st_maneuver_Settings, "horz_scroll", 1, "")
end 

createState("st_grand_compass_Settings")
st_grand_compass_Settings:useLayers(backgroundLayers, ui_grand_compass_Settings)
st_grand_compass_Settings.init = function()
	txtTitle:SET(m_i18n("Compass on the map"))
end

sc_wiman_compass_OnRelease = function()
  sc_NextStateAnim(st_grand_compass_Settings, "horz_scroll", 1, "")
end 

createState("st_Grand_Compass")
st_EasyNav:useLayers(primary, ui_Grand_Compass)

sc_changecolor = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then
color = col_green
elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorss = function(color)
if color == 6  then
color = colss_white
elseif colorss == 5 then
color = colss_yellow
elseif color == 4 then
color = colss_red
elseif color == 3 then
color = colss_blue
elseif color == 2 then
color = colss_green
elseif color == 1 then
color = colss_brown
elseif color == 0 then
color = fn_cock_dataT
end
return color
end

sc_changeshad = function(shad)
if shad == 1  then
color = col_black
elseif shad == 0 then
color = col_white
end
return shad
end

sc_changeshadss = function(shad)
if shad == 1  then
color = colss_black
elseif shad == 0 then
color = colss_white
end
return shad
end

sc_changeshadleft = function(shadleft)
if shadleft == 1  then
color = col_black
elseif shadleft == 0 then
color = col_white
end
return shadleft
end

sc_changeshadleftss = function(shadleft)
if shadleft == 1  then
color = colss_black
elseif shadleft == 0 then
color = colss_white
end
return shadleft
end

sc_changeshadbotton = function(shadbotton)
if shadbotton == 1  then
color = col_black
elseif shadbotton == 0 then
color = col_white
end
return shadbotton
end

sc_changeshadbottonss = function(shadbotton)
if shadbotton == 1  then
color = colss_black
elseif shadbotton == 0 then
color = colss_white
end
return shadbotton
end

sc_changeshadothers = function(shadothers)
if shadothers == 1  then
color = col_black
elseif shadothers == 0 then
color = col_white
end
return shadothers
end

sc_changeshadothersss = function(shadothers)
if shadothers == 1  then
color = colss_black
elseif shadothers == 0 then
color = colss_white
end
return shadothers
end

sc_TransparencyPercent = function(value)
	return (tostring(100*value/32) .. "%") 
end

sc_Changepar_pio = function(pio)
	return (tostring(pio).."min")
	end

sc_changecolorcdistance = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNleft()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadleft()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorctime = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNleft()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadleft()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorctimespan = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNleft()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadleft()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorcgpstime = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNleft()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadleft()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolordistance = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNbotton()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadbotton()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolortime = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNbotton()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadbotton()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolortimespan = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNbotton()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadbotton()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorcstreet = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadN()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShad()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolornstreet = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadN()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShad()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorcity = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadN()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShad()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorcdistman = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNothers()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadothers()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorndistman = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNothers()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadothers()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

sc_changecolorcspeed = function(color)
if color == 6  then
color = col_white
elseif color == 5 then
color = col_yellow
elseif color == 4  then
color = col_red
elseif color == 3 then
color = col_blue
elseif color == 2 then

     if (MODEL.screen.nightmode() and MODEL.lua.colShadNothers()) or (MODEL.screen.nightmode() == false and MODEL.lua.colShadothers()) then

 	    color = col_green
           else
	    color = col_greenn
          end

elseif color == 1 then
color = col_brown
elseif color == 0 then
color = fn_cock_data
end
return color
end

 sc_wReadOutRouteSummaryTimeSupported = function()
	return type(VOICE.eta) == "function" and MODEL.regional.current_voice.is_tts()
end
sc_wEta_OnRelease = function()
	sc_NextStateAnim(st_wSetIntervalTime, "fade", 1, "")
end
createState("st_wSetIntervalTime")
st_wSetIntervalTime:useLayers(backgroundLayers,"ui_wSetIntervalTime")
st_wSetIntervalTime.init = function()
	txtTitle.TEXT = m_i18n("Time of arrival TTS Pro Settings")
end
st_wSetIntervalTime.done = function()
	if wTestSpeakingID then
		PromptCancel(wTestSpeakingID)
		wTestSpeakingID = 0
	end
end
sc_wEtaTTS_play = function()
	sc_wsayspeech_test(VOICE.eta(MODEL.gps.current_time()))
end
sc_weta_change = function()
	if MODEL.sound.speech.is_say_bool() or MODEL.sound.voice_muted() then
		return
	end
	if MODEL.lua.wLastKnownEtaTime_etatts() == TIMETYPE.new(0) then
		if wEtaStartDelay then
			wEtaStartDelay = wEtaStartDelay - 1
			return
		end
	end
	local nextwaypoint = MODEL.lua.wETATTSVoiceWaypoint() and MODEL.route.list.navigated.waypoints.list.size() > 2
	local current_time = nextwaypoint and MODEL.navigation.eta_at_waypoint() or MODEL.navigation.eta_at_destination()
	current_time = TIMETYPE.new({hour = current_time.hour, min = current_time.min, sec = 0, millisec = 0})
	local interval = MODEL.navigation.distance_to_destination() > MODEL.lua.wDistanceEta() and MODEL.lua.wIntervalEtaLong() or MODEL.lua.wIntervalEta()
	local current_interval = (current_time >= MODEL.lua.wLastKnownEtaTime() and 1 or -1) * (current_time - MODEL.lua.wLastKnownEtaTime())
	if current_interval >= TIMESPAN.new(1000 * interval) then
		if not MODEL.sound.speech.is_say_bool() then
			sc_wsayspeech(VOICE.eta(current_time,nextwaypoint),21,25)
			MODEL.lua.wLastKnownEtaTime = current_time
		end
	end
end

-- .ad. rodizio

MODEL.SET.lua.ADshowRodizio = BOOL_MODEL(true)

ad_showRodizio = function(dia_da_placa,country)
 	local hora = MODEL.gps.current_time().hour
	local showRodizio = false
		
	if dia_da_placa == 6 or not (country == "_BRA") then		-- obrigado ao Fidelis
		showRodizio = true						-- true mostra a placa
		else	
			if MODEL.gps.current_date().dayOfWeek == dia_da_placa then 
				if hora == 7 or hora == 8 or hora == 9 or hora == 17 or hora == 18 or hora == 19 then
					showRodizio = true
				end
			end 
	end
	if dia_da_placa == 0 then
		showRodizio = false
	end	
MODEL.lua.ADshowRodizio = showRodizio
end
