﻿module("VOICE")

ASSERT(type(voice_debug_log) == "function", "Missing voice_debug_log function.")
ASSERT(type(transform_chain) == "function", "Missing transform_chain function.")
ASSERT(type(table_concat) == "function", "Missing table_concat function.")
ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(transform.substitute_transform) == "table", "Missing substitute_transform table.")
ASSERT(type(wsplit) == "function", "Missing wsplit function.")
ASSERT(type(wjoin) == "function", "Missing wjoin function.")


local function getDirectionPrePharse(wstr)
	local pre_pharse = L" en direction de "
	return pre_pharse .. wstr
end

local function getDestinationPrePharse(wstr)
	local pre_pharse = L" jusqu'à "
	return pre_pharse .. wstr
end

local function checkStreetType(wstr)
	local street = wstr
	local street_table = wsplit(wstr, L'%s')
	local number = #street_table
	local first_element, str
	if number > 1 then
		first_element = street_table[1]
		if first_element ~= transform.street_type2gender:transform(first_element) then
			str = transform.street_type2gender:transform(first_element)
		else
			voice_debug_log(L"[DEBUG5] The street type isn't special! Street type is " .. wstr .. L".", 5)
			str = L''
		end
		return str
	end
end

local function checkInManouverTable(str)
	local res
	for k,v in pairs(maneuver_type2type) do
		if str == k then
			res = v
			return res
		end
	end
	if res == nil then
		res = str
	end
	return res
end

local function getManouverType(str)
	local res = checkInManouverTable(str)
	return res
end

local function getManoverValue(manouver_type, guidance)
	local res
	if manouver_type ~= nil and guidance ~= nil then
		res = type2value[manouver_type][guidance]
	else
		voice_debug_log("[DEBUG3] The argument cannot be nil! The manouver_type is " .. tostring(manouver_type) .. " and the guidance is " .. tostring(guidance), 3)
		res = L''
	end
	return res
end

local function getArticleWithGuidanceAndWstr(actual_guidance, wstr)
	local pre
	if actual_guidance == L'aggr' then
		pre = checkStreetType(wstr)
	else
		pre = actual_guidance
	end
	return pre
end

local function getArticle(manouver, wstr, guidance)
	local manouver_type, actual_guidance, prepos
	if manouver ~= checkInManouverTable(manouver) then
		manouver_type = getManouverType(manouver) 
		actual_guidance = getManoverValue(manouver_type, guidance) 
		prepos = getArticleWithGuidanceAndWstr(actual_guidance, wstr) 
	else
		
		voice_debug_log(" Please see the manouver name! Actual manouver is " .. manouver .. ". Perhaps it isn't in the maneuver_type2type table!", 3)
		prepos = L""
	end
	if prepos == nil then
		
		voice_debug_log("Preposition is nil!",3)
		prepos = L""
	end
	return prepos .. L" "
end

local function getResolvedAbbreviation(wstr)
	local actual = wstr
	local actual_table = wsplit(actual, L'%s')
	local number = #actual_table
	local joined_table
	if #actual_table > 1 then
		for k,v in pairs(actual_table) do
			actual_table[k] = transform.substitute_transform:transform(v)
		end
	else
		actual_table[1] = transform.substitute_transform:transform(actual_table[1])
	end
	joined_table = wjoin(actual_table, L" ")
	return joined_table
end


local function signpost_exitnumber(data, idx)
	local exitnumber = data[idx].signpost.exitnumber
	local str
	if exitnumber then
		if exitnumber.phoneme then
			str = getDirectionPrePharse(exitnumber.phoneme)
		else
			str = getDirectionPrePharse(exitnumber.text)
		end
		return str
	end
	
end

local function signpost_exitname(data, idx)
	local exitname = data[idx].signpost.exitname
	local str, abbrev_str
	if exitname then
		if exitname.phoneme then
			str = getDirectionPrePharse(exitname.phoneme)
		else
			abbrev_str = getResolvedAbbreviation(exitname.text)
			str = getDirectionPrePharse(abbrev_str)
		end
		return str
	end
	
end

local function signpost_destination(data, idx)
	local destination = data[idx].signpost.destination
	local str, abbrev_str
	if destination then
		if destination.phoneme then
			str = getDestinationPrePharse(destination.phoneme)
		else
			abbrev_str = getResolvedAbbreviation(destination.text)
			str = getDestinationPrePharse(abbrev_str)
		end
		return str
	end
	
end

local function signpost_settlement(data, idx)
	
	local settlement = data[idx].signpost.settlement
	local str, abbrev_str
	local pre = L" vers la " 
	if settlement then
		if settlement.phoneme then
			str = pre .. settlement.phoneme
		else
			abbrev_str = getResolvedAbbreviation(settlement.text)
			str = pre .. abbrev_str
		end
		return str
	end
	
end

local function signpost_roadnumber(data, idx)
	local str
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then
		if roadnumber.phoneme then
			str = roadnumber.phoneme
		else
			str = roadnumber.text
			
		end
		return str
	end
end

local function road_name(data, idx)
	local name = data[idx].road.name
	local manouver = data[idx].manouver
	local article, str, abbrev_str
	if name then
		abbrev_str = getResolvedAbbreviation(name.text)
		if name.phoneme then
			article = getArticle(manouver, abbrev_str, 'street_name')
			str = article .. L" " .. name.phoneme
		else
			article = getArticle(manouver, abbrev_str, 'street_name')
			str = article .. abbrev_str
		end
		return str
		
	end
end

local function road_number(data, idx)
	local number = data[idx].road.number
	local str
	if number then
		if number.phoneme then
			str = number.phoneme
		else
			str = number.text
			
		end
		return str
	end
	
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	if sentence_transform then
		str = sentence_transform:transform(str)
	end
	return str
end


function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu)
end

function route_summary_format_street_name(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_order(data)
	return transform_and_format(data, substitute_transform)
end
