local IQS_Search = MODEL.address.multi

function sc_IQS_Onrelease()
	sc_NextStateAnim( st_IQS_Find, "fade", 0, "")
	sc_ShowMapUpdateNotification()
end


--------------------------------------------------------------------------------------------------------------------------------------------------------------
--Address Base Setup------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------
function sc_IQS_InitSearchBase()
	IQS_Search.do_spellcheck = true
	
	MODEL.map.cursor.position = MODEL.navigation.car.position()
	E_IQS_SearchSetup.Center = MODEL.map.cursor.position() -- previously set as car pos or last selected city
	-- default center for ordering is the car position
	IQS_Search.center_for_distance_ordering = E_IQS_SearchSetup.Center
	IQS_Search.distance = E_IQS_SearchSetup.Distance
	
	local isStreetSearchSupported = MODEL.address.search.support_streetsearch_in_state( MODEL.map.cursor.address.state():sub( 2, 4 ) )
	if isStreetSearchSupported then -- we should only set state, because we can search streets in it
		IQS_Search.country_code = MODEL.map.cursor.address.state():sub( 2, 4 )
		E_IQS_SearchSetup.CityID = qWord_0
		
		MODEL.my.map.select_country( IQS_Search.country_code() )
		MODEL.lua.IQS_CenterName = MODEL.address.search.get_country_and_state_text( IQS_Search.country_code() )
		MODEL.lua.IQS_CenterDescription = L""
	else
		IQS_Search.country_code = ""
		E_IQS_SearchSetup.CityID = MODEL.map.cursor.city_id()
		
		MODEL.my.map.select_cos(E_IQS_SearchSetup.CityID)
		--MODEL.lua.IQS_CenterName = wstring.gsub( MODEL.my.map.selected_item.text(), L"\n", L", ")
		local name
		local desc
		name, desc = MODEL.address.search.get_city_text(E_IQS_SearchSetup.CityID)
		MODEL.lua.IQS_CenterName = name
		MODEL.lua.IQS_CenterDescription = desc 
	end
	
	IQS_Search.baseposition = E_IQS_SearchSetup.Center
	IQS_Search.city_id = E_IQS_SearchSetup.CityID 
	IQS_Search.drop_result()
	IQS_Search.suggest_keywords(0, L"")
	IQS_Search.result_filtering = false
	IQS_Search.category_list.setcurrent(-1)
end


function sc_IQS_SetBasePosition( StoreCountryAndCity )
	E_IQS_SearchSetup.Center = IQS_Search.baseposition()
	if StoreCountryAndCity then
		E_IQS_SearchSetup.Country = IQS_Search.country_code()
		E_IQS_SearchSetup.CityID = IQS_Search.city_id()
	end
	IQS_Search.baseposition = E_IQS_SearchSetup.Center
	IQS_Search.center_for_distance_ordering = E_IQS_SearchSetup.Center
	if StoreCountryAndCity then
		IQS_Search.country_code = E_IQS_SearchSetup.Country
		IQS_Search.city_id = E_IQS_SearchSetup.CityID 
	end
	IQS_Search.separate_corrected = true
end

function sc_IQS_InitIQSSearchCategory()
	IQS_Search.find_favourites = true
	IQS_Search.find_gls = true
	IQS_Search.find_history = true
	IQS_Search.find_junction = true
	IQS_Search.find_kmlpoi = true
	IQS_Search.find_location = false
	IQS_Search.find_poi = true
	IQS_Search.find_poi_container = true
	IQS_Search.find_street = true
	IQS_Search.enable_mixed_category = true
	IQS_Search.exact_parse = 2 -- only the full-covered nodes will be results
end

function sc_IQS_InitIQSPOISearch()
	local POISetup = IQS_Search.poi_query()
	POISetup.area = 300000
	POISetup.center = "fixed"
	POISetup.position = IQS_Search.baseposition()
	
	IQS_Search.custom_favourites_query = true
	POISetup = IQS_Search.favourites_query()
	POISetup.area = -1
	POISetup.center = "fixed"
	POISetup.position = IQS_Search.baseposition()
	
end

function sc_IQS_ShowKeyboard()
	IQS_Search.result_filtering = false
	MODEL.regional.keyboard.load_panel_by_type(EInputPanelType.Alpha, false)
	MODEL.regional.keyboard.load_panel_by_name(PERSISTENT.keyboard_panel_alpha())
	sc_init_local_menu("ui.lm_keyboardPanels", nil, "IME")
	sc_SetEnabledKeyboardPanels()
end

--------------------------------------------------------------------------------------------------------------------------------------------------------------
--st_IQS_Find es a hozza tartozo dolgok------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------

st_IQS_Find:useLayers( backgroundLayers,
					   "ui_IQS_Find",
					   localMenuLayers )

function st_IQS_Find.enter()
	btn_IQS_CityCenter.TEXT = m_i18n("City Center")
	inp_IQS_Find.value = L""
	sc_IQS_InitSearchBase()
	MODEL.lua.IQS_SortBy = "distance"
	MODEL.other.force_init_finish("poi")
	if PERSISTENT.vIQS_TutorialCount_Place() < gIQS_HintCount then
		PERSISTENT.vIQS_TutorialCount_Place = PERSISTENT.vIQS_TutorialCount_Place() + 1 
		ui_IQS_Find_Tutorial:SHOW()
	end
end

function st_IQS_Find.init()
	AddressSearchState.mode	= AddressSearchMode.address
	local ForceSearch = IQS_Search.find_location()
	txtTitle.TEXT = m_i18n("Combined Search")
	
	sc_IQS_ShowKeyboard()
    sc_IQS_InitIQSSearchCategory()
    sc_IQS_InitIQSPOISearch()
    KEY("RETURN", sc_IQS_ShowResultList)
    ui.vKeyTableDone = sc_IQS_ShowResultList
    MODEL.lua.easyShowDoneKey = false
    
    IQS_Search.category_filter = E_IQS_CategoryTypes.All
	IQS_Search.do_filter()
	
	IQS_Search.sort_filtered(MODEL.lua.IQS_SortBy())
	
	MODEL.lua.keyb_result_count_model = "address.multi.filtered_list.size"
	inputFieldRequired = true
	inputFieldRequired_space = true
	sc_INP_onchange(0, ui.inp_IQS_Find.value)
	
	if (ui.inp_IQS_Find.VALUE() ~= L"" and ForceSearch) then
		sc_IQS_FindResult()
	end
end

function st_IQS_Find.done()
	KEY("RETURN")
	MODEL.lua.keyb_result_count_model = ""
end

function st_IQS_Find.exit()
	killDelayed(MODEL.lua.IQS_SearchDelayID())
	MODEL.lua.IQS_SearchDelayID = -1
	IQS_Search.cancel_search()
	IQS_Search.drop_result()
	--IQS_Search.reset()
	MODEL.poi.IQS_flat_search.drop_result()
end

function sc_IQS_FindResult()
	local value = ui.inp_IQS_Find.VALUE()
	MODEL.lua.IQS_Filter = value
	
	IQS_Search.cancel_search()

	if ( MODEL.lua.IQS_SearchDelayID() ~= -1 ) then
		killDelayed(MODEL.lua.IQS_SearchDelayID())
		MODEL.lua.IQS_SearchDelayID = -1
	end
	if wstring.len(value) >= gIQS_MinChar then
		IQS_Search.predefined_category_order = " "
		MODEL.lua.IQS_SearchDelayID = doDelayed( gIQS_SearchDelay, sc_IQS_FindResult_Delayed )
	else
		IQS_Search.name_filter = value
	end
	IQS_Search.suggest_keywords(0, value)
end

function sc_IQS_FindResult_Delayed()
	MODEL.lua.IQS_SearchDelayID = -1
	local value = ui.inp_IQS_Find.VALUE()
	sc_IQS_SetBasePosition( true ) -- do not reset country/city
	
	IQS_Search.name_filter = value
	IQS_Search.set_exclusive_query(-1)
	IQS_Search.sort(E_IQS_SearchSetup.SortBy)
	IQS_Search.distance = E_IQS_SearchSetup.Distance
	IQS_Search.execute()
end

function sc_IQS_ShowResultList()
	if ( MODEL.lua.IQS_SearchDelayID() ~= -1 ) then
		killDelayed(MODEL.lua.IQS_SearchDelayID())
		sc_IQS_FindResult_Delayed()
	end
	sc_NextStateAnim(st_IQS_Find_Result, "horz_scroll", 1, "")
end

--------------------------------------------------------------------------------------------------------------------------------------------------------------
--st_IQS_Find_Result es a hozza tartozo dolgok------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------


st_IQS_Find_Result:useLayers( backgroundLayers,
						        "ui_IQS_Find_Result",
						        "ui_IQS_Find_Result_Category",
						        "ui_IQS_Find_Result_Poi_Providers",
						        "ui_List_Background",
					            localMenuLayers )

function st_IQS_Find_Result.enter()
	IQS_Search.category_list.setcurrent(0)
	MODEL.lua.IQS_ResultListType = ""
	if PERSISTENT.vIQS_TutorialCount_Result() < gIQS_HintCount then
		PERSISTENT.vIQS_TutorialCount_Result = PERSISTENT.vIQS_TutorialCount_Result() + 1 
		ui_IQS_Find_Result_Tutorial:SHOW()
	end
end

function st_IQS_Find_Result.init()
	txtTitle.TEXT = m_i18n("Search Results")
	sc_init_local_menu("ui.lm_IQS_LocalSort", nil, "Sort")
	g_OnPoiListItemClicked = sc_FlatSearch_OnPoiItemClicked
	IQS_Search.resume_search()
end

function st_IQS_Find_Result.done()
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = false
end


function st_IQS_Find_Result.exit()
	Back:unregister(sc_IQS_BackFromPOIResult)
end

function sc_IQS_FilterCategoryList()
	local item = MODEL["*"]
	local type = item.type()
	item._list.setcurrent(index)
	
	IQS_Search.result_filtering = true

	IQS_Search.category_filter = item.id()
	IQS_Search.do_filter()
	IQS_Search.sort_filtered(MODEL.lua.IQS_SortBy())

	if item.original_name() == "POI Container" then
		MODEL.lua.IQS_ResultListType = "POI_Container_Result"
	else
		MODEL.lua.IQS_ResultListType = ""
	end
	
	IQS_Search.sort_filtered(MODEL.lua.IQS_SortBy())
	IQS_Search.set_exclusive_query(type)
	
	MODEL.ui.lst_IQS_ResultList.scroll_pos = 0
	
	if (item.original_name() == "POI" and MODEL.lua.PoiProviderFiltering()) then
		gLastProviderID = gROPoi_Provider
		MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
		uieffect:GRAB()
		MODEL.lua.IQS_ResultListType = "ProviderFilter_All"
		Back:register(sc_IQS_BackFromPOIResult)
		
		if MODEL.interface.uieffect_enabled() and MODEL.interface.default_anim_off() then
			uieffect:DO_ANIM( "horz_scroll", 1, "" )
		end
	end
end

function sc_IQS_FilterCategoryList_NetLocalSearch()
	IQS_Search.category_list.setcurrent(-1)
	MODEL.lua.IQS_ResultListType = "NetLocalSearch"
	local flat_search = MODEL.poi.IQS_flat_search
	MODEL.poi.providers[MODEL.lua.featured_provider_id()].enabled = true
	flat_search.clear_providers()
	flat_search.search_root = 0
	flat_search.name_filter = IQS_Search.name_filter()
	flat_search.exclude_provider = true
	flat_search.non_idle = false
	flat_search.add_provider(gROPoi_Provider)
	flat_search.add_provider(MODEL.poi.find_provider("kmlpoi"))
	flat_search.add_provider(gUserPOI_Provider)
	flat_search.center = "fixed"
	flat_search.position = E_IQS_SearchSetup.Center
	flat_search.no_sort()
	flat_search.execute()
	obs_IQS_google_flat_search_ready:START()

end

function sc_IQS_NetLocalSearchReady()
	obs_IQS_google_flat_search_ready:STOP()
	if (MODEL.poi.providers[MODEL.lua.featured_provider_id()].last_response_status() ~= 0 and
	    MODEL.poi.providers[MODEL.lua.featured_provider_id()].last_response_status() ~= 6 and
		MODEL.poi.providers[MODEL.lua.featured_provider_id()].last_response_status() ~= 200) then
		--print("LAST_RESPONSE: " .. MODEL.poi.providers[MODEL.lua.featured_provider_id()].last_response_status())
		local newMsgBox = MODEL.screen.msgbox.new
		newMsgBox.setup( 1 )
		newMsgBox.set_line( 1, m_i18n("Cannot connect to server!") )
		newMsgBox.setup_button( 1, "sc_IQS_EmptyScript", m_i18n("Ok"),"","ico_cancel_mid.bmp#3" )
		MODEL.screen.msgbox.create_new()
	end
end

function sc_IQS_EmptyScript()

end

function sc_IQS_ResultSortBy(sort)
	sc_close_local_menu()
	MODEL.lua.IQS_SortBy = sort
	if MODEL.lua.IQS_ResultListType() == "ProviderFilter" then
		MODEL.poi.IQS_provider_hack.sort(sort)
	else
		IQS_Search.sort_filtered(sort)
	end
	MODEL.ui.lst_IQS_ResultList.scroll_pos = 0
end

--Select Item - Result List------------------------------------------------------------------------------------------------------------------------------------------------------------
function sc_IQS_Seclect_Item()
	IQS_Search.pause_search()
	local item = MODEL["*"]
	local type = item.type()
	if ( type == "Street" ) then
		if item.subtype() == "City" then
			MODEL.my.map.select_cos( item.city_id() )
		elseif (item.street_id()) ~= "" and item.subtype() ~= "Junction" then
			MODEL.my.map.select_street(item.street_id(), item.address.city(), item.address.street())
		else
			local JunctionStreetID = item.junction_street_id()
			if JunctionStreetID ~= "" then
				MODEL.my.map.select_junction( JunctionStreetID, item.street_id() )
			else
				MODEL.my.map.select_address(item.position(), item.address.city(), item.address.street(), item.address.housenum())
			end
			MODEL.my.map.selected_item.name = wstring.gsub(item.override_name(), L"%^", L"")
		end
	elseif ( type == "POI" ) then
		sc_FlatSearch_OnPoiItemClicked(item)
	elseif ( type == "Favourites" ) then
		sc_et_FindFavorite_OnRelease()
	elseif ( type == "History" ) then
		sc_SelectHistoryMain(item.history_index())
	elseif ( type == "Junction" ) then
		MODEL.my.map.select_junction( item.junction_street_id(), item.street_id() )
	elseif ( type == "Gcoor" ) then
		MODEL.my.map.select_gcoor(item.position())
	end
	sc_routeto_show_route()
end


function sc_IQS_Seclect_POIContainer()
	local flat_search = MODEL.poi.flat_search()
	flat_search.reset()
	flat_search.center = "fixed"
	flat_search.position = IQS_Search.baseposition()
	flat_search.distance_on_route = "default"
	flat_search.calculate_detour = "default"
	flat_search.area = 300000
	flat_search.sort = MODEL.lua.IQS_SortBy()
	flat_search.search_root = MODEL["*"].poicontainer_index()
	flat_search.execute()
	g_OnPoiListItemClicked = sc_FlatSearch_OnPoiItemClicked
	if MODEL.lua.IQS_SortBy() == "distance" then
		MODEL.lua.PoiSort = EPoiSort.Distance
	else
		MODEL.lua.PoiSort = EPoiSort.Name
	end
	sc_NextStateAnim(st_FindPOIFlatList, "horz_scroll", 1, "")
end


--------------------------------------------------------------------------------------------------------------------------------------------------------------
--st_IQS_Find_Result es a hozza tartozo dolgok------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------

function sc_IQS_ChangeSearchCenter()
	sc_NextStateAnim( st_IQS_Center, "vert_scroll", 1, "")
end

st_IQS_Center:useLayers( backgroundLayers,
					   "ui_IQS_Center",
					   localMenuLayers )

function st_IQS_Center.enter()
	if ( MODEL.lua.IQS_SearchDelayID() ~= -1 ) then
		killDelayed(MODEL.lua.IQS_SearchDelayID())
		MODEL.lua.IQS_SearchDelayID = -1
	end
	IQS_Search.cancel_search()
	inp_IQS_FindCenter.value = L""
	MODEL.lua.IQS_Filter = L""
	if PERSISTENT.vIQS_TutorialCount_Center() < gIQS_HintCount then
		PERSISTENT.vIQS_TutorialCount_Center = PERSISTENT.vIQS_TutorialCount_Center() + 1 
		ui_IQS_Center_Tutorial:SHOW()
	end
end

function st_IQS_Center.init()
	txtTitle.TEXT = m_i18n("Select Search Area")	
	sc_IQS_ShowKeyboard()
	sc_IQS_SetupCenterSearch()
	KEY("RETURN", sc_IQS_ShowCenterResultList)
	ui.vKeyTableDone = sc_IQS_ShowCenterResultList
	MODEL.lua.keyb_result_count_model = "address.multi.list.size"
	inputFieldRequired = true
	inputFieldRequired_space = true
	IQS_Search.category_filter = E_IQS_CategoryTypes.All
	sc_INP_onchange(0, ui.inp_IQS_FindCenter.value)
end

function sc_IQS_SetupCenterSearch()
	IQS_Search.find_favourites = false
	IQS_Search.find_gls = false
	IQS_Search.find_history = false
	IQS_Search.find_junction = false
	IQS_Search.find_kmlpoi = false
	IQS_Search.find_location = true
	IQS_Search.find_poi = false
	IQS_Search.find_poi_container = false
	IQS_Search.find_street = false
	IQS_Search.enable_mixed_category = false
end

function st_IQS_Center.done()
	MODEL.lua.keyb_result_count_model = ""
end

function st_IQS_Center.exit()
	IQS_Search.cancel_search()
	IQS_Search.drop_result()
	obs_IQS_searchcenter_search_ready:STOP()
end

function sc_IQS_SearchCenter()
	local value = ui.inp_IQS_FindCenter.VALUE()
	MODEL.lua.IQS_Filter = value
	IQS_Search.cancel_search()
	if value:len() == 0 then
		MODEL.ui.lm_IQS_SavedCenterItem[0].name_highlighted	= L""
	end
	
	if wstring.len(value) >= gIQS_MinChar then
		if (MODEL.lua.IQS_SearchDelayID() ~= -1 ) then
			killDelayed(MODEL.lua.IQS_SearchDelayID())
			MODEL.lua.IQS_SearchDelayID = -1
		end
		--Ide nem kell delay
		--MODEL.lua.IQS_SearchDelayID = doDelayed( gIQS_SearchDelay, sc_IQS_SearchCenter_Results )
		sc_IQS_SearchCenter_Results()
	else
		IQS_Search.name_filter = value
	end
	IQS_Search.suggest_keywords(1, value)
end

function sc_IQS_SearchCenter_Results()
	MODEL.lua.IQS_SearchDelayID = -1
	local value = ui.inp_IQS_FindCenter.VALUE()
	IQS_Search.name_filter = value
	IQS_Search.set_exclusive_query(-1)
	IQS_Search.distance = E_IQS_SearchSetup.Distance
	IQS_Search.center_for_distance_ordering = E_IQS_SearchSetup.Center
	IQS_Search.execute()
	obs_IQS_searchcenter_search_ready:START()
end

function sc_IQS_SearchCenteSearchReady()
	obs_IQS_searchcenter_search_ready:STOP()

	local ListItem				= MODEL.ui.lm_IQS_SavedCenterItem[0]
	local ListItem_orig			= IQS_Search.list[0]
	
	ListItem.name				= ListItem_orig.name()
	ListItem.name_highlighted	= ListItem_orig.name_highlighted()
	ListItem.description		= ListItem_orig.description()
	ListItem.subtype			= ListItem_orig.subtype()
	ListItem.country_id			= ListItem_orig.country_id()
	ListItem.city_id			= ListItem_orig.city_id()
	ListItem.position			= ListItem_orig.position()

end

function sc_IQS_ShowCenterResultList()
	sc_NextStateAnim( st_IQS_Center_Result, "horz_scroll", 1, "")
end

function sc_IQS_SelectNewSearchCenter()
	IQS_Search.result_filtering = false
	IQS_Search.country_code = ""
	IQS_Search.city_id = QWORD.new( 0 )
	local item = MODEL["*"]
	local Subtype = item.subtype()
	if (Subtype == "Country") or (Subtype == "State") then
		IQS_Search.country_code = item.country_id()
		MODEL.my.map.select_country( item.country_id() )
		E_IQS_SearchSetup.CityID = qWord_0
		E_IQS_SearchSetup.Center = MODEL.my.map.selected_item.position()
		MODEL.lua.IQS_CenterName = item.name()
		MODEL.lua.IQS_CenterDescription = L""
		
	elseif (Subtype == "City") or (Subtype == "Zip") then
		local CityID = item.city_id()
		MODEL.my.map.select_cos(CityID)
		--MODEL.lua.IQS_CenterName = wstring.gsub( MODEL.my.map.selected_item.text(), L"\n", L", ")
		local name
		local desc
		name, desc = MODEL.address.search.get_city_text(CityID)
		MODEL.lua.IQS_CenterName = name
		MODEL.lua.IQS_CenterDescription = desc 
		
		E_IQS_SearchSetup.CityID = CityID
		E_IQS_SearchSetup.Center = item.position()
		sc_IQS_SetZIPCityID( CityID )
		IQS_Search.center_for_distance_ordering =  E_IQS_SearchSetup.Center
	else
		-- not handled subtype!
		ASSERT( false , 'Subtype :' .. Subtype)
	end

	if MODEL.lua.IQS_CenterName() == L"" then
		MODEL.lua.IQS_CenterName = item.name()
		MODEL.lua.IQS_CenterDescription = L""
	end
	
	IQS_Search.baseposition = E_IQS_SearchSetup.Center
	IQS_Search.city_id = E_IQS_SearchSetup.CityID
	
	if st_IQS_Center_Result.isActive then
		uieffect:GRAB()
		CLEARTOSTATE( st_IQS_Center )
		PREVSTATE()
	else
		sc_PrevStateAnim()
	end
	
	if ui.inp_IQS_Find.VALUE() then
		sc_IQS_FindResult()
	end
end

function sc_IQS_GotoCityCenter()
	MODEL.my.map.select_cos(E_IQS_SearchSetup.CityID)
	sc_FindAddressDone()
end

function sc_IQS_SetZIPCityID( CityID )
	local IdType = MODEL.my.map.get_admidx_type( CityID )
	if IdType == 4 then
		IQS_Search.city_id = CityID
	else
		IQS_Search.city_id = QWORD.new( 0 )
	end
end

--------------------------------------------------------------------------------------------------------------------------------------------------------------
--st_IQS_Find_Result es a hozza tartozo dolgok------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------

st_IQS_Center_Result:useLayers( backgroundLayers,
					   "ui_List_Background",
					   "ui_IQS_Center_Result")

function st_IQS_Center_Result.init()
	IQS_Search.category_list.setcurrent(0)
	txtTitle.TEXT = m_i18n("Search Results")
end


--------------------------------------------------------------------------------------------------------------------------------------------------------------
--IQS Provider Filter------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------------------------------


function sc_IQS_SetPoiProviderFilter(providerID)
	MODEL["*"]._list.setcurrent(index)
	if gLastProviderID == providerID then
		return
	end
	gLastProviderID = providerID
	MODEL.lua.IQS_ResultListType = "ProviderFilter"
	local flat_search = MODEL.poi.IQS_provider_hack()
	flat_search.reset()
	flat_search.area = IQS_Search.distance()
	flat_search.exclude_provider = false
	flat_search.clear_providers()
	flat_search.add_provider(providerID)
	flat_search.search_root = 0
	if MODEL.address.multi.phone_search() then
		flat_search.phone_filter = IQS_Search.poi_query.phone_filter()
	else
		flat_search.name_filter = IQS_Search.name_filter()
	end
	flat_search.non_idle = false
	flat_search.center = "fixed"
	flat_search.position = E_IQS_SearchSetup.Center
	flat_search.sort(MODEL.lua.IQS_SortBy())
	flat_search.execute()
end

function sc_IQS_RemovePoiProviderFilter()
	MODEL.ui.lm_POI_ProviderAll.setcurrent(0)
	gLastProviderID = gROPoi_Provider
	MODEL.poi.IQS_provider_hack.drop_result()
	MODEL.lua.IQS_ResultListType = "ProviderFilter_All"
end

function sc_IQS_BackFromPOIResult()
	if ((MODEL.lua.IQS_ResultListType() == "ProviderFilter_All" or MODEL.lua.IQS_ResultListType() == "ProviderFilter") and st_IQS_Find_Result.isActive) then
		Back:prevent_default()
		uieffect:GRAB()
		IQS_Search.category_list.setcurrent(0)
		IQS_Search.category_filter = E_IQS_CategoryTypes.All
		IQS_Search.do_filter()
		IQS_Search.sort_filtered(MODEL.lua.IQS_SortBy())
		MODEL.lua.IQS_ResultListType = ""
		
		if MODEL.interface.uieffect_enabled() and MODEL.interface.default_anim_off() then
			uieffect:DO_ANIM( "horz_scroll", 0, "" )
		end
		
		Back:unregister(sc_IQS_BackFromPOIResult)
	end
end

gPrevFirstStart = sc_first_start_default_settings

function sc_first_start_default_settings()
	gPrevFirstStart()
	PERSISTENT.savedMapLocalMenu[0] = ("iqs")
end
