﻿

module("VOICE")

ASSERT(type(voice_debug_log) == "function", "Missing voice_debug_log function.")
ASSERT(type(voice_debug_log_table) == "function", "Missing voice_debug_log_table function.")

ASSERT(type(wjoin) == "function", "Missing wjoin function.")
ASSERT(type(wsplit) == "function", "Missing wsplit function.")
ASSERT(type(getFirstNChar) == "function", "Missing getFirstNChar function.")
ASSERT(type(getLastNChar) == "function", "Missing getLastNChar function.")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(transform_chain) == "function", "Missing transform_chain function.")
ASSERT(type(table_concat) == "function", "Missing table_concat function.")
ASSERT(type(transform_pattern_match) == "function", "Missing transform_pattern_match function.")

ASSERT(type(transform_destname) == "table", "Missing transform_destname table.")
ASSERT(type(exit_number2verso) == "table", "Missing exit_number2verso table.")
ASSERT(type(exit_number2acc) == "table", "Missing exit_number2acc table.")
ASSERT(type(roadnumber2verso) == "table", "Missing roadnumber2verso table.")
ASSERT(type(sn_roadnumber2su) == "table", "Missing sn_roadnumber2su table.")
ASSERT(type(sn_roadnumber2empty) == "table", "Missing sn_roadnumber2empty table.")
ASSERT(type(keep_maneuvers) == "table", "Missing keep_maneuvers table.")
ASSERT(type(sentence_transform) == "table", "Missing sentence_transform table.")
ASSERT(type(substitute_transform) == "table", "Missing substitute_transform table.")
ASSERT(type(transform.streettype2article) == "table", "Missing transform.streettype2article table.")
ASSERT(type(transform.verso_exception) == "table", "Missing transform.verso_exception table.")


local function getNthChar(wstr, number)
	ASSERT(type(wstr) == 'wstring', 'In getNthChar() first argument is not wstring!')
	ASSERT(type(number) == 'number', 'In getNthChar() second argument is not number!')
	local nth_char
	if #wstr >= number then
		nth_char = wstring.sub(wstr, number, number)
	else
		voice_debug_log(L"The Nth char out of range! The word is " .. wstr .. L" and the requested Nth is " .. number, 5)
		nth_char = wstr
	end
	return nth_char
end





local function isInTable(str, table)
  for k, v in pairs(table) do
    if v == str then
      return true
    end
  end
end


local function getWithoutPreposIfInfinitive(str, with_point, without_point)
  local gsubbed, wstr
  gsubbed = wstring.gsub(str, with_point, L' %1 %3 ')
  if gsubbed == str then
    wstr = wstring.gsub(str, without_point, L' %1 %3 ')
  else
    wstr = gsubbed
  end
  voice_debug_log(L'\nModified pattern is:\t' .. wstr , 5)
  return wstr
end

local function wrapperInfinitive(str, prepos)
  ASSERT(type(prepos) == 'wstring', L"In wrapperInfinitive() prepos type must be wstring! Prepos is '" .. towstring(prepos) .. L"' and type is " .. towstring(type(prepos)))
  local with_point, without_point, ret
  with_point = L'(%s*[P|p]rendi%s+.+)(%s+' .. prepos .. L'%s+)(.+%..+)'
  without_point = L'(%s*[P|p]rendi%s+.+)(%s+' .. prepos .. L'%s+)(.+%..*)'
  voice_debug_log(L'\nDelete "'.. prepos ..L'"\nOriginal pattern is:\t' .. str, 5)
  return getWithoutPreposIfInfinitive(str, with_point, without_point)
end

local function checkInfinitive(str)
	if wstring.find(str, L'%s*[P|p]rendi%s+') then
		if wstring.find(str, L"%s+in%s+") then
			return wrapperInfinitive(str, L'in')
		elseif wstring.find(str, L"%s+su%s+") then
			return wrapperInfinitive(str, L'su')
		else
			voice_debug_log(L"\nSentence has infinitive, but hasn't search preposition", 5)
			return str
		end
	else
		return str
	end
end

local function checkException(wstr)
  local modified = wstring.gsub(wstr, L"(.+)(%s+in%s+)(%s*roccordo%s+)(.+)", L" %1 sul %3 %4")
  if modified ~= wstr then
    wstr = modified
  end
  return wstr
end


local function nameWrapper_TransformAndFormat(in_data, prepos_type)
  ASSERT(prepos_type ~= nil, 'In nameWrapper prepos_type connot be nil! ')
  if in_data.phoneme then
    return transform_and_format(in_data.phoneme, nil, prepos_type)
  else
    return transform_and_format(in_data.text, substitute_transform,  prepos_type)
  end
end

local function numberWrapper_TransformAndFormat(in_data, prepos_type)
  ASSERT(prepos_type ~= nil, 'In numberWrapper prepos_type connot be nil! ')
  if in_data.phoneme then
    return transform_and_format(in_data.phoneme, nil, prepos_type)
  else
    return transform_and_format(in_data.text, transform_format_roadnumber_eu,  prepos_type)
  end
end


local function signpost_exitnumber(data, idx)
  local exitnumber = data[idx].signpost.exitnumber
  if exitnumber then
    local manouver = data[idx].manouver
    if isInTable(manouver, exit_number2verso) then
      return transform_and_format(exitnumber, nil, transform_destname.exitnumber_verso)
    elseif isInTable(manouver, exit_number2acc) then
      return transform_and_format(exitnumber, nil, transform_destname.exitnumber_acc)
    else
      return transform_and_format(exitnumber, nil, transform_destname.exitnumber)
    end
  end
end

local function signpost_exitname(data, idx)
  local exitname = data[idx].signpost.exitname
  if exitname then
	return transform_and_format(exitname, substitute_transform, transform_destname.exitname)
  end
end

local function signpost_destination(data, idx)
  local destination = data[idx].signpost.destination
  if destination then
	return transform_and_format(destination, substitute_transform, transform_destname.destination)
  end
end

local function signpost_settlement(data, idx)
  local settlement = data[idx].signpost.settlement
  if settlement then
    local article = transform.verso_exception:transform(settlement.text)
    if article == settlement.text then
	  return transform_and_format(settlement, substitute_transform, transform_destname.settlement)
    else
      local wstr = transform_and_format(settlement, substitute_transform, transform_destname.settlement)
      
      
	  return wstring.gsub(wstr, L" verso ", L" verso "..article)
    end
  end
end

local function signpost_roadnumber(data, idx)
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then
      local manouver = data[idx].manouver
      if isInTable(manouver, roadnumber2verso) then
        return numberWrapper_TransformAndFormat(roadnumber, transform_destname.roadnumber_verso)
      else
        return numberWrapper_TransformAndFormat(roadnumber, transform_destname.roadnumber)
      end
	end
end  

local function road_name(data, idx)
  local name = data[idx].road.name
  if name then
    local manouver = data[idx].manouver
    if isInTable(manouver, keep_maneuvers) then
      return nameWrapper_TransformAndFormat(name, transform_destname.roadname_verso)
    else
      return nameWrapper_TransformAndFormat(name, transform_destname.roadname)
    end
  end
end

local function road_number(data, idx)
	local number = data[idx].road.number
	if number then
      local manouver = data[idx].manouver
      if isInTable(manouver, sn_roadnumber2empty) then
        return numberWrapper_TransformAndFormat(number, transform_destname.sn_roadnumber2empty)
      elseif isInTable(manouver, sn_roadnumber2su) then
        return numberWrapper_TransformAndFormat(number, transform_destname.sn_roadnumber2su)
      else
        return numberWrapper_TransformAndFormat(number, transform_destname.roadnumber)
      end
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(wstr)
  if sentence_transform then
    wstr = checkException(wstr)
    wstr = checkInfinitive(wstr)
    ASSERT(type(wstr) == 'wstring', L"In the format_sentence() #1 isn't wstring!")
    wstr = sentence_transform:transform(wstr)
  end
  return wstr
end


function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu)
end

function route_summary_format_street_name(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_order(data)
	return transform_and_format(data, substitute_transform)
end


function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	
	if data.roadnumber then 
		local road = transform_and_format(data.roadnumber, transform_format_roadnumber_eu, L" sulla strada %s")
		if data.from and not data.to then
		
			str =  str..road..transform_and_format(data.from, nil, L", verso %s")
		elseif data.from and data.to then 
		
			str =  str..road..L", tra "..transform_and_format(data.from, substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
		
			str = str..road
		end
	
	elseif data.roadname then
		local road = transform_and_format(data.roadname, transform.roadname_abbrev_table, L" in %s")
		if data.from and not data.to then
			
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", all'incrocio di "..from..L" e "..to
			else 
				str = str..road..L", all'incrocio di "..transform_and_format(data.from,substitute_transform)
			end
		elseif data.from and data.to then
			str = str..road..L", tra "..transform_and_format(data.from,substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
			str = str..road
		end
	
	else
		if data.from and not data.to then
		
			str =  str..L" verso "..transform_and_format(data.from,substitute_transform)
		elseif data.from and data.to then 
		
			str =  str..L" tra "..transform_and_format(data.from,substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
		
		end
	end
	str = str..L"."
	return str
end

