﻿module("VOICE")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(substitute_transform) == "table", "Missing substitute_transform table.")

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

----------------------------------|  G R A M M A R   T A B L E S  |---------------------------------

-- Kiralyok, kiralynok es kiralynek. Sokan vannak :)
local women = {	L"Isabel", L"María", L"Catalina", L"Juana"}

local men = {	L"Juan", L"Carlos", L"Carles", L"Alfonso", L"Felipe", L"Fernando", 
		L"Miguel", L"Sebastián", L"Pedro", L"Enrique", L"Manuel", L"Alberto", 
		L"José", L"Lu[ií]s", L"Alberto"} 

local prefix_types = {
	text = 1,
	article = 2,
	en_article = 3,
	tomando_article = 4,
}

local prefix_attributes = {
	[prefix_types.text] 		= {prefix = L"", article=false}, 
	[prefix_types.article] 		= {prefix = L"", article=true}, 
	[prefix_types.en_article]	= {prefix = L"en ", article=true}, 
	[prefix_types.tomando_article] 	= {prefix = L"tomando ", article=true}, 
}

local maneuver_prefix = {
	continue_left = prefix_types.en_article,
	continue_right = prefix_types.en_article,
	continue_sharp_left = prefix_types.en_article,
	continue_sharp_right = prefix_types.en_article,
	continue_uturn_left = prefix_types.en_article,
	continue_uturn_right = prefix_types.en_article,
	deformed_roundabout_exit = prefix_types.tomando_article,
	exit_left = prefix_types.tomando_article,
	exit_right = prefix_types.tomando_article,
	ferry = prefix_types.text,
	ferry_exit = prefix_types.text,
	goal = prefix_types.text,
	goal_left = prefix_types.text,
	goal_right = prefix_types.text,
	highway_enter = prefix_types.text,
	highway_leave = prefix_types.tomando_article,
	keep_left = prefix_types.en_article,
	keep_left_b = prefix_types.en_article,
	keep_left_hwy = prefix_types.en_article,
	keep_left_shwy = prefix_types.en_article,
	keep_right = prefix_types.en_article,
	keep_right_b = prefix_types.en_article,
	keep_right_hwy = prefix_types.en_article,
	keep_right_shwy = prefix_types.en_article,
	left = prefix_types.en_article,
	left_end = prefix_types.en_article,
	priority = prefix_types.article,
	priority_left = prefix_types.article,
	priority_right = prefix_types.article,
	ramp_left = prefix_types.en_article,
	ramp_right = prefix_types.en_article,
	right = prefix_types.en_article,
	right_end = prefix_types.en_article,
	roundabout_back = prefix_types.tomando_article,
	roundabout_exit = prefix_types.tomando_article,
	roundabout_h = prefix_types.tomando_article,
	roundabout_l = prefix_types.tomando_article,
	roundabout_left = prefix_types.tomando_article,
	roundabout_right = prefix_types.tomando_article,
	roundabout_straight = prefix_types.tomando_article,
	sharp_left = prefix_types.en_article,
	sharp_right = prefix_types.en_article,
	slight_left = prefix_types.en_article,
	slight_right = prefix_types.en_article,
	straight = prefix_types.article,
	uturn = prefix_types.text,
	uturn_left = prefix_types.en_article,
	uturn_left_dual = prefix_types.text,
	uturn_right = prefix_types.en_article,
	uturn_right_dual = prefix_types.text,
	via = prefix_types.text,
	via_left = prefix_types.text,
	via_right = prefix_types.text,
}

local street_name_articles = {
	-- LA
	{{L"^calle ", L"^avenida ", L"^vereda ", L"^autopista ", 
	  L"^autovia ", L"^autovía ",L"^carretera ", L"^nacional ", L"^rotonda ", 
	  L"^travesia ", L"^travesa ", L"^salida ", L"^cuesta ", L"^ronda ",
	  L"^pista ", L"^plaza ", L"^plaça ", L"^rúa ", L"^ruta ", L"^ruela ", 
	  L"^callejuela ", L"^alameda ", L"^rambla ", L"^via ", L"^vía ", 
	  L"^urbanización ", L"^placeta "}, 
	  L"la "},
	-- EL
	{{L"^carrer ", L"^barrio ", L"^camiño ", L"^camino ",  L"^camí ",L"^nudo ", L"^barranco ", 
	  L"^distribuidor ", L"^cruce ", L"^callejón ", L"^carreró ", L"^concejo ", 
	  L"^túnel ", L"^parque ", L"^parc ", L"^semáfor ", L"^paseo ", L"^passeig ", 
	  L"^viaduct ", L"^muelle ", L"^moll ", L"^pasaje ", L"^passatge ", L"^puente ", 
	  L"^pont ", L"^residencial ", L"^jardín ", L"^jardines ", L"^grupo ", L"^pasillo ", L"^arrabal ", 
	  L"^arroyo ", L"^campo ", L"^poligono ", L"^lugar ", L"^patio ", L"^pas ",}, 
	  L"el "},
}

local function get_article(data)
	local article
	local text
	if type(data) == "wstring" then text = data 
	elseif data.text then text = data.text end
	
	if text then
		text = wstring.lower(transform_and_format(text, substitute_transform))
		for _, v in ipairs(street_name_articles) do
			for _, reg in ipairs(v[1]) do
				if wstring.find(text, reg) then article = v[2] break end
			end
			if article then break end
		end
		if not article then article = L"la " end
	end
	return article
end

local function get_prefix_attribute(data, idx)
	return prefix_attributes[maneuver_prefix[data[idx].manouver]]
end

---------------------------------------|  R E A L   W O R K  |--------------------------------------

local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, nil, transform_destname.exitnumber)
end

local function signpost_exitname(data, idx)
	return transform_and_format(data[idx].signpost.exitname, substitute_transform, transform_destname.exitname)
end

local function signpost_destination(data, idx)
	return transform_and_format(data[idx].signpost.destination, substitute_transform, transform_destname.to)
end

local function signpost_settlement(data, idx)
	return transform_and_format(data[idx].signpost.settlement, substitute_transform, transform_destname.settlement)
end

local function signpost_roadnumber(data, idx)
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then 
		local pa = get_prefix_attribute(data, idx)
		local prefix = pa.prefix
		if pa.article then prefix = prefix .. L"la " end
		return prefix..transform_format_roadnumber_eu(roadnumber.text)
	end
end

local function transform_roadname(str)
	-- Ferfiak
	for _, v in ipairs(men) do
		if wstring.find(str, v) then 
			return men_subsitute_transform:transform(str)
		end
	end
	-- Nok
	for _, v in ipairs(women) do
		if wstring.find(str, v) then 
			return women_subsitute_transform:transform(str)
		end
	end
	return substitute_transform:transform(str)
end

local function road_name(data, idx)
	local name = data[idx].road.name
	if not name then return end
	local article = L""
	local pa = get_prefix_attribute(data, idx)
	if pa.article then
		article = get_article(data[idx].road.name)
	end
	return pa.prefix .. article  .. transform_and_format(data[idx].road.name, transform_roadname)
end

local function road_number(data, idx)
	local number = data[idx].road.number
	if number then 
		local pa = get_prefix_attribute(data, idx)
		local prefix = pa.prefix
		if pa.article then prefix = prefix .. L"la " end
		return prefix..transform_format_roadnumber_eu(number.text)
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	if sentence_transform then
		str = sentence_transform:transform(str)
	end
	return str
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------

function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu)
end

function route_summary_format_street_name(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_order(data)
	return transform_and_format(data, substitute_transform)
end

----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	---- Roadnumber prioritas
	if data.roadnumber then 
		local road = L" en la "..data.roadnumber.text 
		if data.from and not data.to then
		-- M7 uton Martonvasar kozeleben
			str =  str..road..L" cerca de "..transform_and_format(data.from, substitute_transform)
		elseif data.from and data.to then 
		-- M7 uton, Martonvasar es Velence kozott - ha az y utan i jön akkor e lesz
			str =  str..road..L", entre "..transform_and_format(data.from)..L" y "..transform_and_format(data.to, substitute_transform)
		else
		-- Egyeb: M7 uton
			str = str..road
		end
	---- Roadname
	elseif data.roadname then
		local article = get_article(data.roadname)
		local road = transform_and_format(data.roadname, substitute_transform, L" en "..article..L"%s")
		if data.from and not data.to then
			-- "," menten robbantunk
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				local article = get_article(from)
				local esta
				if article == L"la " then esta = L" ésta"
				else esta = L" éste" end
				str = str..road..L", en la intersección de"..esta..from..L" con "..to
			else 
				str = str..road..L", en la intersección de "..transform_and_format(data.from, substitute_transform)
			end
		elseif data.from and data.to then
			-- ha az y utan i jön akkor e lesz 
			local from = transform_and_format(data.from, substitute_transform)
			local to = transform_and_format(data.to, substitute_transform)
			str = str..road..L", entre "..get_article(from)..from..L" y "..get_article(to)..to
		else
			str = str..road
		end
	---- Nincs se roadnumber, se roadname 
	else
		if data.from and not data.to then
		-- Martonvasar kozeleben
			str =  str..L" en las cercanías de "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- ha az y utan i jön akkor e lesz 
			local from = transform_and_format(data.from, substitute_transform)
			local to = transform_and_format(data.to, substitute_transform)
			str =  str..L" entre "..get_article(from)..from..L" y "..get_article(to)..to
		else
		-- Egyeb: semmi
		end
	end
	str = str..L"."
	return str
end

----------------------------------------------------------------------------------------------------
---------------------------------------------|  E T A  |--------------------------------------------
----------------------------------------------------------------------------------------------------
function eta(time)
	local head = L"Llegará a su destino "
	local article
	local min
	local tod -- time of day


	local hour = time.hour
	if hour == 0 then hour = 12 end
	if hour > 12 then hour = hour - 12 end
	
	if hour == 1 then article = L"a la "
	else article = "a las " end

	if time.min ~= 0 then min = L":"..towstring(time.min) 
	else min = L"" end

	if time.hour < 3 then tod = L" de la noche."
	elseif time.hour < 6 then tod = L" de la madrugada."
	elseif time.hour < 12 then tod = L" de la mañana."
	elseif time.hour < 20 then tod = L" de la tarde."
	else tod = L" de la noche." end

	return head..towstring(hour)..min..tod
end
