﻿module("VOICE")

transform_destname = {
	exitname   = L"%s",
	exitnumber = L"%s",
	roadname   = L"%s",
	to         = L"%s",
	settlement = L"vers %s"
}

sentence_transform = TRANSFORM.new({
	-- Comma remover, to be localized
	{2,L"(?i)\\. +(ensuite,?) +",L", \\1 "},
	--
	{2,L"(%p)+ *(%p)+",L"%1 "},
	{2,L"%s+(%p+)",L"%1 "},
	{2,L" +",L" "},
})

substitute_transform = TRANSFORM.new({
	{2,L"^(%u)(%u)[ -]*(%d+)",L"%1.%2. %3"},
	{2,L"\-",L" "},
	{2,L"(%d)(%a)",L"%1 %2"},
	{2,L"(%a)(%d)",L"%1 %2"},
	{2,L"//",L", "},
	-- Resolve abbreviations here
	{1,L"Adj /C",L"Adjudant-Chef"},
	{1,L"Adj C",L"Adjudant-Chef"},
	{1,L"Adj. /C",L"Adjudant-Chef"},
	{1,L"L -d",L"Lieu-Dit"},
	{1,L"L. -d",L"Lieu-Dit"},
	{1,L"S/Ltn",L"Sous-Lieutenant"},
	{1,L"S/Ltn",L"Sous-Lieutenant"},
	{1,L"V/am",L"Vice-Amiral"},
	--
	{1,L"ZI",L"Zone Industrielle"},
	{1,L"ZAE",L"Zone d'Activités Économiques"},
	{1,L"ZAC",L"Zone d'Activités Commerciales"},
	{1,L"ZA",L"Zone Artisanale"},
	{1,L"Xrd",L"crossraude"},
	{1,L"Xing",L"crossing"},
	{1,L"Wls",L"wells"},
	{1,L"Wl",L"well"},
	{1,L"Ways",L"wayss"},
	{1,L"Way",L"way"},
	{1,L"Wall",L"wall"},
	{1,L"Walk",L"walk"},
	{1,L"Vws",L"viouss"},
	{1,L"Vw",L"viou"},
	{1,L"Vlys",L"valléss"},
	{1,L"Vly",L"vallée"},
	{1,L"Vlgs",L"villaidgiss"},
	{1,L"Vlg",L"villaidge"},
	{1,L"Vl",L"ville"},
	{1,L"Vis",L"vista"},
	{1,L"Vic",L"Vicinal"},
	{1,L"Via",L"viaduct"},
	{1,L"V",L"Villa"},
	{1,L"Upas",L"anndeurpass"},
	{1,L"Uns",L"younďonnss"},
	{1,L"Un",L"younďone"},
	{1,L"Tunl",L"tunnel"},
	{1,L"Trwy",L"Throu way"},
	{1,L"Trl",L"Traile"},
	{1,L"Trfy",L"Traffic way"},
	{1,L"Trce",L"traice"},
	{1,L"Trak",L"track"},
	{1,L"Ter",L"terrace"},
	{1,L"Sts",L"stritss"},
	{1,L"Strm",L"strime"},
	{1,L"Stra",L"stravenoue"},
	{1,L"Ste",L"Sainte"},
	{1,L"Sta",L"staitionne"},
	{1,L"Sqs",L"squouairss"},
	{1,L"Sq",L"Square"},
	{1,L"Spur",L"speur"},
	{1,L"Spgs",L"springss"},
	{1,L"Spg",L"sprigne"},
	{1,L"SO",L"Sud-Ouest"},
	{1,L"Smt",L"sommite"},
	{1,L"Skwy",L"Skaď way"},
	{1,L"Shrs",L"shorss"},
	{1,L"Shr",L"shore"},
	{1,L"Shls",L"chauss"},
	{1,L"Sgt",L"Sergent"},
	{1,L"Sent",L"Sentier"},
	{1,L"SE",L"Sud-Est"},
	{1,L"Rés",L"Résidence"},
	{1,L"Run",L"rune"},
	{1,L"Rue",L"rue"},
	{1,L"Rtes",L"Routes"},
	{1,L"Rte",L"Route"},
	{1,L"Rst",L"reste"},
	{1,L"Rpds",L"rapidss"},
	{1,L"Rpd",L"rapide"},
	{1,L"Row",L"rau"},
	{1,L"Rnch",L"ranch"},
	{1,L"RN",L"Route Nationale"},
	{1,L"Rlle",L"Ruelle"},
	{1,L"Riv",L"Rivière"},
	{1,L"Pte",L"Porte"},
	{1,L"Prés",L"Président"},
	{1,L"Prom",L"Promenade"},
	{1,L"Pcesse",L"Princesse"},
	{1,L"Pce",L"Prince"},
	{1,L"Ord",L"Ordinaire"},
	{1,L"NO",L"Nord-Ouest"},
	{1,L"NE",L"Nord-Est"},
	{1,L"Mmes",L"Mesdames"},
	{1,L"Mme",L"Madame"},
	{1,L"MM",L"Messieurs"},
	{1,L"Mlles",L"Mesdemoiselles"},
	{1,L"Mlle",L"Mademoiselle"},
	{1,L"Mise",L"Marquise"},
	{1,L"Mis",L"Marquis"},
	{1,L"Mal",L"Maréchal"},
	{1,L"M",L"Monsieur"},
	{1,L"Lt",L"Lieutenant"},
	{1,L"Lots",L"Lotissements"},
	{1,L"Ing",L"Ingénieur"},
	{1,L"Imp",L"Impasse"},
	{1,L"Imm",L"Immeuble"},
	{1,L"Gén",L"Général"},
	{1,L"Fg",L"Faubourg"},
	{1,L"Dép",L"Départemental"},
	{1,L"Cte",L"Comte"},
	{1,L"Crs",L"Cours"},
	{1,L"Cpl",L"Caporal"},
	{1,L"Col",L"Colonel"},
	{1,L"Cim",L"Cimetière"},
	{1,L"Ciale",L"Commerciale"},
	{1,L"Cial",L"Commercial"},
	{1,L"Chev",L"Chevalier"},
	{1,L"Che",L"Chemin"},
	{1,L"Chan",L"Chanoine"},
	{1,L"Cdt",L"Commandant"},
	{1,L"Carr",L"Carrefour"},
	{1,L"Card",L"Cardinal"},
	{1,L"Cap",L"Capitaine"},
	{1,L"C",L"Cite"},
	{1,L"Br",L"branche"},
	{1,L"Bds",L"Boulevards"},
	{1,L"Bd",L"Boulevard"},
	{1,L"Avs",L"Avenues"},
	{1,L"Av",L"Avenue"},
	{1,L"Autorte",L"Autoroute"},
	{1,L"Am",L"Amiral"},
	{1,L"Als",L"Allées"},
	{1,L"Al",L"Allée"},
	{1,L"Adj",L"Adjudant"},
})

