﻿module("VOICE")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(substitute_transform) == "table", "Missing substitute_transform table.")

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------


local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, nil, transform_destname.exitnumber)
end

local function signpost_exitname(data, idx)
	return transform_and_format(data[idx].signpost.exitname, substitute_transform, transform_destname.exitname)
end

local function signpost_destination(data, idx)
	return transform_and_format(data[idx].signpost.destination, substitute_transform, transform_destname.to)
end

local function signpost_settlement(data, idx)
	return transform_and_format(data[idx].signpost.settlement, substitute_transform, transform_destname.settlement)
end

local function signpost_roadnumber(data, idx)
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then 
		return transform_and_format(roadnumber.text, transform_format_roadnumber_eu, transform_destname.roadname)
	end
end

local function road_name(data, idx)
	local name = data[idx].road.name
	return transform_and_format(data[idx].road.name, substitute_transform)
end

local function road_number(data, idx)
	local number = data[idx].road.number
	if number then 
		return transform_format_roadnumber_eu(number.text)
	end
end

------------------------------------------|  O U T P U T  |-----------------------------------------
function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	if sentence_transform then
		str = sentence_transform:transform(str)
	end
	return str
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------

function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu)
end

function route_summary_format_street_name(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_order(data)
	return transform_and_format(data, substitute_transform)
end

----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	---- Roadnumber prioritas
	if data.roadnumber then 
		local road = transform_and_format(data.roadnumber, transform_format_roadnumber_eu, L" sulla strada %s")
		if data.from and not data.to then
		-- M7 uton Martonvasar kozeleben
			str =  str..road..transform_and_format(data.from, nil, L", verso %s")
		elseif data.from and data.to then 
		-- M7 uton, Martonvasar es Velence kozott 
			str =  str..road..L", tra "..transform_and_format(data.from, substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
		-- Egyeb: M7 uton
			str = str..road
		end
	---- Roadname
	elseif data.roadname then
		local road = transform_and_format(data.roadname, transform.roadname_abbrev_table, L" in %s")
		if data.from and not data.to then
			-- "," menten robbantunk
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", all'incrocio di "..from..L" e "..to
			else 
				str = str..road..L", all'incrocio di "..transform_and_format(data.from,substitute_transform)
			end
		elseif data.from and data.to then
			str = str..road..L", tra "..transform_and_format(data.from,substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
			str = str..road
		end
	---- Nincs se roadnumber, se roadname 
	else
		if data.from and not data.to then
		-- Martonvasar kozeleben
			str =  str..L" verso "..transform_and_format(data.from,substitute_transform)
		elseif data.from and data.to then 
		-- Martonvasar es Velence kozott 
			str =  str..L" tra "..transform_and_format(data.from,substitute_transform)..L" e "..transform_and_format(data.to,substitute_transform)
		else
		-- Egyeb: semmi
		end
	end
	str = str..L"."
	return str
end

