﻿module("VOICE")

transform_destname = {
	exitname   = L"%s",
	exitnumber = L"%s",
	roadname   = L"%s",
	to         = L"%s",
	settlement = L"%s"
}

sentence_transform = TRANSFORM.new({
	
	{2, L"(?i)\\. +(ardından|sonra,?) +", L", \\1 "},
	
	{2, L"(%p)+ *(%p)+", L"%1 "},
	{2, L"%s+(%p+)", L"%1 "},
	{2, L" +", L" "},
})

substitute_transform = TRANSFORM.new({
	{2, L"^(%u)(%u)[ -]*(%d+)", L"%1.%2. %3"},
	{2, L"\-",L" "},
	{2, L"(%d)(%a)", L"%1 %2"},
	{2, L"(%a)(%d)", L"%1 %2"},
	{2, L"//",L", "},
	
	{2, L"(?i) St\\.? +(\\d+)", L"s t \\1"},
	{2, L"(?i)^St\\.? ", L"Saint "},
	{2, L"(?i) St\\.?$", L"Street "},
	{2, L"(?i)^Dr\\.? ", L"Doctor"},
	{2, L"(?i) Dr\\.?$", L"Drive"},
	
	{1, L"Yzb", L"Yüzbaþý"},
	{1, L"Yrb", L"Yarbay"},
	{1, L"Yk", L"Yokuþ"},
	{1, L"Viy", L"Viyadük"},
	{1, L"Üniv", L"Üniversite"},
	{1, L"Þht", L"Þehit"},
	{1, L"Tðm", L"Teðmen"},
	{1, L"Sok", L"Sokak"},
	{1, L"Sk", L"Sokak"},
	{1, L"Sit", L"Sitesi"},
	{1, L"Prof", L"Profesör"},
	{1, L"No", L"Numara"},
	{1, L"Müh", L"Mühendis"},
	{1, L"Müd", L"Müdür"},
	{1, L"Mim", L"Mimar"},
	{1, L"Mar", L"Mareþal"},
	{1, L"Kvş", L"Kavşak"},
	{1, L"Köp", L"Köprü"},
	{1, L"KD", L"Kuzeydoðu"},
	{1, L"KB", L"Kuzeybatý"},
	{1, L"K", L"Kuzey"},
	{1, L"Hn", L"Haným"},
	{1, L"Gz", L"Gazi"},
	{1, L"Gen", L"General"},
	{1, L"GD", L"Güneydoðu"},
	{1, L"Gçt", L"Geçit"},
	{1, L"GB", L"Güneybatý"},
	{1, L"G", L"Güney"},
	{1, L"Doç", L"Doçent"},
	{1, L"D", L"Doðu"},
	{1, L"Çýk", L"Çýkmaz"},
	{1, L"Cd", L"Cadde"},
	{1, L"Cad", L"Cadde"},
	{1, L"Bnb", L"Binbaþý"},
	{1, L"Blv", L"Bulvar"},
	{1, L"B", L"Batý"},
	{1, L"Alb", L"Albay"},

})
