﻿module("VOICE")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(substitute_transform) == "table", "Missing substitute_transform table.")



local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, nil, transform_destname.exitnumber)
end

local function signpost_exitname(data, idx)
	return transform_and_format(data[idx].signpost.exitname, substitute_transform, transform_destname.exitname)
end

local function signpost_destination(data, idx)
	return transform_and_format(data[idx].signpost.destination, substitute_transform, transform_destname.to)
end

local function signpost_settlement(data, idx)
	return transform_and_format(data[idx].signpost.settlement, substitute_transform, transform_destname.settlement)
end

local function signpost_roadnumber(data, idx)
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then 
		return transform_and_format(roadnumber.text, transform_format_roadnumber_eu, transform_destname.roadname)
	end
end

local function road_name(data, idx)
	local name = data[idx].road.name
	return transform_and_format(data[idx].road.name, substitute_transform)
end

local function road_number(data, idx)
	local number = data[idx].road.number
	if number then 
		return transform_format_roadnumber_eu(number.text)
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	if sentence_transform then
		str = sentence_transform:transform(str)
	end
	return str
end


function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu)
end

function route_summary_format_street_name(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data, substitute_transform)
end

function route_summary_format_order(data)
	return transform_and_format(data, substitute_transform)
end
