﻿

module("VOICE")

transform = {}

transform.roadname_abbrev_table = TRANSFORM.new({	
	{2, L"(?i)([0-9])[ -]BL\\b", L"\\1 Business Loop"},
	{2, L"(?i)([0-9])[ -]BR\\b", L"\\1 Business Road"},
	{2, L"(?i)([0-9])[ -]BS\\b", L"\\1 Business Spur"},
	{2, L"(?i)(\\d+)\\s*HOV", L"\\1, H O V"},
	{2, L"(?i)^S\\.?T\\.? ", L"Saint "},
	{2, L"(?i)\\sST\\.?\\b", L" Street"},
	
	
	{2, L"(?i)^DR\\.?\\b", L"Doctor"},
	{2, L"\-", L" "},
	
	{1, L"xrd", L"Crossroad"},
	{1, L"xing", L"Crossing"},
	{1, L"wys", L"Ways"},
	{1, L"wy", L"Way"},
	{1, L"wls", L"Wells"},
	{1, L"wkwy", L"Walkway"},
	{1, L"wk", L"Walk"},
	{1, L"whrf", L"Wharf"},
	{1, L"wds", L"WOODS"},
	{1, L"vws", L"Views"},
	{1, L"vw", L"View"},
	{1, L"vsta", L"Vista"},
	{1, L"vst", L"Vista"},
	{1, L"vlys", L"Valleys"},
	{1, L"vlly", L"Valley"},
	{1, L"vly", L"Valley"},
	{1, L"vls", L"VILLAS"},
	{1, L"vlgs", L"Villages"},
	{1, L"vlg", L"Village"},
	{1, L"vl", L"Ville"},
	{1, L"vist", L"Vista"},
	{1, L"vis", L"Vista"},
	{1, L"villiage", L"Village"},
	{1, L"villg", L"Village"},
	{1, L"ville", L"Ville"},
	{1, L"villag", L"Village"},
	{1, L"vill", L"Village"},
	{1, L"viadct", L"Viaduct"},
	{1, L"viad", L"VIADUCT"},
	{1, L"via", L"Viaduct"},
	{1, L"vdct", L"Viaduct"},
	{1, L"vally", L"Valley"},
	{1, L"upas", L"Underpass"},
	{1, L"uns", L"Unions"},
	{1, L"unp", L"UNDERPASS"},
	{1, L"un", L"Union"},
	{1, L"twrs", L"Towers"},
	{1, L"twr", L"Tower"},
	{1, L"turnpk", L"Turnpike"},
	{1, L"tunnl", L"Tunnel"},
	{1, L"tunls", L"Tunnels"},
	{1, L"tunl", L"Tunnel"},
	{1, L"tunel", L"Tunnel"},
	{1, L"trwy", L"Throughway"},
	{1, L"trpk", L"Turnpike"},
	{1, L"trnpk", L"Turnpike"},
	{1, L"trls", L"Trails"},
	{1, L"trl", L"Trail"},
	{1, L"trks", L"Tracks"},
	{1, L"trk", L"Track"},
	{1, L"trfy", L"Trafficway"},
	{1, L"trce", L"Trace"},
	{1, L"trak", L"Track"},
	{1, L"trail", L"Trail"},
	{1, L"tr", L"Trail"},
	{1, L"tpke", L"Turnpike"},
	{1, L"tpk", L"Turnpike"},
	{1, L"tlpk", L"TRAILER PARK"},
	{1, L"terr", L"Terrace"},
	{1, L"ter", L"Terrace"},
	{1, L"sumitt", L"Summit"},
	{1, L"sumit", L"Summit"},
	{1, L"sts", L"Streets"},
	{1, L"strvnue", L"Stravenue"},
	{1, L"strvn", L"Stravenue"},
	{1, L"strt", L"Street"},
	{1, L"strp", L"Strip"},
	{1, L"strm", L"Stream"},
	{1, L"streme", L"Stream"},
	{1, L"stream", L"Stream"},
	{1, L"stravn", L"Stravenue"},
	{1, L"straven", L"Stravenue"},
	{1, L"strave", L"Stravenue"},
	{1, L"strav", L"Stravenue"},
	{1, L"stra", L"Stravenue"},
	{1, L"str", L"Street"},
	{1, L"stps", L"Steps"},
	{1, L"stn", L"Station"},
	{1, L"statn", L"Station"},
	{1, L"sta", L"Station"},
	{1, L"squ", L"Square"},
	{1, L"sqs", L"Squares"},
	{1, L"sqrs", L"Squares"},
	{1, L"sqre", L"Square"},
	{1, L"sqr", L"Square"},
	{1, L"sq", L"Square"},
	{1, L"sprngs", L"Springs"},
	{1, L"sprng", L"Spring"},
	{1, L"spngs", L"Springs"},
	{1, L"spng", L"Spring"},
	{1, L"spgs", L"Springs"},
	{1, L"spg", L"Spring"},
	{1, L"snd", L"Sound"},
	{1, L"smt", L"Summit"},
	{1, L"slpe", L"Slope"},
	{1, L"skwy", L"Skyway"},
	{1, L"shrs", L"Shores"},
	{1, L"shr", L"Shore"},
	{1, L"shoars", L"Shores"},
	{1, L"shoar", L"Shore"},
	{1, L"shoals", L"Shoals"},
	{1, L"shoal", L"Shoal"},
	{1, L"shls", L"Shoals"},
	{1, L"shl", L"Shoal"},
	{1, L"sgt", L"Sargeant"},
	{1, L"sgt", L"Sargeant"},
	{1, L"sch", L"School"},
	{1, L"sbwy", L"Subway"},
	{1, L"rvr", L"River"},
	{1, L"rv", L"River"},
	{1, L"run", L"Run"},
	{1, L"rue", L"Rue"},
	{1, L"rtt", L"Retreat"},
	{1, L"rte", L"Route"},
	{1, L"rst", L"Rest"},
	{1, L"rpds", L"Rapids"},
	{1, L"rpd", L"Rapid"},
	{1, L"row", L"Row"},
	{1, L"rnge", L"Range"},
	{1, L"rnd", L"Round"},
	{1, L"rnchs", L"Ranches"},
	{1, L"rnch", L"Ranch"},
	{1, L"rmbl", L"Ramble"},
	{1, L"rk", L"Rock"},
	{1, L"rivr", L"River"},
	{1, L"riv", L"River"},
	{1, L"rf", L"Reef"},
	{1, L"res", L"Reserve"},
	{1, L"rdwy", L"ROADWAY"},
	{1, L"rds", L"Roads"},
	{1, L"rdgs", L"Ridges"},
	{1, L"rdge", L"Ridge"},
	{1, L"rdg", L"Ridge"},
	{1, L"rd", L"Road"},
	{1, L"rch", L"Reach"},
	{1, L"radl", L"Radial"},
	{1, L"radiel", L"Radial"},
	{1, L"radial", L"Radial"},
	{1, L"rad", L"Radial"},
	{1, L"r", L"Branch"},
	{1, L"qys", L"Quays"},
	{1, L"qy", L"Quay"},
	{1, L"qdrt", L"Quadrant"},
	{1, L"pvt", L"Private"},
	{1, L"pvt", L"Private"},
	{1, L"ptwy", L"PATHWAY"},
	{1, L"pts", L"Points"},
	{1, L"pt", L"Point"},
	{1, L"psge", L"Passage"},
	{1, L"ps", L"Pass"},
	{1, L"prts", L"Ports"},
	{1, L"prt", L"Port"},
	{1, L"prr", L"Prairie"},
	{1, L"prom", L"Promenade"},
	{1, L"prof", L"Professor"},
	{1, L"prk", L"Park"},
	{1, L"prarie", L"Prairie"},
	{1, L"pr", L"Prairie"},
	{1, L"pnes", L"Pines"},
	{1, L"pne", L"Pine"},
	{1, L"plza", L"Plaza"},
	{1, L"plz", L"Plaza"},
	{1, L"plns", L"Plaines"},
	{1, L"pln", L"Plain"},
	{1, L"plains", L"Plaines"},
	{1, L"pl", L"Place"},
	{1, L"pky", L"Parkway"},
	{1, L"pkwys", L"Parkways"},
	{1, L"pkwy", L"Parkway"},
	{1, L"pkway", L"Parkway"},
	{1, L"pkt", L"Pocket"},
	{1, L"pk", L"Park"},
	{1, L"phwy", L"Pathway"},
	{1, L"pde", L"Parade"},
	{1, L"pd", L"Pond"},
	{1, L"paths", L"Paths"},
	{1, L"path", L"Path"},
	{1, L"parkwy", L"Parkway"},
	{1, L"pard", L"PARADE"},
	{1, L"ovps", L"OVERPASS"},
	{1, L"ovl", L"Oval"},
	{1, L"otlk", L"Outlook"},
	{1, L"orchrd", L"Orchard"},
	{1, L"orch", L"Orchard"},
	{1, L"opas", L"Overpass"},
	{1, L"neck", L"Neck"},
	{1, L"nck", L"Neck"},
	{1, L"mtwy", L"Motorway"},
	{1, L"mtns", L"Mountains"},
	{1, L"mtn", L"Mountain"},
	{1, L"mtin", L"Mountain"},
	{1, L"mt", L"Mount"},
	{1, L"mssn", L"Mission"},
	{1, L"msn", L"Mission"},
	{1, L"msgr", L"Monseigneur"},
	{1, L"msgr", L"Monseigneur"},
	{1, L"mountin", L"Mountain"},
	{1, L"montague", L"Montig-You"},
	{1, L"mntns", L"Mountains"},
	{1, L"mntn", L"Mountain"},
	{1, L"mntain", L"Mountain"},
	{1, L"mnt", L"Mount"},
	{1, L"mnrs", L"Manors"},
	{1, L"mnr", L"Manor"},
	{1, L"mndr", L"Meander"},
	{1, L"mls", L"Mills"},
	{1, L"ml", L"Mill"},
	{1, L"mitac", L"My Tack"},
	{1, L"missn", L"Mission"},
	{1, L"mills", L"Mills"},
	{1, L"mill", L"Mill"},
	{1, L"middlefield", L"Middle-Field"},
	{1, L"mews", L"Mews"},
	{1, L"medows", L"Meadows"},
	{1, L"meadows", L"Meadows"},
	{1, L"meadow", L"Meadow"},
	{1, L"mdws", L"Meadows"},
	{1, L"mdw", L"Meadow"},
	{1, L"mdow", L"MEADOW"},
	{1, L"mckee", L"Mc Kee"},
	{1, L"mall", L"Mall"},
	{1, L"maj", L"Major"},
	{1, L"lt", L"Lieutenant"},
	{1, L"loops", L"Loops"},
	{1, L"lodg", L"Lodge"},
	{1, L"loaf", L"Loaf"},
	{1, L"lnwy", L"Laneway"},
	{1, L"lndng", L"Landing"},
	{1, L"lndg", L"Landing"},
	{1, L"ln", L"Lane"},
	{1, L"lkt", L"Lookout"},
	{1, L"lks", L"Lakes"},
	{1, L"lkot", L"LOOKOUT"},
	{1, L"lk", L"Lake"},
	{1, L"lgts", L"Lights"},
	{1, L"lgt", L"Light"},
	{1, L"lfs", L"Bluffs"},
	{1, L"lf", L"Loaf"},
	{1, L"ldge", L"Lodge"},
	{1, L"ldg", L"Lodge"},
	{1, L"lcks", L"Locks"},
	{1, L"lck", L"Lock"},
	{1, L"la", L"L A"},
	{1, L"kys", L"Keys"},
	{1, L"knol", L"Knoll"},
	{1, L"knls", L"Knolls"},
	{1, L"knl", L"Knoll"},
	{1, L"juncton", L"Junction"},
	{1, L"junctn", L"Junction"},
	{1, L"jcts", L"Junctions"},
	{1, L"jctns", L"Junctions"},
	{1, L"jctn", L"Junction"},
	{1, L"jction", L"Junction"},
	{1, L"jct", L"Junction"},
	{1, L"iss", L"Islands"},
	{1, L"islnds", L"Islands"},
	{1, L"islnd", L"Island"},
	{1, L"isles", L"Isles"},
	{1, L"isle", L"Isle"},
	{1, L"is", L"Island"},
	{1, L"int'l", L"international"},
	{1, L"intl", L"international"},
	{1, L"inlt", L"Inlet"},
	{1, L"hwy ", L"Highway"},
	{1, L"hwy", L"Highway"},
	{1, L"hway ", L"Highway"},
	{1, L"hvy", L"highway"},
	{1, L"hvn", L"Haven"},
	{1, L"hts", L"Heights"},
	{1, L"hth", L"HEATH"},
	{1, L"ht", L"Height"},
	{1, L"hse", L"House"},
	{1, L"hrbr", L"HARBOUR"},
	{1, L"hrbor", L"Harbor"},
	{1, L"HOV", L"H O V"},
	{1, L"hosp", L"Hospital"},
	{1, L"holws", L"Hollows"},
	{1, L"holw", L"Hollow"},
	{1, L"hls", L"Hills"},
	{1, L"hllw", L"Hollow"},
	{1, L"hl", L"Hill"},
	{1, L"hiwy", L"Highway"},
	{1, L"hiway", L"Highway"},
	{1, L"hiln", L"HIGHLANDS"},
	{1, L"hills", L"Hills"},
	{1, L"hill", L"Hill"},
	{1, L"highwy", L"Highway"},
	{1, L"hgts", L"Heights"},
	{1, L"hd", L"Head"},
	{1, L"hbrs", L"Harbors"},
	{1, L"hbr", L"Harbor"},
	{1, L"havn", L"Haven"},
	{1, L"haven", L"Haven"},
	{1, L"harbr", L"Harbor"},
	{1, L"harb", L"Harbor"},
	{1, L"gtwy", L"Gateway"},
	{1, L"gtway", L"Gateway"},
	{1, L"gte", L"Gate"},
	{1, L"grvs", L"Groves"},
	{1, L"grv", L"Grove"},
	{1, L"grov", L"Grove"},
	{1, L"grns", L"Greens"},
	{1, L"grn", L"Green"},
	{1, L"grdns", L"Gardens"},
	{1, L"grdn", L"Garden"},
	{1, L"grden", L"Garden"},
	{1, L"gra", L"Grange"},
	{1, L"gly", L"Gully"},
	{1, L"glns", L"Glens"},
	{1, L"gln", L"Glen"},
	{1, L"glens", L"Glens"},
	{1, L"glen", L"Glen"},
	{1, L"gld", L"Glade"},
	{1, L"glad", L"GLADE"},
	{1, L"gen", L"General"},
	{1, L"gdns", L"Gardens"},
	{1, L"gdn", L"Garden"},
	{1, L"gd", L"Grand "},
	{1, L"gatway", L"Gateway"},
	{1, L"gatewy", L"Gateway"},
	{1, L"gardn", L"Garden"},
	{1, L"fwy", L"Freeway"},
	{1, L"ft", L"Fort"},
	{1, L"fshr", L"Foreshore"},
	{1, L"fry", L"Ferry"},
	{1, L"frwy", L"Freeway"},
	{1, L"frway", L"Freeway"},
	{1, L"frtg", L"Frontage"},
	{1, L"frt", L"Fort"},
	{1, L"frsts", L"Forests"},
	{1, L"frst", L"Forest"},
	{1, L"frry", L"Ferry"},
	{1, L"frnt", L"Front"},
	{1, L"frks", L"Forks"},
	{1, L"frk", L"Fork"},
	{1, L"frgs", L"Forges"},
	{1, L"frg", L"Forge"},
	{1, L"freewy", L"Freeway"},
	{1, L"frds", L"Fords"},
	{1, L"frd", L"Ford"},
	{1, L"fr", L"Father"},
	{1, L"forg", L"Forge"},
	{1, L"forests", L"Forest"},
	{1, L"folw", L"Follow"},
	{1, L"flts", L"Flats"},
	{1, L"flt", L"Flat"},
	{1, L"fls", L"Falls"},
	{1, L"flds", L"Fields"},
	{1, L"fld", L"Field"},
	{1, L"fl", L"FALL"},
	{1, L"fdls", L"fields"},
	{1, L"fawy", L"Fairway"},
	{1, L"exts", L"Extensions"},
	{1, L"extnsn", L"Extension"},
	{1, L"extn", L"Extension"},
	{1, L"ext", L"Extension"},
	{1, L"expy", L"Expressway"},
	{1, L"expw", L"Expressway"},
	{1, L"express", L"Expressway"},
	{1, L"expr", L"Expressway"},
	{1, L"exp", L"Expressway"},
	{1, L"ests", L"Estates"},
	{1, L"este", L"ESTATE"},
	{1, L"est", L"Estate"},
	{1, L"esq", L"Esquire"},
	{1, L"esp", L"Esplanade"},
	{1, L"ent", L"Entrance"},
	{1, L"elb", L"Elbow"},
	{1, L"dwns", L"DOWNS"},
	{1, L"dvd", L"Divide"},
	{1, L"dv", L"Divide"},
	{1, L"drwy", L"DRIVEWAY"},
	{1, L"dr", L"Drive"},
	{1, L"drv", L"Drive"},
	{1, L"drs", L"Drives"},
	{1, L"driv", L"Drive"},
	{1, L"dm", L"Dam"},
	{1, L"dl", L"Dale"},
	{1, L"div", L"Divide"},
	{1, L"devn", L"Deviation"},
	{1, L"dam", L"Dam"},
	{1, L"cswy", L"Causeway"},
	{1, L"cso", L"Corso"},
	{1, L"cyn", L"Canyon"},
	{1, L"cvs", L"Coves"},
	{1, L"cv", L"Cove"},
	{1, L"curv", L"Curve"},
	{1, L"ctyd", L"Courtyard"},
	{1, L"cty", L"City"},
	{1, L"cts", L"Courts"},
	{1, L"ctrs", L"Centers"},
	{1, L"ctr", L"Center"},
	{1, L"ct", L"Court"},
	{1, L"crve", L"CURVE"},
	{1, L"crt", L"Court"},
	{1, L"crst", L"Crest"},
	{1, L"crssng", L"Crossing"},
	{1, L"crssing", L"Crossing"},
	{1, L"crss", L"Cross"},
	{1, L"crsnt", L"Crescent"},
	{1, L"crsent", L"Crescent"},
	{1, L"crse", L"Course"},
	{1, L"crscnt", L"Crescent"},
	{1, L"crk", L"Creek"},
	{1, L"cresent", L"Crescent"},
	{1, L"crescent", L"Crescent"},
	{1, L"cres", L"Crescent"},
	{1, L"creek", L"Creek"},
	{1, L"crecent", L"Crescent"},
	{1, L"crcs", L"Circus"},
	{1, L"crcle", L"Circle"},
	{1, L"crcl", L"Circle"},
	{1, L"crc", L"Circle"},
	{1, L"Cr", L"County Road"},
	{1, L"cps", L"Copse"},
	{1, L"cpl", L"Corporal"},
	{1, L"cpe", L"Cape"},
	{1, L"cp", L"Camp"},
	{1, L"cove", L"Cove"},
	{1, L"cors", L"Corners"},
	{1, L"cor", L"Corner"},
	{1, L"conn", L"CONNECTOR"},
	{1, L"con", L"Concourse"},
	{1, L"com", L"COMMON"},
	{1, L"col", L"Colonel"},
	{1, L"co", L"County"},
	{1, L"cnyn", L"Canyon"},
	{1, L"cntr", L"Center"},
	{1, L"cnter", L"Center"},
	{1, L"cnrs", L"CORNERS"},
	{1, L"cnl", L"Canal"},
	{1, L"cmp", L"Camp"},
	{1, L"cmn", L"Common"},
	{1, L"club", L"Club"},
	{1, L"clt", L"Circlet"},
	{1, L"clos", L"CLOSE"},
	{1, L"clfs", L"Cliffs"},
	{1, L"clf", L"Cliff"},
	{1, L"clde", L"Colonnade"},
	{1, L"clb", L"Club"},
	{1, L"cl", L"Close"},
	{1, L"ck", L"Creek"},
	{1, L"cirt", L"CIRCUIT"},
	{1, L"cirs", L"Circles"},
	{1, L"circl", L"Circle"},
	{1, L"circ", L"Circle"},
	{1, L"cir", L"Circle"},
	{1, L"chas", L"CHASE"},
	{1, L"ch", L"Chase"},
	{1, L"centre", L"Center"},
	{1, L"centr", L"Center"},
	{1, L"cent", L"Center"},
	{1, L"cen", L"Center"},
	{1, L"cem", L"Cemetery"},
	{1, L"cct", L"Circuit"},
	{1, L"causway", L"Causeway"},
	{1, L"canyn", L"Canyon"},
	{1, L"camp", L"Camp"},
	{1, L"bywy", L"BYWAY"},
	{1, L"byu", L"Bayoo"},
	{1, L"byps", L"Bypass"},
	{1, L"bypas", L"Bypass"},
	{1, L"bypa", L"Bypass"},
	{1, L"byp", L"Bypass"},
	{1, L"byou", L"Bayou"},
	{1, L"btm", L"Bottom"},
	{1, L"bros", L"Brothers"},
	{1, L"brnch", L"Branch"},
	{1, L"brks", L"Brooks"},
	{1, L"brk", L"Brook"},
	{1, L"br", L"Bridge"},
	{1, L"brg", L"Bridge"},
	{1, L"brdge", L"Bridge"},
	{1, L"brce", L"Brace"},
	{1, L"boulv", L"Boulevard"},
	{1, L"boul", L"Boulevard"},
	{1, L"bottm", L"Bottom"},
	{1, L"bot", L"Bottom"},
	{1, L"bnd", L"Bend"},
	{1, L"blvd", L"Boulevard"},
	{1, L"bluf", L"Bluff"},
	{1, L"blfs", L"Bluffs"},
	{1, L"blf", L"Bluff"},
	{1, L"bl", L"Boulevard"},
	{1, L"bgs", L"Burgs"},
	{1, L"bg", L"Burg"},
	{1, L"bend", L"Bend"},
	{1, L"belt", L"BELTWAY"},
	{1, L"bdwy", L"Broadway"},
	{1, L"bdn", L"bend"},
	{1, L"bch", L"Beach"},
	{1, L"bayou", L"Bayoo"},
	{1, L"bangerter", L"Banghetter"},
	{1, L"avnue", L"Avenue"},
	{1, L"avn", L"Avenue"},
	{1, L"avenu", L"Avenue"},
	{1, L"aven", L"Avenue"},
	{1, L"ave", L"Avenue"},
	{1, L"av", L"Avenue"},
	{1, L"arc", L"Arcade"},
	{1, L"app", L"Approach"},
	{1, L"anx", L"Annex"},
	{1, L"annx", L"Annex"},
	{1, L"anex", L"Annex"},
	{1, L"ambl", L"Amble"},
	{1, L"ally", L"Alli"},
	{1, L"aly", L"Alli"},
	{1, L"alley", L"Alli"},
	{1, L"allee", L"Alli"},
	{1, L"afb", L"Air Force Base"},
	{1, L"accs", L"Access"},
	{1, L"acrs", L"ACRES"},
	{1, L"acc", L"ACCESS"},
	{1, L"abey", L"ABBEY"},
	}
)	

transform.direction_abbrev = TRANSFORM.new({
	{2, L"\\bS\\.?W\\.?\\b", L"South West"},
	{2, L"\\bS\\.?E\\.?\\b", L"South East"},
	{2, L"\\bN\\.?W\\.?\\b", L"North West"},
	{2, L"\\bN\\.?E\\.?\\b", L"North East"},

	{1, L"S", L"South"},
	{1, L"SO", L"South"},
	{1, L"SO.", L"South"},
	{1, L"Sth", L"South"},
	
	{1, L"N", L"North"},
	{1, L"NO", L"North"},
	{1, L"NO.", L"North"},
	{1, L"Nth", L"North"},
	
	{1, L"E", L"East"},
	{1, L"E.", L"East"},
	
	{1, L"W", L"West"},
	{1, L"W.", L"West"},
	
	{1, L"EB", L"East Bound"},
	{1, L"WB", L"West Bound"},
	{1, L"SB", L"South Bound"},
	{1, L"NB", L"North Bound"},
	}
)

transform.state_name_abbrev = TRANSFORM.new({
	{1, L"AL", L"Alabama"},
	{1, L"AK", L"Alaska"},
	{1, L"AZ", L"Arizona"},
	{1, L"AR", L"Arkansas"},
	{1, L"CA", L"California"},
	{1, L"CO", L"Colorado"},
	{1, L"CT", L"Connecticut"},
	{1, L"DE", L"Delaware"},
	{1, L"FL", L"Florida"},
	{1, L"GA", L"Georgia"},
	{1, L"HI", L"Hawaii"},
	{1, L"ID", L"Idaho"},
	{1, L"IL", L"Illinois"},
	{1, L"IN", L"Indiana"},
	{1, L"IA", L"Iowa"},
	{1, L"KS", L"Kansas"},
	{1, L"KY", L"Kentucky"},
	{1, L"LA", L"Louisiana"},
	{1, L"ME", L"Maine"},
	{1, L"MD", L"Maryland"},
	{1, L"MA", L"Massachusetts"},
	{1, L"MI", L"Michigan"},
	{1, L"MN", L"Minnesota"},
	{1, L"MS", L"Mississippi"},
	{1, L"MO", L"Missouri"},
	{1, L"MT", L"Montana"},
	{1, L"NE", L"Nebraska"},
	{1, L"NV", L"Nevada"},
	{1, L"NH", L"New Hampshire"},
	{1, L"NJ", L"New Jersey"},
	{1, L"NM", L"New Mexico"},
	{1, L"NY", L"New York"},
	{1, L"NC", L"North Carolina"},
	{1, L"ND", L"North Dakota"},
	{1, L"OH", L"Ohio"},
	{1, L"OK", L"Oklahoma"},
	{1, L"OR", L"Oregon"},
	{1, L"PA", L"Pennsylvania"},
	{1, L"RI", L"Rhode Island"},
	{1, L"SC", L"South Carolina"},
	{1, L"SD", L"South Dakota"},
	{1, L"TN", L"Tennessee"},
	{1, L"TX", L"Texas"},
	{1, L"UT", L"Utah"},
	{1, L"VT", L"Vermont"},
	{1, L"VA", L"Virginia"},
	{1, L"WA", L"Washington"},
	{1, L"WV", L"West Virginia"},
	{1, L"WI", L"Wisconsin"},
	{1, L"WY", L"Wyoming"},
	}
)

transform.fraction_road = TRANSFORM.new({
	{2, L" 1/2 ", L" and a half "},
	{2, L" 1/2$", L" and a half"},
	}
)

transform.road_number_head = TRANSFORM.new(transform.direction_abbrev, {
	{1, L"HWY", L"Highway"},
	{1, L"JCT", L"JUNCTION"},
	}
)

transform.road_number_tail = TRANSFORM.new(transform.direction_abbrev, {
	{1, L"BL", L"Business Loop"},
	{1, L"BR", L"Business Road"},
	{1, L"BS", L"Business Spur"},
	{1, L"BYP", L"Bypass"},
	{1, L"BYPA", L"Bypass"},
	{1, L"BYPAS", L"Bypass"},
	{1, L"BYPS", L"Bypass"},
	{1, L"HWY", L"Highway"},
	{1, L"JCT", L"JUNCTION"},
	{1, L"L", L"Loop"},
	{1, L"TPK", L"Turnpike"},
	{1, L"TPKE", L"Turnpike"},
	{1, L"TRNPK", L"Turnpike"},
	{1, L"TRPK", L"Turnpike"},
	{1, L"TURNPK", L"Turnpike"},
	}
)

transform.direction_roadname_abbrev = TRANSFORM.new(transform.direction_abbrev, transform.roadname_abbrev_table)

transform.measures_abbrev_table = TRANSFORM.new({
	{1, L"mph", L"miles per hour"},
	}
)
