﻿module("VOICE")

local destname = {
    EXITNAME    = L"%s",
    EXITNUMBER  = L"a sortie %s",
    ROADNAME    = L"%s",
    DESTINATION = L"%s",
    SETTLEMENT  = L"vers %s",
}

local number_formatter_2 = {
    
    { L"0(%d)", L"o %1" },
}

local number_formatter_3 = {
    
    { L"00(%d)", L"o o %1" },
    
    { L"0(%d%d)", L"o %1" },
    
    { L"([1-9])00", L"%1 hundred" },
    
    { L"([1-9])0([1-9])", L"%1 o %2" },
    
    { L"([1-9])([1-9]%d)", L"%1 %2" },
}

local number formatter_4 = {
    
    { L"([1-9])000", L"%1 thousand" },
    
    { L"([1-9])00([1-9])", L"%1 thousand %2" },
    
    { L"([1-9]0)([1-9]%d)", L"%1 %2" },
    
    { L"([1-9][1-9])00", L"%1 hundred" },
    
    { L"([1-9][1-9])0([1-9])", L"%1 o %2" },
    
    { L"([1-9][1-9])([1-9]%d)", L"%1 %2" },
}

local number_formatters = {
    [2] = number_formatter_2,
    [3] = number_formatter_3,
    [4] = number_formatter_4,
}

local function format_number(str)
    
    local _,_, prefix, str = wstring.find(str, L"^(%a*)(%d+)$")
    
    if #prefix > 0 then prefix = prefix .. L" " end
    return prefix .. str
end

local function is_road_number(str)
    
    str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
    
    
    local _,_, head, state, num, tail = wstring.find(str, L"^([%a ]*)([ACDFGHIKLMNOPRSTUVW][ACDEHIJKLMNORSTVXYZ]) (%a*%d+)([ %a]*)$")
    
    if not head then
        _,_, head, state, num, tail = wstring.find(str, L"^([%a ]*)(I) (%d+)([ %a]*)$")
    end
    if head then return true
    else return false end
end

local function format_road_number(roadnumber)
	if roadnumber then 
        local str
        if roadnumber.phoneme then
            str = roadnumber.phoneme
        else
            str = roadnumber.text
            if not roadnumber.substituted then
                
                str = wstring.upper(str)
                
                str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
                
                
                local _,_, head, state, num, tail = wstring.find(str, L"^([%a ]*)([ACDFGHIKLMNOPRSTUVW][ACDEHIJKLMNORSTVXYZ]) (%a*%d+)([ %a]*)$")
                
                if not head then
                    _,_, head, state, num, tail = wstring.find(str, L"^([%a ]*)(I) (%d+)([ %a]*)$")
                end
                
                if not head then 
                    _,_, head, num, tail = wstring.find(str, L"^([%a ]*)(%d+)([ %a]*)$")
                    state = L""
                end
                
                num = format_number(num)
                
                head = transform.road_number_head:transform(head)
                tail = transform.road_number_tail:transform(tail)
                
                state = wstring.gsub(state, L"([^%s])", L"%1 ")
                
                
                    
                
                
                str = head .. L" " .. state .. L" " .. num .. L" " .. tail
                
                str = wstring.gsub(str, L"%s%s+", L" ")
            end
        return str
        end
    end
end

local function format_str(fmt, str)
    str, _ = wstring.gsub(fmt, L"%%s", str)
    return str
end

local function signpost_exitnumber(data, idx)
	local exitnumber = data[idx].signpost.exitnumber
	if exitnumber then 
		local str
		if exitnumber.phoneme then 
			str = exitnumber.phoneme
		else
			str = exitnumber.text
			if not exitnumber.substituted then
                local _, _, num, postfix = wstring.find(str, L"^(%d+)([%a-]*)$")
                num = format_number(num)
                
                if #postfix > 0 then 
                    
                    postfix = wstring.gsub(postfix, L"[/-]+", L", ")
                    str = num .. L" " .. postfix
                else
                    str = num
                end
			end
		end
        return format_str(destname.EXITNUMBER, str)
	end
end

local function signpost_exitname(data, idx)
	local exitname = data[idx].signpost.exitname
	if exitname then 
		local str
		if exitname.phoneme then 
			str = exitname.phoneme
		else
			str = exitnumber.text
		end
		return format_str(destname.EXITNAME, str)
	end
end

local function signpost_destination(data, idx)
	local dest = data[idx].signpost.destination
	if dest then
		local str
		if dest.phoneme then 
			str = dest.phoneme
		else
			str = dest.text
			if not dest.substituted then
                if is_road_number(str) then
                    str = format_road_number(dest)
                else
                    
                    str = wstring.gsub(str, L" 1/2 ", L"et une demie")
                    str = wstring.gsub(str, L" 1/2$", L"et une demie")
                    
                    str = wstring.gsub(str, L"[/-]+", L" ")
                    
                    str = transform.direction_roadname_abbrev:transform(str)
                end
			end
		end
        return format_str(destname.DESTINATION, str)
	end
end

local function signpost_settlement(data, idx)
	local settlement = data[idx].signpost.settlement
	if settlement then
		local str
		if settlement.phoneme then
			str = settlement.phoneme
		else
            str = settlement.text
            if not settlement.substituted then
				
                str = transform.direction_roadname_abbrev:transform(str)
            end
		end
		return format_str(destname.SETTLEMENT, str)
	end
end

local function signpost_roadnumber(data, idx)
    local str = format_road_number(data[idx].signpost.roadnumber)
    if str then
        if data[idx].signpost.sign_road_branch then
            return format_str(destname.ROADNAME, str)
        else
            return format_str(destname.SETTLEMENT, str)
        end
    end
end

local function road_name(data, idx)
	local name = data[idx].road.name
	if name then 
		local str
		if name.phoneme then
			str = name.phoneme
		else
            str = name.text
            if not name.substituted then
                if is_road_number(str) then
                
                    str = format_road_number(name)
                else
                    
                    str = transform.direction_roadname_abbrev:transform(str)
                end
            end
		end
		return str
	end
end

local function road_number(data, idx)
    return format_road_number(data[idx].road.number)
end


local function chain(t, trafo, data, idx)
	local out = trafo(data, idx)
	if out then table.insert(t, out) end
	return t
end

function format_destname(data, idx)
	local t
    local out
	if data[idx].signpost then
		t = chain({}, signpost_exitname, 	data, idx)
		t = chain(t,  signpost_exitnumber, 	data, idx)
		t = chain(t,  signpost_roadnumber, 	data, idx)
		t = chain(t,  signpost_destination,	data, idx)
		t = chain(t,  signpost_settlement, 	data, idx)
        out = table_concat(t, L", ")
	elseif data[idx].road then
		t = chain({}, road_number, data, idx)
		t = chain(t,  road_name,   data, idx)
        out = format_str(destname.ROADNAME, table_concat(t, L", "))
	end
	return out
end

function format_streetname(data, idx)
	local t
	t = chain({}, road_number, 	data, idx)
	t = chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end



function route_summary_format_road_name(data)
	if data.phoneme then return data.phoneme
	else return transform.roadname_abbrev_table:transform(data.text)
	end
end

function route_summary_format_street_name(data)
	if data.phoneme then return data.phoneme
	else return transform.roadname_abbrev_table:transform(data.text)
	end
end

function route_summary_format_bridge_tunnel(data)
	if data.phoneme then return data.phoneme
	else return transform.roadname_abbrev_table:transform(data.text)
	end
end

function route_summary_format_order(data)
	if data.phoneme then return data.phoneme
	else return transform.roadname_abbrev_table:transform(data.text)
	end
end
