﻿module("VOICE")

----------------------------------------------------------------------------------------------------
---------------------------|  V O I C E   T R A N S F O R M   U T I L S  |--------------------------
----------------------------------------------------------------------------------------------------

local destname = {
    EXITNAME    = L"à la sortie  %s",
    EXITNUMBER  = L"à la sortie numéro %s",
    ROADNAME    = L"ver %s",
    DESTINATION = L"direction %s",
    SETTLEMENT  = L"direction %s",
}

local number_formatter_2 = {
    -- 0x => o x
    { L"0(%d)", L"o %1" },
    { L"7([0])", L"septante" },
    { L"7(1)", L"septante et un" },
    { L"7([2-9])", L"septante %1" },
    { L"9([0])", L"nonante" },
    { L"9(1)", L"nonante et un" },
    { L"9([2-9])", L"nonante %1" },
}

local number_formatter_3 = {
    -- 00x => o o x
    --{ L"00(%d)", L"o o %1" },
    -- 0xx => 0 xx
    --{ L"0(%d%d)", L"o %1" },
    -- 100-900 => x hundred
    { L"([1-9])00", L"%1 cent" },
    -- 100-900 => x hundred
    { L"([1-9])70", L"%1 cent septante" },
    { L"([1-9])71", L"%1 cent septante et un" },
    { L"([1-9])72", L"%1 cent septante deux" },
    { L"([1-9])73", L"%1 cent septante trois" },
    { L"([1-9])74", L"%1 cent septante quatre" },
    { L"([1-9])75", L"%1 cent septante cinq" },
    { L"([1-9])76", L"%1 cent septante six" },
    { L"([1-9])77", L"%1 cent septante sept" },
    { L"([1-9])78", L"%1 cent septante huit" },
    { L"([1-9])79", L"%1 cent septante neuf" },
    { L"([1-9])90", L"%1 cent nonante" },
    { L"([1-9])91", L"%1 cent nonante et un" },
    { L"([1-9])92", L"%1 cent nonante deux" },
    { L"([1-9])93", L"%1 cent nonante trois" },
    { L"([1-9])94", L"%1 cent nonante quatre" },
    { L"([1-9])95", L"%1 cent nonante cinq" },
    { L"([1-9])96", L"%1 cent nonante six" },
    { L"([1-9])97", L"%1 cent nonante sept" },
    { L"([1-9])98", L"%1 cent nonante huit" },
    { L"([1-9])99", L"%1 cent nonante neuf" },

    -- 10x-90x
    --{ L"([1-9])0([1-9])", L"%1 o %2" },
    -- 1xx-9xx
    --{ L"([1-9])([1-9]%d)", L"%1 %2" },
}

-- Attol fugg hany szamjegyu a szam
local number_formatters = {
    [2] = number_formatter_2,
    [3] = number_formatter_3,
    [4] = number_formatter_4,
}


local function format_number(str)
    if type(str) ~= "wstring" then
        ASSERT(FALSE, "The input of format_number must be wstring. Type: "..type(str))
        return L""
    end
    local formatter = number_formatters[#str]
    if formatter then
        local rep
        for _,v in ipairs(formatter) do
            str, rep = wstring.gsub(str, v[1], v[2])
            if rep > 0 then break end
        end
    end
    return str
end

-- 55, A55, ST45
local roadnumber_typ_patterns = {
    L"^%d+",
    L"^%a%d+",
    L"^%a%a%d+",
}

-- Ugy nez ki mint ha utszam lenne?
local function is_road_number(str)
    return transform_pattern_match(str, roadnumber_typ_patterns)
end

--[[
-- Ugy nez ki mint ha utszam lenne?
local function is_road_number(str)
    -- Kotojelet kivesszuk
    str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
    -- Szetszedjuk head (A,B,M), number (32) es tail reszekre (N)
    local _,_, head, num, tail = wstring.find(str, L"^(%a?)(%d+)(.*)$")
    if num then return true
    else return false end
end
]]

local tail_replace_map = {
	{L"%(E%)",L"Est"},
	{L"%(W%)",L"Ouest"},
	{L"%(S%)",L"Sud"},
	{L"%(N%)",L"Nord"},
	{L"%(NE%)",L"Nord Est"},
	{L"%(NW%)",L"Nord ouest"},
	{L"%(SE%)",L"Sud Est"},
	{L"%(SW%)",L"Sud Ouest"},
	{L"%(M%)",L"Autoroute"},
}

local function format_road_number(roadnum)
    local res
    if is_road_number(roadnum) then
        roads = transform_roadnumber_explode_eu(roadnum)
        for k, str in ipairs(roads) do
            -- Nagybetu
            str = wstring.upper(str)
            -- Kotojelbol space
            str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
            _,_,head,num,tail = wstring.find(str, L"^(.-)(%d+)(.-)$")
            -- Modif pour l'expression "Vers ..."
            if head == L"A" then head = L"Lautoroute A" end
            if head == L"E" then head = L"Leuropéaine E" end
            if head == L"N" then head = L"Lanationale" end
            if head == L"D" then head = L"Ladépartementale" end
            if head == L"C" then head = L"Lacommunale" end
            if head == L"R" then head = L"Le ring" end
            -- Szam formazas
            num = format_number(num)
            -- Tail formazas
            tail = transform.direction_abbrev:transform(tail)
            -- Osszerakjuk
            str = table_concat({head,num,tail}, L" ")
            -- Dupla space ki
            str = wstring.gsub(str, L"%s%s+", L" ")
            -- Eltesszuk
            roads[k] = str
        end
        res = table_concat(roads, L"; ")
    else
        res = transform.roadname_abbrev_table:transform(roadnum)
    end
    return res
end

local function format_road_name(str)
    if is_road_number(str) then
    -- Ha utszamnak nez ki, akkor akkent formazzuk
        str = transform.roadname_abbrev_table:transform(str)
    else
    -- Kulonben siman utnevnek
        str = transform.roadname_abbrev_table:transform(str)
    end
    return str
end
-- modifs deu---------------------------------------------------------------------------------------------------

--local preposition_tbl = {L"auf den",L"auf das",L"auf die",L"in den",L"in die",L"in das",L"über die",L"ver",L"direction"}

--local preposition_insert_tbl = {
--	{L"auf den ",{L"platz$",L"ring$",L"damm$",L"berg$",L"kanal$", L"^platz de[rs] "}},
--	{L"auf das ",{L"dreieck$",L"kreuz$"}},
--	{L"auf die ",{L"allee$",L"treppe$",L"^%a?%d+%a?$"}},
--	{L"in den ",{L"horst$",L"kamp$",L"winkel$",L"pfad$",L"weg$",L"steg$",L"stieg$",L"hof$"}},
--	{L"in die ",{L"gasse$",L"strase$",L"strasse$",L"sträse$",L"straße$",L"sträße$", L"^stra[ßs]+e de[rs] "}},
--	{L"durch den ",{L"tunnel$",L"tunel$"}},
--	{L"über die ",{L"brucke$",L"brücke$"}},
--	{L"in das ",{L"tor$"}},
--	{L"ver ",{L"A$"}},
--}

--local settlement_preposition = L"direction"

--local function get_preposition(str, tbl)
--	str = wstring.lower(str)
--	for k,value in ipairs(tbl) do
--		for _,pattern in ipairs(tbl[k][2]) do
--			if wstring.find(str,pattern) then
--				return tbl[k][1] 
--			end	
--		end		
--	end
--end








----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

local function format_signpost_exitnumber(str)
	local _, _, prefix, num, postfix = wstring.find(str, L"^(.-)(%d+)(.-)$")
	ASSERT(num, L"Aucun numéro de sortie: "..str)
	if num then num = format_number(num) end
	-- Prefixbol kivesszuk az EXIT-et
	if prefix then prefix = wstring.gsub(wstring.upper(prefix), L"Sortie%s*", L"") end
	-- Ha van postfix (pl "140A-B" esetben)
	if postfix then postfix = wstring.gsub(postfix, L"[/-]+", L", ") end
        -- Osszefuzzuk es kesz
	return table_concat({prefix, num, postfix}, L" ")
end

local function signpost_exitnumber(data, idx)
    return transform_and_format(data[idx].signpost.exitnumber, format_signpost_exitnumber, destname.EXITNUMBER)
end

local function signpost_exitname(data, idx)
    return transform_and_format(data[idx].signpost.exitname, nil, destname.EXITNAME)
end

local function signpost_destination(data, idx)
    return transform_and_format(data[idx].signpost.destination, transform.roadname_abbrev_table,destname.DESTINATION)
end

local function signpost_settlement(data, idx)
        return transform_and_format(data[idx].signpost.settlement, transform.direction_abbrev, destname.SETTLEMENT)
end
-- modifs ---------------------------------------

--local function signpost_settlement(data, idx)
--	local settlement = data[idx].signpost.settlement

--	if settlement then
----		local str = transform_and_format(settlement,replace_mapinfo)
--		local str = transform_and_format(settlement,transform.direction_abbrev, destname.SETTLEMENT)
--		-- Ha van benn gyarilag "direction"
--		if wstring.find(settlement.text,settlement_preposition) then
--			return str
--		end
--		-- Hozza kell tenni
--		return settlement_preposition .. L" " .. str
--	end
--end

--fin modifs -----------------------------------

local function signpost_roadnumber(data, idx)
    local format
    if data[idx].signpost.sign_road_branch then format = destname.ROADNAME
    else format = destname.SETTLEMENT end

    return transform_and_format(data[idx].signpost.roadnumber, format_road_number, format)
end

local function road_name(data, idx)
    return transform_and_format(data[idx].road.name, transform.roadname_abbrev_table)
end

local function road_number(data, idx)
    return transform_and_format(data[idx].road.number, format_road_number)
end

------------------------------------------|  O U T P U T  |-----------------------------------------
function format_destname(data, idx)
    local t
    local out
    if data[idx].signpost then
        t = transform_chain({}, signpost_exitname, 	data, idx)
	t = transform_chain(t,  signpost_exitnumber, 	data, idx)
	t = transform_chain(t,  signpost_roadnumber, 	data, idx)
	t = transform_chain(t,  signpost_destination,	data, idx)
	t = transform_chain(t,  signpost_settlement, 	data, idx)
        out = table_concat(t, L", ")
    elseif data[idx].road then
	t = transform_chain({}, road_number, data, idx)
	t = transform_chain(t,  road_name,   data, idx)
        out = wstring.format(destname.ROADNAME, table_concat(t, L", "))
    end
    return out
end

function format_streetname(data, idx)
    local t
    t = transform_chain({}, road_number, 	data, idx)
    t = transform_chain(t,  road_name, 	data, idx)
    return table_concat(t, L", ")
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------
function route_summary_format_road_name(data)
        return transform_and_format(data, format_road_number)
--        return transform_and_format(data, transform.roadname_abbrev_table)
end

function route_summary_format_street_name(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

function route_summary_format_bridge_tunnel(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

function route_summary_format_order(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	---- Roadnumber prioritas
	if data.roadnumber then 
		local road = transform_and_format(data.roadnumber, format_road_number, L" sur %s")
		if data.from and not data.to then
		-- M7 uton Martonvasar kozeleben
			str =  str..road..L" près de "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- M7 uton, Martonvasar es Velence kozott 
			str =  str..road..L", entre "..transform_and_format(data.from)..L" et "..transform_and_format(data.to)
		else
		-- Egyeb: M7 uton
			str = str..road
		end
	---- Roadname
	elseif data.roadname then
		local road = transform_and_format(data.roadname, transform.roadname_abbrev_table, L" on %s")
		if data.from and not data.to then
			-- "," menten robbantunk
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", a l'intersection de "..from..L" et "..to
			else 
				str = str..road..L", a l'intersection de "..transform_and_format(data.from)
			end
		elseif data.from and data.to then
			str = str..road..L", entre "..transform_and_format(data.from)..L" et "..transform_and_format(data.to)
		else
			str = str..road
		end
	---- Nincs se roadnumber, se roadname 
	else
		if data.from and not data.to then
		-- Martonvasar kozeleben
			str =  str..L" near "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- Martonvasar es Velence kozott 
			str =  str..L" entre "..transform_and_format(data.from)..L" et "..transform_and_format(data.to)
		else
		-- Egyeb: semmi
		end
	end
	str = str..L"."
	return str
end


----------------------------------------------------------------------------------------------------
------------------------------------------|  D E T O U R  |-----------------------------------------
----------------------------------------------------------------------------------------------------

function format_street_name (streetname)
    if wstring.sub (streetname, 1, 9) == L "for_turns" then
        return transform_and_format (wstring.sub (streetname, 10), transform.roadname_abbrev_table, destname.ROADNAME)
    else
        return transform_and_format (streetname, transform.roadname_abbrev_table)
    end
end

