FavGroup = m_i18n("@Favourites")
PicturePoiGroup = m_i18n("@My Picture POI")
gSearchEngineIsInitialized = false
 
sc_FindParking = function()
	return MODEL.poi.find_group("Parking") == -1 and MODEL.poi.find_group("Automotive\1Parking") or MODEL.poi.find_group("Parking")
end
 
gGlobalSearchAroundArea = MODEL.lua.wGlobalSearchAroundArea()
poi_search_params = {station_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 50000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "destination", search_root = -1}, accomodation_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 50000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "destination", search_root = -1}, parking_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 1500, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "destination", search_root = -1}, restaurant_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 1500, max_result = 100, distance_on_route = "enabled", calculate_detour = "forced", center = "route", search_root = -1}, petrol_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 1500, max_result = 200, distance_on_route = "enabled", calculate_detour = "forced", center = "route", search_root = -1}, atm_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 1500, max_result = 100, distance_on_route = "enabled", calculate_detour = "forced", center = "route", search_root = -1}, help_carrepair_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 80000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1}, help_hospital_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 80000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1}, help_police_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 80000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1}, help_atm_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 80000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1}, help_petrol_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 80000, max_result = 100, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1}, picturepoi_search = {sort = "name", area = -1, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1, provider = -1}, favorite_search = {sort = "name", area = -1, max_result = 300, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1, provider = -1, non_idle = true}, places_around_cursor_search = {sort = "multi_sort:igo9_specialpoi_first+distance", area = 300000, distance_on_route = "disabled", calculate_detour = "disabled", center = "cursor"}, ads_search = {area = 50000, max_result = 300, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = 0}, picturepoi_presearch = {sort = "name", area = 0, max_result = 1, distance_on_route = "disabled", calculate_detour = "disabled", center = "gps", search_root = -1, provider = -1, non_idle = true}}
sc_RegisterPoiSearches = function()
	sc_RegisterQuickSearch("help_nearby_carrepair_quick")
	sc_RegisterQuickSearch("help_nearby_hospital_quick")
	sc_RegisterQuickSearch("help_nearby_police_quick")
	sc_RegisterQuickSearch("help_nearby_atms_quick")
	sc_RegisterQuickSearch("help_nearby_petrolstation_quick")
	sc_RegisterQuickSearch("find_places_parking_quick")
	sc_RegisterQuickSearch("find_places_restaurant_quick")
	sc_RegisterQuickSearch("find_places_petrolstation_quick")
	sc_RegisterQuickSearch("find_places_atms_quick")
	sc_RegisterQuickSearch("ads_search")
	sc_RegisterQuickSearch("tmp_flat")
	sc_RegisterQuickSearch("pictures")
	sc_RegisterQuickSearch("find_places_station_quick")
	sc_RegisterQuickSearch("find_places_accomodation_quick")
	for i = 0, 3 do
		sc_RegisterQuickSearch("wuser_find_places_quick" .. tostring(i))
	end
	sc_RegisterQuickSearch("wmulti_search")
	sc_RegisterQuickSearch("wmulti_provider")
end
 
sc_SetupPoiSearches = function()
	if gSearchEngineIsInitialized or not MODEL.poi.initialized() then
		return 
	end
	local search, param
	poi_search_params.station_search.search_root = MODEL.poi.find_group("Station")
	poi_search_params.accomodation_search.search_root = MODEL.poi.find_group("Accommodation")
	poi_search_params.parking_search.search_root = sc_FindParking()
	poi_search_params.restaurant_search.search_root = MODEL.poi.find_group("Restaurant")
	poi_search_params.petrol_search.search_root = MODEL.poi.find_group("Petrol_Station")
	poi_search_params.atm_search.search_root = MODEL.poi.find_group("Finance\1Cash_Dispenser")
	poi_search_params.help_carrepair_search.search_root = MODEL.poi.find_group("Automotive\1Car_Service")
	poi_search_params.help_hospital_search.search_root = MODEL.poi.find_group("Medical")
	poi_search_params.help_police_search.search_root = MODEL.poi.find_group("Community\1Public_Services\1Police_Station")
	poi_search_params.help_atm_search.search_root = MODEL.poi.find_group("Finance\1Cash_Dispenser")
	poi_search_params.help_petrol_search.search_root = MODEL.poi.find_group("Petrol_Station")
	poi_search_params.picturepoi_search.search_root = MODEL.poi.find_group(PicturePoiGroup)
	poi_search_params.favorite_search.search_root = MODEL.poi.find_group(FavGroup)
	poi_search_params.favorite_search.provider = MODEL.poi.find_provider("userpoi")
	poi_search_params.picturepoi_presearch.search_root = MODEL.poi.find_group(PicturePoiGroup)
	poi_search_params.picturepoi_presearch.provider = MODEL.poi.find_provider("picturepoi")
	sc_wUserPOISearchParams_CheckRemoved()
	for cntr = 0, 3 do
		search = MODEL.poi["wuser_find_places_quick" .. tostring(cntr)]
		param = MODEL.ui.lm_wuser_poi_search_params[cntr]
		search.search_root = MODEL.poi.find_group(param.group())
	end
	gSearchEngineIsInitialized = true
	sc_SetupQuickSearch("help_nearby_carrepair_quick", poi_search_params.help_carrepair_search)
	sc_SetupQuickSearch("help_nearby_hospital_quick", poi_search_params.help_hospital_search)
	sc_SetupQuickSearch("help_nearby_police_quick", poi_search_params.help_police_search)
	sc_SetupQuickSearch("help_nearby_atms_quick", poi_search_params.help_atm_search)
	sc_SetupQuickSearch("help_nearby_petrolstation_quick", poi_search_params.help_petrol_search)
	sc_SetupQuickSearch("find_places_parking_quick", poi_search_params.parking_search)
	sc_SetupQuickSearch("find_places_restaurant_quick", poi_search_params.restaurant_search)
	sc_SetupQuickSearch("find_places_petrolstation_quick", poi_search_params.petrol_search)
	sc_SetupQuickSearch("find_places_atms_quick", poi_search_params.atm_search)
	sc_SetupQuickSearch("ads_search", poi_search_params.ads_search)
	sc_SetupQuickSearch("tmp_flat")
	sc_SetupQuickSearch("pictures")
	sc_SetupQuickSearch("find_places_station_quick", poi_search_params.station_search)
	sc_SetupQuickSearch("find_places_accomodation_quick", poi_search_params.accomodation_search)
	for cntr = 0, 3 do
		search = MODEL.poi["wuser_find_places_quick" .. tostring(cntr)]
		param = MODEL.ui.lm_wuser_poi_search_params[cntr]
		search.sort = "multi_sort:igo9_specialpoi_first+distance"
		search.area = param.distance()
		search.center = param.on_route() and "route" or "destination"
		search.search_root = MODEL.poi.find_group(param.group())
		search.max_result = 1
		search.distance_on_route = "disabled"
		search.calculate_detour = "disabled"
	end
end
 
sc_RegisterQuickSearch = function(name)
	MODEL.poi.create_search(name, "flat")
end
 
sc_SetupQuickSearch = function(name, params)
	local search = MODEL.poi[name]
	if params ~= nil then
		for param,value in pairs(params) do
			search[param] = value
		end
	end
	search.max_result = 1
	search.distance_on_route = "disabled"
	search.calculate_detour = "disabled"
end
 
sc_RegisterPoiSearches()
