gEditSpeedcamFromInfo = false
gSpeedPopupID = -1
gRateSpeedcamDelayID = -1
wclickedSpeed = nil
wclickedPosition = nil
wclickedRotation = nil
gSpeedcamID_tmp = ""
wSCSMCommunityMode = false
wAddCamPrevState = var.new(-1)
wSpeedCam_Type_entered = nil
wSpeedCam_SpeedLimit_entered = nil
wSpeedCam_Direction_entered = nil
wSpeedCam_Direction_type_entered = nil
wMuteResetedID = ""
createState("st_EditSpeedcam")
st_EditSpeedcam:useLayers(backgroundLayers, "ui_EditSpeedcam")
 
st_EditSpeedcam.enter = function()
	if MODEL.lua.managespeedcam() then
		wSpeedCam_Type_entered = MODEL.lua.SpeedCam_Type()
		wSpeedCam_SpeedLimit_entered = MODEL.lua.SpeedCam_SpeedLimit()
		wSpeedCam_Direction_entered = MODEL.lua.SpeedCam_Direction()
		wSpeedCam_Direction_type_entered = MODEL.lua.SpeedCam_Direction_type()
	end
end
 
st_EditSpeedcam.init = function()
	if MODEL.lua.managespeedcam() then
		txtTitle.TEXT = m_i18n("Speedcam~Edit Alert Point")
	elseif MODEL.lua.WannaReportAlertPoints() and MODEL.network.supported() and MODEL.EXISTS.warning.speedcam.community_speedcam_enabled() and MODEL.warning.speedcam.community_speedcam_enabled() then
		txtTitle.TEXT = m_i18n("Speedcam~Report Alert Point")
	else
		txtTitle.TEXT = m_i18n("Speedcam~Add Alert Point")
	end
	if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editdirection") then
		MODEL.lua.SpeedCam_Direction_type = sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "defdirection")
	end
	MODEL.lua.wSpeedcamEditMode = 1
end
 
sc_UpdateSpeedcamModels = function(Model)
	local pos, type, speedlimit, direction, direction_type, service, id
	if Model == nil then
		speedlimit, direction, direction_type = MODEL.warning.manage.get_segment_params()
		pos = MODEL.map.cursor.position()
		type = 0
		id = ""
		service = 3
	else
		pos = Model.position()
		type = Model.category()
		speedlimit = Model.speed_limit()
		direction = Model.heading()
		direction_type = Model.heading_type()
		service = Model.service()
		id = Model.id()
		if Model.EXISTS.confidence() then
			MODEL.lua.SpeedCam_Confidence = Model.confidence()
		else
			MODEL.lua.SpeedCam_Confidence = -1
		end
	end
	MODEL.lua.SpeedCam_Pos = pos
	MODEL.lua.SpeedCam_Type = type
	MODEL.lua.SpeedCam_SpeedLimit = speedlimit
	MODEL.lua.SpeedCam_Direction = direction
	MODEL.lua.SpeedCam_Direction_type = direction_type
	MODEL.lua.SpeedCam_Service = service
	MODEL.lua.SpeedCam_ID = id
	if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editspeed") then
		MODEL.lua.SpeedCam_SpeedLimit = (MODEL.lua.SpeedCam_Type() ~= 1 and MODEL.lua.SpeedCam_Type() ~= 4 and 200 or 0)
	end
end
sc_AddSpeedcam = function(closelocal)
	MODEL.lua.wSMAddCamCurrentDirection = 360 * tonumber(MODEL.map.primary.rotate())/4096
	MODEL.lua.managespeedcam = false
	if closelocal then
		sc_close_local_menu()
	end
	sc_UpdateSpeedcamModels()
	sc_NextStateAnim(st_EditSpeedcam, "fade", 1, "")
end
 
sc_EditSpeedcam = function(closelocal)
	MODEL.lua.wSMAddCamCurrentDirection = 360 * tonumber(MODEL.map.primary.rotate())/4096
	gEditSpeedcamFromInfo = false
	sc_CopySpeedCamUserList()
	MODEL.lua.managespeedcam = true
	if closelocal then
		sc_close_local_menu()
	end
	if MODEL.map.primary.clicked_speedcam_list.size() == 1 then
		sc_UpdateSpeedcamModels(MODEL.map.primary.clicked_speedcam_list[0])
		sc_NextStateAnim(st_EditSpeedcam, "fade", 1, "")
	else
		sc_NextStateAnim(st_SelectSpeedcam, "fade", 1, "")
	end
end
 
sc_EditSpeedcamFromList = function()
	gEditSpeedcamFromInfo = false
	sc_UpdateSpeedcamModels(MODEL["*"])
	MODEL["*"]._list.setcurrent(index)
	sc_NextStateAnim(st_EditSpeedcam, "fade", 1, "")
end
 
sc_SaveSpeedcam = function()
	if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editspeed") then
		MODEL.lua.SpeedCam_SpeedLimit = (MODEL.lua.SpeedCam_Type() ~= 1 and MODEL.lua.SpeedCam_Type() ~= 4 and 200 or 0)
	end
	if MODEL.lua.managespeedcam() then
		MODEL.warning.manage.update_speedcam(MODEL.lua.SpeedCam_ID(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type())
	else
		MODEL.warning.manage.add_speedcam(MODEL.lua.SpeedCam_Pos(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type())
		if MODEL.lua.WannaReportAlertPoints() and MODEL.network.supported() and MODEL.EXISTS.warning.speedcam.community_speedcam_enabled() and MODEL.warning.speedcam.community_speedcam_enabled() and MODEL.lua.SpeedCam_Type() ~= 3 then
			MODEL.warning.manage.add_community_speedcam(MODEL.lua.SpeedCam_Pos(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type(), MODEL.gps.position(), MODEL.gps.rotation(), MODEL.gps.speed())
		end
	end
	MODEL.map.primary.update_clicked_speedcam_list()
	sc_CopySpeedCamUserList()
	sc_UpdateCameraCursorIcon()
	sc_back()
end
 
sc_EditSpeedcameraType = function()
	sc_NextStateAnim(st_EditSpeedcam_Type, "fade", 1, "")
end
 
createState("st_EditSpeedcam_Type")
st_EditSpeedcam_Type:useLayers(backgroundLayers, "ui_EditSpeedcam_Type")
tmpPrevSpeedcamType = -1
st_EditSpeedcam_Type.init = function()
	txtTitle.TEXT = m_i18n("Select Alert Point Type")
	tmpPrevSpeedcamType = MODEL.lua.SpeedCam_Type()
end
 
st_EditSpeedcam_Type.done = function()
	if MODEL.lua.wSpeedcamEditMode() == 1 and tmpPrevSpeedcamType ~= MODEL.lua.SpeedCam_Type() then
		if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editspeed") then
			MODEL.lua.SpeedCam_SpeedLimit = (MODEL.lua.SpeedCam_Type() ~= 1 and MODEL.lua.SpeedCam_Type() ~= 4 and 200 or 0)
		else
			MODEL.lua.SpeedCam_SpeedLimit = sc_GetSegmentSpeedLimit()
		end
	end
end
 
sc_EditSpeedcam_Type_onrelease = function()
	if MODEL.lua.wSpeedcamEditMode() == 1 then
		MODEL.lua.SpeedCam_Type = MODEL["*"].type()
		sc_back()
	elseif MODEL.lua.wSpeedcamEditMode() == 2 then
		MODEL.lua.SpeedCam_Type = MODEL["*"].type()
		sc_wReSetSMAddCamList(MODEL.lua.SpeedCam_Type())
		if MODEL.ui.wSMAddCamList.list.size() == 1 then
			sc_SM_AddCamEnd()
		else
			sc_NextStateAnim(MODEL.ui.wSMAddCamList[1].state(), "fade", 1, "")
		end
	elseif MODEL.lua.wSpeedcamEditMode() == 3 then
		MODEL.lua.wSMAddCamType = MODEL["*"].type()
		sc_back()
	elseif MODEL.lua.wSpeedcamEditMode() == 4 then
		MODEL.lua.SpeedCam_Type = MODEL["*"].type()
		sc_EditSpeedcam_Type_onrelease_Mode4_Ok()
	end
end
 
sc_EditSpeedcam_Type_onrelease_Mode4_Ok = function()
	sc_wReSetEditCamList(MODEL.lua.SpeedCam_Type())
	if MODEL.ui.wSMAddCamList.list.size() == 1 then
		sc_wEditSpeedCam_done()
	else
		sc_NextStateAnim(MODEL.ui.wSMAddCamList[1].state(), "fade", 1, "")
	end
end
 
createState("st_wSMEditSpeedcam_Direction")
st_wSMEditSpeedcam_Direction:useLayers(backgroundLayers, "ui_wSMEditSpeedcam_Direction")
st_wSMEditSpeedcam_Direction.init = function()
	txtTitle.TEXT = m_i18n("Select Alert Point Direction Type")
end
 
sc_EditSpeedcam_Direction_onrelease = function()
	MODEL.lua.SpeedCam_Direction_type = MODEL["*"].direction()
	if MODEL.ui.wSMAddCamList.list.size() == 3 or MODEL.ui.wSMAddCamList[1].state() == "st_EditSpeedcam_Speed" then
		sc_NextStateAnim(st_EditSpeedcam_Speed, "fade", 1, "")
	elseif MODEL.lua.wSpeedcamEditMode() == 4 then
		sc_wEditSpeedCam_done()
	else
		sc_SM_AddCamEnd()
	end
end
 
sc_EditSpeedcam_Direction_onrelease_Mode4_Ok = function()
	if MODEL.ui.wSMAddCamList.list.size() == 3 or MODEL.ui.wSMAddCamList[1].state() == "st_EditSpeedcam_Speed" then
		sc_NextStateAnim(st_EditSpeedcam_Speed, "fade", 1, "")
	else
		sc_wEditSpeedCam_done()
	end
end
 
sc_EditSpeedcam_Direction_setting_onrelease = function()
	MODEL.lua.wSMAddCamDir = (MODEL.lua.wSMAddCamDir() == 2 and 3 or 2)
end
 
sc_EditSpeedcameraDirection = function()
	sc_NextStateAnim(st_EditSpeedcam_Direction, "fade", 1, "")
end
 
gMaxZoomBeforeSpeedcamEdit = nil
createState("st_EditSpeedcam_Direction")
st_EditSpeedcam_Direction:useLayers(primary, uieffect, "ui_EditSpeedcam_Direction")
st_EditSpeedcam_Direction.init = function()
	local mapLayer = MODEL.map.primary
	gMaxZoomBeforeSpeedcamEdit = mapLayer.maxzoom2d()
	mapLayer.save_state(mapLayer.state())
	mapLayer.enter_state("poiitem")
	mapLayer.center_noanim(MODEL.map.cursor.position())
	mapLayer.show_cursor = false
	mapLayer.set_rotate(0)
	sc_SpeedCam_SetMapCenter()
	mapLayer.center_lock = true
	mapLayer.auto_set_cursor = false
	mapLayer.set_zoom(100, false)
	mapLayer.maxzoom2d = 36000
	MODEL.warning.speedcam_warning = false
end
 
st_EditSpeedcam_Direction.done = function()
	MODEL.map.primary.maxzoom2d = gMaxZoomBeforeSpeedcamEdit
	MODEL.map.primary.exit_state()
	MODEL.warning.speedcam_warning = true
end
 
sc_EditSpeedcameraSpeed = function()
	sc_NextStateAnim(st_EditSpeedcam_Speed, "fade", 1, "")
end
 
createState("st_EditSpeedcam_Speed")
st_EditSpeedcam_Speed:useLayers(backgroundLayers, "ui_EditSpeedcam_Speed")
 
st_EditSpeedcam_Speed.init = function()
	txtTitle.TEXT = m_i18n("Select Alert Point Speed")
	if MODEL.lua.wSpeedcamEditMode() == 4 then
		local text = MODEL.lua.SpeedCam_SpeedLimit()
		if MODEL.regional.units() ~= 1 then
			text = regional.units:convert("Speed", "km/h", text, "miles/hour")
			text = double.round(text):toInt()
		end
		MODEL.lua.SpeedCam_SpeedLimitMode4 = text
	end
end
 
sc_EditSpeedcam_Speed_onrelease = function()
	local speed = MODEL["*"].speed()
	if MODEL.regional.units() ~= 1 then
		speed = regional.units:convert("Speed", "km/h", speed, "miles/hour")
		speed = double.round(speed):toInt()
	end
	if MODEL.lua.wSpeedcamEditMode() == 1 then
		MODEL.lua.SpeedCam_SpeedLimit = speed
		sc_back()
	elseif MODEL.lua.wSpeedcamEditMode() == 2 then
		MODEL.lua.SpeedCam_SpeedLimit = speed
		sc_SM_AddCamEnd()
	elseif MODEL.lua.wSpeedcamEditMode() == 3 then
		MODEL.lua.wSMAddCamSpeed = speed
		sc_back()
	elseif MODEL.lua.wSpeedcamEditMode() == 4 then
		MODEL.lua.SpeedCam_SpeedLimit = speed
		sc_wEditSpeedCam_done()
	end
end
 
sc_DeleteSpeedcam = function()
	sc_wShowNewMessageBox(m_i18n("Would you like to delete this Alert Point?"),"sc_DeleteSpeedcamOK", m_i18n("Delete"),"ico_Delete_mid.bmp#3")
end
 
sc_DeleteSpeedcamOK = function()
	MODEL.warning.manage.update_speedcam(MODEL.lua.SpeedCam_ID(), wSpeedCam_Type_entered, wSpeedCam_SpeedLimit_entered, wSpeedCam_Direction_entered, wSpeedCam_Direction_type_entered)
	doDelayed(1, sc_DeleteSpeedcamOKDone)
end
 
sc_DeleteSpeedcamOKDone = function()
	MODEL.warning.manage.delete_speedcam(MODEL.lua.SpeedCam_ID())
	MODEL.map.primary.update_clicked_speedcam_list()
	MODEL.ui.clicked_SpeedCamList.remove(MODEL.ui.clicked_SpeedCamList.index())
	if gEditSpeedcamFromInfo then
		sc_back()
	end
	sc_back()
	if (st_SelectSpeedcam.isActive or st_SelectSpeedcamForInfo.isActive) and MODEL.map.primary.clicked_speedcam_list.isempty() then
		sc_back()
	end
	sc_UpdateCameraCursorIcon()
end
 
sc_wResetSoundMuted = function()
	if MODEL.navigation.curr_speedcam.id() ~= wMuteResetedID then
		MODEL.lua.wSCSoundMuted = false
		wMuteResetedID = MODEL.navigation.curr_speedcam.id()
	end
end
 
sc_ToggleSpeedcamSound = function()
	MODEL.lua.wSCSoundMuted = not MODEL.lua.wSCSoundMuted()
	MODEL.navigation.curr_speedcam.speed_warning_sound_active = not MODEL.lua.wSCSoundMuted()
	if MODEL.lua.wSCSoundMuted() then
		sc_wplaysound(1, L"!!!", 1)
		if MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported() and not MODEL.lua.wTTSProGuidancePriority() then
			MODEL.sound.speech.unlock(wLockSpeakingID)
		end
		if wSpeedCameraSpeakingID then
			PromptCancel(wSpeedCameraSpeakingID)
			wSpeedCameraSpeakingID = 0
		end
		if not (MODEL.lua.wUltraSound() or (MODEL.lua.wUltraSoundTTS() and MODEL.lua.wReadOutSCSupported())) and MODEL.sound.speech.saying_source() == "voice.warning" then
			MODEL.sound.speech.cancel()
		end
	end
end
 
st_SelectSpeedcam:useLayers(backgroundLayers, "ui_List_Background", "ui_SelectSpeedcam")
st_SelectSpeedcam.init = function()
	txtTitle.TEXT = m_i18n("Speedcam~Select Alert Point")
end
 
sc_GetSpeedCamOtherBmp = function(category, typebmp)
	return "camerakSM" .. sc_GetSpeedCamOtherBmpRes(typebmp) .. tostring(category) .. ".bmp"
end
 
sc_GetSpeedCamLayerBmp = function(category, typebmp)
	local value = "camerakSM" .. sc_GetSpeedCamOtherBmpRes(typebmp) .. "0.bmp"
	local typestr = sc_GetSpeedCamCatValue(category, "type")
	if typestr ~= nil then
		value = "camerakSM" .. sc_GetSpeedCamOtherBmpRes(typebmp) .. tostring(typestr) .. ".bmp"
	end
	return value
end
 
sc_GetSpeedCamCatValue = function(catID, name)
	local value = nil
	for item in ModelList_iter(MODEL.ui.wCameraSettingName.unfiltered_list) do
		if item.type() == catID then
			value = item[name]()
			break
		end
	end
	return value
end
 
sc_UpdateCameraCursorIcon = function()
	MODEL.map.primary.cursor_icon = (MODEL.map.primary.clicked_speedcam_list.isempty() and "cursor" or "cursor_speedcam")
	g_cursor_strapped = not MODEL.map.primary.clicked_speedcam_list.isempty()
end
 
createState("st_SMAddCamSetting")
st_SMAddCamSetting:useLayers(backgroundLayers, "ui_List_Background", "ui_SMAddCamSetting")
 
st_SMAddCamSetting.init = function()
	txtTitle.TEXT = m_i18n("Function Add Camera to GPS Settings")
	MODEL.lua.wSpeedcamEditMode = 3
end
 
st_SMAddCamSetting.exit = function()
	SAVESETTINGS()
end
 
sc_SM_AddCam_init = function()
	MODEL.lua.SpeedCam_Pos = MODEL.navigation.car.position()
	wclickedSpeed = MODEL.navigation.car.current_speed()
	MODEL.map.cursor.position = MODEL.lua.SpeedCam_Pos()
	MODEL.lua.wSMAddCamCurrentDirection = 360 * (4096 - tonumber(MODEL.navigation.car.heading()))/4096
	local speedlimit, direction, direction_type = MODEL.warning.manage.get_segment_params()
	if MODEL.lua.wSMAddCamTypeMode() then
		MODEL.lua.SpeedCam_Type = MODEL.lua.wSMAddCamType()
	end
	MODEL.lua.SpeedCam_Direction_type = (MODEL.lua.wSMAddCamDirMode() and MODEL.lua.wSMAddCamDir() or direction_type)
	MODEL.lua.SpeedCam_SpeedLimit = (MODEL.lua.wSMAddCamSpeedMode() and MODEL.lua.wSMAddCamSpeed() or speedlimit)
	MODEL.lua.SpeedCam_Direction = direction
	SETMARKER(wAddCamPrevState)
	wSCSMCommunityMode = false
	if not (MODEL.lua.WannaReportAlertPoints() and MODEL.network.supported() and MODEL.EXISTS.warning.speedcam.community_speedcam_enabled() and MODEL.warning.speedcam.community_speedcam_enabled()) then
		sc_SM_AddCam()
	elseif MODEL.lua.wSMAddCamGeneralMode() == 0 then
		sc_SM_AddCam()
	elseif MODEL.lua.wSMAddCamGeneralMode() == 1 then
		sc_SM_AddCamCommunity_init()
	elseif MODEL.lua.wSMAddCamGeneralMode() == 2 then
		MODEL.screen.msgbox.new.setup(3)
		MODEL.screen.msgbox.new.set_line(1, m_i18n("Would you like to Report or Add Alert Point?"))
		MODEL.screen.msgbox.new.setup_button(1, "sc_SM_AddCamCommunity_init", m_i18n("Report"), "", "ico_GetExtras_mid.bmp#3")
		MODEL.screen.msgbox.new.setup_button(2, "", m_i18n("Cancel"), "", "ico_cancel_mid.bmp#3")
		MODEL.screen.msgbox.new.setup_button(3, "sc_SM_AddCam", m_i18n("Add"), "", "ico_speedcam_add_mid.bmp#3")
		MODEL.screen.msgbox.create_new()
	end
end
sc_AddSpeedCam_quick_onrelease = function()
	wSCSMCommunityMode = true
	sc_SM_AddCam()
end
 
sc_SM_AddCamCommunity_init = function()
	ui.vQuickAdd = true
	sc_NEL_Check_Auth()
end
 
sc_SM_AddCam = function()
	sc_wSetSMAddCamList()
	if MODEL.ui.wSMAddCamList.list.isempty() then
		sc_SM_AddCamEnd()
		sc_NaviMenuAlphaRestore()
	else
		MODEL.lua.wSpeedcamEditMode = 2
		sc_NextStateAnim(MODEL.ui.wSMAddCamList[0].state(), "fade", 1, "")
	end
end
 
sc_SM_AddCamEnd = function()
	if MODEL.lua.SpeedCam_Pos() ~= 0 then
		sc_CheckSMCamParameters(MODEL.lua.SpeedCam_Pos())
		if wSCSMCommunityMode then
			MODEL.warning.manage.add_community_speedcam(MODEL.lua.SpeedCam_Pos(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type(), wclickedPosition, wclickedRotation, wclickedSpeed)
		else
			MODEL.warning.manage.add_speedcam(MODEL.lua.SpeedCam_Pos(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type())
		end
	end
	sc_wAddCamPrevState_GO()
end
 
sc_wSetSMAddCamList = function()
	MODEL.ui.wSMAddCamList.clear()
	if MODEL.lua.wSMAddCamTypeMode() then
		sc_wReSetSMAddCamList(MODEL.lua.wSMAddCamType())
		return
	else
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Type"})
	end
	if not MODEL.lua.wSMAddCamDirMode() then
		ui.wSMAddCamList:add({state="st_wSMEditSpeedcam_Direction"})
	end
	if not MODEL.lua.wSMAddCamSpeedMode() then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Speed"})
	end
end
 
sc_wReSetSMAddCamList = function(type)
	MODEL.ui.wSMAddCamList.clear()
	if not MODEL.lua.wSMAddCamTypeMode() then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Type"})
	end
	if not MODEL.lua.wSMAddCamDirMode() and sc_GetSpeedCamCatValue(type, "editdirection") then
		ui.wSMAddCamList:add({state="st_wSMEditSpeedcam_Direction"})
	end
	if not MODEL.lua.wSMAddCamSpeedMode() and sc_GetSpeedCamCatValue(type, "editspeed") then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Speed"})
	end
end
 
sc_CheckSMCamParameters = function(position)
	if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editdirection") then
		MODEL.lua.SpeedCam_Direction_type = sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "defdirection")
	end
	if not sc_GetSpeedCamCatValue(MODEL.lua.SpeedCam_Type(), "editspeed") then
		MODEL.lua.SpeedCam_SpeedLimit = (MODEL.lua.SpeedCam_Type() ~= 1 and MODEL.lua.SpeedCam_Type() ~= 4 and 200 or 0)
	end
end
 
sc_RateSpeedCamPopup = function()
	if not ((vActiveState() == "st_screensaver" and MODEL.lua.wSpeedcamSS()) or (vActiveState() == "st_easynav" and not MODEL.lua.dragMode())) then
		return
	end
	local speedCamCategory = MODEL.navigation.curr_speedcam.category()
	local text1 = m_i18n("Confirm")
	local text2 = m_i18n("Challenge")
	rateSpeedcamId = MODEL.navigation.curr_speedcam.id()
	if MODEL.lua.wSCCategory() ~= -1 and MODEL.lua.wSCVisual() then
		sc_RemoveSpeedCamRateMsg()
		gSpeedPopupID = sc_AddMapPopup(2, translate(m_i18n("Feedback on Alert Point")), sc_GetSpeedCamLayerBmp(speedCamCategory,"Menu_"), 0, "sc_RateSpeedCam_Up", "sc_RateSpeedCam_Down", false, nil, 1, text1, text2)
		gRateSpeedcamDelayID = doDelayed(500, sc_RemoveSpeedCamRateMsg)
	end
end
 
sc_RemoveSpeedCamRateMsg = function()
	killDelayed(gRateSpeedcamDelayID)
	sc_RemoveMapPopupById(gSpeedPopupID)
end
 
rate = {up = 0, down = 1, passive = 2}
sc_RateSpeedCam_Up = function()
	MODEL.warning.manage.rate_speedcam(rateSpeedcamId, rate.up)
end
 
sc_RateSpeedCam_Down = function()
	MODEL.warning.manage.rate_speedcam(rateSpeedcamId, rate.down)
end
 
sc_CopySpeedCamUserList = function()
	MODEL.ui.clicked_SpeedCamList.clear()
	for item in ModelList_iter(MODEL.map.primary.clicked_speedcam_list) do
		if item.service() ~= 0 and item.service() ~= 2 then
			ui.clicked_SpeedCamList:add({category = item.category(), confidence = item.confidence(), heading = item.heading(), heading_type = item.heading_type(), icon_phase = item.icon_phase(), id = item.id(), position = item.position(), service = item.service(), speed_limit = item.speed_limit()})
		end
	end
end
st_SelectSpeedcamForInfo:useLayers(backgroundLayers, "ui_List_Background", "ui_SelectSpeedcamForInfo")
st_SelectSpeedcamForInfo.init = function()
	txtTitle.TEXT = m_i18n("Select Alert Point")
end
 
sc_ShowSpeedcamInfo = function()
	sc_UpdateSpeedcamModels(MODEL["*"])
	MODEL["*"]._list.setcurrent(index)
	sc_NextStateAnim(st_ShowSpeedcamInfo, "fade", 1, "")
end
 
createState("st_ShowSpeedcamInfo")
st_ShowSpeedcamInfo:useLayers(backgroundLayers, "ui_List_Background", "ui_ShowSpeedcamInfo")
st_ShowSpeedcamInfo.init = function()
	txtTitle.TEXT = m_i18n("Alert Point Information")
end
 
createState("st_wEmptyEditSC")
 
createState("st_wEditSCSettings")
st_wEditSCSettings:useLayers(backgroundLayers, "ui_wEditSCSettings")
st_wEditSCSettings.init = function()
	txtTitle.TEXT = m_i18n("Quick editing of Alert Point settings")
end
 
sc_wEditSpeedCam_onlongclick = function()
	local animType = (vActiveState() == "st_easynav" and "fade" or "horz_scroll")
	sc_NextStateAnim(st_wEditSCSettings, animType, 1, "")
end
 
sc_wEditSpeedCam = function()
	local model = MODEL.navigation.curr_speedcam()
	MODEL.lua.SpeedCam_Pos = model.position()
	MODEL.lua.SpeedCam_Type = model.category()
	MODEL.lua.SpeedCam_SpeedLimit = model.speed_limit()
	MODEL.lua.SpeedCam_Direction = model.heading()
	MODEL.lua.SpeedCam_Direction_type = model.heading_type()
	MODEL.lua.SpeedCam_ID = model.id()
	MODEL.lua.wSMAddCamCurrentDirection = 360 * (4096 - tonumber(MODEL.navigation.car.heading()))/4096
	wSpeedCam_Type_entered = MODEL.lua.SpeedCam_Type()
	wSpeedCam_SpeedLimit_entered = MODEL.lua.SpeedCam_SpeedLimit()
	wSpeedCam_Direction_entered = MODEL.lua.SpeedCam_Direction()
	wSpeedCam_Direction_type_entered = MODEL.lua.SpeedCam_Direction_type()
	sc_wSetEditCamList()
	SETMARKER(wAddCamPrevState)
	if MODEL.ui.wSMAddCamList.list.isempty() then
		sc_wDeleteSpeedCam_init()
	else
		MODEL.lua.wSpeedcamEditMode = 4
		sc_NextStateAnim(MODEL.ui.wSMAddCamList[0].state(), "fade", 1, "")
	end
end
 
sc_wEditSpeedCam_done = function()
	sc_CheckSMCamParameters(MODEL.lua.SpeedCam_Pos())
	MODEL.warning.manage.update_speedcam(MODEL.lua.SpeedCam_ID(), MODEL.lua.SpeedCam_Type(), MODEL.lua.SpeedCam_SpeedLimit(), MODEL.lua.SpeedCam_Direction(), MODEL.lua.SpeedCam_Direction_type())
	sc_wAddCamPrevState_GO()
end
 
sc_wSetEditCamList = function()
	MODEL.ui.wSMAddCamList.clear()
	if MODEL.lua.wEditCamTypeMode() then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Type"})
	else
		sc_wReSetEditCamList(MODEL.lua.SpeedCam_Type())
		return
	end
	if MODEL.lua.wEditCamDirMode() then
		ui.wSMAddCamList:add({state="st_wSMEditSpeedcam_Direction"})
	end
	if MODEL.lua.wEditCamSpeedMode() then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Speed"})
	end
end
 
sc_wReSetEditCamList = function(type)
	MODEL.ui.wSMAddCamList.clear()
	if MODEL.lua.wEditCamTypeMode() then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Type"})
	end
	if MODEL.lua.wEditCamDirMode() and sc_GetSpeedCamCatValue(type, "editdirection") then
		ui.wSMAddCamList:add({state="st_wSMEditSpeedcam_Direction"})
	end
	if MODEL.lua.wEditCamSpeedMode() and sc_GetSpeedCamCatValue(type, "editspeed") then
		ui.wSMAddCamList:add({state="st_EditSpeedcam_Speed"})
	end
end
 
sc_wDeleteSpeedCam_init = function()
	sc_wShowNewMessageBox(m_i18n("Would you like to delete this Alert Point?"),"sc_wDeleteSpeedCam_initOK", m_i18n("Delete"),"ico_Delete_mid.bmp#3")
end
 
sc_wDeleteSpeedCam_initOK = function()
	sc_NextStateAnim(st_wEmptyEditSC, "fade", 1, "")
	MODEL.warning.manage.update_speedcam(MODEL.lua.SpeedCam_ID(), wSpeedCam_Type_entered, wSpeedCam_SpeedLimit_entered, wSpeedCam_Direction_entered, wSpeedCam_Direction_type_entered)
	doDelayed(1, sc_wDeleteSpeedCam_initOKDone)
end
 
sc_wDeleteSpeedCam_initOKDone = function()
	MODEL.warning.manage.delete_speedcam(MODEL.lua.SpeedCam_ID())
	sc_wAddCamPrevState_GO()
end
 
sc_EditSpeedcamFromInfo = function()
	gEditSpeedcamFromInfo = true
	MODEL.lua.managespeedcam = true
	sc_NextStateAnim(st_EditSpeedcam, "fade", 1, "")
end
 
sc_GetSegmentSpeedLimit = function()
	local speedlimit, _, _ = MODEL.warning.manage.get_segment_params()
	return speedlimit
end
 
sc_wIsSpeedCamEditable = function()
	local editable = false
	for item in ModelList_iter(MODEL.map.primary.clicked_speedcam_list) do
		if item.service() ~= 0 and item.service() ~= 2 then
			editable = true
		end
	end
	return not MODEL.map.primary.clicked_speedcam_list.isempty() and MODEL.warning.speedcam_warning() and editable
end
 
sc_wAddCamPrevState_GO = function()
	if wAddCamPrevState() ~= -1 then
		CLEARTOMARKER(wAddCamPrevState())
	else
		CLEARTOSTATE(st_EasyNav)
	end
end
 
