﻿module("VOICE")

transform_destname = {
	exitname   = L"in på %s",
	exitnumber = L"in på %s",
	roadname   = L"på %s",
	to         = L"in på %s",
	settlement = L"mot %s"
}

sentence_transform = TRANSFORM.new({
	-- Comma remover, to be localized
	{2, L"(?i)\\. +(fortsätt|ta|håll|följ|vänd|kör|sväng|lämna|ankom,?) +", L", \\1 "},
	--
	{2, L"(%p)+ *(%p)+", L"%1 "},
	{2, L"%s+(%p+)", L"%1 "},
	{2, L" +", L" "},
})

substitute_transform = TRANSFORM.new({
	{2, L"^(%u)(%u)[ -]*(%d+)", L"%1.%2. %3"},
	{2, L"\-", L" "},
	{2, L"(%d)(%a)", L"%1 %2"},
	{2, L"(%a)(%d)", L"%1 %2"},
	{2, L"//", L", "},
	-- Resolve abbreviations here
	{2, L"(?i) St\\.? +(\\d+)", L"s t \\1"},
	{2, L"(?i)^St\\.? ", L"Sankt "},
	{2, L"(?i) St\\.?$", L"Street "},
	{2, L"(?i)^Dr\\.? ", L"Doctor"},
	{2, L"(?i) Dr\\.?$", L"Drive"},
	--
	{1, L"S:ta", L"Sankta"},
	{1, L"S:T", L"Sankt"},
	{1, L"k:a", L"kyrka"},
	{1, L"IND. OMR.", L"Industriområde"},
	{1, L"NAT. PARK", L"Nationalpark"},
	{1, L"NAT PARK", L"Nationalpark"},
	{1, L"JOHN F. KENNEDY ", L"John Fitzgerald Kennedy"},
	{1, L"JOHN F KENNEDY ", L"John Fitzgerald Kennedy"},
	{1, L"IND OMR", L"Industriområde"},
	{1, L"G:a", L"Gamla"},
	{1, L"G:", L"GATA"},
	--
	{1, L"VERKS", L"Verkstad"},
	{1, L"v", L"vägen"},
	{1, L"UNIV", L"Universitet"},
	{1, L"TR", L"TRAPPOR"},
	{1, L"tr", L"trappa"},
	{1, L"TPL", L"TRAFIKPLATS"},
	{1, L"TGT", L"TORGET"},
	{1, L"TERM", L"Terminal"},
	{1, L"SV", L"Sydväst"},
	{1, L"Sta", L"Sankta"},
	{1, L"St", L"Stora"},
	{1, L"SÖ", L"Sydöst"},
	{1, L"SJKHUS", L"Sjukhus"},
	{1, L"S", L"Södra"},
	{1, L"REST", L"Restaurant"},
	{1, L"PROF", L"Professor"},
	{1, L"PR", L"Prinsessan"},
	{1, L"PLATS", L"PLATSEN"},
	{1, L"PL", L"PLATS"},
	{1, L"ÖVR", L"Övre"},
	{1, L"Ö", L"Östra"},
	{1, L"O", L"Ost"},
	{1, L"NV", L"Nordväst"},
	{1, L"NÖ", L"Nordöst"},
	{1, L"NO", L"Nordost"},
	{1, L"NDR", L"Nedre"},
	{1, L"NAT", L"Nationell"},
	{1, L"N", L"Norra"},
	{1, L"L", L"Lilla"},
	{1, L"JVGST", L"Järnvägsstation"},
	{1, L"INT", L"Internationell"},
	{1, L"INFO", L"Information"},
	{1, L"GR", L"GRÄND"},
	{1, L"GL", L"Gamla"},
	{1, L"GK", L"Golfklubb"},
	{1, L"GGN", L"GÅNGEN"},
	{1, L"GÅRDSV", L"GÅRDSVÄG"},
	{1, L"GÅNG", L"GÅNGEN"},
	{1, L"GÅ", L"GÅNGEN"},
	{1, L"G", L"GATAN"},
	{1, L"FLYGST", L"Flygstation"},
	{1, L"FLPL", L"Flygplats"},
	{1, L"ESP", L"ESPLANADEN"},
	{1, L"C", L"Centralstation"},
	{1, L"BR", L"Bröderna"},
	{1, L"BORGM", L"Borgmästare"},
	{1, L"BA", L"BACKEN"},
	{1, L"av", L"aveny"},
	{1, L"AKUTMOTT", L"Akutmottagning"},
	{1, L"AB", L"Aktiebolag"},
	{1, L"&", L"Och"},
	{1, L"&", L"Och"},

})
