﻿module("VOICE")

----------------------------------------------------------------------------------------------------
---------------------------|  V O I C E   T R A N S F O R M   U T I L S  |--------------------------
----------------------------------------------------------------------------------------------------

local destname = {
    EXITNAME    = L"at exit to %s",
    EXITNUMBER  = L"at exit %s",
    ROADNAME    = L"onto %s",
    DESTINATION = L"to %s",
    SETTLEMENT  = L"towards %s",
}

local number_formatter_2 = {
    -- 0x => o x
    { L"0(%d)", L"o %1" },
}

local number_formatter_3 = {
    -- 100-900 => x hundred
    { L"([1-9])00", L"%1 hundred" },
    -- 110,120...980,990
    { L"([1-9])(%d)0", L"%1 %20" },
    -- xyz => x y z
    { L"(%d)(%d)(%d)", L"%1 %2 %3" },
}

local number_formatter_4 = {
    -- 1-9000
    { L"([1-9])000", L"%1 thousand" },
    -- xx00
    { L"([1-9][1-9])00", L"%1 hundred" },
    -- xxx0
    { L"([1-9])([1-9])(%d)0", L"%1 %2 %30"},
    -- xyzw => x y z w
    { L"(%d)(%d)(%d)(%d)", L"%1 %2 %3 %4"},
}

-- Attol fugg hany szamjegyu a szam
local number_formatters = {
    [2] = number_formatter_2,
    [3] = number_formatter_3,
    [4] = number_formatter_4,
}

-- '0' => 'oh'
local oh_formatters = {
    {L"^0$",L"o"},
    {L"^0 ",L"o "},
    {L" 0$",L" o"},
    {L" 0 ",L" o "},
}

local function format_number(str)
    if type(str) ~= "wstring" then
        ASSERT(FALSE, "The input of format_number must be wstring. Type: "..type(str))
        return L""
    end
    local formatter = number_formatters[#str]
    if formatter then
        local rep
        for _,v in ipairs(formatter) do
            str, rep = wstring.gsub(str, v[1], v[2])
            if rep > 0 then break end
        end
        for _,v in ipairs(oh_formatters) do
	    rep = 1
            while rep > 0 do
                str, rep = wstring.gsub(str, v[1], v[2])
            end
        end
    end
    return str
end

-- 55, A55, ST45
local roadnumber_typ_patterns = {
    L"^%d+",
    L"^%a%d+",
    L"^%a%a%d+",
}

-- Ugy nez ki mint ha utszam lenne?
local function is_road_number(str)
    return transform_pattern_match(str, roadnumber_typ_patterns)
end

--[[
-- Ugy nez ki mint ha utszam lenne?
local function is_road_number(str)
    -- Kotojelet kivesszuk
    str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
    -- Szetszedjuk head (A,B,M), number (32) es tail reszekre (N)
    local _,_, head, num, tail = wstring.find(str, L"^(%a?)(%d+)(.*)$")
    if num then return true
    else return false end
end
]]

local tail_replace_map = {
	{L"%(E%)",L"East"},
	{L"%(W%)",L"West"},
	{L"%(S%)",L"South"},
	{L"%(N%)",L"North"},
	{L"%(NE%)",L"North East"},
	{L"%(NW%)",L"North west"},
	{L"%(SE%)",L"South East"},
	{L"%(SW%)",L"South West"},
	{L"%(M%)",L"Motorway"},
}

local function format_road_number(roadnum)
    local res
    if is_road_number(roadnum) then
        roads = transform_roadnumber_explode_eu(roadnum)
        for k, str in ipairs(roads) do
            -- Nagybetu
            str = wstring.upper(str)
            -- Kotojelbol space
            str = wstring.gsub(str, L"(%a)-(%a)", L"%1 %2")
            _,_,head,num,tail = wstring.find(str, L"^(.-)(%d+)(.-)$")
            --
            if head == L"A" then head = L"Ay" end
            -- Szam formazas
            num = format_number(num)
            -- Tail formazas
            tail = transform.direction_abbrev:transform(tail)
            -- Osszerakjuk
            str = table_concat({head,num,tail}, L" ")
            -- Dupla space ki
            str = wstring.gsub(str, L"%s%s+", L" ")
            -- Eltesszuk
            roads[k] = str
        end
        res = table_concat(roads, L"; ")
    else
        res = transform.roadname_abbrev_table:transform(roadnum)
    end
    return res
end

local function format_road_name(str)
    if is_road_number(str) then
    -- Ha utszamnak nez ki, akkor akkent formazzuk
        str = format_road_number(str)
    else
    -- Kulonben siman utnevnek
        str = transform.roadname_abbrev_table:transform(str)
    end
    return str
end

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

local function format_signpost_exitnumber(str)
	local _, _, prefix, num, postfix = wstring.find(str, L"^(.-)(%d+)(.-)$")
	ASSERT(num, L"No number in format_signpost_exitnumber: "..str)
	if num then num = format_number(num) end
	-- Prefixbol kivesszuk az EXIT-et
	if prefix then prefix = wstring.gsub(wstring.upper(prefix), L"EXIT%s*", L"") end
	-- Ha van postfix (pl "140A-B" esetben)
	if postfix then postfix = wstring.gsub(postfix, L"[/-]+", L", ") end
        -- Osszefuzzuk es kesz
	return table_concat({prefix, num, postfix}, L" ")
end

local function signpost_exitnumber(data, idx)
    return transform_and_format(data[idx].signpost.exitnumber, format_signpost_exitnumber, destname.EXITNUMBER)
end

local function signpost_exitname(data, idx)
    return transform_and_format(data[idx].signpost.exitname, nil, destname.EXITNAME)
end

local function signpost_destination(data, idx)
    return transform_and_format(data[idx].signpost.destination, transform.roadname_abbrev_table,destname.DESTINATION)
end

local function signpost_settlement(data, idx)
        return transform_and_format(data[idx].signpost.settlement, transform.direction_abbrev, destname.SETTLEMENT)
end

local function signpost_roadnumber(data, idx)
    local format
    if data[idx].signpost.sign_road_branch then format = destname.ROADNAME
    else format = destname.SETTLEMENT end

    return transform_and_format(data[idx].signpost.roadnumber, format_road_number, format)
end

local function road_name(data, idx)
    return transform_and_format(data[idx].road.name, format_road_name)
end

local function road_number(data, idx)
    return transform_and_format(data[idx].road.number, format_road_number)
end

------------------------------------------|  O U T P U T  |-----------------------------------------
function format_destname(data, idx)
    local t
    local out
    if data[idx].signpost then
        t = transform_chain({}, signpost_exitname, 	data, idx)
	t = transform_chain(t,  signpost_exitnumber, 	data, idx)
	t = transform_chain(t,  signpost_roadnumber, 	data, idx)
	t = transform_chain(t,  signpost_destination,	data, idx)
	t = transform_chain(t,  signpost_settlement, 	data, idx)
        out = table_concat(t, L", ")
    elseif data[idx].road then
	t = transform_chain({}, road_number, data, idx)
	t = transform_chain(t,  road_name,   data, idx)
        out = wstring.format(destname.ROADNAME, table_concat(t, L", "))
    end
    return out
end

function format_streetname(data, idx)
    local t
    t = transform_chain({}, road_number, 	data, idx)
    t = transform_chain(t,  road_name, 	data, idx)
    return table_concat(t, L", ")
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------
function route_summary_format_road_name(data)
        return transform_and_format(data, format_road_number)
end

function route_summary_format_street_name(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

function route_summary_format_bridge_tunnel(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

function route_summary_format_order(data)
        return transform_and_format(data, transform.roadname_abbrev_table)
end

----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	---- Roadnumber prioritas
	if data.roadnumber then 
		local road = transform_and_format(data.roadnumber, format_road_number, L" on %s")
		if data.from and not data.to then
		-- M7 uton Martonvasar kozeleben
			str =  str..road..L" near "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- M7 uton, Martonvasar es Velence kozott 
			str =  str..road..L", between "..transform_and_format(data.from)..L" and "..transform_and_format(data.to)
		else
		-- Egyeb: M7 uton
			str = str..road
		end
	---- Roadname
	elseif data.roadname then
		local road = transform_and_format(data.roadname, transform.roadname_abbrev_table, L" on %s")
		if data.from and not data.to then
			-- "," menten robbantunk
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", at the intersection of "..from..L" and "..to
			else 
				str = str..road..L", at the intersection of "..transform_and_format(data.from)
			end
		elseif data.from and data.to then
			str = str..road..L", between "..transform_and_format(data.from)..L" and "..transform_and_format(data.to)
		else
			str = str..road
		end
	---- Nincs se roadnumber, se roadname 
	else
		if data.from and not data.to then
		-- Martonvasar kozeleben
			str =  str..L" near "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- Martonvasar es Velence kozott 
			str =  str..L" between "..transform_and_format(data.from)..L" and "..transform_and_format(data.to)
		else
		-- Egyeb: semmi
		end
	end
	str = str..L"."
	return str
end

----------------------------------------------------------------------------------------------------
------------------------------------------|  D E T O U R  |-----------------------------------------
----------------------------------------------------------------------------------------------------

function format_street_name (streetname)
    if wstring.sub (streetname, 1, 9) == L "for_turns" then
        return transform_and_format (wstring.sub (streetname, 10), transform.roadname_abbrev_table, destname.ROADNAME)
    else
        return transform_and_format (streetname, transform.roadname_abbrev_table)
    end
end

