﻿module("VOICE")

transform = {}

transform.roadname_abbrev_table = TRANSFORM.new({	
	{1,L"Acc",L"Access"},
	{1,L"Afb",L"Air Force Base"},
	{1,L"Aly",L"Alley"},
	{1,L"Appr",L"Approach"},
	{1,L"Arc",L"Arcade"},
	{1,L"Av",L"Avenue"},
	{1,L"Ave",L"Avenue"},
	{1,L"Ay",L"Alley"},
	{1,L"Bch",L"Beach"},
	{1,L"Blvd",L"Boulevard"},
	{1,L"Bndgs",L"Buildings"},
	{1,L"Bnk",L"Bank"},
	{1,L"Br",L"Bridge"},
	{1,L"Brdge",L"Bridge"},
	{1,L"Brdwy",L"Broadway"},
	{1,L"Brg",L"Bridge"},
	{1,L"Bri",L"Bridge"},
	{1,L"Brk",L"Brook"},
	{1,L"Brks",L"Brooks"},
	{1,L"Bros",L"Brothers"},
	{1,L"By",L"Bay"},
	{1,L"Byp",L"Bypass"},
	{1,L"Byps",L"Bypass"},
	{1,L"Cem",L"Cemetery"},
	{1,L"Ch",L"Chase"},
	{1,L"Chas",L"Chase"},
	{1,L"Chyd",L"Churchyard"},
	{1,L"Cir",L"Circle"},
	{1,L"Cirs",L"Circles"},
	{1,L"Cl",L"Close"},
	{1,L"Clb",L"Club"},
	{1,L"Clf",L"Cliff"},
	{1,L"Clfs",L"Cliffs"},
	{1,L"Cmn",L"Common"},
	{1,L"Cmp",L"Camp"},
	{1,L"Cnl",L"Canal"},
	{1,L"Cnr",L"Corner"},
	{1,L"Co",L"County"},
	{1,L"Col",L"Colonel"},
	{1,L"Com",L"Common"},
	{1,L"Cor",L"Corner"},
	{1,L"Cors",L"Corners"},
	{1,L"Cotts",L"Cottages"},
	{1,L"Cp",L"Camp"},
	{1,L"Cpc",L"Coppice"},
	{1,L"Cpl",L"Corporal"},
	{1,L"Cr",L"Crescent"},
	{1,L"Cres",L"Crescent"},
	{1,L"Crft",L"Croft"},
	{1,L"Crk",L"Creek"},
	{1,L"Crse",L"Course"},
	{1,L"Crst",L"Crest"},
	{1,L"Crve",L"Curve"},
	{1,L"Cs",L"Circus"},
	{1,L"Cswy",L"Causeway"},
	{1,L"Ct",L"Court"},
	{1,L"Cts",L"Courts"},
	{1,L"Cty",L"City"},
	{1,L"Cv",L"Cove"},
	{1,L"Cvs",L"Coves"},
	{1,L"Dl",L"Dale"},
	{1,L"Dm",L"Dam"},
	{1,L"Dr",L"Doctor"},
	{1,L"Dr",L"Drive"},
	{1,L"Dr",L"Drove"},
	{1,L"E",L"East"},
	{1,L"Embkt",L"Embankment"},
	{1,L"Ent",L"Entrance"},
	{1,L"Esq",L"Esquire"},
	{1,L"Est",L"Estate"},
	{1,L"Ests",L"Estates"},
	{1,L"Expy",L"Expressway"},
	{1,L"Fd",L"Fold"},
	{1,L"Fld",L"Field"},
	{1,L"Flds",L"Fields"},
	{1,L"Fls",L"Falls"},
	{1,L"Flt",L"Flat"},
	{1,L"Flts",L"Flats"},
	{1,L"Fm",L"Farm"},
	{1,L"Fr",L"Father"},
	{1,L"Frd",L"Ford"},
	{1,L"Frds",L"Fords"},
	{1,L"Frg",L"Forge"},
	{1,L"Frgs",L"Forges"},
	{1,L"Frk",L"Fork"},
	{1,L"Frks",L"Forks"},
	{1,L"Frst",L"Forest"},
	{1,L"Frsts",L"Forests"},
	{1,L"Fry",L"Ferry"},
	{1,L"Ft",L"Fort"},
	{1,L"Fwy",L"Freeway"},
	{1,L"Gdn",L"Garden"},
	{1,L"Gdns",L"Gardens"},
	{1,L"Gen",L"General"},
	{1,L"Gln",L"Glen"},
	{1,L"Glns",L"Glens"},
	{1,L"Gn",L"Green"},
	{1,L"Grn",L"Green"},
	{1,L"Grng",L"Grange"},
	{1,L"Grns",L"Greens"},
	{1,L"Grv",L"Grove"},
	{1,L"Grvs",L"Groves"},
	{1,L"Gt",L"Gate"},
	{1,L"Gy",L"Gully"},
	{1,L"Hd",L"Head"},
	{1,L"Hl",L"Hill"},
	{1,L"Hllw",L"Hollow"},
	{1,L"Hls",L"Hills"},
	{1,L"Hosp",L"Hospital"},
	{1,L"Hs",L"Houses"},
	{1,L"Hse",L"House"},
	{1,L"Hts",L"Heights"},
	{1,L"Hvn",L"Haven"},
	{1,L"Hwy",L"Highway"},
	{1,L"Inlt",L"Inlet"},
	{1,L"Is",L"Island"},
	{1,L"Iss",L"Islands"},
	{1,L"Jct",L"Junction"},
	{1,L"Jcts",L"Junctions"},
	{1,L"Knl",L"Knoll"},
	{1,L"Knls",L"Knolls"},
	{1,L"La",L"Lane"},
	{1,L"Lck",L"Lock"},
	{1,L"Lcks",L"Locks"},
	{1,L"Ldg",L"Lodge"},
	{1,L"Lk",L"Lake"},
	{1,L"Lks",L"Lakes"},
	{1,L"Ln",L"Lane"},
	{1,L"Ln",L"Line"},
	{1,L"Lnd",L"Landing"},
	{1,L"Lp",L"Loop"},
	{1,L"Lt",L"Lieutenant"},
	{1,L"Lwn",L"Lawn"},
	{1,L"Maj",L"Major"},
	{1,L"Mdow",L"Meadow"},
	{1,L"Mdw",L"Meadow"},
	{1,L"Mdws",L"Meadows"},
	{1,L"Mkt",L"Market"},
	{1,L"Ml",L"Mill"},
	{1,L"Mls",L"Mills"},
	{1,L"Mnr",L"Manor"},
	{1,L"Mnrs",L"Manors"},
	{1,L"Mr",L"Mister"},
	{1,L"Mrs",L"Mistress"},
	{1,L"Ms",L"Miss"},
	{1,L"Msgr",L"Monseigneur"},
	{1,L"Mt",L"Mount"},
	{1,L"Mtn",L"Mountain"},
	{1,L"Mtns",L"Mountains"},
	{1,L"Mtwy",L"Motorway"},
	{1,L"N",L"North"},
	{1,L"NE",L"Northeast"},
	{1,L"NW",L"Northwest"},
	{1,L"Opas",L"Overpass"},
	{1,L"Orch",L"Orchard"},
	{1,L"Ovl",L"Oval"},
	{1,L"Pct",L"Precinct"},
	{1,L"Pd",L"Pond"},
	{1,L"Pde",L"Parade"},
	{1,L"Pdk",L"Paddock"},
	{1,L"Pk",L"Park"},
	{1,L"Pl",L"Place"},
	{1,L"Prof",L"Professor"},
	{1,L"Prom",L"Promenade"},
	{1,L"Prt",L"Port"},
	{1,L"Prts",L"Ports"},
	{1,L"Ps",L"Pass"},
	{1,L"Psge",L"Passage"},
	{1,L"Pt",L"Path"},
	{1,L"Pt",L"Point"},
	{1,L"Pts",L"Points"},
	{1,L"Pvt",L"Private"},
	{1,L"Qy",L"Quay"},
	{1,L"Rd",L"Ride"},
	{1,L"Rd",L"Road"},
	{1,L"Rdg",L"Ridge"},
	{1,L"Rdgs",L"Ridges"},
	{1,L"Rds",L"Roads"},
	{1,L"Rf",L"Reef"},
	{1,L"Rk",L"Rock"},
	{1,L"Rs",L"Rise"},
	{1,L"Rv",L"River"},
	{1,L"Rw",L"Row"},
	{1,L"S",L"South"},
	{1,L"Sch",L"School"},
	{1,L"SE",L"Southeast"},
	{1,L"Sgt",L"Sargeant"},
	{1,L"Shr",L"Shore"},
	{1,L"Shrs",L"Shores"},
	{1,L"Smt",L"Summit"},
	{1,L"Spg",L"Spring"},
	{1,L"Spgs",L"Springs"},
	{1,L"Sq",L"Square"},
	{1,L"Sqs",L"Squares"},
	{1,L"St",L"Saint"},
	{1,L"St",L"Street"},
	{1,L"Std",L"Strand"},
	{1,L"Stn",L"Station"},
	{1,L"Strm",L"Stream"},
	{1,L"Sts",L"Streets"},
	{1,L"SW",L"Southwest"},
	{1,L"Ter",L"Terrace"},
	{1,L"Trk",L"Track"},
	{1,L"Trl",L"Trail"},
	{1,L"Tun",L"Tunnel"},
	{1,L"Tunl",L"Tunnel"},
	{1,L"Twr",L"Tower"},
	{1,L"Upas",L"Underpass"},
	{1,L"Via",L"Viaduct"},
	{1,L"Vl",L"Vale"},
	{1,L"Vlg",L"Village"},
	{1,L"Vlgs",L"Villages"},
	{1,L"Vls",L"Villas"},
	{1,L"Vly",L"Valley"},
	{1,L"Vlys",L"Valleys"},
	{1,L"Vw",L"View"},
	{1,L"Vws",L"Views"},
	{1,L"W",L"West"},
	{1,L"Whrf",L"Wharf"},
	{1,L"Wk",L"Walk"},
	{1,L"Wl",L"Wall"},
	{1,L"Wl",L"Well"},
	{1,L"Wls",L"Wells"},
	{1,L"Wy",L"Way"},
	{1,L"Wys",L"Ways"},
	{1,L"Xing",L"Crossing"},
	{1,L"Xrd",L"Crossroad"},
	{1,L"Yd",L"Yard"},
	}
)

transform.direction_abbrev = TRANSFORM.new({
        {1,L"M",L"Motorway"},
        {1,L"E",L"East"},
	{1,L"W",L"West"},
	{1,L"S",L"South"},
	{1,L"N",L"North"},
	{1,L"NE",L"North East"},
	{1,L"NW",L"North west"},
	{1,L"SE",L"South East"},
	{1,L"SW",L"South West"},
}
)
sentence_transform = TRANSFORM.new({
	-- Comma remover, to be localized
	{2, L"(?i)\\. +(después,?) +",L", \\1 "},
	--
	{2, L"(%p)+ *(%p)+",L"%1 "},
	{2, L"%s+(%p+)",L"%1 "},
	{2, L" +",L" "},
})

substitute_transform = TRANSFORM.new({
	{2, L"^(%u)(%u)[ -]*(%d+)", L"%1.%2. %3"},
	{2, L"\-", L" "},
	{2, L"(%d)(%a)", L"%1 %2"},
	{2, L"(%a)(%d)", L"%1 %2"},
	{2, L"//", L", "},
	-- Resolve abbreviations here
	{2, L"(?i) St\\.? +(\\d+)", L"s t \\1"},
	{2, L"(?i)^St\\.? ", L"Saint "},
	{2, L"(?i) St\\.?$", L"strit "},
	{2, L"(?i)^Dr\\.? ", L"Dottor"},
	{2, L"(?i) Dr\\.?$", L"draiv"},
	--
	{1, L"S.O", L"Suroeste"},
	{1, L"S.E", L"Sureste"},
	{1, L"R. de", L"Riera de"},
	{1, L"R. d'", L"Riera d'"},
	{1, L"R de", L"Riera de"},
	{1, L"R d'", L"Riera d'"},
	{1, L"PZADE LOS", L"PLAZA DE LOS"},
	{1, L"PZADE LAS", L"PLAZA DE LAS"},
	{1, L"PZADE LA", L"PLAZA DE LA"},
	{1, L"PTIODE LOS", L"PATIO DE LOS"},
	{1, L"PTIODE LAS", L"PATIO DE LAS"},
	{1, L"PTIODE LA", L"PATIO DE LA"},
	{1, L"PTGE.", L"PASSATGE"},
	{1, L"Pg.Mar", L"Passeig Maritim de"},
	{1, L"Pg Mar", L"Passeig Maritim de"},
	{1, L"P.ø", L"Paseo"},
	{1, L"O.", L"Oeste"},
	{1, L"NDODE LA", L"NUDO DE LA"},
	{1, L"NDO.DE", L"NUDO DE"},
	{1, L"NDO.DE LA", L"NUDO DE LA"},
	{1, L"NDO", L"NUDO"},
	{1, L"N.O", L"Noroeste"},
	{1, L"N.E", L"Nordeste"},
	{1, L"N.", L"Norte"},
	{1, L"MUELLDE LA", L"MUELLE DE LA"},
	{1, L"KALE PARTIK.", L"KALE PARTIKULARRA"},
	{1, L"K.PARTIK.", L"KALE PARTIKULARRA"},
	{1, L"K.PARTIK", L"KALE PARTIKULARRA"},
	{1, L"K.NAGUSIA", L"KALE NAGUSIA"},
	{1, L"K.NAG.", L"KALE NAGUSIA"},
	{1, L"K.NAG", L"KALE NAGUSIA"},
	{1, L"K.LUZAPENA", L"KALEAREN LUZAPENA"},
	{1, L"K.", L"KARRIKA"},
	{1, L"K PARTIK", L"KALE PARTIKULARRA"},
	{1, L"K NAG", L"KALE NAGUSIA"},
	{1, L"Gran V.", L"Gran V¡a"},
	{1, L"Gran V. del", L"Gran Via del"},
	{1, L"G.V.DE", L"GRAN VÖA DE"},
	{1, L"G.V DE", L"GRAN VÖA DE"},
	{1, L"G V DE", L"GRAN VÖA DE"},
	{1, L"Esc. del", L"Escales del"},
	{1, L"Esc. de", L"Escales de"},
	{1, L"Esc. de la", L"Escales de la"},
	{1, L"Esc del", L"Escales del"},
	{1, L"Esc de", L"Escales de"},
	{1, L"Esc de la", L"Escales de la"},
	{1, L"ERREP.ZAHAR.", L"ERREPIDE ZAHARRA"},
	{1, L"ERREP.", L"ERREPIDEA"},
	{1, L"ERREP ZAHAR", L"ERREPIDE ZAHARRA"},
	{1, L"ERREP ZAHAR.", L"ERREPIDE ZAHARRA"},
	{1, L"CTRA.DEL", L"CARRETERA DEL"},
	{1, L"CTRA.DE", L"CARRETERA DE"},
	{1, L"CTRA.DE LOS", L"CARRETERA DE LOS"},
	{1, L"CTRA.DE LAS", L"CARRETERA DE LAS"},
	{1, L"CTRA.DE LA", L"CARRETERA DE LA"},
	{1, L"CRRLODE LA", L"CORRALILLO DE LA"},
	{1, L"CRO.DE", L"CARREIRO DE"},
	{1, L"CPADE LA", L"CAMPA DE LA"},
	{1, L"CMNO.DEL", L"CAMINO DEL"},
	{1, L"CMNO.DE", L"CAMINO DE"},
	{1, L"CMNO.DE LOS", L"CAMINO DE LOS"},
	{1, L"CMNO.DE LAS", L"CAMINO DE LAS"},
	{1, L"CMNO.DE LA", L"CAMINO DE LA"},
	{1, L"CMNO.AL", L"CAMINO AL"},
	{1, L"CMNO.A", L"CAMINO A"},
	{1, L"Cm.V. de", L"Cam¡ Vell de"},
	{1, L"Cm.V  de", L"Cam¡ Vell de"},
	{1, L"Cm V de", L"Cam¡ Vell de"},
	{1, L"C/PART", L"CALLE PARTICULAR"},
	{1, L"C/PART.DEL", L"CALLE PARTICULAR DEL"},
	{1, L"C/PART.DE", L"CALLE PARTICULAR DE"},
	{1, L"C/PART.DE LAS", L"CALLE PARTICULAR DE LAS"},
	{1, L"C/PART.DE LA", L"CALLE PARTICULAR DE LA"},
	{1, L"C/DEL", L"CALLE DEL"},
	{1, L"C/DE", L"CALLE DE"},
	{1, L"C/DE LOS", L"CALLE DE LOS"},
	{1, L"C/DE LAS", L"CALLE DE LAS"},
	{1, L"C/DE LA", L"CALLE DE LA"},
	{1, L"C/", L"CARRER"},
	{1, L"C.PART", L"CALLE PARTICULAR"},
	{1, L"C.PART.DEL", L"CALLE PARTICULAR DEL"},
	{1, L"C.PART.DE", L"CALLE PARTICULAR DE"},
	{1, L"C.PART.DE LAS", L"CALLE PARTICULAR DE LAS"},
	{1, L"C.PART.DE LA", L"CALLE PARTICULAR DE LA"},
	{1, L"C.PART.", L"CALLE PARTICULAR"},
	{1, L"C.PART DE", L"CALLE PARTICULAR DE"},
	{1, L"C.PART DE LAS", L"CALLE PARTICULAR DE LAS"},
	{1, L"C.DEL", L"CALLE DEL"},
	{1, L"C.DE", L"CALLE DE"},
	{1, L"C.DE LOS", L"CALLE DE LOS"},
	{1, L"C.DE LAS", L"CALLE DE LAS"},
	{1, L"C.DE LA", L"CALLE DE LA"},
	{1, L"C.A", L"Carrer Antic del"},
	{1, L"C PART", L"CALLE PARTICULAR"},
	{1, L"C PART.DEL", L"CALLE PARTICULAR DEL"},
	{1, L"C PART DEL", L"CALLE PARTICULAR DEL"},
	{1, L"C PART DE", L"CALLE PARTICULAR DE"},
	{1, L"C PART DE LAS", L"CALLE PARTICULAR DE LAS"},
	{1, L"C PART DE LA", L"CALLE PARTICULAR DE LA"},
	{1, L"C A", L"Carrer Antic del"},
	{1, L"BJADA.DEL", L"BAJADA DEL"},
	{1, L"BJADA.DE LOS", L"BAJADA DE LOS"},
	{1, L"BJADA.DE LAS", L"BAJADA DE LAS"},
	{1, L"BJADA.DE LA", L"BAJADA DE LA"},
	{1, L"BELNADE LA", L"BELENA DE LA"},
	{1, L"BDA.DEL", L"BAJADA DEL"},
	{1, L"BDA.DE LOS", L"BAJADA DE LOS"},
	{1, L"BDA.DE LAS", L"BAJADA DE LAS"},
	{1, L"BDA.DE LA", L"BAJADA DE LA"},
	{1, L"AVNDA.DEL", L"AVENIDA DEL"},
	{1, L"AVDA.DOS", L"AVENIDA DOS"},
	{1, L"AVDA.DO", L"AVENIDA DO"},
	{1, L"AVDA.DEL", L"AVENIDA DEL"},
	{1, L"AVDA.DE", L"AVENIDA DE"},
	{1, L"AVDA.DE LOS", L"AVENIDA DE LOS"},
	{1, L"AVDA.DE LAS", L"AVENIDA DE LAS"},
	{1, L"AVDA.DE LA", L"AVENIDA DE LA"},
	{1, L"AVDA.DAS", L"AVENIDA DAS"},
	{1, L"AVDA.DA", L"AVENIDA DA"},
	{1, L"AUTO.DO", L"AUTOESTRADA DO"},
	{1, L"ACDE LOS", L"ACUEDUCTO DE LOS"},
	{1, L"ACDE LA", L"ACUEDUCTO DE LA"},
	--
	{1, L"ZUMR", L"ZUMARDIA"},
	{1, L"ZUMK", L"ZUMARKALEA"},
	{1, L"ZUMARK", L"ZUMARKALEA"},
	{1, L"ZUMAR", L"ZUMARDIA"},
	{1, L"ZUBB", L"ZUBIA"},
	{1, L"ZHRB", L"ZEHARBIDEA"},
	{1, L"ZHKL", L"ZEHARKALEA"},
	{1, L"ZEHARB", L"ZEHARBIDEA"},
	{1, L"ZEHAR", L"ZEHARKALEA"},
	{1, L"ZEHAR", L"ZEHARKALEA"},
	{1, L"X", L"Xardíns"},
	{1, L"VÍLS", L"VÍA DE LAS"},
	{1, L"VÍLO", L"VÍA DE LOS"},
	{1, L"VÍLA", L"VÍA DE LA"},
	{1, L"VÍL", L"VÍA DEL"},
	{1, L"VREDADEL", L"VEREDA DEL"},
	{1, L"VREDADE", L"VEREDA DE"},
	{1, L"VREDA", L"VEREDA"},
	{1, L"Viaducte", L"Viaducte de"},
	{1, L"VDEL", L"VÍA DEL"},
	{1, L"VDE", L"VÍA DE"},
	{1, L"VCTODEL", L"VIADUCTO DEL"},
	{1, L"VCTODE", L"VIADUCTO DE"},
	{1, L"VCTO", L"VIADUCTO"},
	{1, L"V", L"VÍA"},
	{1, L"URBDEL", L"URBANIZACIÓN DEL"},
	{1, L"URBDE", L"URBANIZACIÓN DE"},
	{1, L"URB", L"URBANIZACIÓN"},
	{1, L"TVSIADEL", L"TRAVESÍA DEL"},
	{1, L"TVSIADE", L"TRAVESÍA DE"},
	{1, L"TVSIA", L"TRAVESÍA"},
	{1, L"TRVADEL", L"TRAVESÍA DEL"},
	{1, L"TRVADE", L"TRAVESÍA DE"},
	{1, L"TRVA", L"TRAVESÍA"},
	{1, L"Trv", L"Travessia de"},
	{1, L"Trav", L"Travessera de"},
	{1, L"Torrent", L"Torrent de"},
	{1, L"TNELDEL", L"TÚNEL DEL"},
	{1, L"TNELDE", L"TÚNEL DE"},
	{1, L"TNEL", L"TÚNEL"},
	{1, L"Sra", L"Señora"},
	{1, L"Sr", L"Señor"},
	{1, L"SO", L"Suroeste"},
	{1, L"Sn", L"San"},
	{1, L"Sgo", L"Sargento"},
	{1, L"SE", L"Sureste"},
	{1, L"SDADEL", L"SENDA DEL"},
	{1, L"SDADE", L"SENDA DE"},
	{1, L"SDA", L"SENDA"},
	{1, L"SBIDADEL", L"SUBIDA DEL"},
	{1, L"SBIDADE", L"SUBIDA DE"},
	{1, L"SBIDA", L"SUBIDA"},
	{1, L"SARR", L"SARRERA"},
	{1, L"SARB", L"SARBIDEA"},
	{1, L"S", L"Santa"},
	{1, L"RTRNODEL", L"RETORNO DEL"},
	{1, L"RTRNODE", L"RETORNO DE"},
	{1, L"RTRNO", L"RETORNO"},
	{1, L"RTDADEL", L"ROTONDA DEL"},
	{1, L"RTDADE", L"ROTONDA DE"},
	{1, L"RTDA", L"ROTONDA"},
	{1, L"RMBS", L"RAMBLA DE LAS"},
	{1, L"RMBO", L"RAMBLA DE LOS"},
	{1, L"RMBLADEL", L"RAMBLA DEL"},
	{1, L"RMBLADE", L"RAMBLA DE"},
	{1, L"RMBLA", L"RAMBLA"},
	{1, L"Rev", L"Reverendo"},
	{1, L"RDLS", L"RONDA DE LAS"},
	{1, L"RDLO", L"RONDA DE LOS"},
	{1, L"RDADEL", L"RONDA DEL"},
	{1, L"RDADE", L"RONDA DE"},
	{1, L"RDA", L"RONDA"},
	{1, L"RCÓNLAS", L"RINCÓN LAS"},
	{1, L"RCÓNLA", L"RINCÓN LA"},
	{1, L"RCÓNDEL", L"RINCÓN DEL"},
	{1, L"RCÓNDE", L"RINCÓN DE"},
	{1, L"RCÓN", L"RINCÓN"},
	{1, L"RCON", L"RINCON"},
	{1, L"RBLADEL", L"RAMBLA DEL"},
	{1, L"RBLADE", L"RAMBLA DE"},
	{1, L"RBLA", L"RAMBLA"},
	{1, L"R", L"Rúa"},
	{1, L"PÇA", L"PLAÇA"},
	{1, L"P°", L"Paseo"},
	{1, L"PZTADE", L"PLAZOLETA DE"},
	{1, L"PZTA", L"PLAZOLETA DEL"},
	{1, L"PZODEL", L"PASADIZO DEL"},
	{1, L"PZODE", L"PASADIZO DE"},
	{1, L"PZO", L"PASADIZO"},
	{1, L"PZADEL", L"PLAZA DEL"},
	{1, L"PZADE", L"PLAZA DE"},
	{1, L"PZA", L"PLAZA"},
	{1, L"PTIODEL", L"PATIO DEL"},
	{1, L"PTIODE", L"PATIO DE"},
	{1, L"PTIO", L"PATIO"},
	{1, L"PTGE", L"PASSATGE"},
	{1, L"Pte", L"Presidente"},
	{1, L"PSYS", L"PASAJE DE LAS"},
	{1, L"PSYO", L"PASAJE DE LOS"},
	{1, L"PSYA", L"PASAJE DE LA"},
	{1, L"PSODEL", L"PASEO DEL"},
	{1, L"PSODE", L"PASEO DE"},
	{1, L"PSO", L"PASEO"},
	{1, L"PSLK", L"PASEALEKUA"},
	{1, L"PSLADEL", L"PASARELA DEL"},
	{1, L"PSLA", L"PASARELA"},
	{1, L"PSJL", L"PASAJE DEL"},
	{1, L"PSJD", L"PASAJE DE"},
	{1, L"PSI", L"PASAIA"},
	{1, L"PSDEL", L"PASEO DEL"},
	{1, L"PSDE", L"PASEO"},
	{1, L"PSAJEDEL", L"PASAJE DEL"},
	{1, L"PSAJEDE", L"PASAJE DE"},
	{1, L"PSAJE", L"PASAJE"},
	{1, L"PS", L"PASEO"},
	{1, L"Prolong", L"Prolongación de"},
	{1, L"PROLDEL", L"PROLONGACIÓN DEL"},
	{1, L"PROLDE", L"PROLONGACIÓN DE"},
	{1, L"PROL", L"PROLONGACIÓN"},
	{1, L"Prof", L"Profesor"},
	{1, L"PRIVDEL", L"PRIVADA DEL"},
	{1, L"PRIVDE", L"PRIVADA DE"},
	{1, L"PRIV", L"PRIVADA"},
	{1, L"Prc", L"Praciña"},
	{1, L"Pr", L"Praza"},
	{1, L"PNTEDEL", L"PUENTE DEL"},
	{1, L"PNTEDE", L"PUENTE DE"},
	{1, L"PNTE", L"PUENTE"},
	{1, L"PLÇ", L"PLAÇA"},
	{1, L"PLZX", L"PLAZATXOA"},
	{1, L"PLZLADEL", L"PLAZUELA DEL"},
	{1, L"PLZLADE", L"PLAZUELA DE"},
	{1, L"PLZLA", L"PLAZUELA"},
	{1, L"PLZADEL", L"PLAZA DEL"},
	{1, L"PLZADE", L"PLAZA DE"},
	{1, L"PLZA", L"PLAZA"},
	{1, L"PLZ", L"PLAZA"},
	{1, L"PLXS", L"PLAZA DE LAS"},
	{1, L"PLXO", L"PLAZA DE LOS"},
	{1, L"PLXL", L"PLAZA DEL"},
	{1, L"PLXD", L"PLAZA DE"},
	{1, L"PLXA", L"PLAZA DE LA"},
	{1, L"PLCITA", L"PLACITA"},
	{1, L"Plc", L"Placeta d'"},
	{1, L"Pla", L"Pla de la"},
	{1, L"PL", L"PLAZA"},
	{1, L"PJE", L"PASAJE"},
	{1, L"PGE", L"PASSATGE"},
	{1, L"PG", L"PASSEIG"},
	{1, L"Pdís", L"Passadís de l'"},
	{1, L"PCTADEL", L"PLACETA DEL"},
	{1, L"PCTADE", L"PLACETA DE"},
	{1, L"PCTA", L"PLACETA"},
	{1, L"PAYS", L"PASEO DE LAS"},
	{1, L"PAYO", L"PASEO DE LOS"},
	{1, L"PAYA", L"PASEO DE LA"},
	{1, L"PAXL", L"PASEO DEL"},
	{1, L"PASEA", L"PASEALEKUA"},
	{1, L"PASAI", L"PASAIA"},
	{1, L"Pas", L"Pas de"},
	{1, L"Parc", L"Parc de"},
	{1, L"Palau", L"Palau de"},
	{1, L"Ntro", L"Nuestro"},
	{1, L"Ntra", L"Nuestra"},
	{1, L"NO", L"Noroeste"},
	{1, L"NE", L"Nordeste"},
	{1, L"NDODE", L"NUDO DE"},
	{1, L"NDO", L"NUDO"},
	{1, L"MUXA", L"MUELLE DE LA"},
	{1, L"MUELLDE", L"MUELLE DE"},
	{1, L"MUELL", L"MUELLE"},
	{1, L"MUED", L"MUELLE DE"},
	{1, L"MUE", L"MUELLE"},
	{1, L"MTE", L"MONTE"},
	{1, L"Mq", L"Marqués"},
	{1, L"Moll", L"Moll de"},
	{1, L"MDTEA", L"MENDATEA"},
	{1, L"Llano", L"LLano de la"},
	{1, L"LGIA", L"LORATEGIA"},
	{1, L"LDA", L"LANDA"},
	{1, L"KXOA", L"KALETXOA"},
	{1, L"KXKA", L"KALEXKA"},
	{1, L"KTXIA", L"KALEITXIA"},
	{1, L"KTIA", L"KANTOIA"},
	{1, L"KRRK", L"KARRIKA"},
	{1, L"KNKA", L"KALENKA"},
	{1, L"KNAGUSIA", L"KALE NAGUSIA"},
	{1, L"KLXK", L"KALEXKA"},
	{1, L"KLUZAPENA", L"KALEAREN LUZAPENA"},
	{1, L"KLTX", L"KALETXOA"},
	{1, L"KARRI", L"KARRIKA"},
	{1, L"KALZ", L"KALEA"},
	{1, L"KALN", L"KALE NAGUSIA"},
	{1, L"KAIZ", L"KAIA"},
	{1, L"K", L"KARRIKA"},
	{1, L"JTSR", L"JAITSIERA"},
	{1, L"JDINESDEL", L"JARDINES DEL"},
	{1, L"JDINESDE", L"JARDINES DE"},
	{1, L"JDINES", L"JARDINES"},
	{1, L"JAITSI", L"JAITSIERA"},
	{1, L"J", L"Jardins d'"},
	{1, L"INRD", L"INGURUBIDEA"},
	{1, L"INGURUB", L"INGURUBIDEA"},
	{1, L"INGURU", L"INGURUBIDEA"},
	{1, L"IBTK", L"IBILTOKIA"},
	{1, L"IBILT", L"IBILTOKIA"},
	{1, L"IBILB", L"IBILBIDEA"},
	{1, L"IBIL", L"IBILBIDEA"},
	{1, L"IBBD", L"IBILBIDEA"},
	{1, L"Hnos", L"Hermanos"},
	{1, L"HIRIB", L"HIRIBIDEA"},
	{1, L"HIRB", L"HIRIBIDEA"},
	{1, L"GTADEL", L"GLORIETA DEL"},
	{1, L"GTADE", L"GLORIETA DE"},
	{1, L"GTA", L"GLORIETA"},
	{1, L"GRUPDEL", L"GRUPO DEL"},
	{1, L"GRUPDE", L"GRUPO DE"},
	{1, L"GRUP", L"GRUPO"},
	{1, L"Gral", L"General"},
	{1, L"GLYS", L"GLORIETA DE"},
	{1, L"Fr", L"Frai"},
	{1, L"Excmos", L"Excelentísimos"},
	{1, L"Excmo", L"Excelentísimo"},
	{1, L"Excmas", L"Excelentísimas"},
	{1, L"Excma", L"Excelentísima"},
	{1, L"ETXALD", L"ETXALDEA"},
	{1, L"ETRB", L"ETORBIDEA"},
	{1, L"ETOR", L"ETORBIDEA"},
	{1, L"ETDEA", L"ETORBIDEA"},
	{1, L"ETAF", L"ESTRADA A"},
	{1, L"ETAB", L"ESTRADA DAS"},
	{1, L"ETAA", L"ESTRADA DA"},
	{1, L"ESTDADE", L"ESTRADA DE"},
	{1, L"ESTDADAS", L"ESTRADA DAS"},
	{1, L"ESTDADA", L"ESTRADA DA"},
	{1, L"ESTDAA", L"ESTRADA A"},
	{1, L"ESTDA", L"ESTRADA"},
	{1, L"ESTAR", L"ESTARDA"},
	{1, L"Esc", L"Escultor"},
	{1, L"ERZH", L"ERREPIDE ZAHARRA"},
	{1, L"ERRON", L"ERRONDA"},
	{1, L"ERRIB", L"ERRIBERA"},
	{1, L"ERREP", L"ERREPIDEA"},
	{1, L"ERPD", L"ERREPIDEA"},
	{1, L"ERP", L"ERREPIDEA"},
	{1, L"ERDA", L"ERRONDA"},
	{1, L"ENPTZA", L"ENPARANTZA"},
	{1, L"ENP", L"ENPARANTZA"},
	{1, L"Eng", L"Enginyer"},
	{1, L"Dª", L"Doña"},
	{1, L"Dra", L"Drivea"},
	{1, L"DIST", L"DISTRIBUIDOR"},
	{1, L"Dcra", L"Drecera de"},
	{1, L"D", L"Don"},
	{1, L"C˚", L"CAMINO"},
	{1, L"CÑODOS", L"CAMIÑO DOS"},
	{1, L"CÑODO", L"CAMIÑO DO"},
	{1, L"CÑODEL", L"CAMIÑO DEL"},
	{1, L"CÑODE", L"CAMIÑO DE"},
	{1, L"CÑODAS", L"CAMIÑO DAS"},
	{1, L"CÑODA", L"CAMIÑO DA"},
	{1, L"CÑO", L"CAMIÑO"},
	{1, L"CÑADADEL", L"CAÑADA DEL"},
	{1, L"CÑADADE", L"CAÑADA DE"},
	{1, L"CÑADA", L"CAÑADA"},
	{1, L"Cª", L"CARRETERA"},
	{1, L"CZADADEL", L"CALZADA DEL"},
	{1, L"CZADADE", L"CALZADA DE"},
	{1, L"CZADA", L"CALZADA"},
	{1, L"CXONDOS", L"CALEXÓN DOS"},
	{1, L"CXONDO", L"CALEXÓN DO"},
	{1, L"CXONDE", L"CALEXÓN DE"},
	{1, L"CXONDA", L"CALEXÓN DA"},
	{1, L"CXON", L"CALEXÓN"},
	{1, L"CUSS", L"CUESTA DE LAS"},
	{1, L"CUSO", L"CUESTA DE LOS"},
	{1, L"CUSL", L"CUESTA DEL"},
	{1, L"CUSA", L"CUESTA DE LA"},
	{1, L"CUS", L"CUESTA DE"},
	{1, L"CTRADEL", L"CARRETERA DEL"},
	{1, L"CTRADE", L"CARRETERA DE"},
	{1, L"Ctra", L"Carretera"},
	{1, L"CTRA", L"CARRETERA A"},
	{1, L"CTO", L"CIRCUITO"},
	{1, L"CTADEL", L"CUESTA DEL"},
	{1, L"CTADE", L"CUESTA DE"},
	{1, L"CTA", L"CUESTA"},
	{1, L"CSTE", L"COSTA DOS"},
	{1, L"CSTD", L"COSTA DO"},
	{1, L"CSTADO", L"COSTA DO"},
	{1, L"CSTADEL", L"CUESTA DEL"},
	{1, L"CSTADE", L"CUESTA DE"},
	{1, L"CSTADA", L"COSTA DA"},
	{1, L"CSTA", L"COSTA"},
	{1, L"CSTA", L"COSTA DA"},
	{1, L"CRRLODE", L"CORRALILLO DE"},
	{1, L"CRRLO", L"CORRALILLO"},
	{1, L"CRRDADEL", L"CERRADA DEL"},
	{1, L"CRRDADE", L"CERRADA DE"},
	{1, L"CRRDA", L"CERRADA"},
	{1, L"CRRALDEL", L"CORRAL DEL"},
	{1, L"CRRALDE", L"CORRAL DE"},
	{1, L"CRRAL", L"CORRAL"},
	{1, L"CRODE", L"CARREIRO DE"},
	{1, L"Cro", L"Carreró"},
	{1, L"CRLO", L"CARRETERA DE LOS"},
	{1, L"CRCO", L"CIRCUITO"},
	{1, L"CRAS", L"CARRETERA DE LAS"},
	{1, L"CPODEL", L"CAMPO DEL"},
	{1, L"CPODE", L"CAMPO DE"},
	{1, L"CPO", L"CAMPO"},
	{1, L"CPADEL", L"CAMPA DEL"},
	{1, L"CPADE", L"CAMPA DE"},
	{1, L"CPA", L"CAMPA"},
	{1, L"Costa", L"Costa de"},
	{1, L"Constr", L"Constructor"},
	{1, L"COLDEL", L"COLONIA DEL"},
	{1, L"COLDE", L"COLONIA DE"},
	{1, L"COL", L"COLONIA"},
	{1, L"CO", L"CAMINO"},
	{1, L"Cno", L"Camino"},
	{1, L"CNLLADOS", L"CANELLA DOS"},
	{1, L"CNLLADO", L"CANELLA DO"},
	{1, L"CNLLADE", L"CANELLA DE"},
	{1, L"CNLLADAS", L"CANELLA DAS"},
	{1, L"CNLLADA", L"CANELLA DA"},
	{1, L"CNLLA", L"CANELLA"},
	{1, L"CNLE", L"CANELLA DOS"},
	{1, L"CNLD", L"CANELLA DO"},
	{1, L"CNLC", L"CANELLA DE"},
	{1, L"CNLB", L"CANELLA DAS"},
	{1, L"CNLA", L"CANELLA DA"},
	{1, L"CNL", L"CANELLA"},
	{1, L"Cnigo", L"Canónigo"},
	{1, L"CMÑODOS", L"CAMIÑO DOS"},
	{1, L"CMÑODO", L"CAMIÑO DO"},
	{1, L"CMÑODEL", L"CAMIÑO DEL"},
	{1, L"CMÑODE", L"CAMIÑO DE"},
	{1, L"CMÑODAS", L"CAMIÑO DAS"},
	{1, L"CMÑODA", L"CAMIÑO DA"},
	{1, L"CMÑO", L"CAMIÑO"},
	{1, L"CMNS", L"CAMINO DE LAS"},
	{1, L"CMNODEL", L"CAMINO DEL"},
	{1, L"CMNODE", L"CAMINO DE"},
	{1, L"CMNOAL", L"CAMINO AL"},
	{1, L"CMNOA", L"CAMINO A"},
	{1, L"CMNO", L"CAMINO DE LOS"},
	{1, L"CMNL", L"CAMINO DEL"},
	{1, L"CMNA", L"CAMINO DE LA"},
	{1, L"CMJE", L"CAMIÑO DOS"},
	{1, L"CMJD", L"CAMIÑO DO"},
	{1, L"CMJC", L"CAMIÑO DE"},
	{1, L"CMJB", L"CAMIÑO DAS"},
	{1, L"CMJA", L"CAMIÑO DA"},
	{1, L"CMJ", L"CAMIÑO"},
	{1, L"CMDD", L"CAMPO DO"},
	{1, L"CMDB", L"CAMPO DAS"},
	{1, L"CMDA", L"CAMPO DA"},
	{1, L"Cm", L"Camí"},
	{1, L"CLONDOS", L"CALEXÓN DOS"},
	{1, L"CLONDO", L"CALEXÓN DO"},
	{1, L"CLONDE", L"CALEXÓN DE"},
	{1, L"CLONDA", L"CALEXÓN DA"},
	{1, L"CLON", L"CALEXÓN"},
	{1, L"CLLÓNDEL", L"CALLEJÓN DEL"},
	{1, L"CLLÓNDE", L"CALLEJÓN DE"},
	{1, L"CLLÓN", L"CALLEJÓN"},
	{1, L"CLLON", L"CALLEJON"},
	{1, L"CLLJADEL", L"CALLEJA DEL"},
	{1, L"CLLJADE", L"CALLEJA DE"},
	{1, L"CLLJA", L"CALLEJA"},
	{1, L"CJON", L"CALLEJON"},
	{1, L"CJLADEL", L"CALLEJUELA DEL"},
	{1, L"CJLADE", L"CALLEJUELA DE"},
	{1, L"CJLA", L"CALLEJUELA"},
	{1, L"CDELDE", L"CORDEL DE"},
	{1, L"CDEL", L"CORDEL"},
	{1, L"CDE", L"CALLE DE"},
	{1, L"CAYS", L"CALLE DE LAS"},
	{1, L"CAYO", L"CALLE DE LOS"},
	{1, L"CAYA", L"CALLE DE LA"},
	{1, L"CAXO", L"CALEXÓN DO"},
	{1, L"CAXE", L"CALEXÓN DOS"},
	{1, L"CAXD", L"CALLE DE"},
	{1, L"CAXC", L"CALEXÓN DE"},
	{1, L"CAXA", L"CALEXÓN DA"},
	{1, L"Cap", L"Capitán"},
	{1, L"CAMPDO", L"CAMPO DO"},
	{1, L"CAMPDE", L"CAMPO DE"},
	{1, L"CAMPDAS", L"CAMPO DAS"},
	{1, L"CAMPDA", L"CAMPO DA"},
	{1, L"CAMP", L"CAMPO"},
	{1, L"CAMD", L"CAMINO DE"},
	{1, L"CALX", L"CALEXÓN"},
	{1, L"CALD", L"CALLE DEL"},
	{1, L"Ca", L"CARRETERA"},
	{1, L"C", L"CARRER"},
	{1, L"BXDA", L"BAIXADA"},
	{1, L"BVDE", L"BULEVAR DE"},
	{1, L"BV", L"BULEVAR"},
	{1, L"BULEVDEL", L"BULEVAR DEL"},
	{1, L"BULEVDE", L"BULEVAR DE"},
	{1, L"BULEV", L"BULEVAR"},
	{1, L"BOULEVDEL", L"BOULEVARD DEL"},
	{1, L"BOULEVDE", L"BOULEVARD DE"},
	{1, L"BOULEV", L"BOULEVARD"},
	{1, L"BODOS", L"BARRIO DOS"},
	{1, L"BODO", L"BARRIO DO"},
	{1, L"BODEL", L"BARRIO DEL"},
	{1, L"BODE", L"BARRIO DE"},
	{1, L"BODAS", L"BARRIO DAS"},
	{1, L"BODA", L"BARRIO DA"},
	{1, L"BO", L"BARRIO"},
	{1, L"BLDE", L"BOULEVARD DE"},
	{1, L"BLDA", L"BOULEVARD DE LA"},
	{1, L"BL", L"BOULEVARD"},
	{1, L"BJRADEL", L"BAJERA DEL"},
	{1, L"BJRADE", L"BAJERA DE"},
	{1, L"BJRA", L"BAJERA"},
	{1, L"BJADADEL", L"BAJADA DEL"},
	{1, L"BJADADE", L"BAJADE DE"},
	{1, L"BJADA", L"BAJADA DE"},
	{1, L"BIR", L"BIRIBILGUNA"},
	{1, L"BIDA", L"BIDARIAK"},
	{1, L"BID", L"BIDEA"},
	{1, L"BELNA", L"BELENA"},
	{1, L"BDDEL", L"BOULEVARD DEL"},
	{1, L"BDDE", L"BOULEVARD DE"},
	{1, L"BDADEL", L"BAJADA DEL"},
	{1, L"BDADE", L"BAJADA DE"},
	{1, L"BDA", L"BAJADA DE"},
	{1, L"BD", L"BOULEVARD"},
	{1, L"BARDADEL", L"BARRIADA DEL"},
	{1, L"BARDADE", L"BARRIADA DE"},
	{1, L"BARDA", L"BARRIADA"},
	{1, L"AVNS", L"AVENIDA DE LAS"},
	{1, L"AVNO", L"AVENIDA DE LOS"},
	{1, L"AVNDADEL", L"AVENIDA DEL"},
	{1, L"AVNDADE", L"AVENIDA DE"},
	{1, L"AVNDA", L"AVENIDA DE"},
	{1, L"AVNA", L"AVENIDA DE LA"},
	{1, L"AVGDA", L"AVINGUDA"},
	{1, L"AVDOS", L"AVENIDA DOS"},
	{1, L"AVDO", L"AVENIDA DO"},
	{1, L"AVDEL", L"AVENIDA DEL"},
	{1, L"AVDAS", L"AVENIDA DAS"},
	{1, L"AVDADOS", L"AVENIDA DOS"},
	{1, L"AVDADO", L"AVENIDA DO"},
	{1, L"AVDADEL", L"AVENIDA DEL"},
	{1, L"AVDADE", L"AVENIDA DE"},
	{1, L"AVDADAS", L"AVENIDA DAS"},
	{1, L"AVDADA", L"AVENIDA DA"},
	{1, L"AVDA", L"AVENIDA DE"},
	{1, L"AV", L"AVINGUDA"},
	{1, L"AUZUN", L"AUZUNEA"},
	{1, L"AUZO", L"AUZOA"},
	{1, L"AUZ", L"AUZOA"},
	{1, L"AUTOVDEL", L"AUTOVÍA DEL"},
	{1, L"AUTOVDE", L"AUTOVÍA DE"},
	{1, L"AUTOV", L"AUTOVÍA"},
	{1, L"AUTOPDEL", L"AUTOPISTA DEL"},
	{1, L"AUTOPDE", L"AUTOPISTA DE"},
	{1, L"AUTOP", L"AUTOPISTA"},
	{1, L"AUTODO", L"AUTOESTRADA DO"},
	{1, L"AUTOB", L"AUTOBIDEA"},
	{1, L"AUTD", L"AUTOBIDEA"},
	{1, L"AUTB", L"AUTOBIA"},
	{1, L"AUAO", L"AUTOESTRADA DO"},
	{1, L"Arq", L"Arquitecta"},
	{1, L"ANDADDEL", L"ANDADOR DEL"},
	{1, L"ANDADDE", L"ANDADOR DE"},
	{1, L"ANDAD", L"ANDADOR"},
	{1, L"ALM", L"ALAMEDA"},
	{1, L"ALDP", L"ALDAPA"},
	{1, L"ALDAP", L"ALDAPA"},
	{1, L"ALD", L"ALDAPA"},
	{1, L"ALAMDEL", L"ALAMEDA DEL"},
	{1, L"ALAMDE", L"ALAMEDA DE"},
	{1, L"ALAM", L"ALAMEDA"},
	{1, L"AIDE", L"AVENIDA DOS"},
	{1, L"AIDD", L"AVENIDA DO"},
	{1, L"AIDB", L"AVENIDA DAS"},
	{1, L"AIDA", L"AVENIDA DA"},
	{1, L"ACYU", L"CAMINO AL"},
	{1, L"ACYT", L"BOULEVARD DE LOS"},
	{1, L"ACYS", L"BOULEVARD DE LAS"},
	{1, L"ACYR", L"BOULEVARD DEL"},
	{1, L"ACYQ", L"ANDADOR DE LOS"},
	{1, L"ACYP", L"ANDADOR DE LAS"},
	{1, L"ACYO", L"ANDADOR DEL"},
	{1, L"ACYN", L"ANDADOR DE LA"},
	{1, L"ACYM", L"ANDADOR DE"},
	{1, L"ACYL", L"ANDADOR"},
	{1, L"ACYK", L"PRIVADA DE LOS"},
	{1, L"ACYJ", L"PRIVADA DE LAS"},
	{1, L"ACYI", L"PRIVADA DEL"},
	{1, L"ACYH", L"PRIVADA DE LA"},
	{1, L"ACYG", L"PRIVADA DE"},
	{1, L"ACYF", L"PRIVADA"},
	{1, L"ACYE", L"CALZADA DE LOS"},
	{1, L"ACYD", L"CALZADA DE LAS"},
	{1, L"ACYC", L"CALZADA DEL"},
	{1, L"ACYB", L"CALZADA DE LA"},
	{1, L"ACYA", L"CALZADA DE"},
	{1, L"ACXZ", L"CALZADA"},
	{1, L"ACXY", L"RETORNO DE LOS"},
	{1, L"ACXX", L"RETORNO DE LAS"},
	{1, L"ACXW", L"RETORNO DEL"},
	{1, L"ACXV", L"RETORNO DE LA"},
	{1, L"ACXU", L"RETORNO DE"},
	{1, L"ACXT", L"RETORNO"},
	{1, L"ACXS", L"CAMINO A"},
	{1, L"ACUR", L"CERRADA"},
	{1, L"ACUQ", L"CERRADA DE"},
	{1, L"ACUP", L"CERRADA DE LA"},
	{1, L"ACUO", L"CERRADA DE LOS"},
	{1, L"ACUN", L"CERRADA DEL"},
	{1, L"ACUM", L"CERRADA DE LAS"},
	{1, L"ACUL", L"PROLONGACIÓN"},
	{1, L"ACUK", L"PROLONGACIÓN DE"},
	{1, L"ACUJ", L"PROLONGACIÓN DEL"},
	{1, L"ACUI", L"PROLONGACIÓN DE LA"},
	{1, L"ACUH", L"PROLONGACIÓN DE LAS"},
	{1, L"ACUG", L"PROLONGACIÓN DE LOS"},
	{1, L"ACTODEL", L"ACUEDUCTO DEL"},
	{1, L"ACTODE", L"ACUEDUCTO DE"},
	{1, L"ACTO", L"ACUEDUCTO"},
	{1, L"ACTL", L"ACUEDUCTO DEL"},
	{1, L"ACTA", L"ACUEDUCTO DE LA"},
	{1, L"ACRM", L"RINCÓN LAS"},
	{1, L"ACRL", L"RINCÓN LA"},
	{1, L"ACRJ", L"RINCÓN DEL"},
	{1, L"ACRI", L"RINCÓN DE LOS"},
	{1, L"ACRH", L"RINCÓN DE LAS"},
	{1, L"ACRG", L"RINCÓN DE LA"},
	{1, L"ACRF", L"RINCÓN DE"},
	{1, L"ACRE", L"RINCÓN"},
	{1, L"ACQW", L"BELENA DE LA"},
	{1, L"ACQU", L"BELENA"},
	{1, L"ACQS", L"CAMIÑO DEL"},
	{1, L"ACQR", L"ZOKOA"},
	{1, L"ACQP", L"KALENKA"},
	{1, L"ACQO", L"KALEAREN LUZAPENA"},
	{1, L"ACQM", L"BELENA"},
	{1, L"ACDEL", L"ACUEDUCTO DEL"},
	{1, L"AC", L"ACUEDUCTO"},
	{1, L"ABSR", L"BIRIBILGUNA"},
	{1, L"ABSQ", L"AUZOA"},
	{1, L"ABSP", L"ENPARANTZA"},
	{1, L"ABRW", L"BARRIO DO"},
	{1, L"ABRV", L"BARRIO DOS"},
	{1, L"ABRU", L"BARRIO DAS"},
	{1, L"ABRT", L"BARRIO DA"},
	{1, L"ABRS", L"TÚNEL DE LOS"},
	{1, L"ABRQ", L"SUBIDA DEL"},
	{1, L"ABRP", L"SUBIDA DE LOS"},
	{1, L"ABRO", L"SUBIDA DE LAS"},
	{1, L"ABRN", L"SUBIDA DE LA"},
	{1, L"ABRM", L"SUBIDA DE"},
	{1, L"ABRL", L"SUBIDA"},
	{1, L"ABRK", L"SENDA DEL"},
	{1, L"ABRJ", L"SENDA DE LOS"},
	{1, L"ABRI", L"SENDA DE LAS"},
	{1, L"ABRH", L"SENDA DE LA"},
	{1, L"ABRG", L"SENDA DE"},
	{1, L"ABRF", L"SENDA"},
	{1, L"ABRE", L"ROTONDA DE LOS"},
	{1, L"ABRD", L"ROTONDA DE LAS"},
	{1, L"ABRC", L"PLAZUELA DEL"},
	{1, L"ABRB", L"PLAZUELA DE LOS"},
	{1, L"ABRA", L"PLAZUELA DE LAS"},
	{1, L"ABQZ", L"PLAZUELA DE LA"},
	{1, L"ABQY", L"PLAZUELA DE"},
	{1, L"ABQX", L"PLAZUELA"},
	{1, L"ABQR", L"PLACITA"},
	{1, L"ABQQ", L"PATIO DEL"},
	{1, L"ABQP", L"PATIO DE LOS"},
	{1, L"ABQO", L"PATIO DE LAS"},
	{1, L"ABQN", L"PATIO DE LA"},
	{1, L"ABQM", L"PATIO"},
	{1, L"ABQF", L"PASARELA DEL"},
	{1, L"ABQA", L"PASARELA"},
	{1, L"ABPW", L"CORRALILLO DE LA"},
	{1, L"ABPV", L"CORRALILLO DE"},
	{1, L"ABPU", L"CORRALILLO"},
	{1, L"ABPT", L"CORRAL DEL"},
	{1, L"ABPS", L"CORRAL DE LOS"},
	{1, L"ABPR", L"CORRAL DE LAS"},
	{1, L"ABPQ", L"CORRAL DE LA"},
	{1, L"ABPP", L"CORRAL DE"},
	{1, L"ABPO", L"CORRAL"},
	{1, L"ABPM", L"CORDEL DE LOS"},
	{1, L"ABPL", L"CORDEL DE LAS"},
	{1, L"ABPK", L"CORDEL DE LA"},
	{1, L"ABPJ", L"CORDEL DE"},
	{1, L"ABPI", L"CORDEL"},
	{1, L"ABPH", L"COLONIA DEL"},
	{1, L"ABPG", L"COLONIA DE LOS"},
	{1, L"ABPF", L"COLONIA DE LAS"},
	{1, L"ABPE", L"COLONIA DE LA"},
	{1, L"ABPD", L"COLONIA DE"},
	{1, L"ABPC", L"COLONIA"},
	{1, L"ABPB", L"CAÑADA DEL"},
	{1, L"ABPA", L"CAÑADA DE LOS"},
	{1, L"ABOZ", L"CAÑADA DE LAS"},
	{1, L"ABOY", L"CAÑADA DE LA"},
	{1, L"ABOX", L"CAÑADA DE"},
	{1, L"ABOW", L"CAÑADA"},
	{1, L"ABOV", L"CALLEJUELA DEL"},
	{1, L"ABOU", L"CALLEJUELA DE LOS"},
	{1, L"ABOS", L"CALLEJUELA DE LA"},
	{1, L"ABOR", L"CALLEJUELA DE"},
	{1, L"ABOQ", L"CALLEJUELA"},
	{1, L"ABOP", L"BULEVAR DEL"},
	{1, L"ABOO", L"BULEVAR DE LOS"},
	{1, L"ABON", L"BULEVAR DE LAS"},
	{1, L"ABOL", L"BULEVAR DE"},
	{1, L"ABOK", L"BULEVAR"},
	{1, L"ABOJ", L"BAJERA DEL"},
	{1, L"ABOI", L"BAJERA DE LOS"},
	{1, L"ABOH", L"BAJERA DE LAS"},
	{1, L"ABOG", L"BAJERA DE LA"},
	{1, L"ABOF", L"BAJERA DE"},
	{1, L"ABOE", L"BAJERA"},
	{1, L"ABOD", L"BAJADA DEL"},
	{1, L"ABOC", L"BAJADA DE LOS"},
	{1, L"ABOB", L"BAJADA DE LAS"},
	{1, L"ABOA", L"BAJADA DE LA"},
	{1, L"ABNZ", L"BAJADA DE"},
	{1, L"ABNX", L"AUTOVÍA DEL"},
	{1, L"ABNW", L"AUTOVÍA DE LOS"},
	{1, L"ABNV", L"AUTOVÍA DE LAS"},
	{1, L"ABNU", L"AUTOVÍA DE LA"},
	{1, L"ABNT", L"AUTOVÍA DE"},
	{1, L"ABNS", L"AUTOVÍA"},
	{1, L"ABNR", L"CALLEJA DEL"},
	{1, L"ABNQ", L"CALLEJA DE LOS"},
	{1, L"ABNP", L"CALLEJA DE LAS"},
	{1, L"ABNO", L"CALLEJA DE LA"},
	{1, L"ABNN", L"CALLEJA DE"},
	{1, L"ABNM", L"CALLEJA"},
	{1, L"AAYB", L"CARREIRO DE"},
	{1, L"AAGM", L"SARRERA"},
	{1, L"AAGL", L"SARBIDEA"},
	{1, L"AAGK", L"MENDATEA"},
	{1, L"AAGJ", L"LORATEGIA"},
	{1, L"AAGI", L"LANDA"},
	{1, L"AAGH", L"KANTOIA"},
	{1, L"AAGG", L"KALEITXIA"},
	{1, L"AAGF", L"KALE PARTIKULARRA"},
	{1, L"AAGE", L"ETXALDEA"},
	{1, L"AAGD", L"ESTARDA"},
	{1, L"AAGC", L"ERRIBERA"},
	{1, L"AAGB", L"BIDARIAK"},
	{1, L"AAFZ", L"AUZUNEA"},
	{1, L"AAFY", L"VIADUCTO DEL"},
	{1, L"AAFW", L"VIADUCTO DE LAS"},
	{1, L"AAFV", L"VIADUCTO DE LA"},
	{1, L"AAFU", L"VIADUCTO DE"},
	{1, L"AAFT", L"VIADUCTO"},
	{1, L"AAFS", L"VEREDA DEL"},
	{1, L"AAFR", L"VEREDA DE LOS"},
	{1, L"AAFQ", L"VEREDA DE LAS"},
	{1, L"AAFP", L"VEREDA DE LA"},
	{1, L"AAFO", L"VEREDA DE"},
	{1, L"AAFN", L"VEREDA"},
	{1, L"AAFM", L"URBANIZACIÓN DEL"},
	{1, L"AAFL", L"URBANIZACIÓN DE LOS"},
	{1, L"AAFK", L"URBANIZACIÓN DE LAS"},
	{1, L"AAFJ", L"URBANIZACIÓN DE LA"},
	{1, L"AAFG", L"TRAVESÍA DEL"},
	{1, L"AAFF", L"TRAVESÍA DE LOS"},
	{1, L"AAFE", L"TRAVESÍA DE LAS"},
	{1, L"AAFD", L"TRAVESÍA DE LA"},
	{1, L"AAFC", L"PUENTE DEL"},
	{1, L"AAFB", L"PUENTE DE LOS"},
	{1, L"AAFA", L"PUENTE DE LAS"},
	{1, L"AAEZ", L"PUENTE DE LA"},
	{1, L"AAEY", L"PUENTE DE"},
	{1, L"AAEX", L"PUENTE"},
	{1, L"AAEW", L"PASADIZO DEL"},
	{1, L"AAET", L"PASADIZO DE LA"},
	{1, L"AAES", L"PASADIZO DE"},
	{1, L"AAER", L"PASADIZO"},
	{1, L"AAEP", L"PLAZOLETA DE LOS"},
	{1, L"AAEO", L"PLAZOLETA DE LAS"},
	{1, L"AAEN", L"PLAZOLETA DE LA"},
	{1, L"AAEM", L"PLAZOLETA DE"},
	{1, L"AAEL", L"PLAZOLETA DEL"},
	{1, L"AAEK", L"PLACETA DE LOS"},
	{1, L"AAEJ", L"PLACETA DE LAS"},
	{1, L"AAEF", L"NUDO DE LA"},
	{1, L"AAEE", L"NUDO DE"},
	{1, L"AAED", L"NUDO"},
	{1, L"AAEC", L"JARDINES DEL"},
	{1, L"AAEB", L"JARDINES DE LOS"},
	{1, L"AAEA", L"JARDINES DE LAS"},
	{1, L"AADZ", L"JARDINES DE LA"},
	{1, L"AADY", L"JARDINES DE"},
	{1, L"AADX", L"JARDINES"},
	{1, L"AADW", L"GRUPO DEL"},
	{1, L"AADV", L"GRUPO DE LOS"},
	{1, L"AADU", L"GRUPO DE LAS"},
	{1, L"AADT", L"GRUPO DE LA"},
	{1, L"AADH", L"DISTRIBUIDOR"},
	{1, L"AADG", L"CAMPO DEL"},
	{1, L"AADF", L"CAMPO DE LAS"},
	{1, L"AADE", L"CAMPO DE LA"},
	{1, L"AADD", L"CAMPO DE"},
	{1, L"AADC", L"CAMPA DEL"},
	{1, L"AACZ", L"CAMPA DE LA"},
	{1, L"AACY", L"CAMPA DE"},
	{1, L"AACX", L"CAMPA"},
	{1, L"AACW", L"CALLEJÓN DEL"},
	{1, L"AACV", L"CALLEJÓN DE LOS"},
	{1, L"AACU", L"CALLEJÓN DE LAS"},
	{1, L"AACT", L"CALLEJÓN DE LA"},
	{1, L"AACS", L"CALLEJÓN DE"},
	{1, L"AACR", L"CALLEJÓN"},
	{1, L"AACQ", L"CALLE PARTICULAR DEL"},
	{1, L"AACO", L"CALLE PARTICULAR DE LAS"},
	{1, L"AACN", L"CALLE PARTICULAR DE LA"},
	{1, L"AACM", L"CALLE PARTICULAR DE"},
	{1, L"AACL", L"CALLE PARTICULAR"},
	{1, L"AACK", L"BARRIO DEL"},
	{1, L"AACJ", L"BARRIO DE LOS"},
	{1, L"AACI", L"BARRIO DE LAS"},
	{1, L"AACH", L"BARRIO DE LA"},
	{1, L"AACE", L"BARRIADA DEL"},
	{1, L"AACD", L"BARRIADA DE LOS"},
	{1, L"AACC", L"BARRIADA DE LAS"},
	{1, L"AACB", L"BARRIADA DE LA"},
	{1, L"AACA", L"BARRIADA DE"},
	{1, L"AABZ", L"BARRIADA"},
	{1, L"AABY", L"ALAMEDA DEL"},
	{1, L"AABX", L"ALAMEDA DE LOS"},
	{1, L"AABW", L"ALAMEDA DE LAS"},
	{1, L"AABV", L"ALAMEDA DE LA"},
	{1, L"AABU", L"ALAMEDA DE"},
	{1, L"AAAY", L"PATIO DE"},
})

