﻿module("VOICE")

----------------------------------------------------------------------------------------------------
---------------------------|  V O I C E   T R A N S F O R M   U T I L S  |--------------------------
----------------------------------------------------------------------------------------------------

-----------------------------------------------
-- ASSERT a konyvtari transform fuggvenyekre --
-----------------------------------------------

assert(type(transform_and_format) == "function")
assert(type(transform_pattern_match) == "function")
assert(type(transform_chain) == "function")
assert(type(transform_format_roadnumber_eu) == "function")

local preposition_tbl = {L"через",L"в направление на"}

local preposition_insert_tbl = {
	{L"в ",{L"переулок",L"проезд",L"тупик"}},
	{L"на ",{L""}},
}

local traffic_preposition_insert_tbl = {
	-- in dem,der / von dem, der
	{L" dem ",{	L"platz$",L"ring$",L"damm$",L"berg$",L"kanal$", L"^platz de[rs] ", 
			L"dreieck$",L"kreuz$", L"horst$",L"kamp$",L"winkel$",L"pfad$",
			L"weg$",L"steg$",L"stieg$",L"hof$", L"tunnel$",L"tunel$", L"tor$"}},

	{L" der ",{	L"allee$",L"treppe$",L"^%a?%d+%a?$", L"gasse$",L"strase$",L"strasse$",
			L"sträse$",L"straße$",L"sträße$", L"^stra[ßs]+e de[rs] ", L"brucke$",L"brücke$"}},

	{L" von ",{L""}},
}

local settlement_preposition = L"в направление на"

local replace_roadnumber = {
	{L"1[PР]92",L"Дорогу Калуга Орел"},
	{L"1[PР]119",L"трассу Орел Тамбов"},
	{L"1[PР]132",L"Дорогу Калуга Рязань"},
	{L"1[PР]158",L"Дорогу Нижний Новгород Саранск"},
	{L"1[PР]158",L"Дорогу Пенза Саратов"},
	{L"1[PР]175",L"Дорогу Йошкар-Ола Зеленодольск"},
	{L"1[PР]178",L"Дорогу Саранск Ульяновск"},
	{L"1[PР]193",L"Дорогу Воронеж Тамбов"},
	{L"1[PР]208",L"Дорогу Тамбов Пенза"},
	{L"1[PР]209",L"Дорогу Тамбов Пенза"},
	{L"1[PР]228",L"Дорогу Сызрань Волгоград"},
	{L"1[PР]241",L"Дорогу Казань Ульяновск"},
	{L"1[PР]242",L"Дорогу Пермь Екатеринбург"},
	{L"1[PР]253",L"Дорогу Майкоп Кореновск"},
	{L"1[PР]335",L"Дорогу Оренбург Илек"},
	{L"1[PР]344",L"Дорогу Нытва Кудымкар"},
	{L"1[PР]351",L"Дорогу Екатеринбург Тюмень"},
	{L"1[PР]354",L"Дорогу Екатеринбург Курган"},
	{L"1[PР]402",L"Дорогу Тюмень Омск"},
	{L"1[PР]418",L"Дорогу Иркутск Усть-Ордынский"},
	{L"1[PР]488",L"Дорогу Южно-Сахалинск Корсаков"},
	{L"[AА]100",L"Дорогу Москва Бородино"},
	{L"[AА]101",L"Дорогу Москва Рославль"},
	{L"[AА]102",L"Рязанское шоссе"},
	{L"[AА]103",L"Щёлковское шоссе"},
	{L"[AА]104",L"Дмитровское шоссе"},
	{L"[AА]105",L"Успенское шоссе"},
	{L"[AА]106",L"Ильинское шоссе"},
	{L"[AА]107",L"Московское малое кольцо"},
	{L"[AА]108",L"Московское большое кольцо"},
	{L"[AА]111",L"Дорогу Торжок Осташков"},
	{L"[AА]112",L"Дорогу Тверь Ржев"},
	{L"[AА]113",L"Дорогу Кострома Иваново"},
	{L"[AА]114",L"Дорогу Вологда Новая Ладога"},
	{L"[AА]116",L"Дорогу Порхов Остров"},
	{L"[AА]117",L"Дорогу Опочка граница с Белоруссией"},
	{L"[AА]121",L"Дорогу Санкт-Петербург Ропша"},
	{L"[AА]122",L"Дорогу Санкт-Петербург Огоньки"},
	{L"[AА]123",L"Дорогу Зеленогорск Выборг"},
	{L"[AА]124",L"Дорогу Выборг Приозерск"},
	{L"[AА]125",L"Дорогу Молодежное Череасово"},
	{L"[AА]126",L"Дорогу Дубки граница с Финляндией"},
	{L"[AА]127",L"Дорогу Зверево граница с Финляндией"},
	{L"[AА]128",L"Дорогу Санкт-Петербург Морье"},
	{L"[AА]129",L"Дорогу Зеленогорск Выборг"},
	{L"[AА]130",L"Дорогу Олонец Сортавала"},
	{L"[AА]131",L"Дорогу Суоярви Койриноя"},
	{L"[AА]132",L"Дорогу Суоярви Юстозеро"},
	{L"[AА]133",L"Дорогу Петрозаводск Суоярви"},
	{L"[AА]134",L"Дорогу Кочкома Реболы"},
	{L"[AА]135",L"Дорогу Кемь Лонка"},
	{L"[AА]136",L"Дорогу Лоухи Суоперя"},
	{L"[AА]137",L"Дорогу Тунгозеро Калевала"},
	{L"[AА]138",L"Дорогу Кола Печенга"},
	{L"[AА]141",L"Дорогу Орел Смоленск"},
	{L"[AА]142",L"Дорогу Тросна Калиновка"},
	{L"[AА]144",L"Дорогу Курск Борисоглебск"},
	{L"[AА]146",L"Дорогу Краснодар Новоросийск"},
	{L"[AА]147",L"Дорогу Краснодар Джубга"},
	{L"[AА]148",L"Дорогу Адлер Красная Поляна"},
	{L"[AА]151",L"Дорогу Цивильск Ульяновск"},
	{L"[AА]153",L"Дорогу Волгоград Мариновка"},
	{L"[AА]154",L"Дорогу Астрахань Ставрополь"},
	{L"[AА]155",L"Дорогу Черкесск Домбай"},
	{L"[AА]156",L"Дорогу Лермонтов Черкесск"},
	{L"[AА]157",L"Дорогу Минеральные Воды Кисловодск"},
	{L"[AА]158",L"Дорогу Прохладный Баксан Эльбрус"},
	{L"[AА]166",L"Дорогу Чита Забайкальск"},
	{L"[AА]190",L"Дорогу Калининград Полесск"},
	{L"[AА]191",L"Дорогу Калининград Зеленоградск"},
	{L"[AА]192",L"Дорогу Зеленоградск Приморск"},
	{L"[AА]193",L"Дорогу Калининград Балтийск"},
	{L"[AА]194",L"Дорогу Калининград Мамоново"},
	{L"[AА]195",L"Дорогу Калининград Долгоруково"},
	{L"[AА]196",L"Дорогу Калининград Крылово"},
	{L"[AА]197",L"Дорогу Черняховск Крылово"},
	{L"[AА]198",L"Дорогу Советск - Гусев"},
	{L"[AА]212",L"Дорогу Псков Изборск"},
	{L"[AА]216",L"Дорогу Гвардейск Неман"},
	{L"[AА]229",L"Дорогу Калининград Нестеров"},
	{L"[AА]340",L"Дорогу Астрахань - Красный Яр"},
	{L"[AА]349",L"Дорогу Барнаул Рубцовск"},
	{L"[EЕ]30",L"Минское шоссе"},
	{L"[EЕ]101",L"шоссе Е 101"},
	{L"[EЕ]105",L"шоссе Е 105"},
	{L"[EЕ]115",L"трассу Е 115"},
	{L"[MМ]10",L"трассу Москва Санкт Петербург"},
	{L"[MМ]11",L"трассу Санкт Петербург Таллин"},
	{L"[MМ]12",L"трассу Минск Вильнюс Рига Таллинн"},
	{L"[MМ]13",L"трассу Брянск Новозыбков"},
	{L"[MМ]14",L"трассу Брест Кишинев Одесса"},
	{L"[MМ]17",L"трассу Киев Чоп Будапешт"},
	{L"[MМ]18",L"трассу Санкт Петербург Мурманск"},
	{L"[MМ]19",L"трассу Новошахтинск Майский"},
	{L"[MМ]20",L"трассу Санкт Петербург Минск"},
	{L"[MМ]21",L"трассу Волгоград Каменск Шахтинский"},
	{L"[MМ]23",L"трассу Ростов на Дону Таганрог"},
	{L"[MМ]25",L"трассу Новороссийск Керченский пролив"},
	{L"[MМ]27",L"трассу Джубга Новороссийск"},
	{L"[MМ]29",L"трассу Краснодар Баку"},
	{L"[MМ]32",L"трассу Самара Большая Черниговка"},
	{L"[MМ]36",L"трассу Челябинск Троицк"},
	{L"[MМ]38",L"трассу Омск Черлак"},
	{L"[MМ]51",L"трассу Челябинск Чита"},
	{L"[MМ]52",L"трассу Новосибирск Бийск"},
	{L"[MМ]53",L"трассу Челябинск Чита"},
	{L"[MМ]54",L"трассу Красноярск Кызыл"},
	{L"[MМ]55",L"трассу Челябинск Чита"},
	{L"[MМ]56",L"трассу Невр Якутск"},
	{L"[MМ]60",L"трассу Хабаровск Владивосток"},
	{L"[MМ]1",L"трассу Москва Минск"},
	{L"[MМ]2",L"трассу Москва Симферополь"},
	{L"[MМ]3",L"трассу Москва Киев"},
	{L"[MМ]4",L"трассу Москва Новороссийск"},
	{L"[MМ]5",L"трассу Москва Екатеринбург"},
	{L"[MМ]6",L"трассу Москва Астрахань"},
	{L"[MМ]7",L"трассу Москва Уфа"},
	{L"[MМ]8",L"трассу Москва Архангельск"},
	{L"[MМ]9",L"трассу Москва Рига"},
	{L"[PР]92",L"Дорогу Калуга Орел"},
	{L"[PР]111",L"Волоколамское шоссе"},
	{L"[PР]113",L"Рогачевское шоссе"},
	{L"[PР]119",L"Дорогу Орел Елец Липецк Тамбов"},
	{L"[PР]132",L"Дорогу Калуга Тула Рязань"},
	{L"[PР]158",L"Дорогу Нижний Новгород Саранск Саратов"},
	{L"[PР]175",L"Дорогу Йошкар-Ола Зеленодольск"},
	{L"[PР]178",L"Дорогу Саранск Ульяновск"},
	{L"[PР]193",L"Дорогу Воронеж Тамбов"},
	{L"[PР]208",L"Дорогу Тамбов Пенза"},
	{L"[PР]209",L"Дорогу Тамбов Пенза"},
	{L"[PР]228",L"Дорогу Сызрань Волгоград"},
	{L"[PР]241",L"Дорогу Казань Ульяновск"},
	{L"[PР]242",L"Дорогу Пермь Екатеринбург"},
	{L"[PР]253",L"Дорогу Майкоп Кореновск"},
	{L"[PР]254",L"Дорогу Туапсе Кавказский заповедник"},
	{L"[PР]291",L"Дорогу Урвань Уштулу"},
	{L"[PР]297",L"Дорогу Владикавказ Беслан"},
	{L"[PР]298",L"Дорогу Алагир Нижний Зарамаг"},
	{L"[PР]335",L"Дорогу Оренбург Илек"},
	{L"[PР]344",L"Дорогу Нытва Кудымкар"},
	{L"[PР]351",L"Дорогу Екатеринбург Тюмень"},
	{L"[PР]352",L"Серовский тракт"},
	{L"[PР]354",L"Дорогу Екатеринбург Курган"},
	{L"[PР]402",L"Дорогу Тюмень Омск"},
	{L"[PР]404",L"Дорогу Тюмень Ханты-Мансийск"},
	{L"[PР]418",L"Дорогу Иркутск Усть-Ордынский"},
}

local replace_mapinfo = {
	{L"Проезб",L"проезд"},
	{L"Пр[ -]Т",L"проспект"},
	{L"Ш",L"шоссе"},
	{L"УЛ",L"улица"},
	{L"ТУП",L"тупик"},
	{L"ПРОСП",L"проспект"},
	{L"ПР",L"проезд"},
	{L"ПЛ",L"площадь"},
	{L"ПЕР",L"переулок"},
	{L"НАБ",L"набережная"},
	{L"БУЛЬВ",L"бульвар"},
	{L"АЛ",L"аллея"},
	{L"км",L"километр"},
	{L"Дорога без имени",L" "},
	{L"Дор. без имени",L" "},
	{L"МКАД",L"Мкад"},
	{L"Кад",L"Кольцевая автодорога"},
	{L"ЕКАД",L"Кольцевая автодорога"},
	{L"БОЛ",L"большая"},
	{L"БОРОВСКОЕ",L"Боровское"},
	{L"БРАТЕЕВО",L"Братеево"},
	{L"Верхние Поля",L"Верхние Полала"},
	{L"ВЕШКИ",L"Вешки"},
	{L"ВЛКСМ",L"Комсомола"},
	{L"ВОЛОКОЛАМСК",L"Волоколамск"},
	{L"ВОСКРЕСЕНСК",L"Воскресенск"},
	{L"ДЖУБГА",L"Джубга"},
	{L"КРАСНОГОРСК",L"Красногорск"},
	{L"Нижние Поля",L"Нижние Полала"},
	{L"НОСОВИХИНСКОЕ",L"Носовихинское"},
	{L"ОЧАКОВО",L"Очаково"},
	{L"ПОДОЛЬСК",L"Подольск"},
	{L"ПУТИЛКОВСКОЕ",L"Путилковское"},
	{L"СКОЛКОВО",L"Сколково"},
	{L"СОЛНЦЕВО",L"Солнцево"},
	{L"СОЛНЕЧНОГОРСК",L"Солнечногорск"},
	{L"ТУЛЬСКАЯ",L"Тульская"},
	{L"ХИМКИ",L"Химки"},
	{L"ЩЕРБИНКА",L"Щербинка"},
	{L"Brateyevo",L"Братеево"},
	{L"Domodedowo",L"Домодедово"},
	{L"Dzhubga",L"Джубга"},
	{L"Khimki",L"Химки"},
	{L"Podol'sk",L"Подольск"},
	{L"Sheremetyevo",L"Шереметьево"},
	{L"Shcherbinka",L"Щербинка"},
	{L"Volokolamsk",L"Волоколамск"},
	{L"[sS][tT]%.",L"Sankt "},
--;**********************************************************************
	{L"(.*)3[- ][Ее](.*)",L"%1 третье %2"},
	{L"(.*)1[- ][гГ]о(.*)",L"%1 первого %2"},
	{L"(.*)2[- ][гГ]о(.*)",L"%1 второго %2"},
	{L"(.*)3[- ][гГ]о(.*)",L"%1 третьего %2"},
	{L"(.*)4[- ][гГ]о(.*)",L"%1 четвертого %2"},
	{L"(.*)5[- ][гГ]о(.*)",L"%1 пятого %2"},
	{L"(.*)6[- ][гГ]о(.*)",L"%1 шестого %2"},
	{L"(.*)7[- ][гГ]о(.*)",L"%1 седьмого %2"},
	{L"(.*)8[- ][гГ]о(.*)",L"%1 восьмого %2"},
	{L"(.*)9[- ][гГ]о(.*)",L"%1 девятого %2"},
	{L"(.*)22[- ][гГ]о(.*)",L"%1 двадцать второго %2"},
	{L"(.*)25[- ][оО]го(.*)",L"%1 двадцать пятого %2"},
	{L"(.*)1812[- ][гГ]о(.*)",L"%1 восемьсот двенадцатого %2"},
	{L"(.*)1905[- ][гГ]о(.*)",L"%1 девятьсот пятого %2"},
	{L"(.*)26[- ][тТ]и(.*)",L"%1 двадцати шести %2"},
	{L"(.*)10[- ][лЛ]етия(.*)",L"%1 десятилетия %2"},
	{L"(.*)50[- ][лЛ]етия(.*)",L"%1 пятидесятилетия %2"},
	{L"(.*)60[- ][лЛ]етия(.*)",L"%1 шестидесятилетия %2"},
	{L"(.*)800[- ][лЛ]етия(.*)",L"%1 восемьсотлетия %2"},
	{L"(.*)1[- ][ый][й ](.*)",L"%1 первый %2"},
	{L"(.*)2[- ][ойЙ][й ](.*)",L"%1 второй %2"},
	{L"(.*)3[- ][ий][й ](.*)",L"%1 третий %2"},
	{L"(.*)4[- ][ый][й ])(.*)",L"%1 четвертый %2"},
	{L"(.*)5[- ][ый][й ](.*)",L"%1 пятый %2"},
	{L"(.*)6[- ][ой][й ](.*)",L"%1 шестой %2"},
	{L"(.*)7[- ][ой][й ](.*)",L"%1 седьмой %2"},
	{L"(.*)8[- ][ой][й ](.*)",L"%1 восьмой %2"},
	{L"(.*)9[- ][ый][й ](.*)",L"%1 девятый %2"},
	{L"(.*)10[- ][ый][й ](.*)",L"%1 десятый %2"},
	{L"(.*)11[- ][ый][й ](.*)",L"%1 одиннадцатый %2"},
	{L"(.*)12[- ][ый][й ](.*)",L"%1 двенадцатый %2"},
	{L"(.*)13[- ][ый][й ](.*)",L"%1 тринадцатый %2"},
	{L"(.*)14[- ][ый][й ](.*)",L"%1 четырнадцатый %2"},
	{L"(.*)15[- ][ый][й ](.*)",L"%1 пятнадцатый %2"},
	{L"(.*)16[- ][ый][й ](.*)",L"%1 шестнадцатый %2"},
	{L"(.*)17[- ][ый][й ](.*)",L"%1 семнадцатый %2"},
	{L"(.*)18[- ][ый][й ](.*)",L"%1 восемнадцатый %2"},
	{L"(.*)19[- ][ый][й ](.*)",L"%1 девятнадцатый %2"},
	{L"(.*)1[- ][яЯ](.*)",L"%1 первая %2"},
	{L"(.*)2[- ][яЯ](.*)",L"%1 вторая %2"},
	{L"(.*)3[- ][яЯ](.*)",L"%1 третья %2"},
	{L"(.*)4[- ][яЯ](.*)",L"%1 четвертая %2"},
	{L"(.*)5[- ][яЯ](.*)",L"%1 пятая %2"},
	{L"(.*)6[- ][яЯ](.*)",L"%1 шестая %2"},
	{L"(.*)7[- ][яЯ](.*)",L"%1 седьмая %2"},
	{L"(.*)8[- ][яЯ](.*)",L"%1 восьмая %2"},
	{L"(.*)9[- ][яЯ](.*)",L"%1 девятая %2"},
	{L"(.*)10[- ][яЯ](.*)",L"%1 десятая %2"},
	{L"(.*)11[- ][яЯ](.*)",L"%1 одиннадцатая %2"},
	{L"(.*)12[- ][яЯ](.*)",L"%1 двенадцатая %2"},
	{L"(.*)13[- ][яЯ](.*)",L"%1 тринадцатая %2"},
	{L"(.*)14[- ][яЯ](.*)",L"%1 четырнадцатая %2"},
	{L"(.*)15[- ][яЯ](.*)",L"%1 пятнадцатая %2"},
	{L"(.*)16[- ][яЯ](.*)",L"%1 шестнадцатая %2"},
--;**********************************************************************
--;**********************************************************************
	{L"(.*)набережная(.*)",L"%1 %2 набережная"},
	{L"(.*)улица(.*)",L"%1 %2 улица"},
	{L"(.*)площадь(.*)",L"%1 %2 площадь"},
	{L"(.*)переулок(.*)",L"%1 %2 переулок"},
	{L"(.*)проезд(.*)",L"%1 %2 проезд"},
	{L"(.*)тупик(.*)",L"%1 %2 тупик"},
	{L"(.*)проспект(.*)",L"%1 %2 проспект"},
	{L"(.*)бульвар(.*)",L"%1 %2 бульвар"},
	{L"(.*)шоссе(.*)",L"%1 %2 шоссе"},
	{L"(.*)трассу(.*)",L"%1 %2 трассу"},

	{L"М[. ](?=.*улица)",L" малая "},
	{L"Б[. ](?=.*улица)",L" большая "},
	{L"М[. ](?=.*переулок)",L" малый "},
	{L"Б[. ](?=.*переулок)",L" большой "},
	{L"М[. ](?=.*тупик)",L" малый "},
	{L"Б[. ](?=.*тупик)",L" большой "},
	{L"М[. ](?=.*проезд)",L" малый "},
	{L"Б[. ](?=.*проезд)",L" большой "},
	{L"В[. ](?=.*улица)",L" верхняя "},
	{L"Н[. ](?=.*улица)",L" нижняя "},
	{L"В[. ](?=.*переулок)",L" верхний "},
	{L"Н[. ](?=.*переулок)",L" нижний "},
	{L"В[. ](?=.*проезд)",L" верхний "},
	{L"Н[. ](?=.*проезд)",L" нижний "},

--; здесь падежи для поворотов "на..." 

	{L"(.*)улица",L"улицу %1"},
	{L"(.*)[Пп]лощадь",L"площадь %1"},
	{L"(.*)переулок",L"переулок %1"},
	{L"(.*)проспект",L"проспект %1"},
	{L"(.*)проезд",L"проезд %1"},
	{L"(.*)тупик",L"тупик %1"},
	{L"(.*)бульвар",L"бульвар %1"},
	{L"(.*)шоссе",L"шоссе %1"},
	{L"(.*)трассу",L"трассу %1"},
	{L"(.*)линия",L"линию %1"},
	{L"(.*)аллея",L"аллею %1"},
	{L"(.*)набережная",L"набережную %1"},

--;**********************************************************************
	{L"^(%u)(%u)[ -]*(%d+)",L"%1.%2. %3"},
	{L"\-",L" "},
	{L"(%d)(%a)",L"%1 %2"},
	{L"(%a)(%d)",L"%1 %2"},
	{L"//",L", "},
}

local replace_str = {
	{L"улицу(.*)",L"улица %1"},
	{L"Дорогу(.*)",L"Дорога %1"},
	{L"трассу(.*)",L"трасса %1"},
	{L"линию(.*)",L"линия %1"},
	{L"аллею(.*)",L"аллея %1"},
	{L"набережную(.*)",L"набережная %1"},
}
	
local replace_sentence={
	{L"\. *[Dd]ann",L", dann"},
	{L"(%p)+ *(%p)+",L"%1 "},
	{L"%s+(%p+)",L"%1 "},
	{L" +",L" "},
}

local function get_preposition(str, tbl)
	str = wstring.lower(str)
	for k,value in ipairs(tbl) do
		for _,pattern in ipairs(tbl[k][2]) do
			if wstring.find(str,pattern) then
				return tbl[k][1] 
			end	
		end		
	end
end

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

local function not_settlement(str)
	str = wstring.lower(str)
	if transform_pattern_match(str,preposition_tbl) then
		return L""
	end	
        return get_preposition(str, preposition_insert_tbl)
end

local function signpost_exitnumber(data, idx)
	local exitnumber = data[idx].signpost.exitnumber
	if exitnumber then 
		return not_settlement(exitnumber.text) .. transform_and_format(exitnumber,replace_mapinfo)
	end
end

local function signpost_exitname(data, idx)
	local exitname = data[idx].signpost.exitname
	if exitname then 
		return not_settlement(exitname.text) .. transform_and_format(exitname,replace_mapinfo)
	end
end

local function signpost_destination(data, idx)
	local dest = data[idx].signpost.destination
	if dest then
		return not_settlement(dest.text) .. transform_and_format(dest,replace_mapinfo)
	end
end

local function signpost_settlement(data, idx) 			--  в "напрввлении" где символы  '>>'
	local settlement = data[idx].signpost.settlement
	if settlement then
		local str = transform_and_format(settlement,replace_mapinfo)
		-- Ha van benn gyarilag "richtung"
		if wstring.find(settlement.text,settlement_preposition) then
			return str
		end
		-- Hozza kell tenni
		return settlement_preposition .. L" " .. str
	end
end

local function signpost_roadnumber(data, idx)    		--  название трассы M1 ... Mx
	-- Road numberhez nem hasznaljuk a fonemat
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then 
--		return not_settlement(roadnumber.text) .. transform_format_roadnumber_eu(roadnumber.text)
		return not_settlement(roadnumber.text) .. transform_and_format(roadnumber.text,replace_roadnumber)
	end
end

local function road_name(data, idx)				--  название дороги
	local name = data[idx].road.name
	if name then 
--	return not_settlement(name.text) .. transform_and_format(name,replace_mapinfo)
	local str = transform_and_format(name,replace_mapinfo)
	return not_settlement(str) .. str
	end
end

local function road_number(data, idx)    		--  название дорог Е101 ... 
	local number = data[idx].road.number
	if number then 
--		return not_settlement(number.text) .. transform_format_roadnumber_eu(number.text)
		return not_settlement(number.text) .. transform_and_format(number.text,replace_roadnumber)
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	data, idx)
		t = transform_chain(t,  signpost_exitnumber, data, idx)
		t = transform_chain(t,  signpost_roadnumber,data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	for key, value in ipairs(replace_sentence) do
		str = wstring.gsub(str,value[1],value[2])
	end
	return str
end


----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------

function route_summary_format_road_name(data)
	if data.phoneme then return data.phoneme
	else  -- return transform_format_roadnumber_eu(data.text)
	local str = transform_and_format(data.text,replace_roadnumber)   
	return transform_and_format(str,replace_str) 
	end
end

function route_summary_format_street_name(data)
	if data.phoneme then return data.phoneme
	else 	-- return data.text
	local str = transform_and_format(data.text,replace_mapinfo)   
	return transform_and_format(str,replace_str) 
	end
end

function route_summary_format_bridge_tunnel(data)
	if data.phoneme then return data.phoneme
	else return data.text
	end
end

function route_summary_format_order(data)
	if data.phoneme then return data.phoneme
	else return data.text
	end
end

----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

-- 1. Zar az M0 uton, Martonvasar kozeleben. = in die Strasse Numer A1, in der Nähe von Martonvasar./ in der Nähe von der HaupStrasse Numer 33.
-- 2. Zar az M0 uton, Martonvasar es Velence kozt. = in die Strasse Numer A1, zwischen Martonvasar und Velence.
-- 3. Zar a Budai uton, a Budai ut Fiskalis ut keresztezodesben = in der/dem (lsd tabla) Budai ut, in der Kreuzung Budai ut und Fiskalis ut.
-- 4. Zar a Budai uton, Fiskalis ut es 8. ut kozott. = in der/dem Budai ut, zwischen Fiskalis ut und 8. ut.

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	local loc = MODEL.regional.is_it_voice_localizable(DescKey) 
	ASSERT(loc, "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	---- Roadnumber prioritas
	if data.roadnumber then 
		local road = L" in die Strasse Numer "..transform_format_roadnumber_eu(data.roadnumber.text)
		if data.from and not data.to then
		-- M7 uton Martonvasar kozeleben
			str =  str..road..L", in der Nähe von "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- M7 uton, Martonvasar es Velence kozott 
			str =  str..road..L", zwischen "..transform_and_format(data.from)..L" und "..transform_and_format(data.to)
		else
		-- Egyeb: M7 uton
			str = str..road
		end
	---- Roadname
	elseif data.roadname then
		-- Text/fonema + prepocicio
		local road = transform_and_format(data.roadname)
		road = L" in"..get_preposition(data.roadname.text, traffic_preposition_insert_tbl)..road
		if data.from and not data.to then
			-- "," menten robbantunk
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", in der Kreuzung "..from..L" und "..to
			else 
				str = str..road..L", in der Kreuzung "..data.from.text
			end
		elseif data.from and data.to then
			str = str..road..L", zwischen "..transform_and_format(data.from)..L" und "..transform_and_format(data.to)
		else
			str = str..road
		end
	---- Nincs se roadnumber, se roadname 
	else
		if data.from and not data.to then
		-- Martonvasar kozeleben
			str =  str..L" in der Nähe von "..transform_and_format(data.from)
		elseif data.from and data.to then 
		-- Martonvasar es Velence kozott 
			str =  str..L" zwischen "..transform_and_format(data.from)..L" und "..transform_and_format(data.to)
		else
		-- Egyeb: semmi
		end
	end
	str = str..L"."
	return str
end


----------------------------------------------------------------------------------------------------
------------------------------------------|  D E T O U R  |-----------------------------------------
----------------------------------------------------------------------------------------------------

function format_street_name (streetname)
    if wstring.sub (streetname, 1, 9) == L "for_turns" then
        return transform_and_format (wstring.sub (streetname, 10), transform.roadname_abbrev_table, destname.ROADNAME)
    else
        return transform_and_format (streetname, transform.roadname_abbrev_table)
    end
end

